;;; cmail-use-gnuspop3.el --- use Gnus version of pop3.el from cmail

;; Author: Takeshi Morishima (tm@interaccess.com)
;; Keywords: mail
;; Created at: Sat Feb 26 15:39:56 JST 2000

;; This file is part of cmail (a mail utility for GNU Emacs)

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; This is a cmail option feature module for Gnus/pop3.el.

;;; Code:

(require 'path-util)
(eval-when-compile (require 'cmail-vars))

(cmail-i18n-defgroup cmail-use-gnuspop3-group nil
  ((ja_JP . "Gnus/pop3.el$B$rMxMQ$7$F(BPOP$B%5!<%P$K%"%/%;%9$9$k$?$a$N@_Dj!#(B")
   (en_US . "Customization for accessing mail servers using Gnus/pop3.el."))
  :group 'cmail-other-features)

(defun cmail-set-gnuspop3 (var flag)
  (if flag
      (if (not (module-installed-p 'cmail-gnuspop3))
	  (message "Feature is not available due to lack of pop3.el.")
	(cmail-pop3glue-setup)
	(setq cmail-use-gnuspop3 t))
    (cmail-pop3glue-unload)
    (setq cmail-use-gnuspop3 nil)))

(defun cmail-pop3glue-setup ()
  "Prepare to use Gnus/pop3.el"
  (autoload 'cmail-pop3glue-movemail
    "cmail-pop3glue" "cmail-pop3glue" nil)
  (if (and (boundp 'cmail-pop3glue-biff) cmail-pop3glue-biff)
      (progn
	(autoload 'cmail-pop3glue-display-hook
	  "cmail-pop3glue" "cmail-pop3glue" nil)
	(add-hook 'display-time-hook 'cmail-pop3glue-display-hook)))
  (cmail-add-fetch-handler 'pop3 'cmail-pop3glue-movemail))

(defun cmail-pop3glue-unload ()
  "Unset Gnus/pop3.el"
  (cmail-del-fetch-handler 'pop3 'cmail-pop3glue-movemail)
  (remove-hook 'display-time-hook 'cmail-pop3glue-display-hook)
  (if (featurep 'cmail-pop3glue) (unload-feature 'cmail-pop3glue)))

(defun cmail-pop3glue-biff-set (var flag)
  (set var flag)
  (if (and flag (boundp 'cmail-use-gnuspop3) cmail-use-gnuspop3)
      (progn
	(autoload 'cmail-pop3glue-display-hook
	  "cmail-pop3glue" "cmail-pop3glue" nil)
	(add-hook 'display-time-hook 'cmail-pop3glue-display-hook))
    (remove-hook 'display-time-hook 'cmail-pop3glue-display-hook)))

(cmail-i18n-defcustom cmail-use-gnuspop3 nil
  ((ja_JP . "\
*Non nil $B$J$i$P(BGnus/pop3.el$B$rMxMQ$7$F(BPOP$B%5!<%P$K%"%/%;%9$9$k!#(B")
   (en_US . "\
*Non nil means use Gnus/pop3.el to access pop servers."))
  :type 'boolean
  :set 'cmail-set-gnuspop3
  :group 'cmail-all-variables
  :group 'cmail-use-gnuspop3-group)
(cmail-custom-add-init 'cmail-set-gnuspop3 'cmail-use-gnuspop3)

(cmail-i18n-defcustom cmail-gnuspop3-biff nil
  ((ja_JP . "\
*Non nil $B;~(Bdisplay-time$B$N;~4VI=<(5!G=$K%a!<%kE~CeI=<($rDI2C$9$k!#(B

cmail-use-gnuspop3 $B$,M-8z$K$J$C$F$$$F$+$D(B display-time $B$,:nF0$7$F$$$k(B
$BI,MW$,$"$k!#(B")
   (en_US . "\
*Non nil means add mail arrival notice to display-time feature.

Valid when cmail-use-gnuspop3 is t, and display-time is activated."))
  :set 'cmail-pop3glue-biff-set
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-use-gnuspop3-group)
(cmail-custom-add-init 'cmail-pop3glue-biff-set 'cmail-gnuspop3-biff)


(cmail-i18n-defcustom cmail-gnuspop3-biff-icount 3
  ((ja_JP . "\
*$B%a!<%kE~Ce$r(Bdisplay-time$B$NI=<(99?72?2sKh$K%A%'%C%/$9$k$+$N;XDj!#(B

$B<B:]$NIQEY$O(B display-time-interval $B$K0MB8$9$k!#(B")
   (en_US . "\
*Number of times display-time updates should untl the next server check.

Actual interval seconds depends on display-time-interval."))
  :type 'integer
  :group 'cmail-all-variables
  :group 'cmail-use-gnuspop3-group)

(defun cmail-use-gnuspop3 nil)
(provide 'cmail-use-gnuspop3)

;; end-of-file
