#!/bin/sh
# $Id: run-tests.sh 333 2003-07-08 00:02:08Z miles $

CMDLINE="sbcl --noinform --load xmls --eval"
FORM="(xmls::test)"

usage () {
    cat <<USAGE
usage: run-tests.sh [options] [tests]
options: 
    --sbcl run tests with sbcl (default)
    --cmucl run tests with cmucl
    --all run all tests in tests directory
    --verbose output parsed xml
USAGE
    exit 1
}

while [ $# -gt 0 ]; do 
    case $1 in
        --cmucl)
            CMDLINE="lisp -load xmls -eval"
            shift
            ;;
        --all)
            TESTS="tests/*/*"
            shift
            ;;
        --verbose)
            FORM="(progn (setf xmls::*test-verbose* t)(xmls::test))"
            shift
            ;;
        *)
            TESTS="$*"
            break
            ;;
    esac
done

if test -z "$TESTS"; then
    usage
fi

$CMDLINE "$FORM" $TESTS
