;; CMUCL GLUT interface
;; Knut Arild Erstad February 8th 2001

;; The C code generation is a bit quick and dirty...

(in-package :gl)

(eval-when (:compile-toplevel :load-toplevel)
  (defparameter *output-c* nil
    "Boolean; true if C code should be output by the GLUT-CALLBACK macro.
This only has to be done once, and since the resulting C file is distributed
along with this file, the value should be false (NIL)."))

(defmacro add-to-string (base add)
  "Macro for appending a string at the end of another (slow)."
  `(setq ,base (concatenate 'string ,base ,add)))

(defun c-function-call-into-lisp (lispfunc args argtypes)
  (let ((str (format nil "funcall~A(~A" (length args) lispfunc)))
    (mapc (lambda (arg type)
	    (add-to-string
	     str (format nil (ecase type
			       (int ", make_fixnum(~A)")
			       (unsigned-char ", make_fixnum((int)~A)"))
			 arg)))
	  args argtypes)
    (add-to-string str ");")
    str))

(defun c-typename (type)
  (ecase type
    (int "int")
    (unsigned-char "unsigned char")))

(defun c-arglist (argnames argtypes)
  (if (null argnames)
      "void"
      (let ((str (format nil "~A ~A"
			 (c-typename (first argtypes)) (first argnames))))
	(mapc (lambda (name type)
		(add-to-string str (format nil ", ~A ~A"
					   (c-typename type) name)))
	      (rest argnames) (rest argtypes))
	str)))

(defun c-callback (callback-name lispfunc argtypes)
  (let* ((n (length argtypes))
	 (argnames (loop for i from 0 below n
			 collect (format nil "arg~A" i))))
    (format nil "void ~A(~A) {~%  ~A~%}"
	    callback-name (c-arglist argnames argtypes)
	    (c-function-call-into-lisp lispfunc argnames argtypes))))

(defmacro glut-callback (name argtypes c-name)
  (let* ((lisp-function-variable (gensym))
	 ;;(lisp-function-c-variable (gensym)))
	 (c-set-callback-function (gensym)))
    ;; C code
    (when *output-c*
      (with-open-file (file "glut-callbacks-c.c"
			    :direction :output :if-exists :append)
	(format file "
/*** ~A ***/
lispobj lisp_~A = 0;
~A
void set_~A_callback(lispobj function) {
  if (function==0 && lisp_~A==0) return;
  if (function==0)
    ~A(0);
  else {
    lisp_~A = function;
    ~A(~A_callback);
  }
}"
		c-name c-name
		(c-callback (format nil "~A_callback" c-name)
			    (format nil "lisp_~A" c-name)
			    argtypes)
		c-name c-name c-name c-name c-name c-name)))
    ;; Lisp code
    `(eval-when (:compile-toplevel :load-toplevel)
      (alien:def-alien-variable
	  (,(format nil "set_~A_callback" c-name) ,c-set-callback-function)
	  (function c-call:void c-call:unsigned-int))
      (defvar ,lisp-function-variable nil)
      (defun ,name (lisp-function)
	(setq ,lisp-function-variable lisp-function)
	(alien:alien-funcall ,c-set-callback-function
			     (if (null lisp-function)
				 0
				 (kernel:get-lisp-obj-address
				  lisp-function))))
      (export ',name)
      ;; add GC hook
      (eval-when (:load-toplevel)
	(push
	 (lambda ()
	   (alien:alien-funcall
	    ,c-set-callback-function
	    (if (null ,lisp-function-variable)
		0
		(kernel:get-lisp-obj-address ,lisp-function-variable))))
	 ext:*after-gc-hooks*)))))
