/* Site-specific code. Here parsing and more of this site is.
 * $Id: BeNews.pike,v 1.5 2001/02/13 15:14:56 underley Exp $
 *
 * Written by David Hedbor <david@hedbor.org>.
 *
 */

import Headlines;

#include <headlines/base.h>

constant name = "benews";
constant site = "BeNews";
constant url  = "http://benews.com/";
constant path = "story/headlines/10";
constant names =  ({ "title", "date" });
constant all_names =  ({ "title", "date", "url" });
constant titles =  ({ "Title", "Date" });
constant sub = "Computing/BeOS";


array headlines;

private static void fetch_failed(object http)
{
  werror("%s: failed to get headlines..\n", site);
}

private static void parse_reply(string data)
{
  string title, url;
  int tim;
  sscanf(data, "%*s\n%s", data);
  while(sscanf(data, "%s\n%d\n%s\n%s", title, tim, url, data) > 2) {
    array lines = ({ title, ctime(tim)[4..23], url });
    headlines += ({ mkmapping(all_names, lines) });
  }
}

string entry2txt(mapping hl)
{
  return sprintf("Title:  %s\n"
		 "URL:    %s\n"
		 "Date:   %s\n"
		 "\n",
		 hl->title||"None", 
		 HTTPFetcher()->encode(hl->url||""),
		 hl->date);
}

