/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * Based on camas_main  Stefan Wallstrm and Bosse Lincoln.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_actions_null.pike,v 1.11 2004/01/08 20:53:17 vida Exp $
 */
#include <module.h>
inherit "module";
inherit "caudiumlib";

#include <camas/globals.h>      // Global definitions
#include <camas/utf.h>          // UTF8 conversion macros
#include <camas/language.h>     // Language sym names M_*
#include <camas/msg.h>          // MSG() macros

constant cvs_version   = "$Id: camas_actions_null.pike,v 1.11 2004/01/08 20:53:17 vida Exp $";
constant module_type   = MODULE_PROVIDER|MODULE_EXPERIMENTAL;
constant module_name   = "CAMAS: Actions NULL";
constant module_doc    = "This dummy module handles the so called 'actions' in "
			 "Camas. Actions are the actions taken by Camas each time"
			 " a user make a query. Examples "
                         "of actions are login to IMAP server, launching the "
			 "spellchecker when a user press the spellcheck "
			 "button,... <br>"
			 "With this module you can put your own actions and they "
			 "will be called as if they were part of CAMAS.";
constant thread_safe   = 1;
constant module_unique = 1;

array(string) query_provides()
{
  return ({ "camas_actions" });
}

void create()
{
#ifdef CAMAS_DEBUG
   defvar("debug", 0, "Debug", TYPE_FLAG,
     "When on, debug messages will be logged in Caudium's debug logfile. "
     "This information is very useful to the developers when fixing bugs.");
#endif
}

// you need to have a class Actions
class Actions {

  // you may define these but it's not mandatary
  private object features;
  private array imap_commands = ({ });
  private object sessobj;
  private object camas_main;
  private object id;
  // this object manage the actions modules and their priorities
  private object handler;
  
  void create(object _id, object _handler)
  {
    if(_id)
    {
      id = _id;
      camas_main = id->conf->get_provider("camas_main");
      sessobj = CSESSION;
      handler = _handler;
    }
  }

  void destroy()
  {
    handler->add_imap_commands(imap_commands);
  }

  // this action will be called each time a request to actionfoo=1
  // add your imap commands in imap_commands, Camas will launch 
  // the imapclient automatically
  // Finally note you have access to all CAMAS internals
  void foo()
  {
    write("foo called\n");
    // foo() will be called for other camas actions modules by default
    // if you don't want this behaviour you can call this function :
    handler->donot_execute_next_module();
  }

  // once finished this action will call foo() in other actions module
  // Every foo() in all actions modules will be called unless one of
  // them contains handler->donot_execute_next_module()
  void foo2()
  {
    handler->add_action("foo");
  }

};

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: debug
//! When on, debug messages will be logged in Caudium's debug logfile. This information is very useful to the developers when fixing bugs.
//!  type: TYPE_FLAG
//!  name: Debug
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

