
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <fcntl.h>

#include "brightonMini.h"

extern guimain global;

int
destroySynth(int cid)
{
	guiSynth *synth = findSynth(global.synths, cid);
	bristolMidiMsg msg;

printf("destroySynth(%i): %i\n", cid, synth->sid);
	/*
	 * Since we registered two synths, we now need to remove the upper
	 * manual.
	 */
	bristolMidiSendMsg(global.controlfd, synth->sid, 127, 0,
		BRISTOL_EXIT_ALGO);
	if (bristolMidiRead(global.controlfd, &msg) < 0)
		printf("socket closed\n");
}

displayPanelText(guiSynth *synth, char *text, int value, int panel, int index)
{
	brightonEvent event;
	char display[32];

	sprintf(display, "%s: %i", text, value);
	event.type = BRIGHTON_MEM;
	event.m = (void *) &display[0];
	brightonParamChange((void *) synth->connid, panel, index, &event);
}

displayText(guiSynth *synth, char *text, int value, int index)
{
	brightonEvent event;
	char display[32];

	sprintf(display, "%s: %i", text, value);
	event.type = BRIGHTON_MEM;
	event.m = (void *) &display[0];
	brightonParamChange((void *) synth->connid, synth->panel, index, &event);
}

guiSynth *
findSynth(guiSynth *synth, int reference)
{
//printf("findSynth(%x, %x)\n", synth, reference);
	if (synth == 0)
		return(0);

	if (synth->connid == reference)
		return(synth);

	return(findSynth(synth->next, reference));
}

loadMemory(guiSynth *synth, char *algo, char *name, int location, int active,
int skip, int flags)
{
	brightonEvent event;
	char path[256];
	int i, fd, ca[2], panel = 0, index = 0;

//printf("loadmemory %i: %s\n", location, synth->resources->name);

	if ((name != 0) && (name[0] == '/'))
		sprintf(path, "%s", name);
	else {
//		printf("home is %s\n", global.home);

		sprintf(path, "%s/memory/%s/%s%i.mem",
			global.home, algo, algo, location);
	}

	if ((fd = open(path, O_RDONLY)) < 0)
		return(-1);

	if (flags & BRISTOL_STAT)
	{
		close(fd);
		return(0);
	}

	if (read(fd, &synth->mem.algo[0], 32) < 0)
		printf("read failed\n");
	if (read(fd, &synth->mem.name[0], 32) < 0)
		printf("read failed\n");
	if (read(fd, &ca[0], 2 * sizeof(int)) < 0)
		printf("read failed\n");

	if (read(fd, &synth->mem.param[skip], active * sizeof(float)) < 0)
		printf("read failed\n");

	close(fd);

	if (flags & BRISTOL_NOCALLS)
		return(0);

	/*
	 * We now have to call the GUI to configure all these values. The GUI
	 * will then call us back with the parameters to send to the synth.
	 */
	for (i = 0; i < synth->mem.active; i++)
	{
		event.type = BRIGHTON_FLOAT;
		event.value = synth->mem.param[i];
		/*
		 * We need to fine which panel hosts this memory index. If we only
		 * have one panel, this is easy, it has all the controls. If we have
		 * multiple then we need to go through them all.
		 */
		if (synth->resources->nresources == 1)
			brightonParamChange((void *) synth->connid, synth->panel, i,
				&event);
		else {
			index = i;

			for (panel = 0; panel < synth->resources->nresources; panel++)
			{
				if ((index - synth->resources->resources[panel].ndevices) < 0)
				{
					/*
					 * If this is a text panel, skip it.
					 */
					if (synth->resources->resources[panel].devlocn[index].device
						== 3)
						continue;
					brightonParamChange((void *) synth->connid, panel, index,
						&event);
					break;
				} else
					index -= synth->resources->resources[panel].ndevices;
			}
		}
	}
	return(0);
}

saveMemory(guiSynth *synth, char *algo, char *name, int location, int skip)
{
	char path[256];
	int fd;

//printf("savememory %i\n", location);

	if ((name != 0) && (name[0] == '/'))
	{
		sprintf(synth->mem.algo, "%s", algo);
		sprintf(path, "%s", name);
	} else {
//		printf("home is %s\n", global.home);

		sprintf(path, "%s/memory/%s/%s%i.mem",
			global.home, algo, algo, location);
		sprintf(synth->mem.algo, "%s", algo);
		if (name == NULL)
			sprintf(synth->mem.name, "no name");
		else
			sprintf(synth->mem.name, "%s", name);
		printf("path is %s\n", path);
	}

	if ((fd = open(path, O_WRONLY|O_CREAT|O_TRUNC, 0770)) < 0)
		return(-1);

	if (write(fd, &synth->mem, sizeof(struct Memory) - sizeof(float *)) < 0)
		printf("write failed 1\n");
	if (write(fd, &synth->mem.param[skip], synth->mem.active * sizeof(float)) < 0)
		printf("write failed 2\n");

	close(fd);
}

initConnection(guimain *global, guiSynth *synth)
{
	bristolMidiMsg msg;
	int sid;

	forkengine(global);

	/*
	 * send a hello, with a voice count, then request starting of the
	 * synthtype. All of these will require an ACK, and we should wait here
	 * and read that ack before proceeding with each next step.
	 */
	bristolMidiSendMsg(global->controlfd, synth->midichannel,
//		127, 0, BRISTOL_HELLO|BRISTOL_VOICES|synth->voices);
		127, 0, BRISTOL_HELLO|synth->voices);
	if (bristolMidiRead(global->controlfd, &msg) != BRISTOL_OK)
		cleanupBristol();
	/*
	 * The returned value is the connection ID that we need to use for all
	 * further system conversations.
	 */
	sid = (msg.params.bristol.valueMSB << 7) + msg.params.bristol.valueLSB;

	bristolMidiSendMsg(global->controlfd, sid,
		127, 0, BRISTOL_MIDICHANNEL|synth->midichannel);
	if (bristolMidiRead(global->controlfd, &msg) != BRISTOL_OK)
		cleanupBristol();

	bristolMidiSendMsg(global->controlfd, sid,
		127, 0, BRISTOL_REQSTART);
	if (bristolMidiRead(global->controlfd, &msg) != BRISTOL_OK)
		cleanupBristol();

	bristolMidiSendMsg(global->controlfd, sid,
		127, 0, BRISTOL_INIT_ALGO|synth->synthtype);
	if (bristolMidiRead(global->controlfd, &msg) != BRISTOL_OK)
		cleanupBristol();

	return(sid);
}

forkengine(guimain *global)
{
	int flags;

	if ((global->flags & BRIGHTON_NOENGINE) == 0)
	{
printf("STARTING ENGINE....\n");
		if ((global->enginePID = fork()) == 0)
		{
			execlp(BRISTOL_ENGINE, "engine", NULL);
			printf("Could not find bristol engine\n");
			_exit(-1);
		}
	}
	sleep(1);

	flags = BRISTOL_CONN_TCP|BRISTOL_DUPLEX|
		(global->flags &  BRISTOL_CONN_FORCE);

	if ((global->controlfd = bristolMidiOpen("localhost",
		flags, global->port, -1, NULL, NULL)) < 0)
	{
printf("opening link to engine: %i\n", global->port);
		if ((global->controlfd = bristolMidiOpen("localhost",
			flags, global->port, -1, NULL, NULL)) < 0)
			cleanupBristol();
	} else
		printf("%s already active\n", BRISTOL_ENGINE);
printf("%x %x %i\n", global, global->flags, global->controlfd);
}

