#ifndef _ITERATOR_H_
#define _ITERATOR_H_

#include "compound.h"
#include "position.h"

class Track;
class Part;
class Event;
class PrPartEditor;

class Iterator {
 protected:
  Track   * _track;
  Part    * _part;
  Part    * _new_part;
  Event   * _event;
  Position _left;
  Position _right;

 public:
  Iterator() {}

  Iterator(const Iterator& i);

  Iterator(Track * track, Position left = 0, Position right = 0);

  Iterator(Part * part, Position left = 0, Position right = 0);

  Iterator(PrPartEditor * editor);

  virtual ~Iterator();

  bool operator!=(const Iterator& i) const;

  bool operator==(const Iterator& i) const;

  virtual bool done() const;

  Position start();

  bool endsAt(long p);

  bool startsAt(long p);

  bool startsAfter(long p);

  Element * operator *();

  Iterator& operator++();

  Iterator operator++(int);

  Part * part() const { return _part; }

  Part * change();
};

#endif
