#ifndef _KDEDRUMTRACK_CPP_
#define _KDEDRUMTRACK_CPP_

#include <iostream.h>

#include <kiconloader.h>

#include <qspinbox.h>
#include <qcombobox.h>


#include "prMainEditor.h"
#include "drumTrack.h"
#include "player.h"
#include "song.h"

#include "kdeDrumTrack.h"
#include "kdeMainEditor.h"

extern const char * gmNames[];
extern Song * sonG;

extern PrMainEditor * mainEditor;

#define ME ((KdeMainEditor*)mainEditor)

KdeDrumTrack::KdeDrumTrack(Track * tr) : KdeTrack(tr) {

  KIconLoader * loader = KGlobal::iconLoader();
  _icon = new QPixmap(loader->loadIcon( "drum", KIcon::Toolbar ));

  int hh = ME->trackHeight();
  QStrList * devList = new QStrList();
  for (int i=0;i<sonG->player()->devicenum();i++) devList->append(sonG->player()->device(i));
  
  // _instbox = new QComboBox(FALSE,this,"instrument");
  // _instbox->insertStrList( gmNames );
  // _instbox->setCurrentItem(((DrumTrack*)_track)->program());
  // _instbox->setGeometry(168,0,160,hh+1);
  // connect(_instbox,SIGNAL(highlighted(int)),SLOT(updateInst(int)));

  _output = new QComboBox(FALSE,this,"_output");
  _output->insertStrList( devList );
  _output->setCurrentItem(((DrumTrack*)_track)->output());
  _output->setGeometry(328,0,96,hh+1);
  connect(_output,SIGNAL(highlighted(int)),SLOT(updateOut(int)));

  _chanbox = new QSpinBox(0,15,1,this);
  _chanbox->setGeometry(424,0,44,hh+1);
  _chanbox->setValue(((DrumTrack*)_track)->channel());
  _chanbox->setBackgroundMode( PaletteMid );
  connect(_chanbox,SIGNAL(valueChanged(int)),SLOT(updateChan(int)));

  _vol = new QSpinBox(-100,100,1,this);
  _vol->setGeometry(468,0,54,hh+1);
  _vol->setValue(((DrumTrack*)_track)->volume());
  _vol->setBackgroundMode( PaletteMid );
  connect(_vol,SIGNAL(valueChanged(int)),SLOT(updateVol(int)));

  _tra = new QSpinBox(-100,100,1,this);
  _tra->setGeometry(522,0,54,hh+1);
  _tra->setValue(((DrumTrack*)_track)->transpose());
  _tra->setBackgroundMode( PaletteMid );
  connect(_tra,SIGNAL(valueChanged(int)),SLOT(updateTra(int)));

  _del = new QSpinBox(-100,100,1,this);
  _del->setGeometry(576,0,54,hh+1);
  _del->setValue(((DrumTrack*)_track)->delay());
  _del->setBackgroundMode( PaletteMid );
  connect(_del,SIGNAL(valueChanged(int)),SLOT(updateDel(int)));


}


void KdeDrumTrack::erase() {
  // TODO: delete anything?;
  KdeTrack::erase();
}

void KdeDrumTrack::update(bool menu) {
  KdeTrack::update(menu);
  //mute->update(); track->gMain()->muteTrack(track->trackNum());
  
  // _instbox->setCurrentItem(((DrumTrack*)_track)->program());
  _output->setCurrentItem(((DrumTrack*)_track)->output());
  _chanbox->setValue(((DrumTrack*)_track)->channel());
  _vol->setValue(((DrumTrack*)_track)->volume());
  _tra->setValue(((DrumTrack*)_track)->transpose());
  _del->setValue(((DrumTrack*)_track)->delay());
  
  //show();
}


int KdeDrumTrack::gProgram() {
  // return _instbox->getCurrentItem();
  return 0;
}

void KdeDrumTrack::sProgram(int n) {
  //((KbDrumTrack*)track)->sProgram(n);
  // _instbox->setCurrentItem(n);
}


void KdeDrumTrack::updateChan(int n) {
  ((DrumTrack*)_track)->setChannel(n);
}

void KdeDrumTrack::updateInst(int n) {
  ((DrumTrack*)_track)->setProgram(n);
  //track->gMain()->updateInst(track->trackNum(),n);
}

void KdeDrumTrack::updateOut(int n) {
  ((DrumTrack*)_track)->setOutput(n);
}

void KdeDrumTrack::updateVol(int n) {
  ((DrumTrack*)_track)->setVolume(n);
  //track->gMain()->updateVol(track->trackNum());
}

void KdeDrumTrack::updateTra(int n) {
  ((DrumTrack*)_track)->setTranspose(n);
  //track->gMain()->updateTra(track->trackNum());
}

void KdeDrumTrack::updateDel(int n) {
  ((DrumTrack*)_track)->setDelay(n);
}



#endif
#include "kdeDrumTrack.moc"
