#ifndef _TRACK_CPP_
#define _TRACK_CPP_

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include "track.h"
#include "str.h"
#include "table.h"
#include "element.h"
#include "loader.h"
#include "scoreTrack.h"
#include "drumTrack.h"
#include "masterTrack.h"
#include "audioTrack.h"
#include "commentTrack.h"
#include "part.h"
#include "song.h"
#include "convertTrack.h"
#include "prTrack.h"
#include "reference.h"
#include "event.h"
#include "note.h"
#include "player.h"

extern Song * sonG;
extern char * getcmd(char*);
extern int output;

#ifdef HAVE_ARTS_ENVIRONMENT
#include "soundserver.h"
using namespace Arts::Environment;
using namespace std;
#endif


void Track::initEnvironment() {
#ifdef HAVE_ARTS_ENVIRONMENT
  if (output==ARTS) {
    Arts::SoundServer server = Arts::Reference("global:Arts_SoundServer");
    if (server.isNull()) {
      cout << "SoundServer is null" << endl;
    } else {
      _arts_instument = Arts::DynamicCast(server.createObject("Arts::Environment::InstrumentItem"));
      _arts_instument.filename(EXAMPLES_DIR "/instrument_arts_all.arts-map");
      cout << "INSTRUMENT : " EXAMPLES_DIR "/instrument_arts_all.arts-map" << endl;
    }
  }
#endif
}


Track::Track() : _name(new String("new track")), _mute(false), _lock(false) {
  _type      = TRACK;
  initEnvironment();
}

Track::Track(const Track& e, Type t) : Compound(e,t), _name(0) {
    setName((String*)e.name()->copy());
    _mute = e.mute();
    _lock = e.lock();
    initEnvironment();
}

Track::~Track() {
  if (_name!=0) delete _name;
  if (_pr!=0) _pr->erase();
  // cout << "scratching track" << endl;
  scratch();
  // cout << "ok" << endl;
}


int Track::pitch(Note * note) const {
  if      (_type == SCORETRACK) return ((ScoreTrack*)this)->transpose()+note->pitch();
  else if (_type == DRUMTRACK)  return ((DrumTrack*)this)->transpose()+note->pitch();
  else                          return note->pitch();
}

int Track::vel(Note * note) const {
  if      (_type == SCORETRACK) return ((ScoreTrack*)this)->volume()+note->vel();
  else if (_type == DRUMTRACK)  return ((DrumTrack*)this)->volume()+note->vel();
  else                          return note->vel();
}

int Track::delay() const {
  if      (_type == SCORETRACK) return ((ScoreTrack*)this)->delay();
  else if (_type == DRUMTRACK)  return ((DrumTrack*)this)->delay();
  else                          return 0;
}

int Track::channel() const {
  if      (_type == SCORETRACK) return ((ScoreTrack*)this)->channel();
  else if (_type == DRUMTRACK)  return ((DrumTrack*)this)->channel();
  else                          return 0;
}

int Track::program() const {
  if      (_type == SCORETRACK) return ((ScoreTrack*)this)->program();
  else if (_type == DRUMTRACK)  return ((DrumTrack*)this)->channel();
  else                          return 0;
}

void Track::setName(String * str) {
  if (_name!=0) { delete _name; }
  _name = str;
}

void Track::setName(const char * c) {
  if (_name!=0) { delete _name; }
  _name = new String(c);
}

void Track::setMute(bool m) { _mute = m; }

void Track::setLock(bool l) { _lock = l; }

void Track::add(Element * el) {
  if (el!=0) {
    if (content()==0) {
      setContent(el);
    } else {
      Part * pt = 0;
      long pos = 0;
      long newpos = ((Part*)el)->start().ticks();
      long freepos = 0;
      bool done = false;
      for (Element * cur = first(); ((cur != 0) && (!done)); cur = Element::next(cur)) {
	pt  = (Part*) cur;
	pos = pt->start().ticks();
	if (pos > newpos) {
	  // if (newpos>=freepos) {
	    insertBefore(el,cur);
	    done = true;
	    /* } else {
	    cout << "****" << endl;
	    }*/
	}
	// freepos = pt->end((Event*)pt->last());
      }
      if (!done) { Element::append(el,content()); }

    }
  }
}


void Track::hide() {
  for (Part * pt = (Part*) this->first(); pt != 0; pt = (Part*) this->next(pt)) pt->hide();
  if (_pr!=0) _pr->hide();
}

void Track::show() {
  for (Part * pt = (Part*) this->first(); pt != 0; pt = (Part*) this->next(pt)) pt->show();
  if (_pr!=0) _pr->show();
}

ostream & Track::print(int dep, ostream & s) const {
  s << spc(dep) << "<TRACK type=\"" << isA() << "\" name=\"" << _name->getValue() << "\" mute=\"" << _mute << "\" lock=\"" << _lock << "\" >" << endl;
  printOptions(dep,s);
  printContent(dep,s);
  s << spc(dep) << "</TRACK>" << endl;
  return s;
}

void Track::flush(const char * c) const {
  cout << c << "TRACK" << endl;
}

void Track::loadOpt(ifstream*&) { cout << "loadOpt()" << endl; }


/*Element * Track::copy() const {
  Track * sng = new Track(this);
  return sng;
  }*/

/* <TRACK type="0" name="Sopran" mute="0" lock="0" >
<OPTIONS program="0" channel="0" output="2" volume="0" transpose="0" delay="0" />
*/

Element * Track::load(char * line, ifstream *& inPtr, Element * parent) {
  Table * attr = Loader::getAttributes("TRACK",line);
  //cout << *attr << endl;

  Track * tr = 0;
    if (attr->getEntry("type") && attr->getEntry("name") && attr->getEntry("mute") && attr->getEntry("lock")) {
    int type = atoi(((String*) attr->getEntry("type"))->getValue());
    String * strDesc = (String*) attr->getEntry("descriptor");
    const char * desc = strDesc==0 ? 0 : strDesc->getValue();
    const char * name = ((String*) attr->getEntry("name"))->getValue();
    int mute = atoi(((String*) attr->getEntry("mute"))->getValue());
    int lock = atoi(((String*) attr->getEntry("lock"))->getValue());
    tr = sonG->createTrack(type,desc);
    if (tr!=0) {
      tr->loadOpt(inPtr);
      tr->setName(name);
      tr->setMute(mute);
      tr->setLock(lock);
      Element::loadContent(tr,"/TRACK","PART",&Part::load,inPtr);
    }
    attr->scratch();
    delete attr;
  }
  return tr;
}

bool Track::isTrack() const { return true; }
bool Track::isMixable() const { return true; }


const char * Track::eventType() { return 0; }

EVENTLOAD Track::eventLoad() { return 0; }


#endif
