#ifndef _MASTEREVENT_CPP_
#define _MASTEREVENT_CPP_

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "loader.h"
#include "table.h"
#include "str.h"
#include "masterEvent.h"
#include "event.h"

MasterEvent::MasterEvent( ) : _tempo(0), _meter0(0), _meter1(0) { _type = MASTEREVENT; }

MasterEvent::MasterEvent(const MasterEvent& m) : Event(m) {
  _type = MASTEREVENT;
  _tempo = m.tempo();
  _meter0 = m.meter0();
  _meter1 = m.meter1();
}

MasterEvent::MasterEvent(Position pos, int tempo)
  : Event(pos,0), _tempo(tempo), _meter0(0), _meter1(0) {
  _type = MASTEREVENT;
}

MasterEvent::MasterEvent(Position pos, int met0, int met1)
  : Event(pos,0), _tempo(0), _meter0(met0), _meter1(met1) {
  _type = MASTEREVENT;
}

MasterEvent::MasterEvent(Position pos, int tempo, int met0, int met1)
  : Event(pos,0), _tempo(tempo), _meter0(met0), _meter1(met1) {
  _type = MASTEREVENT;
}


void MasterEvent::setTempo(int tempo) { _tempo = tempo; }

void MasterEvent::setMeter0(int met0) { _meter0 = met0; }

void MasterEvent::setMeter1(int met1) { _meter1 = met1; }



ostream & MasterEvent::print(int dep, ostream & s) const {
  s << spc(dep) << "<MASTEREVENT pos=\"" << internalStart().ticks() << "\"";
  if (_tempo>0) s << " tempo=\"" << _tempo << "\"";
  if (_meter1>0) s << " meter0=\"" << _meter0 << "\" meter1=\"" << _meter1 << "\"";
  s << " />" << endl;
  return s;
}

void MasterEvent::flush(const char * c) const {
  cout << c << "MASTEREVENT" << endl;
}

Element * MasterEvent::copy() const {
  return new MasterEvent(*this);
}


Element * MasterEvent::load(char * aline, ifstream *& inPtr, Element * parent) {
  MasterEvent * masterEvent = new MasterEvent();
  Table * attr = Loader::getAttributes("MASTEREVENT",aline);
  if (attr!=0) {
    int pos = 0;
    int tempo = 0;
    int met0 = 0;
    int met1 = 0;

    if (attr->getEntry("pos")) pos = atoi(((String*) attr->getEntry("pos"))->getValue());
    if (attr->getEntry("tempo")) tempo = atoi(((String*) attr->getEntry("tempo"))->getValue());
    if (attr->getEntry("meter0")) met0 = atoi(((String*) attr->getEntry("meter0"))->getValue());
    if (attr->getEntry("meter1")) met1 = atoi(((String*) attr->getEntry("meter1"))->getValue());

    masterEvent->setInternalStart(pos);
    masterEvent->setTempo(tempo);
    masterEvent->setMeter0(met0);
    masterEvent->setMeter1(met1);

    attr->scratch();
    delete attr;
  }
  return masterEvent;
}


#endif
