#ifndef _ELEMENT_CPP_
#define _ELEMENT_CPP_

#include <iostream.h>
#include <string.h>
#include <fstream.h>
#include "element.h"
#include "compound.h"
#include "prProgress.h"
#include "reference.h"

//#include "table.h"
//#include "reference.h"
//#include "str.h"

const char * cType[] = { "SCORETRACK", "DRUMTRACK", "MASTERTRACK", "AUDIOTRACK", "COMMENTTRACK", "TRACK",
			 "ABSTRACT", "ATOM", "STRING", "POSITION", "REFERENCE",
			 "EVENT", "MASTEREVENT", "NOTE", "MIDIEVENT", "SYMBOL", "AUDIOEVENT",
			 "ORNAMENT", "LYRICS", "STEM", "EXPRESSION", "BOW", "RIEMANNFUNCTION",
			 "COMPOUND", "SONG", "PART", "SELECTION", "VECTOR", "TABLE",
			 "OPERATION", "ADDON", "ADDELEMENT", "REMOVEELEMENT", "CONVERTTRACK", "MOVEPART", "COPYPART", "COPYGHOSTPART", "MOVEEVENT", "COPYEVENT", "CHANGENOTE",
			 "GLUENOTE", "SPLITNOTE", "ADDORNAMENT", "REMOVEORNAMENT", "ADDSYMBOL",
			 "ADDTOSELECTION", "REMOVEFROMSELECTION", "NEWSELECTION", "SELECTLEFT", "SELECTRIGHT", "UNSELECT", "SPLITPART", "GLUEPARTS",
			 "COPYSELECTION", "CUTSELECTION", "PASTESELECTION", "DELETESELECTION" };


extern char * getcmd(char*);


// categories of general midi instrumets

const char * gmCat[] = {"Piano", "Chromatic Percussion", "Organ", "Guitar", "Bass", "Strings/Orchestra", "Ensemble", "Brass",
"Reed", "Pipe", "Synth Lead", "Synth Pad", "Synth Eftects", "Ethnic", "Percussive", "Sound Effects"};

// names of general midi instrument table

const char * gmNames[] = {"Acoustic Grand Piano", "Bright Acoustic Piano",
"Electric grand Piano", "Honky Tonk Piano", "Eiectric Piano 1", "Electric Piano 2",
"Harpsichord", "Clavinet", "Celesra", "Glockenspiel", "Music Box", "Vibraphone", "Marimba",
"Xylophone", "Tubular bells", "Dulcimer", "Drawbar Organ", "Percussive Organ", "Rock Organ",
"Church Organ", "Reed Organ", "Accordion", "Harmonica", "Tango Accordion", "Nylon Accustic Guitar",
"Steel Acoustic Guitar", "Jazz Electric Guitar", "Ciean Electric Guitar", "Muted Electric Guitar",
"Overdrive Guitar", "Distorted Guitar", "Guitar Harmonics", "Acoustic Bass", "Electric Fingered Bass",
"Electric Picked Bass", "Fretless Bass", "Slap Bass 1", "Slap Bass 2", "Syn Bass 1", "Syn Bass 2",
"Violin", "Viola", "Cello", "Contrabass", "Tremolo Strings", "Pizzicato Strings", "Orchestral Harp",
"Timpani", "String Ensemble 1", "String Ensemble 2 (Slow)", "Syn Strings 1", "Syn Strings 2",
"Choir Aahs", "Voice Oohs", "Syn Choir", "Orchestral Hit", "Trumpet", "Trombone", "Tuba", "Muted Trumpet",
"French Horn", "Brass Section", "Syn Brass 1", "Syn Brass 2", "Soprano Sax", "Alto Sax", "Tenor Sax",
"Baritone Sax", "Oboe", "English Horn", "Bassoon", "Clarinet", "Piccolo", "Flute", "Recorder",
"Pan Flute", "Bottle Blow", "Shakuhachi", "Whistle", "Ocarina", "Syn Square Wave", "Syn Sawtooth Wave",
"Syn Calliope", "Syn Chiff", "Syn Charang", "Syn Voice", "Syn Fifths Sawtooth Wave", "Syn Brass & Lead",
"New Age Syn Pad", "Warm Syn Pad", "Polysynth Syn Pad", "Choir Syn Pad", "Bowed Syn Pad",
"Metal Syn Pad", "Halo Syn Pad", "Sweep Syn Pad", "SFX Rain", "SFX Soundtrack", "SFX Crystal",
"SFX Atmosphere", "SFX Brightness", "SFX Goblins", "SFX Echoes", "SFX Sci-fi", "Sitar", "Banjo",
"Shamisen", "Koto", "Kalimba", "Bag Pipe", "Fiddle", "Shanai", "Tinkle Bell", "Agogo", "Steel Drums",
"Woodblock", "Taiko Drum", "Melodic Tom", "Syn Drum", "Reverse Cymbal", "Guitar Fret Noise",
"Breath Noise", "Seashore", "Bird Tweet", "Telephone Ring", "Helicopter", "Applause", "Gun Shot",
"part defined",0};


#ifdef DEBUGIT
int Element::_total = 0;
Element * Element::_list = 0;
#endif

Element::Element() : _next(0), _prev(0), _type(ABSTRACT) {
#ifdef DEBUGIT
  _total++;
  _nnnn = 0;
  if (_list==0) _list = this;
  else { Element * foo = _list; for (;foo->_nnnn!=0;foo=foo->_nnnn) {}; foo->_nnnn = this; }
#endif
}

Element::Element(const Element & el) : _next(0), _prev(0), _type(ABSTRACT) {
#ifdef DEBUGIT
  _total++;
  _nnnn = 0;
  if (_list==0) _list = this;
  else { Element * foo = _list; for (;foo->_nnnn!=0;foo=foo->_nnnn) {}; foo->_nnnn = this; }
#endif
}

Element::~Element() {
#ifdef DEBUGIT
  _total--;
  if (this==_list) { _list = _nnnn; } else { bool exit=false; Element * foo = _list; for (;(!exit)&&(foo->_nnnn!=this);foo=foo->_nnnn) {
    // foo->flush("* ");
    if ((foo==0)||(foo->_nnnn==0)) exit=true; }; if (!exit) foo->_nnnn = _nnnn; }
#endif
}

#ifdef DEBUGIT
// for debugging only:
//void Element::dump() { int i=0; for (Element * foo = _list; foo != 0; foo = foo = foo->_nnnn) cout << i++ << ": " << *foo << endl; }
void Element::dump(int k) {
  if (k<0) {
    int i=0; for (Element * foo = _list; foo != 0; foo = foo = foo->_nnnn) { cout << i++ << " " << foo; foo->flush(" "); }
  } else {
    int i=0; for (Element * foo = _list; (foo != 0) && (i < k); foo = foo = foo->_nnnn) { i++; }
    cout << *foo << endl;
  }
}
#endif

Element * Element::next(Element * base) {
  Element * retv = 0;
  if (base != 0) {
    retv = base->_next;
  }
  return retv;
}

Element * Element::prev(Element * base) {
  Element * retv = 0;
  if (base != 0) {
    retv = base->_prev;
  }
  return retv;
}

void Element::splitBefore(Element * e) {
  if (e != 0) {
    Element * prev = Element::prev(e);
    if (prev != 0) {
      prev->_next = 0;
      e->_prev = 0;
    }
  }
}

Element * Element::first(Element * base) {
  Element * retv = 0;
  if (base != 0) {
    for (retv = base; retv->_prev != 0; retv = retv->_prev) {}
  }
  return retv;
}

Element * Element::last(Element * base) {
  Element * retv = 0;
  if (base != 0) {
    for (retv = base;retv->_next != 0;retv = retv->_next) {}
  }
  return retv;
}

Element * Element::get(int i, Element * base) {
  Element * retv = 0;
  if (base!=0) {
    Element * foo = first(base);
    while (i>0) {
      foo = next(foo);
      i--;
    }
    retv = foo;
  }
  return retv;
}

void Element::append(Element * ne, Element * base) {
  if ((base != 0)&&(ne!=0)) {
    Element * foo = 0;
    for (foo = base; foo->_next != 0; foo = foo->_next) {}
    foo->_next = ne;
    ne->_prev = foo;
  }
}

Element * Element::preput(Element * ne, Element * base) {
  if ((base != 0)&&(ne!=0)) {
    Element * foo = 0;
    for (foo = base; foo->_prev != 0; foo = foo->_prev) {}
    foo->_prev = ne;
    ne->_next = foo;
  }
  return ne;
}

Element * Element::insertBefore(Element * ne, Element * base) {
  Element * retv = Element::first(base);
  if ((base != 0)&&(ne!=0)) {
    Element * prev = base->_prev;
    ne->_next = base;
    base->_prev = ne;
    ne->_prev = prev;
    if (prev == 0) {
      retv = ne;
    } else {
      prev->_next = ne;
    }
  }
  return retv;
}

void Element::insertAfter(Element * ne, Element * base) {
  if ((base != 0)&&(ne!=0)) {
    Element * next = base->_next;
    ne->_prev = base;
    base->_next = ne;
    ne->_next = next;
    if (next != 0) {
      next->_prev = ne;
    }
  }
}

void Element::exchange(Element * e1, Element * e2) {
  Element * prev1 = e1->_prev;
  Element * next1 = e1->_next;
  Element * prev2 = e2->_prev;
  Element * next2 = e2->_next;
  // set e2 into the old e1-context
  if (prev1!=0) prev1->_next = e2;
  e2->_prev = prev1;

  if (next1 != e2) {
    if (next1!=0) next1->_prev = e2;
    e2->_next = next1;
  } else { // this is the case, when e1 is directly left from e2:
    e2->_next = e1;
  }

  // set e1 into the old e2-context
  if (prev2 != e1) {
    if (prev2!=0) prev2->_next = e1;
    e1->_prev = prev2;
  } else { // this is the case, when e1 is directly left from e2:
    e1->_prev = e2;
  }

  if (next2!=0) next2->_prev = e1;
  e1->_next = next2;
}


Element * Element::remove(Element * el) {
  Element * retv = Element::first(el);
  if (el != 0) {
    if (el->_prev) { el->_prev->_next = el->_next; } else { retv = el->_next; }
    if (el->_next) el->_next->_prev = el->_prev;
    el->_next = 0;
    el->_prev = 0;
  }
  return retv;
}

bool Element::member(Compound * list) {
  bool retv = false;
  for (Element * el = list->content(); el != 0; el = Element::next(el))
    if (el==this)
      retv = true;
  return retv;
}

int Element::ord(Compound * list) {
  int retv = -1;
  int i = 0;
  for (Element * el = list->content(); el != 0; el = Element::next(el)) {
    if (el==this) retv = i;
    i++;
  }
  return retv;
}


/*
void Element::clear(Element *& el) {
  Element * f = Element::first(el);
  for (Element * e = f; e != 0;) {
    Element * n = e->_next;
    delete e;
    e = n;
  }
  el = 0;
}
*/

/*void Element::dump(Element * base) {
  if (base == 0) cout << "nil" << endl;
  for (Element * el = first(base); el != 0; el = el->_next)
    el->print();
}

void Element::print() {
  cout << "nude element" << endl;
  }*/

char * Element::spc(int depth) const {
  char * retv = new char[depth*2+1];
  for (int i=0;i<depth*2;i++) { retv[i]=' '; }
  retv[depth*2] = 0;
  return retv;
}

Type Element::isA() const {
  return _type;
}


const char * Element::ctype() const {
  return cType[_type];
}

/*
bool Element::operator==(Element * e) {
  cout << "1 To be implemented" << endl;
}

bool Element::operator==(const char * s) {
  cout << "2 To be implemented" << endl;
  }*/


void Element::hide() {}

void Element::show() {}




void Element::loadContent(Compound * list, const char * term, const char * name, Element*(*loadme)(char*,ifstream*&,Element*), ifstream * inPtr, PrProgress * progress, int num) {
  if ((list!=0)&&(term!=0)&&(name!=0)&&(inPtr!=0)) {
    bool ok = true;
    if (progress!=0) progress->progress(0);
    int percent = 0;
    double percentD = 0;
    double percStep = 1;
    if (progress!=0) percStep = 1.0*progress->range()/num;

    char * line = new char[401];
    line[0]=0;
    char * ptr = line;
    int termlen = strlen(term);
    int namelen = strlen(name);
    Element * element = 0;
    while (ok && (strncmp(ptr,term,termlen)!=0)) {
      if (strncmp(ptr,name,namelen)==0) {
	element = (*loadme)(line,inPtr,list);
	if (element!=0) {
	  if (list->isA()==TABLE) list->add(new Reference(strdup(element->ctype()),element));
	  else list->add(element);
	}
      } else {
	if (line[0]!=0)	cout << "*** ERR " << term << ": " << line << endl;
      }
      ok=inPtr->getline(line,400,'\n');
      if (ok==true) ptr = getcmd(line);
      percentD += percStep;
      if ((progress!=0) && (int(percentD)>percent)) { progress->progress(int(percent)); percent = int(percentD); }
    }
  }
}

void Element::loadContent(Compound * list, const char * term, int num, const char * name[], Element*(*loadme[])(char*,ifstream*&,Element*), ifstream * inPtr, PrProgress * progress, int trnum) {
  if ((list!=0)&&(term!=0)&&(name!=0)&&(inPtr!=0)) {
    bool ok = true;
    if (progress!=0) progress->progress(0);
    int percent = 0;
    double percentD = 0;
    double percStep = 1;
    if (progress!=0) percStep = 1.0*progress->range()/num;

    char * line = new char[401];
    line[0]=0;
    char * ptr = line;
    int termlen = strlen(term);
    Element * element = 0;
    while (ok && (strncmp(ptr,term,termlen)!=0)) {
      bool tagfound = false;
      for (int i=0;i<num;i++) {
	int namelen = strlen(name[i]);
	if (strncmp(ptr,name[i],namelen)==0) {
	  element = (*loadme[i])(line,inPtr,list);
	  if (element!=0) {
	    if (list->isA()==TABLE) list->add(new Reference(strdup(element->ctype()),element));
	    else list->add(element);
	  }
	  tagfound = true;
	}
      }
      if (!tagfound) {
	if (line[0]!=0) cout << "*** ERR " << term << ": " << line << endl;
      }
      ok=inPtr->getline(line,400,'\n');
      if (ok==true) ptr = getcmd(line);
      percentD += percStep;
      if ((progress!=0) && (int(percentD)>percent)) { progress->progress(int(percent)); percent = int(percentD); }
    }
  }
}


ostream & operator<<(ostream & s, Element & e)
{
  return e.print(0,s);
}



#endif
