#ifndef _COPYGHOSTPART_H_
#define _COPYGHOSTPART_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Track;
class Part;

/** This operation copies a part to the position p
 */
class CopyGhostPart : public Operation
{
 private:
  Part * _part;
  Track * _src;
  Track * _tgt;
  Position _old;
  Position _new;

 public:
  CopyGhostPart(Position p, Part * pt, Track * src, Track * tgt);
  CopyGhostPart(const CopyGhostPart&);
  ~CopyGhostPart();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
