/***************************************************************************
                  konqueror.h  -  Konqueror Class Definition
                             -------------------
    begin                : Sun Aug 24 2003
    copyright            : (C) 2003 by Ken Schenke
    email                : kenschenke at yahoo dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This class implements the Konqueror functionality for read and writing*
 *   bookmarks.                                                            *
 *                                                                         *
 ***************************************************************************/

#ifndef KONQUEROR_H
#define KONQUEROR_H

#include "bknode.h"
#include "browserbk.h"
#include <qtextstream.h>

class Konqueror : public BrowserBk
{
public:
	Konqueror()	{ }
	~Konqueror()	{ }

	virtual bool    AreBookmarksValid(const QString &bookmarks);
	virtual bool    BrowseForBookmarks(const BridgeCfg &, QString &bookmarks, QWidget *parent=0);
#ifdef Q_WS_X11
	virtual bool	DetectBrowser(const BridgeCfg &, QStringList &paths);
#endif
	virtual void	readBookmarks(const QString &path, BRWSNUM browserOrd) throw(BkException);
	static	void	saveBookmarks(const QString &path, BkFolder &root, BRWSNUM browserOrd)
						throw(BkException);
	static BrowserBk *classFactory(void);

	virtual BkFolder & root(void) { return m_Root; }

private:
	static  void	saveBookmark(const BkBookmark &bkmark, QTextStream &t, int levels, BRWSNUM browserOrd)
						throw(BkException);
	static  void	saveFolder(BkFolder &folder, QTextStream &t, int levels, BRWSNUM browserOrd)
						throw(BkException);

	BkFolder	m_Root;
};

#endif // end of KONQUEROR_H
