
#include <list>
#include "glow.h"

#define VERSIONSTRING "000003"
#define VERSION 3

class BookEntry : public Gtk {
 public:
  BookEntry(int updateId);
  BookEntry(int updateId,FILE *f);

  void edit();
  char tabHash();
  int  isNull();

  char Name[256];
  char Phone[64];
  char Fax[64];
  char Email[256];
  char Memo[1024];

  void save(FILE *f);

  void clicked(int id);
  void destroyed(int id);

 private:
  int upId;

  Window *editDlg;
  Entry *es[4];
  Text  *ts;
  int idOk,idCancel;

};

class EntryComparator {
 public:
  int operator()(BookEntry *e1, BookEntry *e2) const;
};

class BookTab : public Notebook {
 public:
  BookTab(char *title);
  BookTab(FILE *f);

  HBox *tabwidget;

  void addEntry();
  void removeEntry();

  void save(FILE *f);

  void update();
  void receiveMessage(char *msg);

  void clicked(int id);
  void destroyed(int id);

  void rowSelected(int id,int row,int column,GdkEventButton *geb);
  void rowUnselected(int id,int row,int column,GdkEventButton *geb);

 private:
  void popRename();
  
  Window *renameDlg;
  Entry  *nameEntry;
  CList  *data[13+2];
  int idList[13+2];
  int listSel[13+2];

  char Title[256];
  Label *tablabel;
  Button *tabrename;

  int idRename,idOk,idCancel;

  list<BookEntry *> *entries;
};




class BlackBook : public Window {
 public:
  BlackBook();

  void destroyed();

  void clicked(int bar,int tool);
  void receiveMessage(char *msg);

  static int Id;

 private:
  BookTab *getCurTab();
  void save();
  void load();

  Notebook *tabs;
  int toolbarId;
  int allowSave;

  list<BookTab *> *tlist;
};


class AboutDialog : public Window {
 public:
  AboutDialog();
  void clicked(int id);
};
