#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test archive mirror creation
# Copyright © 2003 Colin Walters <walters@verbum.org>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "Register archive"

begin_test "Register a location with a newline..."
tla register-archive "phool@example.com" "$(echo -e 'http://server\nnewline')" && test_fail "registered archive location with an embedded newline"
end_test

begin_test "Register an archive with a relative path."
tla register-archive -df foo@example.org
tla make-archive foo@example.org ./foo/
tla register-archive -d foo@example.org
tla register-archive ./foo/
file_matches '^'$(pwd)/foo $HOME"/.arch-params/=locations/foo@example.org"
end_test

clean_workdir
