<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-site-metadata.php                                  */
/* Author:      Paul Waite                                              */
/* Description: A page for maintaining the website metadata, allowing   */
/*              you to determine which elements to include, and once    */
/*              included, determine how they are to be used.            */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("metadata-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$maint_formname = "sitemetadata";
$HEADING = "METADATA SCHEMA DEFINITION";
$RESPONSE->page($HEADING, "maint", $theme);
$RESPONSE->body->add_script(
    "function go(mode) {\n"
  . "  if (mode == 'remove'||mode == 'remall') {\n"
  . "    var msg  = 'When you remove metadata elements from the website, you\\n';\n"
  . "    msg += 'also cause all related metadata to be removed from the\\n';\n"
  . "    msg += 'actual website content.\\n\\n';\n"
  . "    msg += 'Do you really want to do this?\\n';\n"
  . "    if (!confirm(msg)) return false;\n"
  . "  }\n"
  . "  document.forms.$maint_formname.mode.value=mode;\n"
  . "  document.forms.$maint_formname.submit();\n"
  . "  return true;\n"
  . "}\n"
  );

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");
include_once("recmaint-defs.php");

//debug_on(DBG_DUMP|DBG_SQL|DBG_DIAGNOSTIC);
//debug_output(DBG_O_LOG);

// ------------------------------------------------------------------
// AUTHORISATION

// Only Editors and Admin allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// ------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "view";

// ##################################################################
// POST PROCESSING

// Function to add a site metadata ekement from query..
function add_meta_element($Q) {
  $element_id = $Q->field("element_id");
  $schema_name = $Q->field("schema_name");
  $comments = $Q->field("comments");
  $definition = $Q->field("definition");
  $description = $definition;
  if ($comments != "") {
    $description .= "\n\n$comments";
  }
  $label = $Q->field("label");
  $ein = new dbinsert("ax_site_meta_element");
  $ein->set("element_id",     $element_id);
  $ein->set("schema_name",    $schema_name);
  $ein->set("label",          $label);
  $ein->set("description",    $description);
  $ein->set("obligation",     $Q->field("obligation"));
  $ein->set("default_value",  $Q->field("default_value"));
  $ein->set("list_of_values", $Q->field("list_of_values"));
  $ein->set("display_order",  $Q->field("display_order"));
  $ein->execute();
}

// Function to remove a site meta element..
function remove_meta_element($elementid, $schema_name) {
  $edel = new dbdelete("ax_layout_metadata");
  $edel->where("element_id=$elementid");
  $edel->where("AND schema_name='" . addslashes($schema_name) . "'");
  $edel->execute();
  $edel = new dbdelete("ax_site_meta_element");
  $edel->where("element_id=$elementid");
  $edel->where("AND schema_name='" . addslashes($schema_name) . "'");
  $edel->execute();
}

// ADD METADATA ELEMENT..
if ($mode == "add" && isset($new_element_id) && isset($schema_name)) {
  $q  = "SELECT *";
  $q .= "  FROM ax_meta_element_set es, ax_meta_element e";
  $q .= " WHERE es.element_id=$new_element_id";
  $q .= "   AND es.schema_name='" . addslashes($schema_name) . "'";
  $q .= "   AND e.element_id=es.element_id";
  $new_element = dbrecordset($q);
  if ($new_element->hasdata) {
    add_meta_element($new_element);
  }
}
// REMOVE METADATA ELEMENT..
elseif ($mode == "remove" && isset($key_element_id) && isset($parent_schema)) {
  remove_meta_element($key_element_id,$parent_schema);
}
// ADD ALL AVAILABLE META ELEMENTS..
elseif ($mode == "addall") {
  $q  = "SELECT *";
  $q .= "  FROM ax_meta_element_set es, ax_meta_element e";
  $q .= " WHERE es.schema_name='" . addslashes($schema_name) . "'";
  $q .= "   AND e.element_id=es.element_id";
  $q .= "   AND e.enabled=TRUE";
  $q .= "   AND es.enabled=TRUE";
  $q .= "   AND NOT EXISTS(";
  $q .= "       SELECT * FROM ax_site_meta_element sme";
  $q .= "        WHERE sme.element_id=es.element_id)";
  $addall = dbrecordset($q);
  if ($addall->hasdata) {
    do {
      add_meta_element($addall);
    } while ($addall->get_next());
  }
}
// REMOVE ALL SITE META ELEMENTS..
elseif ($mode == "remall") {
  $q  = "SELECT *";
  $q .= "  FROM ax_site_meta_element sme, ax_meta_element e";
  $q .= " WHERE e.element_id=sme.element_id";
  $remall = dbrecordset($q);
  if ($remall->hasdata) {
    do {
      remove_meta_element(
          $remall->field("element_id"),
          $remall->field("schema_name")
          );
    } while ($remall->get_next());
  }
}
// SAVE SITE ELEMENT DATA..
elseif (isset($site_recmaintpost_form)
        && $site_recmaintpost_form == $maint_formname) {
  // Element saves..
  if (isset($site_recmaintpost_data) && $site_recmaintpost_data != "") {
    $recs = explode(RECORD_DELIM, $site_recmaintpost_data);
    foreach ($recs as $elemrec) {
      $elemvalues = explode(FIELD_DELIM, $elemrec);
      $elemid = array_shift($elemvalues);
      $elemfields = explode(",", $site_recmaintpost_flds);
      // Update the existing element data..
      $um = new dbupdate("ax_site_meta_element");
      $um->where("element_id=$elemid");
      $pos = 0;
      foreach ($elemfields as $elemfield) {
        if ($elemfield != "element_id"
         && $elemfield != "parent_schema"
         && $elemfield != "tag_name") {
          $elemval = $elemvalues[$pos];
          $um->set($elemfield, $elemval);
        }
        $pos += 1;
      }
      $um->execute();
    } // foreach saved record
  }

  // Check/save ordering..
  if (isset($site_recmaintpost_order) && $site_recmaintpost_order != "") {
    $ord = 1;
    $idlist = explode(FIELD_DELIM, $site_recmaintpost_order);
    foreach ($idlist as $elemid) {
      $upd = new dbupdate("ax_site_meta_element");
      $upd->where("element_id=$elemid");
      $upd->set("display_order", $ord);
      $upd->execute();
      $ord += 1;
    }
  }
}

// ------------------------------------------------------------------
// Get current schema
$q  = "SELECT * FROM ax_meta_schema";
if (isset($schema_name)) {
  $q .= " WHERE schema_name='" . addslashes($schema_name) . "'";
}
$cur_schema = dbrecordset($q);
if ($cur_schema->hasdata) {
  $schema_name = $cur_schema->field("schema_name");
  $description = $cur_schema->field("description");
  $namespace = $cur_schema->field("namespace");
  $namespace_uri = $cur_schema->field("namespace_uri");
  $HEADING .= " - " . $schema_name;
}

// ##################################################################
// FORM ELEMENTS

// Width of large form elements..
$ewidth = "300px";
$cwidth = "150px";
$pwidth = "90px";

// ------------------------------------------------------------------
// BUTTONS..
$bup     = new form_imagebutton("_up",     "", "", "$LIBDIR/img/_up.gif",      "Move up",                  57, 15);
$bdown   = new form_imagebutton("_down",   "", "", "$LIBDIR/img/_down.gif",    "Move down",                57, 15);
$badd    = new form_imagebutton("_add",    "", "", "$LIBDIR/img/_arrowBR.gif", "Add meta element",         57, 15);
$baddall = new form_imagebutton("_addall", "", "", "$LIBDIR/img/_next.gif",    "Add all meta elements",    57, 15);
$brem    = new form_imagebutton("_remove", "", "", "$LIBDIR/img/_arrowBL.gif", "Remove meta element",      57, 15);
$bremall = new form_imagebutton("_remall", "", "", "$LIBDIR/img/_prev.gif",    "Remove all meta elements", 57, 15);
$bsav    = new form_imagebutton("_save",   "", "", "$LIBDIR/img/_save.gif",    "Save changes",             57, 15 );

$badd->set_onclick("go('add')");
$baddall->set_onclick("go('addall')");
$brem->set_onclick("go('remove')");
$bremall->set_onclick("go('remall')");
$bsav->set_onclick("go('save')");

// ------------------------------------------------------------------
// AVAILABLE METADATA ELEMENTS MAINTAINER

// KEYFIELD and RECORD MAINTAINER
// Meta Schema Set Listbox
// Declared here so we can create the maintainer and register buttons
// before they are used in the form.
//
// This is the keyfield listbox which controls the maintainance
// process. It lists all records being maintained..
$avail_meta_listbox = new form_combofield("new_element_id");
$avail_meta_listbox->setclass("axlistbox");
$avail_meta_listbox->setstyle("width:$ewidth;");
$avail_meta_listbox->size = 16;

// Make a new record maintainer..
$avail_maintainer = new recmaintainer($maint_formname, $avail_meta_listbox, "avail_");

$Ted = new table("avail_metadata");
$Ted->setpadding(2);

// ..................................................................
// Heading..
$Ted->tr("axhdg");
$Ted->td("<b>AVAILABLE METADATA ELEMENTS</b>", "axhdg");
$Ted->td_colspan(2);

// ..................................................................
// Schema selector..
$s = "";
$Sel_F = new form_combofield("schema_name", "Schemas", $schema_name);
$Sel_F->setstyle("width:$ewidth;");
$Sel_F->additem("");
$Sel_F->set_onchange("document.forms.$maint_formname.mode.value='select';document.forms.$maint_formname.submit()");
$Q = dbrecordset("SELECT * FROM ax_meta_schema ORDER BY schema_name");
if ($Q->rowcount > 0) {
  do {
    $sname = $Q->field("schema_name");
    $sdesc = $Q->field("description");
    $nspace = $Q->field("namespace");
    $nspace_uri = $Q->field("namespace_uri");
    $Sel_F->additem($sname, $sdesc);
  } while ($Q->get_next());
}
$Ted->tr("axbglite");
$Ted->td("Schema:", "axfg");
$Ted->td($Sel_F->render());

// ..................................................................
// Continue defining main listbox..
$q  = "SELECT *";
$q .= "  FROM ax_meta_element_set es, ax_meta_element e";
$q .= " WHERE es.schema_name='" . addslashes($schema_name) . "'";
$q .= "   AND e.element_id=es.element_id";
$q .= "   AND e.enabled=TRUE";
$q .= "   AND es.enabled=TRUE";
$q .= "   AND NOT EXISTS(";
$q .= "       SELECT * FROM ax_site_meta_element sme";
$q .= "        WHERE sme.element_id=es.element_id)";
$q .= " ORDER BY es.display_order";
$elemset = dbrecordset($q);
$avail_count = $elemset->rowcount;
if ($avail_count > 0) {
  do {
    // Populate listbox..
    $elementid      = $elemset->field("element_id");
    $label          = $elemset->field("label");
    $definition     = $elemset->field("definition");
    $obligation     = $elemset->field("obligation");
    $default_value  = $elemset->field("default_value");
    $list_of_values = $elemset->field("list_of_values");
    $comments       = $elemset->field("comments");
    $pref_scheme    = $elemset->field("preferred_enc_scheme");
    $avail_meta_listbox->additem($elementid, $label);

    // Set more meaningful obligation..
    switch ($obligation) {
      case 'o': $obligation = "Optional"; break;
      case 'm': $obligation = "Mandatory"; break;
      case 'c': $obligation = "Conditional"; break;
      case 'r': $obligation = "Recommended"; break;
    }

    // Qualify the element with possible parent(s)..
    $tag_name = $elemset->field("tag_name");
    $parent_elemid = $elemset->field("parent_element");
    $tag_name = get_full_tag_name($tag_name, $parent_elemid);

    // Get schemes list
    $schemepref = "";
    $schemes = array();
    $q  = "SELECT * FROM ax_element_set_enc se, ax_enc_scheme s";
    $q .= " WHERE se.element_id=$elementid";
    $q .= "   AND se.schema_name='" . addslashes($schema_name) . "'";
    $q .= "   AND s.enc_scheme_id=se.enc_scheme_id";
    $schemesQ = dbrecordset($q);
    if ($schemesQ->hasdata) {
      do {
        $schemeid = $schemesQ->field("enc_scheme_id");
        $scheme_name = $schemesQ->field("enc_scheme_name");
        if ($schemeid == $pref_scheme) {
          $schemepref = $scheme_name;
        }
        else {
          $schemes[] = $scheme_name;
        }
      } while ($schemesQ->get_next());
    }
    $schemelist = implode(", ", $schemes);
    if ($schemepref != "") {
      if ($schemelist != "") {
        $schemelist = "$schemepref ($schemelist)";
      }
      else {
        $schemelist = $schemepref;
      }
    }

    // Populate maintainer data. The maintainer add_record method
    // requires an associative array keyed on listbox key id..
    $rec = array(
            "_schema_name" => $schema_name,
            "_tag_name" => format_tag_name($tag_name),
            "_label" => $label,
            "_obligation" => $obligation,
            "_default_value" => $default_value,
            "_list_of_values" => $list_of_values,
            "_definition" => $definition,
            "_comments" => $comments,
            "_schemelist" => $schemelist
            );
    $avail_maintainer->add_record($elementid, $rec);

    // If this is the element being edited, make sure
    // that it gets focussed..
    if (isset($element_id) && $element_id == $elementid) {
      $avail_maintainer->initial_record($elementid);
    }
  } while ($elemset->get_next());
}

// The listbox field..
$Ted->tr("axbgdark");
$Ted->td( $avail_meta_listbox->render() );
$Ted->td_colspan(2);
$Ted->td_alignment("right", "top");

// ..................................................................
$Ted->tr("axhdg");
$Ted->td("<b>ELEMENT INFO</b>", "axhdg");
$Ted->td_colspan(2);

// ..................................................................
$Fld = new form_textfield("_schema_name");
$Fld->setstyle("width:$cwidth;");
$Fld->setclass("axtxtbox");
$Fld->disabled = true;
$avail_maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Schema:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("_tag_name");
$Fld->setstyle("width:$ewidth;");
$Fld->setclass("axtxtbox");
$Fld->disabled = true;
$avail_maintainer->register_field($Fld);
$Ted->tr("axbgdark");
$Ted->td( "Tag name:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("_label");
$Fld->setstyle("width:$cwidth;");
$Fld->setclass("axtxtbox");
$Fld->disabled = true;
$avail_maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Label:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
// Obligation of metadata data-entry..
$Fld = new form_textfield("_obligation");
$Fld->setstyle("width:$cwidth;");
$Fld->setclass("axtxtbox");
$Fld->disabled = true;
$avail_maintainer->register_field($Fld);
$Ted->tr("axbgdark");
$Ted->td( "Obligation:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("_default_value");
$Fld->setstyle("width:$cwidth;");
$Fld->setclass("axtxtbox");
$Fld->disabled = true;
$avail_maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Default value:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("_list_of_values");
$Fld->setstyle("width:$ewidth;");
$Fld->setclass("axtxtbox");
$Fld->disabled = true;
$avail_maintainer->register_field($Fld);
$Ted->tr("axbgdark");
$Ted->td( "Value list:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_memofield("_definition");
$Fld->setstyle("width:$ewidth;height:50px;");
$Fld->setclass("axmemo");
$Fld->disabled = true;
$avail_maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Definition:", "axfg" );
$Ted->td_alignment( "", "top" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_memofield("_comments");
$Fld->setstyle("width:$ewidth;height:150px;");
$Fld->setclass("axmemo");
$Fld->disabled = true;
$avail_maintainer->register_field($Fld);
$Ted->tr("axbgdark");
$Ted->td( "Comments:", "axfg" );
$Ted->td_alignment( "", "top" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("_scheme_list");
$Fld->setstyle("width:$ewidth;");
$Fld->setclass("axtxtbox");
$Fld->disabled = true;
$avail_maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Schemes:", "axfg" );
$Ted->td_alignment( "", "top" );
$Ted->td( $Fld->render() );

// ..................................................................
// Render the whole form..
$Ted->tr("axtitle");
$Ted->td("&nbsp;", "axtitle");
$Ted->td_colspan(2);

$Ted->set_width_profile("30%,70%");
$AVAIL_METADATA_ELEMENTS .= $Ted->render();

// Render the maintainer. This adds the Javascript data structures
// and renders the hidden fields for submitting changed field data..
$AVAIL_METADATA_ELEMENTS .= $avail_maintainer->render();

// ------------------------------------------------------------------
// WEBSITE METADATA ELEMENTS
// These are the metadata elements actually used on the website to describe content.

// KEYFIELD and RECORD MAINTAINER
// Meta Schema Set Listbox
// Declared here so we can create the maintainer and register buttons
// before they are used in the form.
//
// This is the keyfield listbox which controls the maintainance
// process. It lists all records being maintained..
$site_meta_listbox = new form_combofield("key_element_id");
$site_meta_listbox->setclass("axlistbox");
$site_meta_listbox->setstyle("width:$ewidth;");
$site_meta_listbox->size = 16;

// Make a new record maintainer, and attach the buttons..
$site_maintainer = new recmaintainer($maint_formname, $site_meta_listbox, "site_");

// Register all relevant buttons to the maintainer..
$site_maintainer->register_button("save", $bsav);
$site_maintainer->register_button("up" ,  $bup);
$site_maintainer->register_button("down", $bdown);

$Ted = new table("site_metadata");
$Ted->setpadding(2);

// ..................................................................
// Heading..
$Ted->tr("axhdg");
$Ted->td("<b>WEBSITE METADATA ELEMENTS</b>", "axhdg");
$Ted->td_colspan(2);

$Ted->tr("axbglite");
$Ted->td("&nbsp;");
$Ted->td_colspan(2);
$Ted->td_height(26);

// Continue defining listbox..
$q  = "SELECT *,sme.label as sitelabel";
$q .= "  FROM ax_site_meta_element sme, ax_meta_element e";
$q .= " WHERE e.element_id=sme.element_id";
$q .= "   AND e.enabled=TRUE";
$q .= " ORDER BY sme.display_order";
$elemset = dbrecordset($q);
$site_count = $elemset->rowcount;
if ($site_count > 0) {
  do {
    // Populate listbox..
    $elementid      = $elemset->field("element_id");
    $parent_schema  = $elemset->field("schema_name");
    $label          = $elemset->field("sitelabel");
    $obligation     = $elemset->field("obligation");
    $default_value  = $elemset->field("default_value");
    $list_of_values = $elemset->field("list_of_values");
    $description    = $elemset->field("description");
    $indexed        = $elemset->istrue("indexed");
    $searchable     = $elemset->istrue("searchable");
    $enabled        = $elemset->istrue("enabled");
    $site_meta_listbox->additem($elementid, $label);

    // Qualify the element with possible parent(s)..
    $tag_name = $elemset->field("tag_name");
    $parent_elemid = $elemset->field("parent_element");
    $tag_name = get_full_tag_name($tag_name, $parent_elemid);

    // Populate maintainer data. The maintainer add_record method
    // requires an associative array keyed on listbox key id..
    $rec = array(
            "element_id" => $elementid,
            "parent_schema" => $parent_schema,
            "tag_name" => format_tag_name($tag_name),
            "label" => $label,
            "obligation" => $obligation,
            "default_value" => $default_value,
            "list_of_values" => $list_of_values,
            "description" => $description,
            "indexed" => ($indexed ? "t" : "f"),
            "searchable" => ($searchable ? "t" : "f"),
            "enabled" => ($enabled ? "t" : "f")
            );
    $site_maintainer->add_record($elementid, $rec);

    // If this is the element being edited, make sure
    // that it gets focussed..
    if (isset($element_id) && $element_id == $elementid) {
      $site_maintainer->initial_record($elementid);
    }
  } while ($elemset->get_next());
}

// The listbox field..
$Ted->tr("axbgdark");
$Ted->td( $site_meta_listbox->render() );
$Ted->td_colspan(2);
$Ted->td_alignment("right", "top");

// ..................................................................
$Fld = new form_hiddenfield("element_id");
$site_maintainer->register_field($Fld);
$Ted->tr("axhdg");
$Ted->td("<b>ELEMENT SETTINGS</b>" . $Fld->render(), "axhdg");
$Ted->td_colspan(2);

// ..................................................................
$Fld = new form_textfield("parent_schema");
$Fld->setstyle("width:$cwidth;");
$Fld->setclass("axtxtbox");
$Fld->editable = false;
$site_maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Schema:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("tag_name");
$Fld->setstyle("width:$ewidth;");
$Fld->setclass("axtxtbox");
$Fld->disabled = true;
$site_maintainer->register_field($Fld);
$Ted->tr("axbgdark");
$Ted->td( "Tag name:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("label");
$Fld->setstyle("width:$cwidth;");
$Fld->setclass("axtxtbox");
$site_maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Label:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
// Obligation of metadata data-entry..
$Fld = new form_combofield("obligation");
$Fld->setstyle("width:$cwidth;");
$Fld->setclass("axcombo");
$site_maintainer->register_field($Fld);
$Fld->additem("", "");
$Fld->additem('o', "Optional");
$Fld->additem('m', "Mandatory");
$Fld->additem('c', "Conditional");
$Fld->additem('r', "Recommended");
$Ted->tr("axbgdark");
$Ted->td( "Obligation:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("default_value");
$Fld->setstyle("width:$cwidth;");
$Fld->setclass("axtxtbox");
$site_maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Default value:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("list_of_values");
$Fld->setstyle("width:$ewidth;");
$Fld->setclass("axtxtbox");
$site_maintainer->register_field($Fld);
$Ted->tr("axbgdark");
$Ted->td( "Value list:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_memofield("description");
$Fld->setstyle("width:$ewidth;height:163px;");
$Fld->setclass("axmemo");
$site_maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Description:", "axfg" );
$Ted->td_alignment( "", "top" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_checkbox("indexed");
$Fld->setclass("axchkbox");
$site_maintainer->register_field($Fld);
$Ted->tr("axbgdark");
$Ted->td( "Indexed:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_checkbox("searchable");
$Fld->setclass("axchkbox");
$site_maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Searchable:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_checkbox("enabled");
$Fld->setclass("axchkbox");
$site_maintainer->register_field($Fld);
$Ted->tr("axbgdark");
$Ted->td( "Enabled:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
// Render the whole form..
$Ted->tr("axtitle");
$Ted->td("&nbsp;", "axtitle");
$Ted->td_colspan(2);

$Ted->set_width_profile("30%,70%");
$SITE_METADATA_ELEMENTS .= $Ted->render();

// Render the maintainer. This adds the Javascript data structures
// and renders the hidden fields for submitting changed field data..
$SITE_METADATA_ELEMENTS .= $site_maintainer->render();

// ------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// ------------------------------------------------------------------
// CONTROL BUTTONS
$Tbtn = new table("buttons");
$Tbtn->setpadding(2);
$Tbtn->tr("axhdg");
$Tbtn->td("&nbsp;", "axhdg");
$Tbtn->tr("axyl_rowstripe_lite");
$buttons = "<br><br>";
if ($avail_count > 0) $buttons .= $badd->render() . "<br>";
if ($site_count  > 0) $buttons .= $brem->render() . "<br>";
$buttons .= "<br>";
if ($avail_count > 1) $buttons .= $baddall->render() . "<br>";
if ($site_count  > 1) $buttons .= $bremall->render() . "<br>";
$buttons .= "<br>";
if ($site_count  > 1) {
  $buttons .= $bup->render() . "<br>" . $bdown->render() . "<br>";
}
$buttons .= "<br>";
if ($site_count  > 0) $buttons .= $bsav->render() . "<br>";
$Tbtn->td($buttons, "axyl_rowstripe_lite");
$CONTROL_BUTTONS = $Tbtn->render();

// ------------------------------------------------------------------
// mode field
$hid = new form_hiddenfield("mode", $mode);
$MODE_HIDDEN = $hid->render();

// ##################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form class="axform" name="sitemetadata" method="post">
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width="100%" align=center>
    <tr class="axtitle">
      <td colspan=3 align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center colspan=3 class=axerror><!--ERROR_MSG--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td class="axyl_rowstripe_dark" width="47%" valign="top"><!--AVAIL_METADATA_ELEMENTS--></td>
      <td class="axyl_rowstripe_lite" width="6%"  valign="top"><!--CONTROL_BUTTONS--></td>
      <td class="axyl_rowstripe_dark" width="47%" valign="top"><!--SITE_METADATA_ELEMENTS--></td>
    </tr>
    <tr class="axfoot">
      <td colspan=3></td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// ##################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",             $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",                 $HEADING);
$RESPONSE->plugin("ERROR_MSG",               $ERROR_MSG);
$RESPONSE->plugin("CONTROL_BUTTONS",         $CONTROL_BUTTONS);
$RESPONSE->plugin("AVAIL_METADATA_ELEMENTS", $AVAIL_METADATA_ELEMENTS);
$RESPONSE->plugin("SITE_METADATA_ELEMENTS",  $SITE_METADATA_ELEMENTS);

// ------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>