<?php
/*######################################################################*/
/* CATALYST Php Source Code                                             */
/* Copyright (C) 2002 Paul Waite                                        */
/*                                                                      */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Module:      forum                                                   */
/* Filename:    forum-defs.php                                          */
/* Author:      Mark Kessell                                            */
/* Description: Definitions for content forums, threads and messages    */
/*              management in webpages.                                 */
/*                                                                      */
/*######################################################################*/
/** @package forums */

// ......................................................................
// DEFINITIONS

/** A new forum thread */
define("NEW_THREAD", "NT");

/** A brand new forum */

define("NEW_FORUM", "NF");

/** A new forum thread message */
define("NEW_MSG", "NM");

// ----------------------------------------------------------------------
/**
* The forum class.
* @package forums
*/
class forum extends HTMLObject {
  var $forum_id;
  var $forum_name;
  var $forum_desc;
  var $enabled = true;
  var $private = false;
  var $moderator; // = array();
  var $posts;
  var $last_author;
  var $date_last_author;
  var $threadlast_author;
  var $new_topic;

  // forum title
  var $forum_title = "Default Axyl Forums";
  var $error_msg;

  var $forum_threads = array();
  var $forum_members = array();  // only if forum is a private forum.

  function forum ($forum_id=NEW_FORUM) {
    // Forum constructor.
    debugbr("FORUM CONSTRUCTOR.");
    $forum_id = trim($forum_id);
    $this->forum_id = $forum_id;
    if ( $this->forum_id != NEW_FORUM && is_numeric($this->forum_id)) {
      $this->get_forum();
    }

    // run the POSTprocess function
    $this->POSTprocess();
  } // forum

  function set_forum_greeting($title) {
    // sets the forums title. not to be confused with the forum_name
    if ( trim($title) != "" )
      $this->forum_title = $title;
  } // set_forum_pagetitle

  function get_forum () {
    // Gets the forum record, and it's associated parent messages (threads).
    $q = "select * from ax_forum where forum_id=$this->forum_id";
    $qQ = new dbrecords($q);

    if ( $qQ->hasdata ) {
      // load forum details
      $this->forum_name = $qQ->field("forum_name");
      $this->forum_desc = $qQ->field("forum_desc");
      $this->enabled = $qQ->istrue("enabled");
      $this->private = $qQ->istrue("private");
      debugbr("moderators: ".$qQ->field("moderator"));
      $this->moderator = $qQ->field("moderator");
      /*if ( substr_count($this->moderator, ',') == 0 && trim($this->moderator) != "" ) {
        $this->moderator[] = $qQ->field("moderator");
      } else {
        $this->moderator[]  = explode(',',$qQ->field("moderator"));
      }*/
      $this->get_threads();

      // get forum members if it's a private forum
      if ($this->private) {
        $m = "select user_id from ax_forum_member where forum_id=$this->forum_id";
        $mM = new dbrecords($m);

        if ( $mM->hasdata ) {
          do {
            $this->forum_members[$mM->fields("user_id")] = $mM->fields("user_id");
          } while ( $mM->get_next() );
        }
      } // load members for private forum
    } else {
      $this->forum_id = '';
    }
  } // get_forum

  function save_forum() {
    // save forum details to database.
    global $mode;

    if ( $this->forum_id == NEW_FORUM ) {
      // is an insert
      $query = new dbinsert("ax_forum");
      $fid = get_next_sequencevalue("seq_forum_id", "ax_forum", "forum_id");
      $query->set("forum_id", $fid);
    } else {
      // is an update
      $query = new dbupdate("ax_forum");
      $query->where("forum_id=$this->forum_id");
    }

    $query->set("forum_name", $this->forum_name);
    $query->set("forum_desc", $this->forum_desc);
    $query->set("enabled", $this->enabled);
    $query->set("private", $this->private);
    //$query->set("moderator", implode(',',$this->moderator));
    $query->set("moderator", $this->moderator);

    if ( $query->execute() ) {
      $this->error_msg = "Forum Record SAVED.";
      unset($mode);
      unset($forum_id);
      if ( $this->forum_id == NEW_FORUM ) {
        $this->forum_id = $fid;
      }
    }
  } // save_forum

  function add_member($user_id) {
    // add a member to a private forum.
    if ($this->private) {

    } else {
      // this is a public board.
      // raise error and display
      $this->error_msg = "This is a PUBLIC forum. No need to add members to it, as all members have access to it.";
    }
  } // add_member

  function new_topic () {
    // start a new thread in this forum
    debugbr("forum_id within new_topic function: $this->forum_id");
    $this->new_topic = new forum_thread(NEW_THREAD, $this->forum_id);
  } // new_topic

  function get_threads() {
    // get the parent msgs for this forum
    debugbr("AQUIRING THREADS! FORUM_ID=$this->forum_id");
    if ( $this->forum_id != NEW_FORUM ) {
      debugbr("GETTING THREAD HEADERS!!!");
      $q = "select msg_id from ax_forum_msg where forum_id=$this->forum_id and ";
      $q .= "parent_thread_id is null order by sticky desc, last_modified desc";
      $qQ = new dbrecords($q);

      if ( $qQ->hasdata ) {
        do {
          $this->forum_threads[$qQ->field("msg_id")] = new forum_thread($qQ->field("msg_id"), $this->forum_id);
          $this->forum_threads[$qQ->field("msg_id")]->set_moderator($this->moderator);
        } while ( $qQ->get_next() );
      }
    }

    debugbr("the count of threads in this forum: ".count($this->forum_threads));
  } // get_threads

  /** disable the forum from showing */
  function disable_forum () {
    $this->enabled =false;
  } // disable_forum

  /** enable the forum so it's visible again */
  function enable_forum() {
    $this->enabled = true;
  } // enable_forum

  function delete_forum() {
    // deletes the forum
    // delete disabled forums only, or does it not matter?
  } // delete_forum

  function html () {
    // display the html required for the page.
    global $RESPONSE, $mode, $forum_id, $thread_id;
    global $SaveForum_x, $BackForum_x, $CancelForum_x, $locked, $sticky;
    global $SaveThread_x, $BackThread_x, $CancelThread_x;
    global $SaveMsg_x, $BackMsg_x, $CancelMsg_x, $hide, $msg_id, $thread_id;

    $s = "";

    debugbr("and the current mode is: $mode");

    if ( isset($BackForum_x) || isset($CancelForum_x) ) {
      $mode = '';
    }

    if ( isset($BackThread_x) || isset($CancelThread_x) ) {
      $mode = 'view';
    }

    if ( isset($BackMsg_x) || isset($CancelMsg_x) ) {
      $mode = 'viewthread';
    }

    $T = new table ("forum_html");
    $T->setwidth("100%");
    $T->setborder(0);
    $T->setpadding(4,1);
    $T->setalign("center");

    switch ($mode) {
      case "new":
      case "edit":
        // create and edit forums
        if ( $RESPONSE->ismemberof_group_in("Admin,Editor") ) {
          $T->tr();
          $T->td("Create/Edit Forum Details", "forumheadings" );
          $T->td_colspan(2);
          $T->tr();
          $T->td("<hr>");
          $T->td_colspan(2);

          if ( trim($this->error_msg) != "" ) {
            $T->tr();
            $T->td("<font color=\"red\">$this->error_msg</font>");
            $T->td_colspan(2);
            $T->tr();
            $T->td("<hr>");
            $T->td_colspan(2);
          }

          if ( $this->forum_id != NEW_FORUM ) {
            $fidlabel = new form_labelfield("fid", $this->forum_id);
            $fidlabel->setclass("axfmlbl");
            $T->tr();
            $T->td("Forum Id: ", "forumlabels");
            $T->td_width("20%");
            $T->td_alignment("right");
            $T->td($fidlabel->render());
          }

          // Forum Name text field
          $forumname = new form_textfield("forum_name", "", $this->forum_name);
          $forumname->setstyle("width: 250");
          $forumname->setclass("axtxtbox");
          $T->tr();
          $T->td("Forum Name: ", "forumlabels");
          $T->td_width("20%");
          $T->td_alignment("right");
          $T->td($forumname->render());

          // Forum Description
          $forumdesc = new form_memofield("forum_desc", "", $this->forum_desc);
          $forumdesc->setstyle("width: 250");
          $forumdesc->setclass("axmemo");
          $T->tr();
          $T->td("Forum Desc: ", "forumlabels");
          $T->td_width("20%");
          $T->td_alignment("right", "top");
          $T->td($forumdesc->render());

          // Enabled
          $forumenabled = new form_checkbox("enabled");
          if ($this->enabled) {
            $forumenabled->check();
          } else {
            $forumenabled->uncheck();
          }
          $T->tr();
          $T->td("Enabled: ", "forumlabels");
          $T->td_width("20%");
          $T->td_alignment("right");
          $T->td($forumenabled->render(), "axchkbox");

          debugbr("moderators: $this->moderators");
          debugbr("is array? ".is_array($this->moderators));
          debugbr("count of array: ".count($this->moderators));
          //debugbr("list of moderators: ".implode(', ', $this->moderators));

          // Moderator
          $fm = "select u.user_id from ax_user u";
          if ( !$RESPONSE->ismemberof_group_in("Admin,Editor") ) {
            $tmp = ", ax_user_group ug where u.user_id=ug.user_id and ug.group_id=2";
          }
          if ( trim($tmp) != "" ) $fm .= " $tmp and u.user_id != 'guest' order by lower(u.user_id)";
          else $fm .= " where u.user_id != 'guest' order by lower(u.user_id)";
          $FM = new dbrecords($fm);
          $forummoderator = new form_combofield("moderator", "", $this->moderator, EDITABLE, "", 1, SINGLESELECT);
          $forummoderator->setstyle("width: 250");
          $forummoderator->setclass("axlistbox");
          $forummoderator->add_querydata($FM, "user_id", "user_id");
          $T->tr();
          $T->td("Moderator(s): ", "forumlabels");
          $T->td_width("20%");
          $T->td_alignment("right", "top");
          $T->td($forummoderator->render());

          // POST button
          $pb = new form_imagebutton("SaveForum", "SaveForum", "", "lib/_save.gif", "", 57, 15);
          $cb = new form_imagebutton("CancelForum", "CancelForum", "", "lib/_cancel.gif", "", 57, 15);
          $T->tr();
          $T->td("&nbsp;");
          $T->td($cb->render() . " " . $pb->render());
          $T->td_alignment("left");

          $fidh = new form_hiddenfield("forum_id", $this->forum_id);
          $mh = new form_hiddenfield("mode", $mode);
          $T->tr();
          $T->td($fidh->render().$mh->render());
          $T->td_colspan(2);

          $F = new form("Create/Edit Forum");
          $F->set_fieldwidth_pct(100);
          $F->add($T);
          $s = $F->render();
        } else {
          $T->tr();
          $T->td("Only site Admins and Editors can create/delete or edit forums.");
          $s = $T->render();
        }

        break;
      case "edmsg":
        // admins/editors and moderators can edit any message within a given forum
        if ( $RESPONSE->ismemberof_group_in("Admin,Editor") || $RESPONSE->userid == trim($this->moderator) ) {
          debugbr("<font color=\"red\">EDIT MESSAGE SECTION 1</font>");
          $F = new form("EditMsg");
          $F->set_fieldwidth_pct(100);
          $F->add($this->forum_threads[$thread_id]);
          $s = $F->render();
        }
        break;
      case "delthd":
        // allows an admin / editor to delete a particular message
        if ( $RESPONSE->ismemberof_group_in("Admin,Editor") || $RESPONSE->userid == trim($this->moderator) ) {
          debugbr("DELETING THREAD #$msg_id");
          if ( dbcommand("delete from ax_forum_msg where msg_id=$thread_id or parent_thread_id=$thread_id") ) {
            unset($this->forum_threads);
            $this->get_threads();
          }
        }
      case "view":
        // display the threads within the selected forum
        // get the thread.
        $thd = $this->forum_threads[$thread_id];

        debugbr("<font color=\"red\">is thread an object: ".is_object($thd)."</font>");
        if ( trim($this->forum_id) != "" /*&& is_object($thd)*/ ) {
          // check the locked thread situation
          if ( ($RESPONSE->ismemberof_group_in("Admin,Editor") || $RESPONSE->userid == trim($this->moderator))
              && (trim($locked) == 1 || trim($locked) == 0) ) {
            switch ($locked) {
              case "1":
                debugbr("<font color=\"red\">LOCKING THREAD</font>");
                $thd->lock_thread();
                break;
              case "0":
                debugbr("<font color=\"red\">UNLOCKING THREAD</font>");
                $thd->unlock_thread();
                break;
            }
            unset($this->forum_threads);
            $this->get_threads();
          }

          // check if a thread has been made sticky or not
          if ( ($RESPONSE->ismemberof_group_in("Admin,Editor") || $RESPONSE->userid == trim($this->moderator))
              && (trim($sticky) == 1 || trim($sticky) == 0) ) {
            switch ($sticky) {
              case "1":
                debugbr("<font color=\"red\">STICKY THREAD</font>");
                $thd->stick_thread();
                break;
              case "0":
                debugbr("<font color=\"red\">UNSTICKY THREAD</font>");
                $thd->unstick_thread();
                break;
            }
            unset($this->forum_threads);
            $this->get_threads();
          }

          // display the forum threads.
          debugbr("IS THIS FORUM ENABLED? $this->enabled");
          debugbr("IS THIS FORUM name? $this->forum_name");
          $T->tr();
          $fl = "<a href=\"?mode=\" class=\"forumlink\">Forum List</a>";
          $T->td("$fl >> <b>$this->forum_name</b>");
          if ( !$RESPONSE->ismemberof_group("guest") && $this->enabled ) {
            $T->td("<a href=\"$RESPONSE->requested?mode=newthread&forum_id=$this->forum_id\" class=\"forumlink\">[New Topic]</a>");
            $T->td_colspan(3);
            $T->td_alignment("right");
          } else {
            $T->td_colspan(4);
          }
          $T->tr();
          $T->td("Topic", "threadtitle");
          $T->td_alignment("center");
          $T->td_width("70%");
          $T->td("Replies", "threadtitle");
          $T->td_alignment("center");
          $T->td_width("5%");
          $T->td("Author", "threadtitle");
          $T->td_alignment("center");
          $T->td_width("20%");
          $T->td("Views", "threadtitle");
          $T->td_alignment("center");
          $T->td_width("5%");
          /*$T->tr();
          $T->td("&nbsp;");
          $T->td_colspan(4);*/

          // display the thread header messages
          if ( count($this->forum_threads) > 0 ) {
            // display the threads
            foreach ($this->forum_threads as $thread) {
              //debugbr("<font color=\"red\">THREAD LOCKED: $thread->locked</font>");
              if ( trim($thread->subject) == "" ) $thread->subject = "(no thread topic)";
              debugbr("<font color=\"red\">MODERATOR: $thread->moderator</font>");
              debugbr("<font color=\"red\">$RESPONSE->userid ==== $thread->moderator</font>");

              if ($thread->enabled) {
                if ($thread->locked && !$thread->sticky) {
                  //debugbr("<font color=\"red\">THREAD LOCKED AND ENABLED</font>");
                  $tname = "<a href=\"$RESPONSE->requested?forum_id=$this->forum_id&thread_id=$thread->thread_id&mode=viewthread\" class=\"locked\">$thread->subject</a>";
                } elseif (!$thread->locked && $thread->sticky) {
                  //debugbr("<font color=\"red\">THREAD STICKY AND ENABLED</font>");
                  $tname = "STICKY: <a href=\"$RESPONSE->requested?forum_id=$this->forum_id&thread_id=$thread->thread_id&mode=viewthread\">".strtoupper($thread->subject)."</a>";
                } elseif ($thread->locked && $thread->sticky) {
                  //debugbr("<font color=\"red\">THREAD LOCKED AND STICKY AND ENABLED</font>");
                  $tname = "STICKY: <a href=\"$RESPONSE->requested?forum_id=$this->forum_id&thread_id=$thread->thread_id&mode=viewthread\" class=\"locked\">".strtoupper($thread->subject)."</a>";
                } else {
                  //debugbr("<font color=\"red\">THREAD UNLOCKED AND NOT STICKY AND ENABLED</font>");
                  $tname = "<a href=\"$RESPONSE->requested?forum_id=$this->forum_id&thread_id=$thread->thread_id&mode=viewthread\" class=\"forumlink\">$thread->subject</a>";
                }
              } else {
                $tname = "<a href=\"$RESPONSE->requested?forum_id=$this->forum_id&thread_id=$thread->thread_id&mode=viewthread\"><font color=\"red\"><i>$thread->subject</i></font></a>";
              }

              if ( $RESPONSE->ismemberof_group_in("Admin,Editor") || $RESPONSE->userid == trim($thread->moderator) ) {
                if ($this->enabled) {
                  if (!$thread->locked) {
                    //debugbr("<font color=\"red\">THREAD UNLOCKED</font>");
                    $tname .= "<br>";
                    $tname .= "<a href=\"$RESPONSE->requested?forum_id=$this->forum_id&thread_id=$thread->thread_id&mode=view&locked=1\" class=\"forumlinkother\">";
                    $tname .= "[LOCK]</a>";
                  } else {
                    //debugbr("<font color=\"red\">THREAD LOCKED</font>");
                    $tname .= "<br>";
                    $tname .= "<a href=\"$RESPONSE->requested?forum_id=$this->forum_id&thread_id=$thread->thread_id&mode=view&locked=0\" class=\"forumlinkother\">";
                    $tname .= "[UNLOCK]</a>";
                  }

                  if (!$thread->sticky) {
                    //debugbr("<font color=\"red\">THREAD NOT STICKY</font>");
                    $tname .= "<a href=\"$RESPONSE->requested?forum_id=$this->forum_id&thread_id=$thread->thread_id&mode=view&sticky=1\" class=\"forumlinkother\">";
                    $tname .= "[STICK]</a>";
                  } else {
                    //debugbr("<font color=\"red\">THREAD STICKY</font>");
                    $tname .= "<a href=\"$RESPONSE->requested?forum_id=$this->forum_id&thread_id=$thread->thread_id&mode=view&sticky=0\" class=\"forumlinkother\">";
                    $tname .= "[UNSTICK]</a>";
                  }
                }
              }


              $T->tr();
              $T->td("$tname");
              $T->td_width("70%");
              $T->td_alignment("left");
              $T->td($thread->replies);
              $T->td_width("5%");
              $T->td_alignment("center");
              $T->td($thread->author);
              $T->td_width("20%");
              $T->td_alignment("center");
              $T->td($thread->views);
              $T->td_width("5%");
              $T->td_alignment("center");
              $T->tr();
              $T->td("<hr>");
              $T->td_colspan(4);
            } // foreach
          } // if count(array) > 0
        } else {
          if ( trim($this->forum_id) == "" ) {
            $T->tr();
            $T->td("That Forum Id does not exist within the database");
          }

          /*if ( !is_object($thd) ) {
            $T->tr();
            $T->td("That Thread does not exist within the selected Forum");
          }*/
        }

        $s = $T->render();
        break;
      case "newthread":
        // start a new thread
        if ( !$RESPONSE->ismemberof_group("guest") ) {
          $this->new_topic();
          $F = new form("NewTopic");
          $F->set_fieldwidth_pct(100);
          $F->add($this->new_topic);
          $s = $F->render();
        } else {
          $T->tr();
          $T->td("You must be logged in in order to post a forum thread.");
          $s = $T->render();
        }
        break;
      case "reply":
        // reply to a thread message
        if ( !$RESPONSE->ismemberof_group("guest") ) {
          $thread = $this->forum_threads[$thread_id];
          if ($thread->enabled && !$thread->locked) {
            $F = new form("NewMsg");
            $F->set_fieldwidth_pct(100);
            $F->add($thread);
            $s = $F->render();
          } else {
            $T->tr();
            $T->td("This either LOCKED or DISABLED, and as a result, cannot by replied to.");
            $s = $T->render();
          }
        } else {
          $T->tr();
          $T->td("You must be logged in in order to post to a forum thread.");
          $s = $T->render();
        }
        break;
      case "delmsg":
        // allows an admin / editor to delete a particular message
        // dbcommand("delete from ax_forum_msg where msg_id=$msg_id and parent_thread_id=$msg_id");
        if ( $RESPONSE->ismemberof_group_in("Admin,Editor") || $RESPONSE->userid == trim($this->moderator) ) {
          debugbr("DELETING MESSAGE #$msg_id");
          dbcommand("delete from ax_forum_msg where msg_id=$msg_id");
        }
      case "viewthread":
        // view the messages within the thread
        if ( $this->forum_threads[$thread_id] ) {
          $thread = $this->forum_threads[$thread_id];
          debugbr("thread object: $thread");
          if ( !isset($BackMsg_x) && !isset($CancelMsg_x) && !isset($SaveThread_x) && !isset($SaveMsg_x) && trim($mode) != "edmsg" ) {
            $thread->inc_thread_views();
          }

          $s = $thread->render();
        } else {
          $T->tr();
          $T->td("That Thread Id does not exist within the database.");
          $s = $T->render();
        }

        break;
      case "hidden":
        // enable or disable the forum so only admins and editors can browse them
        if ( $RESPONSE->ismemberof_group_in("Admin,Editor") ) {
          if ( trim($hide) == 't' ) {
            $this->enable_forum();
          } else {
            $this->disable_forum();
          }
          $this->save_forum();
          if ( trim($hide) != "" ) {
            // enable or disable all threads & messages within this forum as required.
            debugbr("ENABLING/DISABLING FORUM THREADS AND MESSAGES");
            $query = new dbupdate("ax_forum_msg");
            $query->where("forum_id=$this->forum_id");
            $query->set("enabled", $this->enabled);
            $query->execute();
          }
        }
        //break;
      default:
        // display the forums that already exist.
        // and are not disabled
        debugbr("this is the default mode. displaying the forums list");
        $q = "select * from ax_forum";
        if ( !$RESPONSE->ismemberof_group_in("Admin,Editor") ) {
          $q .= " where enabled=TRUE";
        }
        $qQ = new dbrecords($q);

        $T->tr();
        $T->td("&nbsp;");
        $T->td_colspan(3);
        $T->tr();
        $T->td($this->forum_title, "forumgreetingdisp");
        $T->td_colspan(4);
        $T->td_alignment("left");
        $T->tr();
        $T->td("Forum Name", "forumtitle" );
        if ( $RESPONSE->ismemberof_group_in("Admin,Editor") ) {
          $T->td("<a href=\"$RESPONSE->requested?forum_id=".NEW_FORUM."&mode=new\" class=\"forumlinkwhite\">[NEW FORUM]</a>", "forumtitle" );
        } else {
          $T->td("&nbsp;", "forumtitle");
        }
        $T->td_colspan(3);
        $T->td_alignment("center");

        $T->tr();
        $T->td("<hr>");
        $T->td_colspan(4);

        if ( $qQ->hasdata ) {
          do {
            if (!$qQ->istrue("enabled")) {
              $fname = "<a href=\"$RESPONSE->requested?forum_id=".$qQ->field("forum_id")."&mode=view\" class=\"disabled\">".strtoupper($qQ->field("forum_name"))."</a>";
            } else {
              $fname = "<a href=\"$RESPONSE->requested?forum_id=".$qQ->field("forum_id")."&mode=view\" class=\"forumlink\">".strtoupper($qQ->field("forum_name"))."</a>";
            }
            $T->tr();
            $T->td("$fname");
            $T->td_width("80%");
            if ( $RESPONSE->ismemberof_group_in("Admin,Editor") ) {
              $T->td("<a href=\"$RESPONSE->requested?forum_id=".$qQ->field("forum_id")."&mode=edit\" class=\"forumlink\">[EDIT]</a>");
              $T->td_width("10%");
              $T->td("&nbsp;");
              if (!$qQ->istrue("enabled")) {
                $T->td("<a href=\"$RESPONSE->requested?forum_id=".$qQ->field("forum_id")."&mode=hidden&hide=t\" class=\"forumlink\">[ENABLE]</a>");
              } else {
                $T->td("<a href=\"$RESPONSE->requested?forum_id=".$qQ->field("forum_id")."&mode=hidden&hide=f\" class=\"forumlink\">[DISABLE]</a>");
              }
              $T->td_width("10%");
            } else {
              $T->td_colspan(4);
            }
            //if ( $RESPONSE->ismemberof_group_in("Admin,Editor") ) {
              $T->tr();
              $T->td("<hr>");
              $T->td_colspan(4);
            //}
          } while ( $qQ->get_next() );
        }

        $s = $T->render();
        break;
    }


    return $s;
  } // html

  function POSTprocess() {
    // this function takes care of the new messages that come in.
    global $forum_desc, $forum_name, $enabled, $private, $moderator;
    global $forum_members, $RESPONSE, $SaveForum, $SaveForum_x;
    global $SaveThread, $SaveThread_x, $SaveMsg, $SaveMsg_x;
    global $msg_subject, $msg_text, $date_posted, $author, $mode;
    global $msg_id, $thread_id;

    debugbr("POST PROCESS!!!");

    if ( isset($SaveForum_x) ) {
      // saving new and modified forum details
      if ( trim($forum_name) != "" ) {
        debugbr("SAVING FORUM!!!");
        $this->forum_name = trim($forum_name);
        $this->forum_desc = trim($forum_desc);
        $this->enabled    = isset($enabled);
        $this->private    = isset($private);
        $this->moderator  = $moderator;

        $this->save_forum();
        $mode = '';
      } else {
        debugbr("NOT SAVING FORUM!!!");
        if (trim($forum_name) == "") {
          debugbr("FORUM NAME IS BLANK!");
          $this->error_msg .= "Forum must have a NAME.";
        }
      }
    } else
    if ( isset($SaveThread_x) ) {
      // saving new thread post
      if ( trim($msg_subject) != "" ) {
        debugbr("SAVING THREAD!!!");
        $this->new_topic();
        $this->new_topic->subject = trim($msg_subject);
        $this->new_topic->text = trim($msg_text);
        $this->new_topic->author = trim($author);
        $this->new_topic->date_posted = trim($date_posted);
        $this->new_topic->save_thread();
        $this->get_threads();
        $mode = 'viewthread';
      } else {
        debugbr("NOT SAVING THREAD!!!");
        if (trim($msg_subject) == "") {
          debugbr("THREAD'S SUBJECT IS BLANK!");
          $this->new_topic->newmsg->error_msg .= "Thread must have a SUBJECT.";
        }

      }
    } else
    if ( isset($SaveMsg_x) ) {
      debugbr("SAVING THE MESSAGE REPLY!!! OR MSG EDIT");
      if ( trim($msg_subject) != "" ) {
        debugbr("SAVING MSG!!!");
        debugbr("msg_id = $msg_id and thread_id = $thread_id");
        debugbr("subject: $msg_subject, text: $msg_text");
        $thread = $this->forum_threads[$thread_id];

        if ( trim($mode) != "edmsg" ) {
          $thread->new_msg();
          $thread->newmsg->msg_subject = trim($msg_subject);
          $thread->newmsg->msg_text = trim($msg_text);
          $thread->newmsg->author = trim($author);
          $thread->newmsg->date_posted = trim($date_posted);
          if ( $thread->newmsg->save_msg() ) {
            $thread->modify_replies();
          }
        } else {
          $thread->render();
          $thread->get_thread_header();
          $thread->get_thread();
        }
        $mode = 'viewthread';
      } else {
        debugbr("NOT SAVING THREAD!!!");
        if (trim($msg_subject) == "") {
          debugbr("MSG'S SUBJECT IS BLANK!");
          $thread->error_msg .= "Message must have a SUBJECT.";
        }

      }
      // reset the mode so it doesn't stay at the enter msg screen.
      //$mode = "viewthread";
      //$this->render();
    }
  } // POSTprocess
} // class forum

// ----------------------------------------------------------------------
/**
* The forum thread class.
* @package forums
*/
class forum_thread extends forum {
  var $locked = false;
  var $sticky = false;
  var $views = 0;
  var $subject;
  var $enabled = true;
  var $text;
  var $author;
  var $thread_id;
  var $replies = 0;
  var $date_posted;
  var $forum_id;
  var $thread_msgs = array();
  var $newmsg;
  var $forum_moderator;

  function forum_thread ($thread_id=NEW_THREAD, $forum_id) {
    // main forum_thread contructor

    if ( isset($forum_id) ) {
      $this->thread_id = trim($thread_id);
      $this->forum_id = trim($forum_id);
    }
    debugbr("thread_id within the thread object: $this->thread_id");
    if ( $this->thread_id != NEW_THREAD && is_numeric($this->thread_id) ) {
      debugbr("getting the thread head message");
      $this->get_thread_header();
    }

    if ( $this->thread_id == NEW_THREAD ) {
      $this->newmsg = new thread_msg(NEW_MSG, $this->thread_id);
    }
  } // forum_thread constructor

  function get_thread_header() {
    // get the message for the thread header for a particular forum
    $q  = "select *, to_char(last_modified, 'DD/MM/YYYY HH:MI am') as date_posted ";
    $q .= "from ax_forum_msg where msg_id=$this->thread_id and forum_id=$this->forum_id";
    $qQ = new dbrecords($q);

    if ( $qQ->hasdata ) {
      $this->subject = trim($qQ->field("msg_subject"));
      $this->text = trim($qQ->field("msg_text"));
      $this->author = trim($qQ->field("msg_author"));
      $this->date_posted = trim($qQ->field("date_posted"));
      $this->views = $qQ->field("views");
      $this->locked = $qQ->istrue("locked");
      $this->sticky = $qQ->istrue("sticky");
      $this->enabled = $qQ->istrue("enabled");
      $this->replies = $qQ->field("replies");

      if ( trim($qQ->field("replies")) != "" ) $this->replies = $qQ->field("replies");
    }
  } // get_thread_header

  function set_moderator($mod="") {
    // sets the moderator for this thread
    $this->moderator = trim($mod);
  } // set_moderator

  function save_thread() {
    // save the thread information.
    // remember, it's just a message that has no parent message.
    global $mode, $thread_id;

    debugbr("the forum_id = $this->forum_id");

    if ( trim($this->thread_id) == NEW_THREAD ) {
      // then it's an insert
      $query = new dbinsert("ax_forum_msg");
      $tid = get_next_sequencevalue("seq_msg_id", "ax_forum_msg", "msg_id");
      $query->set("msg_id", $tid);
      $query->set("last_modified", 'now()');
    } else {
      // else it's an update
      $query = new dbupdate("ax_forum_msg");
      $query->where("msg_id=$this->thread_id");
    }

    $query->set("msg_subject", $this->subject);
    $query->set("msg_text", $this->text);
    $query->set("msg_author", $this->author);
    $query->set("views", $this->views);
    $query->set("forum_id", $this->forum_id);
    $query->set("replies", $this->replies);
    $query->set("sticky", $this->sticky);
    $query->set("locked", $this->locked);

    if ( $query->execute() ) {
      if ( $this->thread_id == NEW_THREAD ) {
        $this->thread_id = $tid;
        $thread_id = $tid;
      }

    }

  } // save_thread

  function lock_thread() {
    // lock the selected thread object
    $this->locked = true;
    $tup = new dbupdate("ax_forum_msg");
    $tup->set("locked", $this->locked);
    $tup->where("msg_id=$this->thread_id");
    $tup->execute();
  } // lock_thread

  function unlock_thread() {
    // unlock the selected thread object
    $this->locked = false;
    $tup = new dbupdate("ax_forum_msg");
    $tup->set("locked", $this->locked);
    $tup->where("msg_id=$this->thread_id");
    $tup->execute();
  } // unlock_thread

  function stick_thread() {
    // stick the selected thread object
    $this->sticky = true;
    $tup = new dbupdate("ax_forum_msg");
    $tup->set("sticky", $this->sticky);
    $tup->where("msg_id=$this->thread_id");
    $tup->execute();
  } // stick_thread

  function unstick_thread() {
    // unstick the selected thread object
    $this->sticky = false;
    $tup = new dbupdate("ax_forum_msg");
    $tup->set("sticky", $this->sticky);
    $tup->where("msg_id=$this->thread_id");
    $tup->execute();
  } // unstick_thread

  function inc_thread_views() {
    // this function writed to the views field in the thread message
    debugbr("<font color=\"red\">UPDATING THE VIEWS</font>");
    $this->views = $this->views + 1;
    $tup = new dbupdate("ax_forum_msg");
    $tup->set("views", $this->views);
    $tup->where("msg_id=$this->thread_id");
    $tup->execute();
  } // inc_thread_views

  function modify_replies() {
    // adjusts the threads replies field
    debugbr("<font color=\"red\">UPDATING THE REPLIES</font>");
    $this->replies = $this->replies + 1;
    $tup = new dbupdate("ax_forum_msg");
    $tup->set("replies", $this->replies);
    $tup->where("msg_id=$this->thread_id");
    $tup->execute();
  } // modify_replies

  function get_thread() {
    // Get the thread msgs.
    if ( $this->thread_id != NEW_THREAD ) {
      $q = "select msg_id from ax_forum_msg where forum_id=$this->forum_id and parent_thread_id=$this->thread_id";
      $q .= " order by last_modified asc";
      $qQ = new dbrecords($q);
      if ( $qQ->hasdata ) {
        do {
          $this->thread_msgs[$qQ->field("msg_id")] = new thread_msg($qQ->field("msg_id"), $this->thread_id);
        } while ( $qQ->get_next() );
      }
      // increment the "views" field in the thread record.
      //$this->inc_thread_views();
    }
    debugbr("the count of msgs in this thread: ".count($this->thread_msgs));
  } // get_thread

  function new_msg() {
    // creates a new message object
    $this->newmsg = new thread_msg(NEW_MSG, $this->thread_id);
  } // new_msg

  function html() {
    // display the message form here
    global $mode, $RESPONSE, $forum_id, $msg_id, $SaveMsg_x;
    global $msg_subject, $msg_text;

    $s = "";
    if ( $this->thread_id == NEW_THREAD ) {
      $s = $this->newmsg->new_msg();
    } else {
      switch ($mode) {
      case "reply":
        $this->new_msg();
        $s = $this->newmsg->new_msg();
        break;
      case "edmsg":
        // edit a message. admin and editor function only.
        debugbr("EDITING THE MESSAGE");
        $emsg = new thread_msg($msg_id, $this->thread_id);
        if ( !isset($SaveMsg_x) ) {
          $s = $emsg->edit_msg();
        } else {
          $emsg->msg_subject = trim($msg_subject);
          $emsg->msg_text = trim($msg_text);
          $emsg->save_msg();
        }
        break;
      default:
        $this->get_thread();
        $this->get_thread_header();
        $T = new table("ForumThread");
        $T->setpadding(4,1);
        $T->setborder(0);
        $T->setwidth("80%");
        $T->setalign("center");

        // thread header
        $T->tr();
        $tl = "<a href=\"$RESPONSE->requested?mode=view&forum_id=$forum_id\" class=\"forumlink\">Thread List</a>";
        $fl = "<a href=\"$RESPONSE->requested?mode=\" class=\"forumlink\">Forum List</a>";
        if ($this->locked) {
          $T->td("$fl >> $tl >> <b>$this->subject (This thread has been LOCKED)</b>");
        } else {
          $T->td("$fl >> $tl >> <b>$this->subject</b>");
        }
        $T->td_colspan(2);
        $T->tr();
        $T->td("&nbsp;");
        $T->td_colspan(2);
        // display the thread header message
        // subject
        $T->tr();
        $T->td("<b>$this->subject</b>", "forumtitle" );
        $T->td_contentcss("font-size:10pt");
        $T->td_alignment("left");
        $T->td_colspan(2);

        // message info and controls
        if ($this->enabled && !$this->locked) {
          $quote = "<a href=\"$RESPONSE->requested?mode=reply&forum_id=$this->forum_id&thread_id=$this->thread_id&quote=$this->thread_id\" class=\"forumlinkother\">[REPLY]</a>";
        } else {
          $quote = "&nbsp;";
        }
        if ( $RESPONSE->ismemberof_group_in("Admin,Editor")  || $RESPONSE->userid == trim($this->moderator) ) {
          $dthd = "<a href=\"$RESPONSE->requested?mode=delthd&msg_id=$this->thread_id&forum_id=$this->forum_id&thread_id=$this->thread_id\" class=\"forumlinkother\">[DELETE]</a>";
          $ethd = "<a href=\"$RESPONSE->requested?mode=edmsg&msg_id=$this->thread_id&forum_id=$this->forum_id&thread_id=$this->thread_id\" class=\"forumlinkother\">[EDIT]</a>";
        }
        $T->tr();
        $T->td("Thread last updated on $this->date_posted", "forummsginfo" );
        if ( !$RESPONSE->ismemberof_group("guest") ) {
          $T->td($quote."&nbsp;".$dthd."&nbsp;".$ethd);
          $T->td_width("20%");
        }

        // message body
        $T->tr();
        $T->td(str_replace("\n", "<br>", $this->text));
        $T->td_alignment("left", "top");
        $T->td_colspan(2);

        // the replies
        if ( count($this->thread_msgs) > 0 ) {
          $T->tr();
          $T->td("<hr>");
          $T->td_colspan(2);
          $temp = "";
          foreach ( $this->thread_msgs as $msg ) {
            // display the thread header message
            // subject
            debugbr("subject: $msg->msg_subject, text: $msg->msg_text");
            if ( trim($temp) != "" ) {
              $T->tr();
              $T->td("<hr>");
              $T->td_colspan(2);
            }
            $T->tr();
            $T->td("<b>$msg->msg_subject</b>");
            $T->td_contentcss("font-size:10pt");
            $T->td_alignment("left");
            $T->td_colspan(2);

            // message info and controls
            if ($this->enabled && !$this->locked) {
              $quote = "<a href=\"$RESPONSE->requested?mode=reply&forum_id=$msg->forum_id&thread_id=$msg->thread_id&quote=$msg->msg_id\" class=\"forumlinkother\">[REPLY]</a>";
            } else {
              $quote = "&nbsp;";
            }
            if ( $RESPONSE->ismemberof_group_in("Admin,Editor")  || $RESPONSE->userid == trim($this->moderator)) {
              $dmsg = "<a href=\"$RESPONSE->requested?mode=delmsg&msg_id=$msg->msg_id&forum_id=$msg->forum_id&thread_id=$msg->thread_id\" class=\"forumlinkother\">[DELETE]</a>";
              $ethd = "<a href=\"$RESPONSE->requested?mode=edmsg&msg_id=$msg->msg_id&forum_id=$msg->forum_id&thread_id=$msg->thread_id\" class=\"forumlinkother\">[EDIT]</a>";
            }
            $T->tr();
            $T->td("Posted by $msg->author on $msg->date_posted", "forumlinkother" );
            if ( !$RESPONSE->ismemberof_group("guest") ) {
              $T->td($quote."&nbsp;".$dmsg."&nbsp;".$ethd);
              $T->td_width("20%");
            }

            // message body
            $T->tr();
            $T->td(str_replace("\n", "<br>", $msg->msg_text));
            $T->td_alignment("left", "top");
            $T->td_colspan(2);

            $temp = "fish";
          }
        }
        $s = $T->render();
      } // switch ($mode)

    }

    return $s;
  } // html
} // class forum_thread

// ----------------------------------------------------------------------
/**
* The thread message class.
* @package forums
*/
class thread_msg extends forum_thread {
  var $locked = false;
  var $sticky = false;
  var $msg_id;
  var $thread_id;
  var $msg_subject;
  var $msg_text;
  var $author;
  var $date_posted;
  var $enabled = true;
  var $ParentMsg;
  var $forum_id;
  var $error_msg;

  function thread_msg ($msg_id=NEW_MSG, $thread_id) {
    // Msg Constructor

    debugbr("message_id: $msg_id and thread_id: $thread_id");
    if ( isset($thread_id) ) {
      $this->thread_id = trim($thread_id);
      $this->msg_id = trim($msg_id);
    }

    if ( isset($forum_id) ) $this->forum_id = $forum_id;

    if ( $this->msg_id != NEW_MSG && is_numeric($msg_id) ) {
      $this->get_msg();
    }
  } // thread_msg

  function get_msg() {
    // get the message object
    debugbr("getting the message to EDIT");
    $q  = "select *, to_char(last_modified, 'DD/MM/YYYY HH:MI am') as date_posted ";
    $q .= "from ax_forum_msg where msg_id=$this->msg_id";
    $qQ = new dbrecords($q);

    if ( $qQ->hasdata ) {
      // get msg and place info in appropriate var.
      $this->msg_subject = trim($qQ->field("msg_subject"));
      $this->msg_text = trim($qQ->field("msg_text"));
      $this->enabled = $qQ->istrue("enabled");
      $this->author = trim($qQ->field("msg_author"));
      $this->date_posted = $qQ->field("date_posted");
      $this->ParentMsg = trim($qQ->field("parent_thread_id"));
      $this->forum_id = trim($qQ->field("forum_id"));
    }
  } // get_msg

  function update_trlm() {
    // this function updates the thread last_modified field,
    // and the replies field.
    // as well as the last_author, threadlast_author and datelast_author
    // fields in the forum record.
    $q1 = "select * from ax_forum where forum_id=$this->forum_id";
    $Q1 = new dbrecords($q1);

    $q2 = "select * from ax_forum_msg where msg_id=$this->thread_id";
    $Q2 = new dbrecords($q2);
  } // update_trlm

  function save_msg() {
    // save the message.
    global $mode, $forum_id, $msg_id;

    debugbr("message id: $msg_id");
    if ( trim($this->msg_id) == NEW_MSG ) {
      // then it's an insert
      $query = new dbinsert("ax_forum_msg");
      $mid = get_next_sequencevalue("seq_msg_id", "ax_forum_msg", "msg_id");
      $query->set("msg_id", $mid);
      $query->set("parent_thread_id", $this->thread_id);
      $query->set("msg_author", $this->author);
      $query->set("last_modified", $this->date_posted);
      $query->set("forum_id", trim($forum_id));
      $query->set("enabled", $this->enabled);
      $query->set("sticky", $this->sticky);
      $query->set("locked", $this->locked);
    } else {
      // else it's an update
      $query = new dbupdate("ax_forum_msg");
      $query->where("msg_id=$this->msg_id");
    }

    $query->set("msg_subject", strip_tags($this->msg_subject), "<br>");
    $query->set("msg_text", strip_tags($this->msg_text), "<br>");

    if ( $query->execute() ) {
      $mode = "viewthread";

      // this is to update the thread last_modified field after the new message has been saved.
      // this is only modified when a new msg is saved into the thread. nothing else.
      // this is so threads can be sorted by the one with th emost recent post.
      if ( $this->msg_id == NEW_MSG && $this->thread_id != NEW_THREAD ) {
        $q = new dbupdate("ax_forum_msg");
        $q->where("msg_id=$this->thread_id");

        $q->set("last_modified", "now()");
        $q->execute();
      }

      // set the msg id
      $this->msg_id = $mid;
      return TRUE;
    } else { return FALSE; }
  } // save_msg

  function display_msg() {
    // return the html for this particular msg
    global $RESPONSE;

    $s = "";

    $T = new table("MessageTable".$this->msg_id);
    $T->setpadding(4,1);
    $T->setwidth("80%");
    $T->setborder(1);
    $T->tr();
    $T->td("<center>".strtoupper($this->msg_subject)."</center>");
    $T->td_colspan(3);
    $T->tr();
    $T->td("&nbsp;");
    $T->td_width("25%");
    $T->td("Posted on $this->date_posted By $this->author.");
    $T->td("&nbsp;");
    $T->td_width("25%");
    $T->tr();
    $T->td($this->msg_text);
    $T->td_colspan(3);

    $s = $T->render();

    return $s;
  } // display_msg

  function new_msg() {
    // displays the form objects for entering in a new message.
    global $RESPONSE, $forum_id, $mode;
    global $msg_subject, $msg_text;
    global $quote;

    if ( trim($msg_subject) != "" ) $this->msg_subject = trim($msg_subject);
    if ( trim($msg_text) != "" ) $this->msg_text = trim($msg_text);

    // set the non-entered fields for a message
    $this->author = $RESPONSE->userid;
    $this->date_posted = date("d/m/Y h:i a");
    if ( trim($this->thread_id) != NEW_THREAD ) {
      $this->ParentMsg = $this->thread_id;
    }

    $s = "";

    if ( trim($mode) == "reply") {
      $q = "select msg_subject, msg_text, msg_author, to_char(last_modified, 'DD/MM/YYYY HH:MI am') as date_posted ";
      $q .= "from ax_forum_msg where msg_id=$quote";
      $Q = new dbrecords($q);

      if ( $Q->hasdata ) {
        $oldsub = $Q->field("msg_subject");
        $this->msg_subject = "RE: ".$Q->field("msg_subject");
        $oldtxt = $Q->field("msg_text");

        $this->msg_text  = ">----------\nPosted by ".$Q->field("msg_author")." on ". $Q->field("date_posted").":";
        $this->msg_text .= "\n\n".$Q->field("msg_text")."\n>----------\n\n";
      }
    }

    // form objects.
    $ms = new form_textfield("msg_subject", "", $this->msg_subject);
    $ms->setstyle("width: 300");
    $ms->setclass("axtxtbox");
    $mt = new form_memofield("msg_text", "", $this->msg_text, EDITABLE, "", STD_WIDTH, 20);
    $mt->setstyle("width: 300");
    $mt->setclass("axmemo");

    $T = new table("MessageTable".$this->msg_id);
    $T->setpadding(4,1);
    $T->setwidth("80%");
    $T->setborder(0);
    $T->setalign("center");

    if ( trim($this->thread_id) != NEW_THREAD ) {
      $T->tr();
      $T->td("Subject:&nbsp;");
      $T->td_alignment("right");
      $T->td_width("25%");
      $T->td("$oldsub");
      $T->tr();
      $T->td("Text:&nbsp;");
      $T->td_alignment("right", "top");
      $T->td_width("25%");
      $T->td(str_replace("\n", "<br>", $oldtxt));
      $T->tr();
      $T->td("<hr>");
      $T->td_colspan(2);

      $pb = new form_imagebutton("SaveMsg", "Save Msg", "", "lib/_save.gif", "", 57, 15);
      $cb = new form_imagebutton("CancelMsg", "Cancel", "", "lib/_cancel.gif", "", 57, 15);
      //$bb = new form_imagebutton("BackMsg", "Back To Msgs", "", "lib/_back.gif", "", 42, 15);
    } else {
      $T->tr();
      $T->td("&nbsp;");
      $T->td("NEW THREAD", "forumheadings");
      /*$T->td_contentcss("font-size:12pt;
                         color: #FF6600;
                         font-weight: bold;");*/
      $pb = new form_imagebutton("SaveThread", "Save Thread", "", "lib/_save.gif", "", 57, 15);
      $cb = new form_imagebutton("CancelThread", "Cancel", "", "lib/_cancel.gif", "", 57, 15);
      //$bb = new form_imagebutton("BackThread", "Back To Threads", "", "lib/_back.gif", "", 42, 15);
    }

    debugbr("error message: $this->error_msg");
    if ( trim($this->error_msg) != "" ) {
      $T->tr();
      $T->td($this->error_msg, "formerror");
      //$T->td_contentcss("font-size:9pt");
      $T->td_colspan(2);
      $T->tr();
      $T->td("<hr>");
      $T->td_colspan(2);
    }

    $T->tr();
    $T->td("&nbsp;");
    $T->td("Posted by $this->author on $this->date_posted");
    //$T->td_contentcss("font-size:9pt");
    $T->tr();
    $T->td("Subject:&nbsp;");
    /*$T->td_contentcss("font-size:9pt;
                       color: #FF6600;");*/
    $T->td_width("25%");
    $T->td_alignment("right");
    $T->td($ms->render());
    $T->tr();
    $T->td("Text:&nbsp;");
    /*$T->td_contentcss("font-size:9pt;
                       color: #FF6600;");*/
    $T->td_width("25%");
    $T->td_alignment("right", "top");
    $T->td($mt->render());

    // POST button
    $T->tr();
    $T->td(/*$bb->render() . " " .*/ $cb->render() . " " . $pb->render());
    $T->td_colspan(2);
    $T->td_alignment("center");

    $fidh = new form_hiddenfield("forum_id", $forum_id);
    $tidh = new form_hiddenfield("thread_id", $this->thread_id);
    $midh = new form_hiddenfield("msg_id", $this->msg_id);
    $ah = new form_hiddenfield("author", $this->author);
    $dph = new form_hiddenfield("date_posted", $this->date_posted);
    $pidh = new form_hiddenfield("ParentMsg", $this->ParentMsg);
    $mh = new form_hiddenfield("mode", $mode);
    $T->tr();
    $T->td($fidh->render().$mh->render().$tidh->render().$midh->render().$ah->render().$dph->render().$pidh->render());
    $T->td_colspan(2);

    $s = $T->render();

    return $s;
  } // new_msg

  function edit_msg() {
    // displays the form objects for editing a message.
    global $RESPONSE, $forum_id, $mode;
    global $quote;

    // set the non-entered fields for a message

    debugbr("===================================================");
    debugbr("message id: $this->msg_id");
    debugbr("thread id: $this->thread_id");
    debugbr("message subject: $this->msg_subject");
    debugbr("message text: $this->msg_text");
    debugbr("author: $this->author");
    debugbr("date posted: $this->date_posted");
    debugbr("enabled: $this->enabled");
    debugbr("parent message id: $this->ParentMsg");
    debugbr("forum id: $this->forum_id");
    debugbr("===================================================");

    $s = "";

    // form objects.
    $ms = new form_textfield("msg_subject", "", $this->msg_subject);
    $ms->setstyle("width: 300");
    $ms->setclass("axtxtbox");
    $mt = new form_memofield("msg_text", "", $this->msg_text, EDITABLE, "", STD_WIDTH, 20);
    $mt->setstyle("width: 300");
    $mt->setclass("axmemo");

    $T = new table("MessageTable".$this->msg_id);
    $T->setpadding(4,1);
    $T->setwidth("80%");
    $T->setborder(0);
    $T->setalign("center");

    $T->tr();
    $T->td("&nbsp;");
    $T->td("EDIT MESSAGE / THREAD", "forumheadings");
    /*$T->td_contentcss("font-size:12pt;
                       color: #FF6600;
                       font-weight: bold;");*/
    $pb = new form_imagebutton("SaveMsg", "Save Msg", "", "lib/_save.gif", "", 57, 15);
    $cb = new form_imagebutton("CancelMsg", "Cancel", "", "lib/_cancel.gif", "", 57, 15);

    debugbr("error message: $this->error_msg");
    if ( trim($this->error_msg) != "" ) {
      $T->tr();
      $T->td("<font color=\"red\">$this->error_msg</font>");
      //$T->td_contentcss("font-size:9pt");
      $T->td_colspan(2);
      $T->tr();
      $T->td("<hr>");
      $T->td_colspan(2);
    }

    $T->tr();
    $T->td("&nbsp;");
    $T->td("Posted by $this->author on $this->date_posted");
    //$T->td_contentcss("font-size:9pt");
    $T->tr();
    $T->td("Subject:&nbsp;");
    /*$T->td_contentcss("font-size:9pt;
                       color: #FF6600;");*/
    $T->td_width("25%");
    $T->td_alignment("right");
    $T->td($ms->render());
    $T->tr();
    $T->td("Text:&nbsp;");
    /*$T->td_contentcss("font-size:9pt;
                       color: #FF6600;");*/
    $T->td_width("25%");
    $T->td_alignment("right", "top");
    $T->td($mt->render());

    // POST button
    $T->tr();
    $T->td($cb->render() . " " . $pb->render());
    $T->td_colspan(2);
    $T->td_alignment("center");

    $fidh = new form_hiddenfield("forum_id", $forum_id);
    $tidh = new form_hiddenfield("thread_id", $this->thread_id);
    $midh = new form_hiddenfield("msg_id", $this->msg_id);
    $ah = new form_hiddenfield("author", $this->author);
    $dph = new form_hiddenfield("date_posted", $this->date_posted);
    $pidh = new form_hiddenfield("ParentMsg", $this->ParentMsg);
    $mh = new form_hiddenfield("mode", $mode);
    $T->tr();
    $T->td($fidh->render().$mh->render().$tidh->render().$midh->render().$ah->render().$dph->render().$pidh->render());
    $T->td_colspan(2);

    $s = $T->render();

    return $s;
  } // edit_msg
} // class thread_msg
// ----------------------------------------------------------------------
?>