/*  -*- Mode: Asm -*-  */

/* Copyright (c) 2002  Michael Stumpf  <mistumpf@de.pepperl-fuchs.com>
   All rights reserved.


   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
     
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. 
*/

/*
    ldexp.S is part of     FPlib V 0.3.0       ported to avr-as
    for details see readme.fplib

 *----------------------------------------------------------------------------------------
 *
 * A = 2^exp * x
 * e.g.
 * double y = ldexp( 3.45, 2 ) = 2^2 * 3.45 = 13.8
 */

#if !defined(DOXYGEN)

#include "gasava.inc"
#include "fplib.inc"

          TEXT_SEG(fplib, ldexp)
          FUNCTION(ldexp)

GLOBAL(ldexp)
        BST     rA3,7
        RCALL   _U(__fp_split1)		; clears rAE
        TST     rA3			;
        BREQ    _ldexp_01		; 2^x*0 = 0
        CPI     rPH,0xFF
        BREQ    _ldexp_10		; negative
        TST     rPH
        BREQ    _ldexp_10
				; overflow or underflow
 _dlexp_00:
        BRPL    _ldexp_NaN		; overflow
 _ldexp_01:
        RJMP    _U(__fp_zero)
 _ldexp_NaN:
        RJMP    _U(__fp_nanERANGE)	; overflow

 _ldexp_10:
        ADD     rA3,rPL
        adc     rT1c,rPH		;
				; check for overflow
        BRNE    _ldexp_20
 _ldexp_20:
        RJMP    _U(__fp_merge)		; rT0 must not be cleared : rAE=0 no rounding anyway

          ENDFUNC

#endif /* not DOXYGEN */
