#ifndef	LIST_DEFINE
#define	LIST_DEFINE

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


class LIST
{
	private:
	long int	_numEntries;
	LISTENTRY	*_head;
	LISTENTRY	*_tail;
	LISTENTRY	*_current;

	public:

	LIST ();
	~LIST ();
	LIST		*copyList ();
	LIST		*splitListBeforeEntry (LISTENTRY *entry);
	LIST		*splitListAfterEntry (LISTENTRY *entry);

	LISTENTRY	*getNextEntry ();
	LISTENTRY	*getNextEntry (LISTENTRY *entry);
	LISTENTRY	*getPrevEntry ();
	LISTENTRY	*getPrevEntry (LISTENTRY *entry);
	LISTENTRY	*getCurrentEntry ();
	LISTENTRY	*getFirstEntry ();
	LISTENTRY	*getLastEntry ();

	LISTENTRY	*moveToNextEntry ();
	LISTENTRY	*moveToPrevEntry ();
	LISTENTRY	*moveToFirstEntry ();
	LISTENTRY	*moveToLastEntry ();

	void		moveEntryToBeforePrev ();
	void		moveEntryToAfterNext ();
	void		moveEntryToAfterEntry (LISTENTRY *movingEntry, LISTENTRY *entry);
	void		moveEntryToBeforeEntry (LISTENTRY *movingEntry, LISTENTRY *entry);

	void		insertEntryAfter (LISTENTRY *entry);
	void		insertEntryBefore (LISTENTRY *entry);

	void		*removeEntry (LISTENTRY *entry);
};

#endif
