/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __TSUTIL_H__
#define __TSUTIL_H__

#include <stdlib.h>
#include <stdio.h>

#include <kmessagebox.h>
#include <qstring.h>

#if QT_VERSION >= 300
#	define ARSON_KDE3	1
#endif

#ifdef NDEBUG
#	undef ARSONDBG
#	undef DEBUG
#endif

/*========================================================*/

#ifdef ARSONDBG
#define Assert(c)		Ts_Assert((c) ? true : false, #c, __FILE__, __LINE__)
#define Verify(c)		Ts_Assert((c) ? true : false, #c, __FILE__, __LINE__)
#else
#define Assert(c)
#define Verify(c)		(c)
#endif	//	ARSONDBG

#if defined(ARSONDBG) || defined(ARSONTRACE)
void Ts_Trace (const char *fmt, ...);
#define Trace			Ts_Trace
#else
#define Trace 			(true)?0:printf
#endif	//	ARSONDBG || ARSONLOG

#define ARRSIZE(arr)	(sizeof((arr))/sizeof((arr)[0]))
#define IFPTR(ptr)		if((ptr))(ptr)
#define THIS			(*this)
#define DELETE(p)		delete (p); (p) = NULL

#define InArray(n,m)	((n) >= 0 && (n) < (m))

/*========================================================*/
#ifdef ARSONDBG
inline void Ts_Assert (bool val, const char *expr, const char *filename, int line)
{
	if (!val)
	{
		QString msg;

		msg.sprintf("Assertion Failed!\n\n"
			"In file %s, line %d.\n"
			"Code: %s\n",
			filename, line, expr);

		const int result = KMessageBox::warningContinueCancel(
			NULL, msg, "Assertion Failed!"
#ifndef ARSON_KDE3
			, "Continue"
#endif	//	!ARSON_KDE3
			);

		if (result != KMessageBox::Continue)
			exit(1);
	}
}

/*========================================================*/
/*	Instance counter
 *========================================================*/

#include <qmap.h>

class arson_instance_counter
{
	struct ic {
		ic (void) : m_count(0) {}
		int &count (void) { return m_count; }
		int count (void) const { return m_count; }
		int m_count;
	};

	typedef QMap<QString,ic> TYPES;

public:
	arson_instance_counter (void) { }
	
	void incr (const QString &name) { m_ics[name].count()++; }
	void decr (const QString &name) {
		Assert(m_ics.contains(name));
		m_ics[name].count()--;
	}

	void dump (const QString &name = QString::null) const
	{
		for (TYPES::ConstIterator it = m_ics.begin(), end = m_ics.end();
			 it != end; ++it)
			if (name == QString::null || it.key() == name)
				Trace("[%-12s] Count: %d\n", it.key().ascii(), it.data().count());
	}

private:
	TYPES m_ics;
};

extern arson_instance_counter g_INSTANCE_COUNTER;

#	define ARSON_INSTANCE_INCR(n)		g_INSTANCE_COUNTER.incr((n))
#	define ARSON_INSTANCE_DECR(n)		g_INSTANCE_COUNTER.decr((n))
#	define ARSON_INSTANCE_DUMP(n)		g_INSTANCE_COUNTER.dump((n))
#	define ARSON_INSTANCE_DUMP_ALL()	g_INSTANCE_COUNTER.dump()
#else
#	define ARSON_INSTANCE_INCR(n)
#	define ARSON_INSTANCE_DECR(n)
#	define ARSON_INSTANCE_DUMP(n)
#	define ARSON_INSTANCE_DUMP_ALL()
#endif	//	ARSONDBG

inline void ts_arson_noop (const char *s, ...) { }

namespace ts {
	template<class T> inline void swap (T &rhs, T &lhs) {
		const T tmp = rhs;
		rhs = lhs;
		lhs = tmp;
	}
};

/*========================================================*/
#endif	/*	__TSUTIL_H__	*/
