/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SUBMIT_H__
#define __SUBMIT_H__

#include "socket.h"

/*========================================================*/

class ArsonCdInfo;
class QTextStream;

class ArsonCdInfoSubmit
{
public:
	ArsonCdInfoSubmit (const ArsonCdInfo &info);
	virtual ~ArsonCdInfoSubmit (void);

	const QString &filename (void) const { return m_filename; }

	virtual bool writeFile (const QString &fn = QString::null);
	
protected:
	virtual bool writeContents (QTextStream *ptr) const = 0;

	const ArsonCdInfo &m_info;
	QString m_filename;
};

/*========================================================*/

class ArsonFreedbSubmit : public ArsonCdInfoSubmit
{
public:
	ArsonFreedbSubmit (const ArsonCdInfo &info, const QString &email, bool hdrs = true)
		: ArsonCdInfoSubmit(info), m_contentLength(0),
		m_email(email), m_bWantHeaders(hdrs)
	{}

	virtual bool writeFile (const QString &fn = QString::null);

private:
	virtual bool writeContents (QTextStream *ptr) const;

	bool writeHeaders (QTextStream *ptr, uint length) const;

	const QString m_email;
	uint m_contentLength;
	bool m_bWantHeaders;
};

/*========================================================*/

class ArsonCdInfoSubmitDlg : public ArsonSocketWaitDlg
{
public:
	ArsonCdInfoSubmitDlg (ArsonCdInfoSubmit &submit,
		ArsonSendSocket *pSocket);

	virtual int exec (void);

protected:
	virtual ArsonSocket *createSocket (void) { return m_pSocket; }

	ArsonSendSocket *m_pSocket;
	ArsonCdInfoSubmit &m_info;
};

/*========================================================*/
#endif	/*	__SUBMIT_H__	*/
