/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	The worker-program path selection config page.
 *
 *	by Tony Sideris	(11:35PM Nov 09, 2002)
 *================================================*/
#include "arson.h"

#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qlayout.h>

#include <kurllabel.h>
#include <klocale.h>
#include <krun.h>

#include "programdlg.h"
#include "listwnd.h"
#include "pathpage.h"

/*========================================================*/

ArsonPathPage::ArsonPathPage (ArsonConfig &config, ArsonConfigDlg *pd, QWidget *parent)
	: ArsonPathPageBase(parent), ArsonConfigPage(config)
{
	KURLLabel *pl;
	static ArsonListHeader hdrs[] = {
		ArsonListHeader(i18n("Program Name"), 25),
		ArsonListHeader(i18n("Program Path"), 45),
		ArsonListHeader(i18n("Extra Parameters"), 30),
	};

	//	Initialize and fill in the program list
	program_list->setListHeaders(hdrs, ARRSIZE(hdrs));
	program_list->setSorting(-1);
	program_list->setAllColumnsShowFocus(true);
	program_list->setSelectionMode(QListView::Single);
	paths->setText(cfg().extraProgramPaths());
	fillProgramList();

	//	cdrdao Drivers
	fillDriverList(writer_drv);
	fillDriverList(source_drv);
	writer_drv->setEditText(cfg().driver());
	source_drv->setEditText(cfg().srcDriver());

	//	Add a helpful hyperlink for setting driver
	pl = new KURLLabel(QString("http://cdrdao.sourceforge.net/drives.html"),
		i18n("Need Help? Heres a driver list..."), driver_group);
	driver_groupLayout->addWidget(pl);
	pl->setGlow(true);

	QObject::connect(program_list, SIGNAL(doubleClicked(QListViewItem*)),
		this, SLOT(program_dblclk(QListViewItem*)));
	QObject::connect(pl, SIGNAL(leftClickedURL(const QString &)),
		this, SLOT(url_clicked(const QString &)));
}

/*========================================================*/

void ArsonPathPage::fillProgramList (void)
{
	QListViewItem *pLast = NULL;
	const ArsonConfig::Program *papp;

	program_list->clear();

	for (int index = 0; (papp = cfg().program(index)); index++)
		pLast = new QListViewItem(program_list, pLast,
			ArsonProgramDef::definition(index).programName(),
			papp->m_program,
			papp->m_params);
}

/*========================================================*/

void ArsonPathPage::url_clicked (const QString &url)
{
	KRun::runURL(url, "text/html");
}

/*==========================================================*/

void ArsonPathPage::auto_detect_clicked()
{
	//	Rescan and refill the program list.
	cfg().autoDetectPrograms(paths->text());
	fillProgramList();
}

/*==========================================================*/

void ArsonPathPage::program_dblclk (QListViewItem *pItem)
{
	const int index = program_list->itemIndex(pItem);
	ArsonConfig::Program *papp = cfg().program(index);

	if (ArsonProgramDlg(this, index, *papp).exec() == QDialog::Accepted)
		fillProgramList();
}

void ArsonPathPage::modify_clicked (void)
{
	if (QListViewItem *pi = program_list->currentItem())
		program_dblclk(pi);
}

/*==========================================================*/

void ArsonPathPage::fillDriverList (QComboBox *ptr)
{
	const char *drivers[] = {
		"plextor",
		"plextor-scan",
		"cdd2600",
		"generic-mmc",
		"generic-mmc-raw",
		"ricoh-mp6200",
		"sony-cdu920",
		"sony-cdu948",
		"taiyo-yuden",
		"teac-cdr55",
		"yamaha-cdr10x",
	};

	for (int index = 0; index < ARRSIZE(drivers); ++index)
		ptr->insertItem(drivers[index]);

	ptr->listBox()->sort();
}

/*==========================================================*/

void ArsonPathPage::on_accept (void)
{
	cfg().setSrcDriver(source_drv->currentText().stripWhiteSpace());
	cfg().setDriver(writer_drv->currentText().stripWhiteSpace());
	cfg().setExtraProgramPaths(paths->text());
}

/*========================================================*/
