/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __CDINDEX_H__
#define __CDINDEX_H__

#include <qstack.h>
#include <qxml.h>

//#include <ktempfile.h>

#include "cdinfowaitdlg.h"
#include "socket.h"
#include "cdinfo.h"

/*========================================================*/

class ArsonCdindexSocket : public ArsonHttpGetSocket
{
public:
	ArsonCdindexSocket (const QString &cdindex,
		const QString &host, short port = 80);

private:
	virtual QString request (void) const;
	virtual QString path (void) const;
	
	QString m_cdIndex;
};

/*========================================================*/

class QXmlAttributes;
class ArsonCdInfo;
class ArsonCdInfo::Track;

class ArsonCdindexParser : public QXmlDefaultHandler
{
	typedef QStack<QString> TAGSTACK;
	
public:
	ArsonCdindexParser (void)
		: m_pCurTrack(NULL)
	{}

	const ArsonCdInfo &info (void) const { return m_info; }
	
private:
	virtual bool startElement (const QString &namespaceURI,
		const QString &local, const QString &name,
		const QXmlAttributes &attr);
	virtual bool endElement (const QString &namespaceURI,
		const QString &local, const QString &name);
	virtual bool characters (const QString &chars);


	bool use (ArsonCdInfo::Track &track, const QString &tag, const QString &data);
	bool use (ArsonCdInfo &info, const QString &tag, const QString &data);
	ArsonCdInfo::Track toTrack (const QXmlAttributes &attr);

	ArsonCdInfo::Track *m_pCurTrack;
	TAGSTACK m_tagStack;
	ArsonCdInfo m_info;
};

/*========================================================*/

class ArsonCdindexDlg : public ArsonCdInfoWaitDlg
{
public:
	ArsonCdindexDlg (const ArsonCdInfo &info, const QString &addr, short port);

protected:
	virtual void handleStream (QTextStream *pStream);
	virtual ArsonSocket *createSocket (void);

	QString m_addr;
	short m_port;
};

/*========================================================*/
#endif	/*	__CDINDEX_H__	*/
