# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package ArchZoom::MimeTypes;

use Exporter;
use vars qw(@ISA @EXPORT %mime_types);
@ISA = qw(Exporter);
@EXPORT = qw(get_file_mime_type);
my %ext_mime_types = ();

sub _prepare_mime_types_hash () {
	my $file = $ArchZoom::Config{mime_types_file};
	return unless $file;
	open MIMETYPES, "<$file" or return warn "Can't open $file: $!\n";
	while (<MIMETYPES>) {
		next if /^#/;
		chomp;
		my ($mime_type, @exts) = split(" ");
		next unless $mime_type && @exts;
		$ext_mime_types{$_} = $mime_type foreach @exts;
	}
	close MIMETYPES;
}

sub get_file_mime_type ($;$) {
	my $file = shift;
	my $is_binary = shift || 0;
	_prepare_mime_types_hash() unless %ext_mime_types;
	my $ext = $file =~ /.*\.(.*)/? $1: "";
	unless (exists $ext_mime_types{$ext}) {
		return $is_binary? "application/octet-stream": "text/plain";
	}
	return $ext_mime_types{$ext};
}

1;
