// ---------------------------------------------------------------------------
// - csys.hpp                                                                -
// - standard system library - c system native function definition           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_CSYS_HPP
#define  ALEPH_CSYS_HPP

#ifndef  ALEPH_CCNF_HPP
#include "ccnf.hpp"
#endif

namespace aleph {

  /// @return the host name
  char* c_hostname (void);

  /// @return the user name
  char* c_username (void);

  /// @return a unique temporary name
  char* c_tmpname (void);

  /// set the program name
  void c_setpgm (const char* c);

  /// @return the program name
  char* c_getpgm (void);

  /// @return the os name
  const char* c_osname (void);

  /// @return the os type
  const char* c_ostype (void);

  /// @return the native option separator
  const char c_optsep (void);

  /// abort the execution without registered code
  void c_abort (void);

  /// exit unconditionnaly with a status code
  void c_exit (int status);

  /// register a function to execute at exit
  /// @param func the function to register
  void c_atexit (void (*func) (void));

  /// @return the process id
  long c_getpid (void);

  /// @return an environment variable value
  const char* c_getenv (const char* name);

  /// @return the backtrace of the calling function
  void* c_backtrace (void);

  /// print the backtrace on the standard error stream
  /// @param bptr the backtrace pointer
  void c_printtrace (void* bptr);

  /// destroy the backtrace information
  /// @param bptr the backtrace pointer
  void c_destroytrace (void* bptr);
}

#endif
