// ---------------------------------------------------------------------------
// - Main.cpp                                                                -
// - the aleph interpreter main program                                      -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Interp.hpp"
#include "System.hpp"
#include "Options.hpp"

// main interpreter 

int main (int argc, char** argv) {
  using namespace aleph;
  OutputTerm terr (OutputTerm::ERROR);

  // create a new option instance
  Options* options = new Options (argc,argv);

  // get the optional file name
  String fname = options->getfname ();
  bool   sflag = (fname.length () == 0);

  // create a new interpreter
  Input*  is = nilp;
  Output* os = nilp;
  Output* es = nilp;
  Interp* interp = (sflag == true) ? new Interp : new Interp (is,os,es);

  // eventually add the initial path
  if ((sflag == false) && (options->getnoipth () == false)) {
    interp->addpath (System::xdir (fname));
  }

  // set some interpreter flags
  interp->setassert (options->getassert ());
  interp->setargs   (options->getargs   ());
  interp->setpath   (options->getpath   ());

  // loop or execute on the standard input or a file
  bool status = false;
  try {
    status  = (sflag == true) ? interp->loop () : interp->loop (fname); 
  } catch (const Exception& e) {
    terr.errorln (e);
    status = false;
  } catch (...) {
    terr << "fatal: unknown exception trapped\n";
    status = false;
  }

  // clean eveything and return
  delete options;
  delete interp;
  return status ? 0 : 1;
}
