/*
 *	aegis - project change supervisor
 *	Copyright (C) 1997, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for aefind/tree/list.c
 */

#ifndef AEFIND_TREE_LIST_H
#define AEFIND_TREE_LIST_H

#include <ac/stddef.h>

#include <main.h>

struct tree_ty; /* existence */


typedef struct tree_list_ty tree_list_ty;
struct tree_list_ty
{
    size_t	    length;
    size_t	    maximum;
    struct tree_ty  **item;
};


tree_list_ty *tree_list_new(void);
void tree_list_delete(tree_list_ty *);
void tree_list_append(tree_list_ty *, struct tree_ty *);

#endif /* AEFIND_TREE_LIST_H */
