;;;***************************************************************
;;;An ACL2 Library of Floating Point Arithmetic

;;;David M. Russinoff
;;;Advanced Micro Devices, Inc.
;;;February, 1998
;;;***************************************************************

(in-package "ACL2")

(local (include-book "frac-coeff"))
(local (include-book "nniq"))
(include-book "basic")
(local (include-book "numerator"))
(local (include-book "denominator"))
(local (include-book "fp"))
(local (include-book "ground-zero"))
(local (include-book "predicate"))
(local (include-book "product"))
(local (include-book "unary-divide"))
(local (include-book "rationalp"))
(local (include-book "integerp"))
(local (include-book "fl2"))
;(local (include-book "flooreric"))
(local (include-book "mod"))
(local (include-book "even-odd"))
(local (include-book "../../../meta/meta-plus-equal"))

;(local (in-theory (disable floor-fl-eric
                           ;integerp-prod
 ;                          )))

(local
 (defthm floor-m+1-1
   (implies (rationalp n)
	     (= (fl (- (/ (1+ m) n)))
		(+ (- (floor (/ m n) 1)) (fl (- (/ (1+ (mod m n)) n))))))
   :hints (("Goal" :in-theory (enable mod)))
   :rule-classes ())
 )


;(local (in-theory (enable mod floor fl)))



(local
  (defthm floor-m+1-2
    (implies (rationalp n)
	     (= (fl (- (/ (1+ m) n)))
		(+ (- (fl (/ m n))) (fl (- (/ (1+ (mod m n)) n))))))
  :rule-classes ()
  :hints (("Goal"; :in-theory (enable fl)
		  :use ((:instance floor-m+1-1)))))
  )

(defthm MOD>=0
    (implies (and (rationalp m); (integerp m)
                  (rationalp n); (integerp n)
		  (> n 0)
		  ;(>= m 0)
                  )
	     (<= 0 (mod m n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable mod)
           :use ((:instance  floor-upper-bound (i m) (j n))))))

(defthm MOD<N
  (implies (and (case-split (not (complex-rationalp m))) ;(rationalp m) ;(integerp m) 
                (case-split (rationalp n))
                (case-split (< 0 n))
                )
           (< (mod m n) n))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable mod))))

(local
(defthm floor-m+1-9
    (implies (and (integerp m)
		  (integerp n)
		  (> n 0)
		 ; (>= m 0)
                  )
	     (<= (1+ (mod m n)) n))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod<n)))))
)



(local
(defthm floor-m+1-11
    (implies (and (integerp m)
		  (integerp n)
		  (> n 0)
		  (>= m 0))
	     (<= (/ (1+ (mod m n)) n) 1))
  :rule-classes ()
  :hints (("Goal" :use ((:instance floor-m+1-9)
;			(:instance floor-m+1-10 (x (1+ (mod m n))) (y n) (z n))
                        ))))

)

(local
(defthm floor-m+1-12
    (implies (and (integerp m)
		  (integerp n)
		  (> n 0)
		  (>= m 0))
	     (> (/ (1+ (mod m n)) n) 0))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod>=0)))))
)

(local
(defthm floor-m+1-13
    (implies (and (integerp m)
		  (integerp n)
		  (>= m 0)
		  (> n 0))
	     (= (fl (- (/ (1+ (mod m n)) n)))
		-1))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable  UNARY-DIVIDE-GREATER-THAN-NON-ZERO-CONSTANT)
           :use ((:instance fl-unique (n -1) (x (- (/ (1+ (mod m n)) n))))
			(:instance floor-m+1-11)
			(:instance floor-m+1-12)))))
)

(defthm FLOOR-M+1
    (implies (and (integerp m)
		  (integerp n)
		  (>= m 0)
		  (> n 0))
	     (= (fl (- (/ (1+ m) n)))
		(1- (- (fl (/ m n))))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance floor-m+1-13)
			(:instance floor-m+1-2)))))

(local (in-theory (disable floor-fl)))
(local (in-theory (enable mod)))

(defthm MOD-FL
  (implies (case-split (acl2-numberp m))
           (equal (+ (* n (fl (/ m n))) (mod m n))
                  m))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable floor-fl))))

;careful - can loop with definition floor
(defthm FLOOR-FL
  (equal (floor m n)
         (fl (/ m n))))
(in-theory (disable floor-fl))

(local (in-theory (disable floor)))

(defthm MOD+-thm
    (implies (and (integerp a)
                  (case-split (not (complex-rationalp m)))
                  (case-split (not (complex-rationalp n)))
                  )
	     (equal (mod (+ m (* a n)) n)
                    (mod m n)))
    :rule-classes ()
    :hints (("Goal" :use ((:instance mod-fl)
                          (:instance mod-fl (m (+ m (* a n))))
                          (:instance fl+int-rewrite (x (/ m n)) (n a))))))
;aa
(defthm MOD<
  (implies (and (< m n)
                (<= 0 m)
                (case-split (rationalp m))
                )
           (equal (mod m n) m))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod-fl)
			(:instance fl-unique (x (/ m n)) (n 0))))))

(defthm INTEGERP-MOD
    (implies (and (integerp m)
		  (integerp n))
	     (integerp (mod m n)))
  :rule-classes (:rewrite :type-prescription)
  :hints (("Goal" :in-theory (enable mod))))  

(defthm RATIONALP-MOD
    (implies (case-split (rationalp m))
	     (rationalp (mod m n)))
  :rule-classes (:rewrite :type-prescription)
  :hints (("Goal" :in-theory (enable mod))))  

(in-theory (disable mod))


(local (defthm floor-2-pos
    (implies (and (integerp m)
		  (>= m 0))
	     (= (fl (- (/ (1+ m) 2)))
		(1- (- (fl (/ m 2))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance floor-m+1 (n 2)))))))

(local (defthm floor-2-neg-1
    (implies (integerp m)
	     (= (fl (- (/ (1+ m) 2)))
		(fl (- (- (/ (1+ (- m)) 2)) m))))
  :rule-classes ()))

(local (defthm floor-2-neg-2
    (implies (integerp m)
	     (= (fl (- (/ (1+ m) 2)))
		(- (fl (- (/ (1+ (- m)) 2))) m)))
  :rule-classes ()
  :hints (("goal" :use (floor-2-neg-1)))))

(local (defthm floor-2-neg-3
    (implies (and (integerp m)
		  (<= m 0))
	     (= (fl (- (/ (1+ m) 2)))
		(1- (- (+ m (fl (/ (- m) 2)))))))
  :rule-classes ()
  :hints (("goal" :use (floor-2-neg-2
			(:instance floor-2-pos (m (- m))))))))

(local (defthm floor-2-neg
    (implies (and (integerp m)
		  (<= m 0))
	     (= (fl (- (/ (1+ m) 2)))
		(1- (- (fl (/ m 2))))))
  :rule-classes ()
  :hints (("goal" :use (floor-2-neg-3)))))

(defthm floor-2
    (implies (integerp m)
	     (= (fl (- (/ (1+ m) 2)))
		(1- (- (fl (/ m 2))))))
  :rule-classes ()
  :hints (("goal" :use (floor-2-neg
			floor-2-pos))))

