/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise.resources;

import java.util.ListResourceBundle;
import java.awt.Event;
import java.awt.event.KeyEvent;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

/**
 * ActionResources.java
 *
 *
 * Created: Wed Mar 20 16:43:38 2002
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */

public class ActionResources extends ListResourceBundle {
	public static final String NEW_NAME = "new.name";
	public static final String NEW_COMMAND = "new.command";
	public static final String NEW_SHORTDESC = "new.shortdesc";
	public static final String NEW_LONGDESC = "new.londesc";
	public static final String NEW_SMALLICON = "new.smallicon";
	public static final String NEW_LARGEICON = "new.largeicon";
	public static final String NEW_ACCELERATOR = "new.accelerator";
	public static final String NEW_MNEMONIC = "new.mnemonic";

	public static final String SAVE_NAME = "save.name";
	public static final String SAVE_COMMAND = "save.command";
	public static final String SAVE_SHORTDESC = "save.shortdesc";
	public static final String SAVE_LONGDESC = "save.londesc";
	public static final String SAVE_SMALLICON = "save.smallicon";
	public static final String SAVE_LARGEICON = "save.largeicon";
	public static final String SAVE_ACCELERATOR = "save.accelerator";
	public static final String SAVE_MNEMONIC = "save.mnemonic";
	
	public static final String SAVEAS_NAME = "saveas.name";
	public static final String SAVEAS_COMMAND = "saveas.command";
	public static final String SAVEAS_SHORTDESC = "saveas.shortdesc";
	public static final String SAVEAS_LONGDESC = "saveas.londesc";
	public static final String SAVEAS_SMALLICON = "saveas.smallicon";
	public static final String SAVEAS_LARGEICON = "saveas.largeicon";
	public static final String SAVEAS_MNEMONIC = "saveas.mnemonic";
	public static final String SAVEAS_MNEMONIC_INDEX = "saveas.mnemonic.index";
	
	public static final String OPEN_NAME = "open.name";
	public static final String OPEN_COMMAND = "open.command";
	public static final String OPEN_SHORTDESC = "open.shortdesc";
	public static final String OPEN_LONGDESC = "open.londesc";
	public static final String OPEN_SMALLICON = "open.smallicon";
	public static final String OPEN_LARGEICON = "open.largeicon";
	public static final String OPEN_ACCELERATOR = "open.accelerator";
	public static final String OPEN_MNEMONIC = "open.mnemonic";

	public static final String CUT_NAME = "cut.name";
	public static final String CUT_COMMAND = "cut.command";
	public static final String CUT_SHORTDESC = "cut.shortdesc";
	public static final String CUT_LONGDESC = "cut.londesc";
	public static final String CUT_SMALLICON = "cut.smallicon";
	public static final String CUT_LARGEICON = "cut.largeicon";
	public static final String CUT_ACCELERATOR = "cut.accelerator";
	public static final String CUT_MNEMONIC = "cut.mnemonic";

	public static final String COPY_NAME = "copy.name";
	public static final String COPY_COMMAND = "copy.command";
	public static final String COPY_SHORTDESC = "copy.shortdesc";
	public static final String COPY_LONGDESC = "copy.londesc";
	public static final String COPY_SMALLICON = "copy.smallicon";
	public static final String COPY_LARGEICON = "copy.largeicon";
	public static final String COPY_ACCELERATOR = "copy.accelerator";
	public static final String COPY_MNEMONIC = "copy.mnemonic";

	public static final String PASTE_NAME = "paste.name";
	public static final String PASTE_COMMAND = "paste.command";
	public static final String PASTE_SHORTDESC = "paste.shortdesc";
	public static final String PASTE_LONGDESC = "paste.londesc";
	public static final String PASTE_SMALLICON = "paste.smallicon";
	public static final String PASTE_LARGEICON = "paste.largeicon";
	public static final String PASTE_ACCELERATOR = "paste.accelerator";
	public static final String PASTE_MNEMONIC = "paste.mnemonic";

	public static final String MANUAL_NAME = "manual.name";
	public static final String MANUAL_COMMAND = "manual.command";
	public static final String MANUAL_SHORTDESC = "manual.shortdesc";
	public static final String MANUAL_LONGDESC = "manual.londesc";
	public static final String MANUAL_SMALLICON = "manual.smallicon";
	public static final String MANUAL_LARGEICON = "manual.largeicon";
	public static final String MANUAL_ACCELERATOR = "manual.accelerator";
	public static final String MANUAL_MNEMONIC = "manual.mnemonic";

	public static final String ABOUT_NAME = "about.name";
	public static final String ABOUT_COMMAND = "about.command";
	public static final String ABOUT_SHORTDESC = "about.shortdesc";
	public static final String ABOUT_LONGDESC = "about.londesc";
	public static final String ABOUT_SMALLICON = "about.smallicon";
	public static final String ABOUT_LARGEICON = "about.largeicon";
	public static final String ABOUT_MNEMONIC = "about.mnemonic";

	public static final String EXIT_NAME = "exit.name";
	public static final String EXIT_COMMAND = "exit.command";
	public static final String EXIT_SHORTDESC = "exit.shortdesc";
	public static final String EXIT_LONGDESC = "exit.londesc";
	public static final String EXIT_SMALLICON = "exit.smallicon";
	public static final String EXIT_LARGEICON = "exit.largeicon";
	public static final String EXIT_MNEMONIC = "exit.mnemonic";

	public static final String EXPLAIN_NAME = "explain.name";
	public static final String EXPLAIN_COMMAND = "explain.command";
	public static final String EXPLAIN_SHORTDESC = "explain.shortdesc";
	public static final String EXPLAIN_LONGDESC = "explain.londesc";
	public static final String EXPLAIN_SMALLICON = "explain.smallicon";
	public static final String EXPLAIN_LARGEICON = "explain.largeicon";
	public static final String EXPLAIN_ACCELERATOR = "explain.accelerator";
	public static final String EXPLAIN_MNEMONIC = "explain.mnemonic";

	public static final String PREFERENCES_NAME = "preferences.name";
	public static final String PREFERENCES_COMMAND = "preferences.command";
	public static final String PREFERENCES_SHORTDESC = "preferences.shortdesc";
	public static final String PREFERENCES_LONGDESC = "preferences.londesc";
	public static final String PREFERENCES_SMALLICON = "preferences.smallicon";
	public static final String PREFERENCES_LARGEICON = "preferences.largeicon";
	public static final String PREFERENCES_MNEMONIC = "preferences.mnemonic";
	
	public static final String DATABASES_NAME = "databases.name";
	public static final String DATABASES_COMMAND = "databases.command";
	public static final String DATABASES_SHORTDESC = "databases.shortdesc";
	public static final String DATABASES_LONGDESC = "databases.longdesc";
	public static final String DATABASES_MNEMONIC = "databases.mnemonic";
	
	public static final String PLANNEROPTIONS_NAME = "planneroptions.name";
	public static final String PLANNEROPTIONS_COMMAND = "planneroptions.command";
	public static final String PLANNEROPTIONS_SHORTDESC = "planneroptions.shortdesc";
	public static final String PLANNEROPTIONS_LONGDESC = "planneroptions.longdesc";
	public static final String PLANNEROPTIONS_MNEMONIC = "planneroptions.mnemonic";

	public static final String ZOOMIN_NAME = "zoomin.name";
	public static final String ZOOMIN_COMMAND = "zoomin.command";
	public static final String ZOOMIN_SHORTDESC = "zoomin.shortdesc";
	public static final String ZOOMIN_LONGDESC = "zoomin.londesc";
	public static final String ZOOMIN_SMALLICON = "zoomin.smallicon";
	public static final String ZOOMIN_LARGEICON = "zoomin.largeicon";
	public static final String ZOOMIN_ACCELERATOR = "zoomin.accelerator";
	public static final String ZOOMIN_MNEMONIC = "zoomin.mnemonic";

	public static final String ZOOMOUT_NAME = "zoomout.name";
	public static final String ZOOMOUT_COMMAND = "zoomout.command";
	public static final String ZOOMOUT_SHORTDESC = "zoomout.shortdesc";
	public static final String ZOOMOUT_LONGDESC = "zoomout.londesc";
	public static final String ZOOMOUT_SMALLICON = "zoomout.smallicon";
	public static final String ZOOMOUT_LARGEICON = "zoomout.largeicon";
	public static final String ZOOMOUT_ACCELERATOR = "zoomout.accelerator";
	public static final String ZOOMOUT_MNEMONIC = "zoomout.mnemonic";

	public static final String DELETE_NAME = "delete.name";
	public static final String DELETE_COMMAND = "delete.command";
	public static final String DELETE_SHORTDESC = "delete.shortdesc";
	public static final String DELETE_LONGDESC = "delete.londesc";
	public static final String DELETE_ACCELERATOR = "delete.accelerator";
	public static final String DELETE_MNEMONIC = "delete.mnemonic";

	public static final String EDIT_NAME = "edit.name";
	public static final String EDIT_COMMAND = "edit.command";
	public static final String EDIT_SHORTDESC = "edit.shortdesc";
	public static final String EDIT_LONGDESC = "edit.londesc";
	public static final String EDIT_ACCELERATOR = "edit.accelerator";
	public static final String EDIT_MNEMONIC = "edit.mnemonic";

	public static final String OK_NAME = "ok.name";
	public static final String OK_COMMAND = "ok.command";
	public static final String OK_SHORTDESC = "ok.shortdesc";
	public static final String OK_LONGDESC = "ok.londesc";
	public static final String OK_ACCELERATOR = "ok.accelerator";
	public static final String OK_MNEMONIC = "ok.mnemonic";

	public static final String CANCEL_NAME = "cancel.name";
	public static final String CANCEL_COMMAND = "cancel.command";
	public static final String CANCEL_SHORTDESC = "cancel.shortdesc";
	public static final String CANCEL_LONGDESC = "cancel.londesc";
	public static final String CANCEL_ACCELERATOR = "cancel.accelerator";
	public static final String CANCEL_MNEMONIC = "cancel.mnemonic";

	public static final String TEST_NAME = "test.name";
	public static final String TEST_COMMAND = "test.command";
	public static final String TEST_SHORTDESC = "test.shortdesc";
	public static final String TEST_LONGDESC = "test.londesc";
	public static final String TEST_ACCELERATOR = "test.accelerator";
	public static final String TEST_MNEMONIC = "test.mnemonic";

	public static final String REFRESH_NAME = "refresh.name";
	public static final String REFRESH_COMMAND = "refresh.command";
	public static final String REFRESH_SHORTDESC = "refresh.shortdesc";
	public static final String REFRESH_LONGDESC = "refresh.londesc";
	public static final String REFRESH_SMALLICON = "refresh.smallicon";
	public static final String REFRESH_ACCELERATOR = "refresh.accelerator";
	public static final String REFRESH_MNEMONIC = "refresh.mnemonic";

	public static final String CONTINUE_NAME = "continue.name";
	public static final String CONTINUE_COMMAND = "continue.command";
	public static final String CONTINUE_SHORTDESC = "continue.shortdesc";
	public static final String CONTINUE_LONGDESC = "continue.londesc";
	public static final String CONTINUE_ACCELERATOR = "continue.accelerator";
	public static final String CONTINUE_MNEMONIC = "continue.mnemonic";

	public static final String BACK_NAME = "back.name";
	public static final String BACK_COMMAND = "back.command";
	public static final String BACK_SHORTDESC = "back.shortdesc";
	public static final String BACK_LONGDESC = "back.londesc";
	public static final String BACK_LARGEICON = "back.largeicon";
	public static final String BACK_ACCELERATOR = "back.accelerator";
	public static final String BACK_MNEMONIC = "back.mnemonic";

	public static final String FORWARD_NAME = "forward.name";
	public static final String FORWARD_COMMAND = "forward.command";
	public static final String FORWARD_SHORTDESC = "forward.shortdesc";
	public static final String FORWARD_LONGDESC = "forward.londesc";
	public static final String FORWARD_LARGEICON = "forward.largeicon";
	public static final String FORWARD_ACCELERATOR = "forward.accelerator";
	public static final String FORWARD_MNEMONIC = "forward.mnemonic";

	public static final String HOME_NAME = "home.name";
	public static final String HOME_COMMAND = "home.command";
	public static final String HOME_SHORTDESC = "home.shortdesc";
	public static final String HOME_LONGDESC = "home.londesc";
	public static final String HOME_LARGEICON = "home.largeicon";
	public static final String HOME_ACCELERATOR = "home.accelerator";
	public static final String HOME_MNEMONIC = "home.mnemonic";

	public static final String ANALYZE_NAME = "analyze.name";
	public static final String ANALYZE_COMMAND = "analyze.command";
	public static final String ANALYZE_SHORTDESC = "analyze.shortdesc";
	public static final String ANALYZE_LONGDESC = "analyze.londesc";
	public static final String ANALYZE_SMALLICON = "analyze.smallicon";
	public static final String ANALYZE_LARGEICON = "analyze.largeicon";
	public static final String ANALYZE_ACCELERATOR = "analyze.accelerator";
	public static final String ANALYZE_MNEMONIC = "analyze.mnemonic";
	public static final String ANALYZE_MNEMONIC_INDEX = "analyze.mnemonic.index";

	public static final String STOP_NAME = "stop.name";
	public static final String STOP_COMMAND = "stop.command";
	public static final String STOP_SHORTDESC = "stop.shortdesc";
	public static final String STOP_LONGDESC = "stop.londesc";
	public static final String STOP_SMALLICON = "stop.smallicon";
	public static final String STOP_LARGEICON = "stop.largeicon";
	public static final String STOP_ACCELERATOR = "stop.accelerator";
	public static final String STOP_MNEMONIC = "stop.mnemonic";

	public static final String DEFAULT_NAME = "default.name";

	public Object[][] getContents()
	{
		return contents;
	}

	private static final Object[][] contents = {
		{ ActionResources.NEW_NAME,                "New" },
		{ ActionResources.NEW_COMMAND,             "new" },
		{ ActionResources.NEW_SHORTDESC,           "New" },
		{ ActionResources.NEW_LONGDESC,            "New" },
		{ ActionResources.NEW_SMALLICON,           "new16.png" },
		{ ActionResources.NEW_LARGEICON,           "new24.png" },
		{ ActionResources.NEW_ACCELERATOR,         KeyStroke.getKeyStroke(KeyEvent.VK_N, Event.CTRL_MASK) },
		{ ActionResources.NEW_MNEMONIC,            new Integer(KeyEvent.VK_N) },

		{ ActionResources.SAVE_NAME,               "Save" },
		{ ActionResources.SAVE_COMMAND,            "save" },
		{ ActionResources.SAVE_SHORTDESC,          "Save" },
		{ ActionResources.SAVE_LONGDESC,           "Save" },
		{ ActionResources.SAVE_SMALLICON,          "save16.png" },
		{ ActionResources.SAVE_LARGEICON,          "save24.png" },
		{ ActionResources.SAVE_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_S, Event.CTRL_MASK) },
		{ ActionResources.SAVE_MNEMONIC,           new Integer(KeyEvent.VK_S) },
		
		{ ActionResources.SAVEAS_NAME,             "Save As..." },
		{ ActionResources.SAVEAS_COMMAND,          "saveas" },
		{ ActionResources.SAVEAS_SHORTDESC,        "Save As" },
		{ ActionResources.SAVEAS_LONGDESC,         "Save As" },
		{ ActionResources.SAVEAS_SMALLICON,        "saveas16.png" },
		{ ActionResources.SAVEAS_LARGEICON,        "saveas24.png" },
		{ ActionResources.SAVEAS_MNEMONIC,         new Integer(KeyEvent.VK_A) },
		{ ActionResources.SAVEAS_MNEMONIC_INDEX,   new Integer(5) },

		{ ActionResources.OPEN_NAME,               "Open..." },
		{ ActionResources.OPEN_COMMAND,            "open" },
		{ ActionResources.OPEN_SHORTDESC,          "Open" },
		{ ActionResources.OPEN_LONGDESC,           "Open" },
		{ ActionResources.OPEN_SMALLICON,          "open16.png" },
		{ ActionResources.OPEN_LARGEICON,          "open24.png" },
		{ ActionResources.OPEN_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		{ ActionResources.OPEN_MNEMONIC,           new Integer(KeyEvent.VK_O) },

		{ ActionResources.CUT_NAME,                "Cut" },
		{ ActionResources.CUT_COMMAND,             "cut" },
		{ ActionResources.CUT_SHORTDESC,           "Cut" },
		{ ActionResources.CUT_LONGDESC,            "Cut" },
		{ ActionResources.CUT_SMALLICON,           "cut16.png" },
		{ ActionResources.CUT_LARGEICON,           "cut24.png" },
		{ ActionResources.CUT_ACCELERATOR,         KeyStroke.getKeyStroke(KeyEvent.VK_X, Event.CTRL_MASK) },
		{ ActionResources.CUT_MNEMONIC,            new Integer(KeyEvent.VK_T) },

		{ ActionResources.COPY_NAME,               "Copy" },
		{ ActionResources.COPY_COMMAND,            "copy" },
		{ ActionResources.COPY_SHORTDESC,          "Copy" },
		{ ActionResources.COPY_LONGDESC,           "Copy" },
		{ ActionResources.COPY_SMALLICON,          "copy16.png" },
		{ ActionResources.COPY_LARGEICON,          "copy24.png" },
		{ ActionResources.COPY_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK) },
		{ ActionResources.COPY_MNEMONIC,           new Integer(KeyEvent.VK_C) },

		{ ActionResources.PASTE_NAME,              "Paste" },
		{ ActionResources.PASTE_COMMAND,           "paste" },
		{ ActionResources.PASTE_SHORTDESC,         "Paste" },
		{ ActionResources.PASTE_LONGDESC,          "Paste" },
		{ ActionResources.PASTE_SMALLICON,         "paste16.png" },
		{ ActionResources.PASTE_LARGEICON,         "paste24.png" },
		{ ActionResources.PASTE_ACCELERATOR,       KeyStroke.getKeyStroke(KeyEvent.VK_V, Event.CTRL_MASK) },
		{ ActionResources.PASTE_MNEMONIC,          new Integer(KeyEvent.VK_P) },

		{ ActionResources.MANUAL_NAME,             "Manual..." },
		{ ActionResources.MANUAL_COMMAND,          "manual" },
		{ ActionResources.MANUAL_SHORTDESC,        "Manual" },
		{ ActionResources.MANUAL_LONGDESC,         "Manual" },
		{ ActionResources.MANUAL_SMALLICON,        "help16.png" },
		{ ActionResources.MANUAL_LARGEICON,        "help24.png" },
		{ ActionResources.MANUAL_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0) },
		{ ActionResources.MANUAL_MNEMONIC,         new Integer(KeyEvent.VK_M) },

		{ ActionResources.ABOUT_NAME,              "About..." },
		{ ActionResources.ABOUT_COMMAND,           "about" },
		{ ActionResources.ABOUT_SHORTDESC,         "About" },
		{ ActionResources.ABOUT_LONGDESC,          "About" },
		{ ActionResources.ABOUT_SMALLICON,         "about16.png" },
		{ ActionResources.ABOUT_LARGEICON,         "about24.png" },
		{ ActionResources.ABOUT_MNEMONIC,          new Integer(KeyEvent.VK_A) },

		{ ActionResources.EXIT_NAME,               "Exit" },
		{ ActionResources.EXIT_COMMAND,            "exit" },
		{ ActionResources.EXIT_SHORTDESC,          "Exit" },
		{ ActionResources.EXIT_LONGDESC,           "Exit" },
		{ ActionResources.EXIT_SMALLICON,          "exit16.png" },
		{ ActionResources.EXIT_LARGEICON,          "exit24.png" },
		{ ActionResources.EXIT_MNEMONIC,           new Integer(KeyEvent.VK_X) },

		{ ActionResources.EXPLAIN_NAME,            "Explain" },
		{ ActionResources.EXPLAIN_COMMAND,         "explain" },
		{ ActionResources.EXPLAIN_SHORTDESC,       "Explain" },
		{ ActionResources.EXPLAIN_LONGDESC,        "Explain" },
		{ ActionResources.EXPLAIN_SMALLICON,       "explain16.png" },
		{ ActionResources.EXPLAIN_LARGEICON,       "explain24.png" },
		{ ActionResources.EXPLAIN_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_E, Event.CTRL_MASK) },
		{ ActionResources.EXPLAIN_MNEMONIC,        new Integer(KeyEvent.VK_E) },

		{ ActionResources.PREFERENCES_NAME,        "Preferences..." },
		{ ActionResources.PREFERENCES_COMMAND,     "preferences" },
		{ ActionResources.PREFERENCES_SHORTDESC,   "Edit Preferences" },
		{ ActionResources.PREFERENCES_LONGDESC,    "Edit Preferences" },
		{ ActionResources.PREFERENCES_SMALLICON,   "prefs16.png" },
		{ ActionResources.PREFERENCES_LARGEICON,   "prefs24.png" },
		{ ActionResources.PREFERENCES_MNEMONIC,    new Integer(KeyEvent.VK_F) },

		{ ActionResources.DATABASES_NAME,          "Databases..." },
		{ ActionResources.DATABASES_COMMAND,       "databases" },
		{ ActionResources.DATABASES_SHORTDESC,     "Edit Databases" },
		{ ActionResources.DATABASES_LONGDESC,      "Edit Databases" },
		{ ActionResources.DATABASES_MNEMONIC,      new Integer(KeyEvent.VK_D) },

		{ ActionResources.PLANNEROPTIONS_NAME,      "Planner Options..." },
		{ ActionResources.PLANNEROPTIONS_COMMAND,   "planneroptions" },
		{ ActionResources.PLANNEROPTIONS_SHORTDESC, "Edit Planner Options" },
		{ ActionResources.PLANNEROPTIONS_LONGDESC,  "Edit Planner Options" },
		{ ActionResources.PLANNEROPTIONS_MNEMONIC,  new Integer(KeyEvent.VK_O) },

		{ ActionResources.ZOOMIN_NAME,             "Zoom In" },
		{ ActionResources.ZOOMIN_COMMAND,          "zoomin" },
		{ ActionResources.ZOOMIN_SHORTDESC,        "Zoom In" },
		{ ActionResources.ZOOMIN_LONGDESC,         "Zoom In" },
		{ ActionResources.ZOOMIN_SMALLICON,        "zoomin16.png" },
		{ ActionResources.ZOOMIN_LARGEICON,        "zoomin24.png" },
		{ ActionResources.ZOOMIN_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_EQUALS, Event.CTRL_MASK) },
		{ ActionResources.ZOOMIN_MNEMONIC,         new Integer(KeyEvent.VK_I) },

		{ ActionResources.ZOOMOUT_NAME,            "Zoom Out" },
		{ ActionResources.ZOOMOUT_COMMAND,         "zoomout" },
		{ ActionResources.ZOOMOUT_SHORTDESC,       "Zoom Out" },
		{ ActionResources.ZOOMOUT_LONGDESC,        "Zoom Out" },
		{ ActionResources.ZOOMOUT_SMALLICON,       "zoomout16.png" },
		{ ActionResources.ZOOMOUT_LARGEICON,       "zoomout24.png" },
		{ ActionResources.ZOOMOUT_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_MINUS, Event.CTRL_MASK) },
		{ ActionResources.ZOOMOUT_MNEMONIC,        new Integer(KeyEvent.VK_O) },

		{ ActionResources.DELETE_NAME,             "Delete" },
		{ ActionResources.DELETE_COMMAND,          "delete" },
		{ ActionResources.DELETE_SHORTDESC,        "Delete" },
		{ ActionResources.DELETE_LONGDESC,         "Delete" },
		{ ActionResources.DELETE_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_D, Event.CTRL_MASK) },
		{ ActionResources.DELETE_MNEMONIC,         new Integer(KeyEvent.VK_D) },

		{ ActionResources.EDIT_NAME,               "Edit" },
		{ ActionResources.EDIT_COMMAND,            "edit" },
		{ ActionResources.EDIT_SHORTDESC,          "Edit" },
		{ ActionResources.EDIT_LONGDESC,           "Edit" },
		{ ActionResources.EDIT_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_E, Event.CTRL_MASK) },
		{ ActionResources.EDIT_MNEMONIC,           new Integer(KeyEvent.VK_E) },

		{ ActionResources.OK_NAME,                 "OK" },
		{ ActionResources.OK_COMMAND,              "ok" },
		{ ActionResources.OK_SHORTDESC,            "OK" },
		{ ActionResources.OK_LONGDESC,             "OK" },
		{ ActionResources.OK_ACCELERATOR,          KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		{ ActionResources.OK_MNEMONIC,             new Integer(KeyEvent.VK_O) },

		{ ActionResources.CANCEL_NAME,             "Cancel" },
		{ ActionResources.CANCEL_COMMAND,          "cancel" },
		{ ActionResources.CANCEL_SHORTDESC,        "Cancel" },
		{ ActionResources.CANCEL_LONGDESC,         "Cancel" },
		{ ActionResources.CANCEL_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK) },
		{ ActionResources.CANCEL_MNEMONIC,         new Integer(KeyEvent.VK_C) },

		{ ActionResources.TEST_NAME,               "Test" },
		{ ActionResources.TEST_COMMAND,            "test" },
		{ ActionResources.TEST_SHORTDESC,          "Test" },
		{ ActionResources.TEST_LONGDESC,           "Test" },
		{ ActionResources.TEST_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_T, Event.CTRL_MASK) },
		{ ActionResources.TEST_MNEMONIC,           new Integer(KeyEvent.VK_T) },

		{ ActionResources.REFRESH_NAME,            "Refresh" },
		{ ActionResources.REFRESH_COMMAND,         "refresh" },
		{ ActionResources.REFRESH_SHORTDESC,       "Refresh" },
		{ ActionResources.REFRESH_LONGDESC,        "Refresh" },
		{ ActionResources.REFRESH_SMALLICON,	   "refresh16.png" },
		{ ActionResources.REFRESH_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_F5, 0) },
		{ ActionResources.REFRESH_MNEMONIC,        new Integer(KeyEvent.VK_R) },

		{ ActionResources.CONTINUE_NAME,           "Continue" },
		{ ActionResources.CONTINUE_COMMAND,        "continue" },
		{ ActionResources.CONTINUE_SHORTDESC,      "Continue" },
		{ ActionResources.CONTINUE_LONGDESC,       "Continue" },
		{ ActionResources.CONTINUE_ACCELERATOR,    KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		{ ActionResources.CONTINUE_MNEMONIC,       new Integer(KeyEvent.VK_O) },

		{ ActionResources.BACK_NAME,               "Back" },
		{ ActionResources.BACK_COMMAND,            "back" },
		{ ActionResources.BACK_SHORTDESC,          "Back" },
		{ ActionResources.BACK_LONGDESC,           "Back" },
		{ ActionResources.BACK_LARGEICON,          "back24.png" },
		{ ActionResources.BACK_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, Event.CTRL_MASK) },
		{ ActionResources.BACK_MNEMONIC,           new Integer(KeyEvent.VK_B) },

		{ ActionResources.FORWARD_NAME,            "Forward" },
		{ ActionResources.FORWARD_COMMAND,         "forward" },
		{ ActionResources.FORWARD_SHORTDESC,       "Forward" },
		{ ActionResources.FORWARD_LONGDESC,        "Forward" },
		{ ActionResources.FORWARD_LARGEICON,       "forward24.png" },
		{ ActionResources.FORWARD_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, Event.CTRL_MASK) },
		{ ActionResources.FORWARD_MNEMONIC,        new Integer(KeyEvent.VK_F) },

		{ ActionResources.HOME_NAME,               "Home" },
		{ ActionResources.HOME_COMMAND,            "home" },
		{ ActionResources.HOME_SHORTDESC,          "Home" },
		{ ActionResources.HOME_LONGDESC,           "Home" },
		{ ActionResources.HOME_LARGEICON,          "home24.png" },
		{ ActionResources.HOME_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_HOME, Event.CTRL_MASK) },
		{ ActionResources.HOME_MNEMONIC,           new Integer(KeyEvent.VK_H) },

		{ ActionResources.ANALYZE_NAME,            "Explain Analyze" },
		{ ActionResources.ANALYZE_COMMAND,         "explain analyze" },
		{ ActionResources.ANALYZE_SHORTDESC,       "Explain Analyze" },
		{ ActionResources.ANALYZE_LONGDESC,        "Explain Analyze" },
		{ ActionResources.ANALYZE_SMALLICON,       "explain16.png" },
		{ ActionResources.ANALYZE_LARGEICON,       "explain24.png" },
		{ ActionResources.ANALYZE_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_L, Event.CTRL_MASK) },
		{ ActionResources.ANALYZE_MNEMONIC,        new Integer(KeyEvent.VK_L) },
		{ ActionResources.ANALYZE_MNEMONIC_INDEX,  new Integer(11) },

		{ ActionResources.STOP_NAME,               "Stop" },
		{ ActionResources.STOP_COMMAND,            "stop" },
		{ ActionResources.STOP_SHORTDESC,          "Stop" },
		{ ActionResources.STOP_LONGDESC,           "Stop" },
		{ ActionResources.STOP_SMALLICON,          "stop16.png" },
		{ ActionResources.STOP_LARGEICON,          "stop24.png" },
		{ ActionResources.STOP_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_Z, Event.CTRL_MASK) },
		{ ActionResources.STOP_MNEMONIC,           new Integer(KeyEvent.VK_Z) },

		{ ActionResources.DEFAULT_NAME,            "Unknown Action" },

	};
}// Resources
