/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;

/**
 * A simple about dialog box for Explain. By default, the title
 * of the dialog is taken from the ExplainResources resource bundle
 * using the key ABOUT_TITLE. The dialog is modal.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public class AboutDialog extends JDialog implements ActionListener {
	private ActionFactory afactory;
	private GenericAction okAction;
	private Frame owner;
	private int result;
	
	/** Result when user has closed window. */
	public static final int OK_OPTION = 0;

	/**
	 * Creates a new <code>AboutDialog</code> instance.
	 *
	 * @param owner a <code>Frame</code> value; the parent of the
	 * about dialog.
	 */
	public AboutDialog(Frame owner)
	{
		this(owner, ExplainResources.getString(ExplainResources.ABOUT_TITLE));
	}

	/**
	 * Creates a new <code>AboutDialog</code> instance.
	 *
	 * @param owner a <code>Frame</code> value; the parent of the
	 * dialog.
	 * @param title a <code>String</code> value; the title of the
	 * window.
	 */
	public AboutDialog(Frame owner, String title)
	{
		// we are a modal dialog
		super(owner, title, true);
		this.owner = owner;

		afactory = new ActionFactory();
		okAction = afactory.getAction(ActionFactory.ACTION_OK);
		okAction.addActionListener(this);
		okAction.setMnemonic(null);

		initComponents();

		pack();
	}

	/**
	 * Show the dialog window, setting its location to be relative to
	 * its parent first.
	 */
	public void show()
	{
		setLocationRelativeTo(owner);
		super.show();
	}

	/**
	 * Get the result of closing the closing. Always OK_OPTION.
	 *
	 * @return an <code>int</code> value
	 */
	public int getResult()
	{
		return result;
	}
	
	/**
	 * Action listener.
	 *
	 * @param e an <code>ActionEvent</code> value
	 */
	public void actionPerformed(ActionEvent e)
	{
		String command = e.getActionCommand();

		if (command.equals(okAction.getActionCommand()))
		{
			ok();
		}
		else
		{
			System.err.println("AboutDialog: unknown action command '" + command + "'");
		}
	}

	//
	// private methods
	//

	private void ok()
	{
		result = OK_OPTION;
		hide();
	}
	
	private void initComponents()
	{
		JPanel contentPanel, buttonPanel, content;
		JButton okButton;
		JLabel label;

		content = new JPanel();
		content.setLayout(new BorderLayout());
		content.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 12));
		setContentPane(content);

		// content
		contentPanel = new JPanel();
		contentPanel.setLayout(new BoxLayout(contentPanel, BoxLayout.Y_AXIS));
		contentPanel.setPreferredSize(new Dimension(410, 450));
		contentPanel.setMinimumSize(new Dimension(410, 450));
		contentPanel.setMaximumSize(new Dimension(410, 450));

		ImageIcon pic = new ImageIcon(this.getClass().getResource(ExplainResources.getString(ExplainResources.SPLASH_IMAGE)));
		label = new JLabel(pic);
		label.setAlignmentX(0.5f);
		label.setBorder(BorderFactory.createEtchedBorder());
		contentPanel.add(label);

		String[] text = ExplainResources.getStringArray(ExplainResources.ABOUT_NOTES);
		for (int i = 0; i < text.length; i++)
		{
			/* all this work to get centered text.. */
			StyledDocument doc = new DefaultStyledDocument();
			SimpleAttributeSet set = new SimpleAttributeSet();
			StyleConstants.setAlignment(set, StyleConstants.ALIGN_CENTER);
			doc.setParagraphAttributes(0, Integer.MAX_VALUE, set, false);

			JTextPane tp = new JTextPane(doc);

			tp.setOpaque(false);
			tp.setText(text[i]);
			tp.setEditable(false);
			tp.setEnabled(false);
			tp.setDisabledTextColor(Color.black);
			tp.setAlignmentX(0.5f);

			contentPanel.add(Box.createRigidArea(new Dimension(0, 11)));
			contentPanel.add(tp);
		}

		content.add(contentPanel, BorderLayout.CENTER);

		// ok button
		okButton = okAction.getButton();
		getRootPane().setDefaultButton(okButton);

		buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
		buttonPanel.add(Box.createHorizontalGlue());
		buttonPanel.add(okButton);
		buttonPanel.add(Box.createHorizontalGlue());

		content.add(buttonPanel, BorderLayout.SOUTH);
	}
}
