# Spec file for rhdb-explain
#
# Author: Liam Stewart <liams@redhat.com>
# Copyright (c) 2002, 2003 Red Hat, Inc.

Summary: Visual Explain for PostgreSQL - Red Hat Edition
Name: rhdb-explain
Version: @VERSION@
Release: 1
URL: http://sources.redhat.com/rhdb/tools.html
Source0: %{name}-%{version}.tar.gz
License: GPL
Group: Applications/Databases
Vendor: Red Hat, Inc.
Requires: rh-postgresql-jdbc

BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildArchitectures: noarch
BuildRequires: ant >= 1.4, sh-utils, j2sdk
# If you wish to build rhdb-explain with the IBM SDK, comment out the line
# above this and uncomment the one immediately below.
#BuildRequires: ant >= 1.4, sh-utils, IBMJava2-JRE, IBMJava2-SDK

%description
A visual query analysis tool for PostgreSQL - Red Hat Edition.

%prep
%setup -q

%build
ant dist

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT/usr/share/rhdb-explain
install -m 644 dist/rhdb-explain.jar $RPM_BUILD_ROOT/usr/share/rhdb-explain

mkdir -p $RPM_BUILD_ROOT/usr/bin
install -m 755 rhdb-explain $RPM_BUILD_ROOT/usr/bin

mkdir -p $RPM_BUILD_ROOT/%{_datadir}/applications $RPM_BUILD_ROOT/%{_datadir}/pixmaps
install -m 644 rhdb-explain.desktop $RPM_BUILD_ROOT%{_datadir}/applications
install -m 644 rhdb-explain.png $RPM_BUILD_ROOT%{_datadir}/pixmaps

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/bin/rhdb-explain
/usr/share/rhdb-explain
%{_datadir}/applications/rhdb-explain.desktop
%{_datadir}/pixmaps/rhdb-explain.png
%doc README

%changelog
* Thu Jun 12 2003 Andrew Overholt <overholt@redhat.com>
- new .desktop location
- no longer remove menu system sub-directory

* Tue Jun 03 2003 Andrew Overholt <overholt@redhat.com>
- "Red Hat Database" -> "PostgreSQL - Red Hat Edition"

* Fri Nov 15 2002 Andrew Overholt <overholt@redhat.com>
- Add explicit build requirement on the IBM SDK as well as note on building
  with the Sun SDK.

* Wed Sep 25 2002 Andrew Overholt <overholt@redhat.com>
- Remove double listing of /usr/share/rhdb-explain/rhdb-explain.jar

* Tue Sep 24 2002 Andrew Overholt <overholt@redhat.com>
- Removed all references to /usr/share/rhdb and moved rhdb-explain to
  /usr/share/rhdb-explain.

* Tue Sep 24 2002 Andrew Overholt <overholt@redhat.com>
- Added /usr/share/rhdb-explain and /usr/share/rhdb to %files

* Wed Sep 11 2002 Andrew Overholt <overholt@redhat.com>
- Changed release number to 1.

* Tue Aug 13 2002 Liam Stewart <liams@redhat.com>
- Removed dependencies on IBMJava2 packages.

* Mon Jul  8 2002 Liam Stewart <liams@redhat.com>
- Updated summary and description text.

* Wed Jul  3 2002 Liam Stewart <liams@redhat.com>
- Added IBMJava2-JRE build requirement.

* Mon Jun 10 2002 Liam Stewart <liams@redhat.com>
- GNOME/KDE desktop entry added.

* Fri Jun  7 2002 Liam Stewart <liams@redhat.com>
- JAR file now installed in /usr/share/rhdb/rhdb-explain
- Added sh-utils requirement

* Thu Jun  6 2002 Liam Stewart <liams@redhat.com>
- Requires and BuildRequires added.

* Tue May  7 2002 Liam Stewart <liams@redhat.com>
- Removed LICENSE.icons from file list since Sun icons are no longer
  used or included.

* Thu Mar  7 2002 Liam Stewart <liams@redhat.com>
- Initial build.


