/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef FILECONTENT_H
#define FILECONTENT_H

#include <qobject.h>
#include <qguardedptr.h>
#include "common.h"

class QTextEdit;
class QListView;
class FileHighlighter;
class Domain;
class StateInfo;
class Annotate;
class Git;
class MyProcess;
class RangeInfo;

class FileContent: public QObject {
Q_OBJECT
public:
	FileContent(Domain* parent, Git* git, QTextEdit* f);
	virtual ~FileContent();
	void update(bool force = false);
	void clear();
	void copySelection();
	void goToAnnotation(int id);
	bool goToRangeStart();
	bool rangeFilter(bool b);
	bool getRange(SCRef sha, RangeInfo* r);
	void startAnnotate();
	void setShowAnnotate(bool b);
	void addAnnotation();
	bool annotateAvailable() { return isAnnotateAvailable; };

signals:
	void annotationAvailable(bool);
	void fileAvailable(bool);
	void revIdSelected(int);

public slots:
	void on_procDataReady(const QString&);
	void on_doubleClicked(int, int);
	void on_eof(bool emitSignal = true);
	void on_annotateReady(Annotate*, const QString&, bool, const QString&);

private:
	friend class FileHighlighter;

	void clearAnnotate();
	void clearText(bool emitSignal = true);
	void findInFile(SCRef str);
	bool lookupAnnotation();
	uint annotateLength(const FileAnnotation* curAnn);
	void saveScreenState();
	void restoreScreenState();

	Domain* d;
	Git* git;
	QTextEdit* ft;
	StateInfo* st;
	RangeInfo* rangeInfo;

	FileHighlighter* fileHighlighter;
	QGuardedPtr<Annotate> annotateObj;
	QGuardedPtr<MyProcess> proc;
	const FileAnnotation* curAnn;

	QString pending;
	QString fileData;
	uint line;
	uint annoLen;
	bool isAnnotateAvailable;
	bool isFileAvailable;
	bool isAnnotationAppended;
	bool isRangeFilterActive;
	bool isShowAnnotate;

	struct ScreenState {
		bool isValid, hasSelectedText, isShowAnnotate;
		int topPara, paraFrom, indexFrom, paraTo, indexTo, annoLen;
	};
	ScreenState ss;
};

#endif
