
/* Automatically generated by autoxml, do not edit. */

#include "myx_public_interface.h"

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include "myx_xml_util_functions.h"
#include <glib.h>

///////////////////////////////////////////////////////////////////////////////
/** @brief Create a new xml-node, contained information from MYX_DBM_DATATYPE
    @param o MYX_DBM_DATATYPE to store in xml-node
    @param parent parent for created node
*//////////////////////////////////////////////////////////////////////////////
static void store_datatype_MYX_DBM_DATATYPE(MYX_DBM_DATATYPE *o,
                                            xmlNodePtr parent)
{
  xmlNodePtr node;
  char ** flag, ** end_flags= o->flags + o->flags_num;
  node= xmlNewTextChild(parent, NULL, (xmlChar*)"datatype", NULL);
  for (flag= o->flags; flag!=end_flags; flag++)
    xmlNewTextChild(node, NULL, (xmlChar*)"flag", (unsigned char*)*flag);

  xmlNewTextChild         (node,NULL,(xmlChar*)"name",             (xmlChar*)o->name);
  NewTextChild_int_content(node,NULL,(xmlChar*)"group",            o->group);
  NewTextChild_int_content(node,NULL,(xmlChar*)"synonym_group",    o->synonym_group);
  NewTextChild_int_content(node,NULL,(xmlChar*)"params_optional",  o->params_optional);
  NewTextChild_int_content(node,NULL,(xmlChar*)"has_length_param", o->has_length_param);
  NewTextChild_int_content(node,NULL,(xmlChar*)"has_decimal_param",o->has_decimal_param);
  NewTextChild_int_content(node,NULL,(xmlChar*)"has_value_params", o->has_value_params);
}

///////////////////////////////////////////////////////////////////////////////
/** @brief Create a new xml-document, contained information 
              from MYX_DBM_DATATYPES
    @param obj MYX_DBM_DATATYPES to store in the xml document
    @return the new created document
*//////////////////////////////////////////////////////////////////////////////
xmlDocPtr make_xml_for_datatype(MYX_DBM_DATATYPES *obj)
{
  xmlDocPtr doc;
  xmlNodePtr parent;
  unsigned int i;

  g_return_val_if_fail(obj, NULL);

  doc= xmlNewDoc((xmlChar*)"1.0");

  parent= doc->children= xmlNewDocRawNode(doc, NULL, (xmlChar*)"datatype", NULL);

  for (i= 0; i < obj->datatypes_num; i++)
    store_datatype_MYX_DBM_DATATYPE(obj->datatypes+i, parent);

  for (i= 0; i < obj->substitutes_num; i++)
  {
    xmlNodePtr vp= xmlNewTextChild(parent, NULL, (xmlChar*)"substitution", NULL);
    xmlNewProp(vp, (xmlChar*)"name", (xmlChar*)obj->substitutes[i].name);
    xmlNewProp(vp, (xmlChar*)"value", (xmlChar*)obj->substitutes[i].value);
  }

  return doc;
}
///////////////////////////////////////////////////////////////////////////////
/** @brief store MYX_DBM_DATATYPES in an XML file
    @param filename path to file to store in
    @param obj MYX_DBM_DATATYPES struct to store
    @return -1 if file was not written, else 0
*//////////////////////////////////////////////////////////////////////////////
int myx_datatype_store(const char *filename, MYX_DBM_DATATYPES *obj)
{
  xmlDocPtr doc;
  int res;

  g_return_val_if_fail(obj, -1);
  g_return_val_if_fail(filename, -1);

  doc= make_xml_for_datatype(obj);

  res= myx_xmlSaveFile(filename, doc);
  xmlFreeDoc(doc);
  return (res == -1) ? -1 : 0;
}

///////////////////////////////////////////////////////////////////////////////
/** @brief read MYX_DBM_DATATYPE struct from xml node
    @param parent node to read from
    @param obj MYX_DBM_DATATYPE struct to fill
*//////////////////////////////////////////////////////////////////////////////
static void read_datatype_MYX_DBM_DATATYPE(xmlNodePtr parent,
                                           MYX_DBM_DATATYPE *obj)
{
  xmlNodePtr node;
  xmlDocPtr doc= parent->doc;
  char ** flag;

  obj->flags_num= get_child_count(parent, (xmlChar*)"flag");
  flag= obj->flags= g_malloc0(obj->flags_num * sizeof(char *));

  for (node= parent->children; node != NULL; node= node->next)
  {
    if (!xmlStrcmp(node->name, (xmlChar*)"flag"))
    {
      *flag= (char*)xmlNodeListGetString(doc, node->children, 1);
      flag++;
    }
    try_to_get_string_field(doc, node, "name",          &obj->name);
    try_to_get_int_field   (doc, node, "group",         (int*)&obj->group);
    try_to_get_int_field   (doc, node, "synonym_group", (int*)&obj->synonym_group);
    try_to_get_int_field   (doc, node, "params_optional",
                            (int*)&obj->params_optional);
    try_to_get_int_field   (doc, node, "has_length_param",
                            (int*)&obj->has_length_param);
    try_to_get_int_field   (doc, node, "has_decimal_param",
                            (int*)&obj->has_decimal_param);
    try_to_get_int_field   (doc, node, "has_value_params",
                            (int*)&obj->has_value_params);
  }
}

///////////////////////////////////////////////////////////////////////////////
/** @brief read MYX_DBM_DATATYPES struct from xml document
    @param doc document to read from
    @param error_code returned error code, <BR>
           possible values are:
             - \link MYX_LIB_ERROR::MYX_XML_EMPTY_DOCUMENT 
                                               MYX_XML_EMPTY_DOCUMENT \endlink
             - unchanged..
    @return loaded MYX_DBM_DATATYPES
*//////////////////////////////////////////////////////////////////////////////
MYX_DBM_DATATYPES *process_xml_for_datatype(xmlDocPtr doc,
                                            MYX_LIB_ERROR *error_code)
{
  xmlNodePtr parent, node;
  MYX_DBM_DATATYPES *obj;
  MYX_DBM_DATATYPE * type= NULL;
  MYX_NAME_VALUE_PAIR * pair= NULL;

  parent= xmlDocGetRootElement(doc);
  if (parent == NULL) 
  {
    *error_code= MYX_XML_EMPTY_DOCUMENT;
    return NULL;
  }

  obj= (MYX_DBM_DATATYPES*)g_malloc0(sizeof(MYX_DBM_DATATYPES));
  obj->datatypes_num= get_child_count(parent, (xmlChar*)"datatype");
  obj->substitutes_num= get_child_count(parent, (xmlChar*)"substitution");

  if (obj->datatypes_num > 0)
  {
    type= obj->datatypes=
                        (MYX_DBM_DATATYPE*)g_malloc0(obj->datatypes_num *
                                                     sizeof(MYX_DBM_DATATYPE));
  }

  if (obj->substitutes_num > 0)
  {
    pair= obj->substitutes=
                  (MYX_NAME_VALUE_PAIR*)g_malloc0(obj->substitutes_num *
                                                  sizeof(MYX_NAME_VALUE_PAIR));
  }

  for (node= parent->children; node != NULL; node= node->next)
  {
    if (!xmlStrcmp(node->name, (xmlChar*)"datatype"))
    {
      read_datatype_MYX_DBM_DATATYPE(node, type);
      type++;
    }
    if (!xmlStrcmp(node->name, (xmlChar*)"substitution"))
    {
      pair->name= (char*)xmlGetProp(node, (xmlChar*)"name");
      pair->value= (char*)xmlGetProp(node, (xmlChar*)"value");
      pair++;
    }
  }

  return obj;
}

///////////////////////////////////////////////////////////////////////////////
/** @ brief load MYX_DBM_DATATYPES struct from an XML file
    @param filename path to a xml-file with stored MYX_DBM_DATATYPES struct

    @param error_code returned error code, <BR>
           possible values are:
             - \link MYX_LIB_ERROR::MYX_NO_ERROR MYX_NO_ERROR \endlink
             - \link MYX_LIB_ERROR::MYX_ERROR_CANT_OPEN_FILE 
                                             MYX_ERROR_CANT_OPEN_FILE \endlink
             - \link MYX_LIB_ERROR::MYX_XML_PARSE_ERROR 
                                                  MYX_XML_PARSE_ERROR \endlink
             - \link MYX_LIB_ERROR::MYX_XML_EMPTY_DOCUMENT 
                                               MYX_XML_EMPTY_DOCUMENT \endlink

    @return loaded MYX_DBM_DATATYPES
*//////////////////////////////////////////////////////////////////////////////
MYX_DBM_DATATYPES *myx_datatype_load(const char *filename,
                                     MYX_LIB_ERROR *error_code)
{
  xmlDocPtr doc;
  MYX_DBM_DATATYPES *obj;

  *error_code= MYX_NO_ERROR;

  if (!file_exists(filename))
  {
    *error_code = MYX_ERROR_CANT_OPEN_FILE;
    return NULL;
  }
  if (!(doc= myx_xmlParseFile(filename)))
  {
    *error_code= MYX_XML_PARSE_ERROR;
    return NULL;
  }
  obj= process_xml_for_datatype(doc, error_code);

  xmlFreeDoc(doc);
  return obj;
}

///////////////////////////////////////////////////////////////////////////////
/** @brief free memory for the MYX_DBM_DATATYPE struct
    @param obj MYX_DBM_DATATYPE struct to free
    @return 0 always
*//////////////////////////////////////////////////////////////////////////////
static int free_datatype_MYX_DBM_DATATYPE(MYX_DBM_DATATYPE *obj)
{
  unsigned int i;
  for (i= 0; i < obj->flags_num; i++)
    g_free(obj->flags[i]);
  g_free(obj->flags);
  xmlFree(obj->name);
  return 0;
}

///////////////////////////////////////////////////////////////////////////////
/** @brief free memory for the MYX_DBM_DATATYPES struct
    @param obj MYX_DBM_DATATYPES struct to free
    @return 0 always
*//////////////////////////////////////////////////////////////////////////////
int myx_free_datatype(MYX_DBM_DATATYPES *obj)
{
  unsigned int i;
  for (i= 0; i < obj->datatypes_num; i++)
    free_datatype_MYX_DBM_DATATYPE(obj->datatypes+i);
  g_free(obj->datatypes);
  return 0;
}

