/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>

#include "sqliteInt.h"
#include "parse.h"
#line 56 "parse.y"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 240
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct {int value; int mask;} yy13;
  struct TrigEvent yy132;
  IdList* yy160;
  Expr* yy178;
  int yy230;
  Select* yy239;
  TriggerStep* yy247;
  struct LimitVal yy270;
  SrcList* yy285;
  Expr * yy292;
  Token yy384;
  struct LikeOp yy440;
  ExprList* yy462;
  int yy479;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 559
#define YYNRULE 295
#define YYERRORSYMBOL 137
#define YYERRSYMDT yy479
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   279,   67,  283,   69,  147,  165,  545,  418,   61,   61,
 /*    10 */    61,   61,  201,   63,   63,   63,   63,   64,   64,   65,
 /*    20 */    65,   65,   66,   66,  547,  548,  431,   68,   63,   63,
 /*    30 */    63,   63,   64,   64,   65,   65,   65,   66,   67,  453,
 /*    40 */    69,  147,  498,   60,   58,  287,  439,  440,  436,  436,
 /*    50 */    62,   62,   61,   61,   61,   61,  500,   63,   63,   63,
 /*    60 */    63,   64,   64,   65,   65,   65,   66,  279,  370,  283,
 /*    70 */   418,    2,  376,   79,  157,  114,  219,  304,  224,  305,
 /*    80 */   169,  244,  855,  118,  558,  503,  203,    2,  245,  388,
 /*    90 */   495,  218,   21,  431,  513,   20,  418,   57,  492,  511,
 /*   100 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   110 */    60,   58,  287,  439,  440,  436,  436,   62,   62,   61,
 /*   120 */    61,   61,   61,  530,   63,   63,   63,   63,   64,   64,
 /*   130 */    65,   65,   65,   66,  279,  377,  378,  174,  371,  368,
 /*   140 */   330,  333,  334,  219,  304,  224,  305,  169,  244,  510,
 /*   150 */   479,   19,  335,  138,  376,  245,  509,  301,  372,  418,
 /*   160 */   431,  529,   91,  199,   65,   65,   65,   66,  504,  167,
 /*   170 */   191,   64,   64,   65,   65,   65,   66,   60,   58,  287,
 /*   180 */   439,  440,  436,  436,   62,   62,   61,   61,   61,   61,
 /*   190 */   254,   63,   63,   63,   63,   64,   64,   65,   65,   65,
 /*   200 */    66,  279,  250,  410,  410,  430,  109,  395,  426,  204,
 /*   210 */   357,  260,  259,  308,  145,  168,  153,  377,  378,  396,
 /*   220 */   327,  201,   67,  189,   69,  147,  225,  431,  546,  361,
 /*   230 */   465,  365,  397,  499,  318,  409,   40,  413,  428,  312,
 /*   240 */   161,  180,  550,  178,   60,   58,  287,  439,  440,  436,
 /*   250 */   436,   62,   62,   61,   61,   61,   61,  410,   63,   63,
 /*   260 */    63,   63,   64,   64,   65,   65,   65,   66,  279,  471,
 /*   270 */   415,  415,  415,  282,  308,  322,  235,  426,  204,  308,
 /*   280 */   174,  367,  308,  330,  333,  334,   67,  308,   69,  147,
 /*   290 */   148,  559,  371,  368,  431,  335,  409,   34,  165,  465,
 /*   300 */   418,  409,   34,  275,  409,   34,  428,  502,  161,  409,
 /*   310 */    35,   60,   58,  287,  439,  440,  436,  436,   62,   62,
 /*   320 */    61,   61,   61,   61,  410,   63,   63,   63,   63,   64,
 /*   330 */    64,   65,   65,   65,   66,  308,  503,  395,  237,  290,
 /*   340 */   279,  391,  392,  146,  324,  387,   20,  288,  347,  396,
 /*   350 */   174,  450,  350,  330,  333,  334,  450,  409,   27,  450,
 /*   360 */   474,  231,  397,  418,  393,  335,  431,  501,  354,  144,
 /*   370 */   512,  503,  524,  232,  394,  465,  496,  410,  527,  392,
 /*   380 */   555,   20,   75,   60,   58,  287,  439,  440,  436,  436,
 /*   390 */    62,   62,   61,   61,   61,   61,  220,   63,   63,   63,
 /*   400 */    63,   64,   64,   65,   65,   65,   66,  308,  221,  185,
 /*   410 */   338,  254,  279,  308,  239,  443,  475,  308,  319,  308,
 /*   420 */   389,  444,  286,  421,  422,  379,  380,  381,  492,  409,
 /*   430 */    34,  311,  421,  422,  212,  409,   48,  170,  431,  409,
 /*   440 */    40,  409,   48,  410,  122,  314,  526,  442,  442,    1,
 /*   450 */   376,  469,  255,  376,   78,   60,   58,  287,  439,  440,
 /*   460 */   436,  436,   62,   62,   61,   61,   61,   61,  355,   63,
 /*   470 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  279,
 /*   480 */   233,  152,  298,  478,  449,  203,  792,  192,  299,  351,
 /*   490 */   376,  281,  376,    9,  203,  376,  245,  376,  201,  432,
 /*   500 */   314,  376,  442,  442,  490,  431,  314,  325,  442,  442,
 /*   510 */   418,  356,  289,  377,  378,  354,  377,  378,  403,  434,
 /*   520 */   435,  410,   60,   58,  287,  439,  440,  436,  436,   62,
 /*   530 */    62,   61,   61,   61,   61,  263,   63,   63,   63,   63,
 /*   540 */    64,   64,   65,   65,   65,   66,  279,  433,  328,  236,
 /*   550 */   497,  473,  490,  377,  378,  377,  378,  484,  377,  378,
 /*   560 */   377,  378,  308,  522,  377,  378,  314,  521,  442,  442,
 /*   570 */   409,    3,  431,  418,  130,  254,  264,  485,  309,  346,
 /*   580 */   461,  213,  462,  242,  409,   28,  469,  292,  214,   60,
 /*   590 */    58,  287,  439,  440,  436,  436,   62,   62,   61,   61,
 /*   600 */    61,   61,  308,   63,   63,   63,   63,   64,   64,   65,
 /*   610 */    65,   65,   66,  279,  308,  458,  536,  248,    5,  308,
 /*   620 */   201,  308,  469,  308,  409,   23,  308,  202,  291,  308,
 /*   630 */   375,  243,  308,  362,   54,  115,  409,   32,   74,  431,
 /*   640 */    76,  409,   53,  409,   24,  409,   51,  345,  409,   96,
 /*   650 */   149,  409,   93,  265,  409,   98,   60,   58,  287,  439,
 /*   660 */   440,  436,  436,   62,   62,   61,   61,   61,   61,  308,
 /*   670 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   680 */   279,  308,  404,  297,  410,   90,  308,  176,  308,  405,
 /*   690 */   308,  409,   99,  308,  419,  308,   22,  308,  520,  344,
 /*   700 */   520,  164,  153,  409,  110,  141,  431,  313,  409,  111,
 /*   710 */   409,   16,  409,   97,  254,  409,   33,  409,   94,  409,
 /*   720 */    52,  410,  187,   60,   58,  287,  439,  440,  436,  436,
 /*   730 */    62,   62,   61,   61,   61,   61,  308,   63,   63,   63,
 /*   740 */    63,   64,   64,   65,   65,   65,   66,  279,  308,  490,
 /*   750 */   490,  414,  308,  320,  308,  538,  308,  460,  409,  112,
 /*   760 */   308,  171,  172,  173,  308,  408,  308,  424,  424,  407,
 /*   770 */   409,  113,  427,  431,  409,   25,  409,   36,  409,   37,
 /*   780 */   170,  437,  409,   26,  211,  293,  409,   38,  409,   39,
 /*   790 */    60,   58,  287,  439,  440,  436,  436,   62,   62,   61,
 /*   800 */    61,   61,   61,  308,   63,   63,   63,   63,   64,   64,
 /*   810 */    65,   65,   65,   66,  279,  308,  490,  490,  451,  308,
 /*   820 */    81,  308,  151,  308,  459,  409,   41,  308,  243,  243,
 /*   830 */   400,  401,  308,  448,  281,   12,  464,  409,   42,  468,
 /*   840 */   431,  409,   43,  409,   29,  409,   30,  241,  460,  409,
 /*   850 */    44,  294,  296,  480,  409,   45,  329,   60,   70,  287,
 /*   860 */   439,  440,  436,  436,   62,   62,   61,   61,   61,   61,
 /*   870 */   308,   63,   63,   63,   63,   64,   64,   65,   65,   65,
 /*   880 */    66,  279,  308,  408,  483,  482,  308,  407,  308,  467,
 /*   890 */   308,  166,  409,   46,  308,  243,  243,  476,  488,   12,
 /*   900 */   122,  518,  519,  179,  409,   47,  481,  431,  409,   31,
 /*   910 */   409,   10,  409,   49,  505,  486,  409,   50,  254,  249,
 /*   920 */   254,  254,  254,  158,  279,   58,  287,  439,  440,  436,
 /*   930 */   436,   62,   62,   61,   61,   61,   61,  410,   63,   63,
 /*   940 */    63,   63,   64,   64,   65,   65,   65,   66,  487,  247,
 /*   950 */   431,  122,  254,  337,  525,  122,  122,  251,  533,  539,
 /*   960 */   166,  540,  266,  360,  534,  543,   88,   88,  252,  287,
 /*   970 */   439,  440,  436,  436,   62,   62,   61,   61,   61,   61,
 /*   980 */   195,   63,   63,   63,   63,   64,   64,   65,   65,   65,
 /*   990 */    66,   71,  315,  268,    4,  253,  182,  258,  285,  349,
 /*  1000 */   342,  352,  353,  261,  262,  544,  310,   71,  315,  269,
 /*  1010 */     4,  222,  363,  272,  285,  593,  273,  554,  140,  226,
 /*  1020 */   385,  423,  310,  317,  425,  316,  532,  542,   18,  156,
 /*  1030 */   479,  454,  457,  430,  332,  489,  374,  382,  383,  317,
 /*  1040 */   384,    8,  302,  303,  491,  390,  398,  284,  403,  430,
 /*  1050 */   223,  406,   73,   72,  402,   81,  411,  399,  323,   56,
 /*  1060 */    71,  306,  307,  205,  321,  413,   80,  227,   73,   72,
 /*  1070 */   472,   77,  452,  163,  234,  455,   71,  306,  307,   71,
 /*  1080 */   315,  413,    4,  229,  201,  456,  285,  412,  228,   82,
 /*  1090 */   119,  326,  230,  206,  310,  207,  101,  276,  415,  415,
 /*  1100 */   415,  416,  417,   11,  238,  494,  466,  470,  240,  209,
 /*  1110 */   210,  317,  493,  506,  415,  415,  415,  416,  417,   11,
 /*  1120 */   507,  430,  155,  339,  508,  514,  177,  215,  216,  217,
 /*  1130 */   105,  277,  341,  181,  516,   83,  343,   85,  256,  455,
 /*  1140 */    73,   72,  517,  197,  183,  270,  348,  117,   71,  306,
 /*  1150 */   307,  528,  271,  413,  186,  126,  535,  358,  127,  128,
 /*  1160 */   541,  135,  300,  132,  194,  136,  529,  551,  552,  553,
 /*  1170 */   129,  193,   89,  196,  430,  556,  208,  100,   95,  373,
 /*  1180 */   386,  116,  200,   55,   17,  594,  415,  415,  415,  416,
 /*  1190 */   417,   11,   92,  142,  143,  595,  159,  108,  160,   59,
 /*  1200 */   438,  420,  499,  429,  137,  441,  413,  445,  150,  162,
 /*  1210 */   446,  447,    6,    7,   13,  359,  267,  259,  463,   12,
 /*  1220 */   120,  280,  121,  154,  477,  102,  201,  246,  331,  103,
 /*  1230 */    84,  104,  336,  175,  221,  340,  139,  515,  123,  415,
 /*  1240 */   415,  415,  184,  124,  295,  166,  257,  106,  523,  278,
 /*  1250 */   364,  531,  125,   86,  188,   14,  190,  537,  131,  133,
 /*  1260 */    87,  134,   15,  107,  198,  549,  366,  369,  536,  557,
 /*  1270 */   274,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  216,   16,  218,  219,   21,  146,   23,   68,   69,
 /*    10 */    70,   71,  109,   73,   74,   75,   76,   77,   78,   79,
 /*    20 */    80,   81,   82,   82,  164,  165,   42,   72,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,  216,  217,
 /*    40 */   218,  219,  168,   59,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,  168,   73,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   16,  140,   16,
 /*    70 */    86,  143,   23,   22,   88,   89,   90,   91,   92,   93,
 /*    80 */    94,   95,  138,  139,  140,  146,  226,  143,  102,  166,
 /*    90 */   167,  152,   19,   42,  155,  156,   23,   46,  175,  180,
 /*   100 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   110 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   120 */    69,   70,   71,   11,   73,   74,   75,   76,   77,   78,
 /*   130 */    79,   80,   81,   82,   16,   86,   87,   88,    1,    2,
 /*   140 */    91,   92,   93,   90,   91,   92,   93,   94,   95,  175,
 /*   150 */   176,   19,  103,   21,   23,  102,  182,  141,  142,   86,
 /*   160 */    42,   49,   44,  147,   79,   80,   81,   82,  180,  154,
 /*   170 */   154,   77,   78,   79,   80,   81,   82,   59,   60,   61,
 /*   180 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   190 */   146,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   200 */    82,   16,   14,  188,  188,   58,   21,   12,   77,   78,
 /*   210 */    98,   99,  100,  146,   22,  200,  201,   86,   87,   24,
 /*   220 */   205,  109,  216,  154,  218,  219,  189,   42,   97,  213,
 /*   230 */   160,  187,   37,   86,   39,  168,  169,   90,  160,  161,
 /*   240 */   162,   53,  236,   55,   59,   60,   61,   62,   63,   64,
 /*   250 */    65,   66,   67,   68,   69,   70,   71,  188,   73,   74,
 /*   260 */    75,   76,   77,   78,   79,   80,   81,   82,   16,  199,
 /*   270 */   123,  124,  125,  149,  146,  208,  209,   77,   78,  146,
 /*   280 */    88,  237,  146,   91,   92,   93,  216,  146,  218,  219,
 /*   290 */   154,    0,    1,    2,   42,  103,  168,  169,   21,  160,
 /*   300 */    23,  168,  169,  157,  168,  169,  160,  161,  162,  168,
 /*   310 */   169,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   320 */    68,   69,   70,   71,  188,   73,   74,   75,   76,   77,
 /*   330 */    78,   79,   80,   81,   82,  146,  146,   12,  199,  211,
 /*   340 */    16,  184,  185,  154,  211,  155,  156,  211,  224,   24,
 /*   350 */    88,  223,  228,   91,   92,   93,  223,  168,  169,  223,
 /*   360 */    20,  220,   37,   86,   39,  103,   42,  159,  146,  179,
 /*   370 */   180,  146,   18,  146,   49,  160,  168,  188,  184,  185,
 /*   380 */   155,  156,  130,   59,   60,   61,   62,   63,   64,   65,
 /*   390 */    66,   67,   68,   69,   70,   71,   90,   73,   74,   75,
 /*   400 */    76,   77,   78,   79,   80,   81,   82,  146,  102,  154,
 /*   410 */    16,  146,   16,  146,  199,   20,   20,  146,  185,  146,
 /*   420 */   167,   20,  163,  164,  165,    7,    8,    9,  175,  168,
 /*   430 */   169,  163,  164,  165,  212,  168,  169,   43,   42,  168,
 /*   440 */   169,  168,  169,  188,   22,  105,   92,  107,  108,   19,
 /*   450 */    23,  146,  187,   23,  130,   59,   60,   61,   62,   63,
 /*   460 */    64,   65,   66,   67,   68,   69,   70,   71,  213,   73,
 /*   470 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   16,
 /*   480 */   209,  146,  215,   20,  223,  226,  132,  154,  215,  234,
 /*   490 */    23,   97,   23,   19,  226,   23,  102,   23,  109,   42,
 /*   500 */   105,   23,  107,  108,  146,   42,  105,  146,  107,  108,
 /*   510 */    23,  122,  207,   86,   87,  146,   86,   87,   96,   62,
 /*   520 */    63,  188,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   530 */    67,   68,   69,   70,   71,   14,   73,   74,   75,   76,
 /*   540 */    77,   78,   79,   80,   81,   82,   16,   90,  146,  146,
 /*   550 */    20,   79,  146,   86,   87,   86,   87,   30,   86,   87,
 /*   560 */    86,   87,  146,   25,   86,   87,  105,   29,  107,  108,
 /*   570 */   168,  169,   42,   86,   53,  146,   55,   50,  146,   41,
 /*   580 */   113,  212,  113,  225,  168,  169,  146,  181,  144,   59,
 /*   590 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   600 */    70,   71,  146,   73,   74,   75,   76,   77,   78,   79,
 /*   610 */    80,   81,   82,   16,  146,   22,  187,   20,  190,  146,
 /*   620 */   109,  146,  146,  146,  168,  169,  146,  191,  101,  146,
 /*   630 */   146,  225,  146,  122,  198,  146,  168,  169,  129,   42,
 /*   640 */   131,  168,  169,  168,  169,  168,  169,  207,  168,  169,
 /*   650 */   154,  168,  169,  132,  168,  169,   59,   60,   61,   62,
 /*   660 */    63,   64,   65,   66,   67,   68,   69,   70,   71,  146,
 /*   670 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   680 */    16,  146,   27,  207,  188,   21,  146,  154,  146,   34,
 /*   690 */   146,  168,  169,  146,   20,  146,   22,  146,   98,   99,
 /*   700 */   100,  200,  201,  168,  169,  112,   42,   16,  168,  169,
 /*   710 */   168,  169,  168,  169,  146,  168,  169,  168,  169,  168,
 /*   720 */   169,  188,   22,   59,   60,   61,   62,   63,   64,   65,
 /*   730 */    66,   67,   68,   69,   70,   71,  146,   73,   74,   75,
 /*   740 */    76,   77,   78,   79,   80,   81,   82,   16,  146,  146,
 /*   750 */   146,  146,  146,  146,  146,  187,  146,   22,  168,  169,
 /*   760 */   146,   98,   99,  100,  146,  106,  146,  123,  124,  110,
 /*   770 */   168,  169,  160,   42,  168,  169,  168,  169,  168,  169,
 /*   780 */    43,   90,  168,  169,  181,  181,  168,  169,  168,  169,
 /*   790 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   800 */    69,   70,   71,  146,   73,   74,   75,   76,   77,   78,
 /*   810 */    79,   80,   81,   82,   16,  146,  146,  146,  146,  146,
 /*   820 */   120,  146,   87,  146,  202,  168,  169,  146,  225,  225,
 /*   830 */     7,    8,  146,   20,   97,   22,  146,  168,  169,  146,
 /*   840 */    42,  168,  169,  168,  169,  168,  169,  146,  113,  168,
 /*   850 */   169,  181,  181,  146,  168,  169,   79,   59,   60,   61,
 /*   860 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   870 */   146,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   880 */    82,   16,  146,  106,   89,   90,  146,  110,  146,   20,
 /*   890 */   146,   22,  168,  169,  146,  225,  225,   20,   20,   22,
 /*   900 */    22,   51,   52,  154,  168,  169,  177,   42,  168,  169,
 /*   910 */   168,  169,  168,  169,  146,  177,  168,  169,  146,  146,
 /*   920 */   146,  146,  146,   19,   16,   60,   61,   62,   63,   64,
 /*   930 */    65,   66,   67,   68,   69,   70,   71,  188,   73,   74,
 /*   940 */    75,   76,   77,   78,   79,   80,   81,   82,  177,   20,
 /*   950 */    42,   22,  146,   20,   20,   22,   22,  146,   20,  187,
 /*   960 */    22,  187,  187,  187,   20,   20,   22,   22,  146,   61,
 /*   970 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   980 */    19,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   990 */    82,   16,   17,  187,   19,  146,  230,  146,   23,  146,
 /*  1000 */   231,  146,  146,  146,  146,  146,   31,   16,   17,  146,
 /*  1010 */    19,  171,  146,  146,   23,  111,  146,  146,  190,  192,
 /*  1020 */   148,  227,   31,   48,  227,  222,  193,  193,   67,    6,
 /*  1030 */   176,  171,  171,   58,  172,  171,  145,  145,  145,   48,
 /*  1040 */   145,   22,  153,   97,  171,  170,  170,   40,   96,   58,
 /*  1050 */   170,  170,   77,   78,  172,  120,  188,  178,  117,  119,
 /*  1060 */    85,   86,   87,  221,  115,   90,  118,  193,   77,   78,
 /*  1070 */    79,  129,  151,  111,   95,   23,   85,   86,   87,   16,
 /*  1080 */    17,   90,   19,  195,  109,  159,   23,  197,  194,   97,
 /*  1090 */   151,  114,  196,  210,   31,  210,   19,  173,  123,  124,
 /*  1100 */   125,  126,  127,  128,  203,  178,  204,  204,  203,  210,
 /*  1110 */   210,   48,  159,  170,  123,  124,  125,  126,  127,  128,
 /*  1120 */   170,   58,    5,   15,  170,  151,  150,   10,   11,   12,
 /*  1130 */    13,  173,  151,  151,  151,   19,   38,  129,  232,   23,
 /*  1140 */    77,   78,  233,   26,  150,   28,  151,   59,   85,   86,
 /*  1150 */    87,  183,   35,   90,  183,   19,  193,   15,  186,  186,
 /*  1160 */   193,  214,  151,  183,   47,  214,   49,   33,  151,  151,
 /*  1170 */   186,   54,  235,   56,   58,  136,  174,  174,  158,    1,
 /*  1180 */    20,   32,   44,   19,  229,  111,  123,  124,  125,  126,
 /*  1190 */   127,  128,  235,   77,   78,  111,  111,  238,  111,   19,
 /*  1200 */    90,   20,   86,   20,   19,  106,   90,   11,   19,   22,
 /*  1210 */    20,   20,  116,  116,   22,   98,   99,  100,  113,   22,
 /*  1220 */    19,  104,   20,  111,   20,   19,  109,   20,   44,   19,
 /*  1230 */    19,   19,   44,   94,  102,   16,   21,   17,   97,  123,
 /*  1240 */   124,  125,   97,   45,   36,   22,  132,   19,   45,    5,
 /*  1250 */   133,    1,  101,   67,  121,   19,  112,   17,  112,  101,
 /*  1260 */    67,  121,   19,   14,  134,   20,   57,    3,  239,    4,
 /*  1270 */   135,
};
#define YY_SHIFT_USE_DFLT (-98)
#define YY_SHIFT_MAX 369
static const short yy_shift_ofst[] = {
 /*     0 */   137,  975, 1117,  -16,  975, 1063, 1063, 1063,   49,  -97,
 /*    10 */   118, 1063, 1063, 1063, 1063, 1063,  -45,  112,  131,  478,
 /*    20 */   487,  200,  200,   51,  185,  252,  324,  396,  463,  530,
 /*    30 */   597,  664,  731,  798,  731,  731,  731,  731,  731,  731,
 /*    40 */   731,  731,  731,  731,  731,  731,  731,  731,  731,  731,
 /*    50 */   731,  865,  908,  908,  991, 1063, 1063, 1063, 1063, 1063,
 /*    60 */  1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063,
 /*    70 */  1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063,
 /*    80 */  1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063,
 /*    90 */  1063, 1063, 1063,  -60,  -60,  -14,   27,   27,   94,   85,
 /*   100 */   394,  478,  478,  478,  478,  354,  478,  478,  478,  487,
 /*   110 */   -59,  -98,  -98,  -98, 1116,   53,  325,  325,  291,  277,
 /*   120 */   478,  277,  478,  478,  478,  478,  478,  478,  478,  478,
 /*   130 */   478,  478,  478,  478,  478,  389,  511,  -97,  -97,  -97,
 /*   140 */   -98,  -98,  147,  147,  192,  262,  340,  430,  395,  401,
 /*   150 */   195,  467,  469,  474,  472,  418,  427,  427,  777,  427,
 /*   160 */   427,   73,  427,  427,  735,  427,  427,  461,  735,  427,
 /*   170 */   427,  527,  527,  527,  427,  427,  461,  427,  427,  461,
 /*   180 */   427,  538,  600,  427,  427,  461,  427,  427,  427,  461,
 /*   190 */   427,  461,  461,  427,  427,  427,  427,  427,  427,  132,
 /*   200 */   655,  659,  593,  644,  644,  509,  655,  655,  737,  655,
 /*   210 */   655,  422,  700,  700, 1023, 1023, 1023, 1023, 1019,  946,
 /*   220 */   946, 1007,  946,  952,  946,  -97,  935,  941,  948,  949,
 /*   230 */   940,  942,  962,  979, 1052,  979,  962,  992,  977,  992,
 /*   240 */   977, 1077,  979,  979, 1052, 1007,  946,  946,  946, 1077,
 /*   250 */  1108,  962,  962,  962,  962, 1098, 1008, 1108,  962, 1088,
 /*   260 */  1088, 1136,  935, 1142, 1142, 1142,  935, 1088, 1136,  962,
 /*   270 */  1134, 1134,  962,  962, 1039,  -98,  -98,  -98,  -98,  457,
 /*   280 */   521,  663,  188,  306,  823,  904,  674,  691,  813,  869,
 /*   290 */   877,  795,  878,  929,  933,  850,  934,  938,  944,  945,
 /*   300 */   961, 1178, 1160, 1149, 1138, 1164, 1074, 1084, 1085, 1087,
 /*   310 */  1180, 1181, 1183, 1110, 1099, 1185, 1196, 1189, 1190, 1187,
 /*   320 */  1191, 1096, 1192, 1097, 1197, 1105, 1201, 1202, 1112, 1204,
 /*   330 */  1184, 1206, 1207, 1210, 1211, 1188, 1212, 1139, 1132, 1219,
 /*   340 */  1220, 1215, 1141, 1208, 1198, 1223, 1203, 1114, 1145, 1228,
 /*   350 */  1244, 1250, 1151, 1186, 1193, 1133, 1236, 1144, 1240, 1146,
 /*   360 */  1158, 1140, 1243, 1245, 1249, 1209, 1130, 1135, 1264, 1265,
};
#define YY_REDUCE_USE_DFLT (-216)
#define YY_REDUCE_MAX 278
static const short yy_reduce_ofst[] = {
 /*     0 */   -56,  136,   16,   70,  189,  128,   67,  133,  190,   15,
 /*    10 */     6,  141,  261,  271,  267,  273, -178,  255, -140,  -61,
 /*    20 */   146,  259,  268, -215, -215, -215, -215, -215, -215, -215,
 /*    30 */  -215, -215, -215, -215, -215, -215, -215, -215, -215, -215,
 /*    40 */  -215, -215, -215, -215, -215, -215, -215, -215, -215, -215,
 /*    50 */  -215, -215, -215, -215,  402,  416,  456,  468,  473,  475,
 /*    60 */   477,  480,  483,  486,  523,  535,  540,  542,  544,  547,
 /*    70 */   549,  551,  590,  602,  606,  608,  610,  614,  618,  620,
 /*    80 */   657,  669,  673,  675,  677,  681,  686,  724,  736,  740,
 /*    90 */   742,  744,  748, -215, -215,  -77, -215, -215, -215, -215,
 /*   100 */   -26,  406,  603,  604,  670,  124,  671,   44,  225,   78,
 /*   110 */  -215, -215, -215, -215,  208,  253,  157,  194,  -72,  139,
 /*   120 */   305,  215,  358,  265,  440,  222,  476,  429,  568,  772,
 /*   130 */   774,  775,  776,  369,  806,   69,  333,  496,  533,  749,
 /*   140 */   436,  501, -126, -112,  -81,  -12,   37,  227,   37,   37,
 /*   150 */   233,  335,  361,  403,  432,  444,  484,  489,  428,  432,
 /*   160 */   605,  612,  607,  672,  622,  690,  693,   37,  622,  701,
 /*   170 */   707,  729,  738,  771,  768,  773,   37,  811,  822,   37,
 /*   180 */   849,  766,  769,  851,  853,   37,  855,  856,  857,   37,
 /*   190 */   858,   37,   37,  859,  863,  866,  867,  870,  871,  872,
 /*   200 */   840,  828,  827,  794,  797,  803,  860,  861,  854,  864,
 /*   210 */   873,  862,  833,  834,  891,  892,  893,  895,  889,  875,
 /*   220 */   876,  879,  880,  882,  881,  868,  874,  894,  888,  896,
 /*   230 */   890,  842,  921,  883,  926,  885,  939,  901,  902,  905,
 /*   240 */   903,  924,  899,  900,  953,  927,  943,  950,  954,  958,
 /*   250 */   976,  974,  981,  982,  983,  906,  909,  994,  995,  968,
 /*   260 */   971,  947,  963,  972,  973,  984,  967,  980,  951, 1011,
 /*   270 */   937,  957, 1017, 1018,  959, 1020, 1002, 1003,  955,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   565,  789,  854,  680,  854,  789,  854,  789,  854,  684,
 /*    10 */   840,  785,  789,  854,  854,  854,  760,  854,  811,  854,
 /*    20 */   596,  811,  811,  715,  854,  854,  854,  854,  854,  854,
 /*    30 */   854,  854,  716,  854,  788,  784,  780,  782,  781,  717,
 /*    40 */   704,  713,  720,  696,  825,  722,  723,  728,  729,  841,
 /*    50 */   844,  750,  766,  749,  854,  854,  854,  854,  854,  854,
 /*    60 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*    70 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*    80 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*    90 */   854,  854,  854,  752,  771,  589,  751,  759,  753,  754,
 /*   100 */   649,  854,  854,  854,  854,  584,  854,  854,  854,  854,
 /*   110 */   755,  756,  767,  768,  854,  854,  854,  854,  565,  680,
 /*   120 */   854,  680,  854,  854,  854,  854,  854,  854,  854,  854,
 /*   130 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*   140 */   674,  684,  854,  854,  640,  854,  854,  854,  854,  854,
 /*   150 */   854,  854,  854,  854,  854,  572,  570,  854,  672,  854,
 /*   160 */   854,  598,  854,  854,  682,  854,  854,  687,  688,  854,
 /*   170 */   854,  854,  854,  854,  854,  854,  586,  854,  854,  661,
 /*   180 */   854,  817,  854,  854,  854,  832,  854,  854,  854,  830,
 /*   190 */   854,  663,  725,  799,  854,  854,  845,  847,  854,  854,
 /*   200 */   707,  672,  681,  854,  854,  783,  707,  707,  619,  707,
 /*   210 */   707,  622,  719,  719,  569,  569,  569,  569,  639,  651,
 /*   220 */   651,  636,  651,  622,  651,  854,  719,  710,  712,  700,
 /*   230 */   714,  854,  689,  708,  854,  708,  689,  697,  699,  697,
 /*   240 */   699,  793,  708,  708,  854,  636,  651,  651,  651,  793,
 /*   250 */   581,  689,  689,  689,  689,  821,  824,  581,  689,  653,
 /*   260 */   653,  730,  719,  660,  660,  660,  719,  653,  730,  689,
 /*   270 */   843,  843,  689,  689,  852,  606,  624,  624,  827,  854,
 /*   280 */   854,  854,  854,  854,  854,  737,  854,  854,  854,  854,
 /*   290 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*   300 */   806,  854,  854,  854,  854,  854,  742,  738,  854,  739,
 /*   310 */   854,  854,  854,  854,  666,  854,  854,  854,  854,  854,
 /*   320 */   854,  854,  701,  854,  711,  854,  854,  854,  854,  854,
 /*   330 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*   340 */   854,  854,  854,  854,  819,  820,  854,  854,  854,  854,
 /*   350 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*   360 */   854,  854,  854,  854,  854,  851,  854,  854,  566,  854,
 /*   370 */   560,  563,  562,  564,  568,  571,  593,  594,  595,  573,
 /*   380 */   574,  575,  576,  577,  578,  579,  585,  587,  605,  607,
 /*   390 */   614,  652,  655,  656,  657,  835,  836,  837,  615,  634,
 /*   400 */   637,  638,  616,  623,  705,  706,  617,  670,  671,  734,
 /*   410 */   664,  665,  669,  736,  740,  741,  743,  744,  592,  599,
 /*   420 */   600,  603,  604,  807,  809,  808,  810,  602,  601,  745,
 /*   430 */   748,  757,  758,  764,  770,  773,  762,  763,  765,  769,
 /*   440 */   772,  667,  668,  776,  778,  779,  833,  834,  774,  786,
 /*   450 */   787,  690,  777,  761,  702,  591,  709,  703,  673,  683,
 /*   460 */   692,  693,  694,  695,  678,  679,  685,  698,  732,  733,
 /*   470 */   686,  675,  676,  677,  775,  735,  746,  747,  618,  625,
 /*   480 */   626,  627,  630,  631,  632,  633,  628,  629,  794,  795,
 /*   490 */   797,  796,  620,  621,  635,  608,  609,  610,  611,  742,
 /*   500 */   612,  613,  597,  590,  641,  644,  645,  646,  647,  648,
 /*   510 */   650,  642,  643,  588,  580,  582,  691,  813,  822,  823,
 /*   520 */   818,  814,  815,  816,  583,  790,  791,  654,  726,  727,
 /*   530 */   812,  826,  828,  731,  829,  831,  658,  659,  662,  798,
 /*   540 */   838,  718,  721,  724,  800,  801,  802,  803,  804,  805,
 /*   550 */   839,  842,  846,  848,  849,  850,  853,  567,  561,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "REINDEX",       "RENAME",        "CTIME_KW",      "OR",          
  "AND",           "IS",            "BETWEEN",       "IN",          
  "ISNULL",        "NOTNULL",       "NE",            "EQ",          
  "GT",            "LE",            "LT",            "GE",          
  "ESCAPE",        "BITAND",        "BITOR",         "LSHIFT",      
  "RSHIFT",        "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "REM",           "CONCAT",        "UMINUS",      
  "UPLUS",         "BITNOT",        "STRING",        "JOIN_KW",     
  "CONSTRAINT",    "DEFAULT",       "NULL",          "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "COLLATE",     
  "AUTOINCR",      "ON",            "DELETE",        "UPDATE",      
  "INSERT",        "SET",           "DEFERRABLE",    "FOREIGN",     
  "DROP",          "UNION",         "ALL",           "EXCEPT",      
  "INTERSECT",     "SELECT",        "DISTINCT",      "DOT",         
  "FROM",          "JOIN",          "USING",         "ORDER",       
  "BY",            "GROUP",         "HAVING",        "LIMIT",       
  "WHERE",         "INTO",          "VALUES",        "INTEGER",     
  "FLOAT",         "BLOB",          "REGISTER",      "VARIABLE",    
  "CASE",          "WHEN",          "THEN",          "ELSE",        
  "INDEX",         "ALTER",         "TO",            "ADD",         
  "COLUMNKW",      "error",         "input",         "cmdlist",     
  "ecmd",          "cmdx",          "cmd",           "explain",     
  "transtype",     "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "ifnotexists",   "dbnm",        
  "columnlist",    "conslist_opt",  "select",        "column",      
  "columnid",      "type",          "carglist",      "id",          
  "ids",           "typetoken",     "typename",      "signed",      
  "plus_num",      "minus_num",     "carg",          "ccons",       
  "term",          "expr",          "onconf",        "sortorder",   
  "autoinc",       "idxlist_opt",   "refargs",       "defer_subclause",
  "refarg",        "refact",        "init_deferred_pred_opt",  "conslist",    
  "tcons",         "idxlist",       "defer_subclause_opt",  "orconf",      
  "resolvetype",   "raisetype",     "ifexists",      "fullname",    
  "oneselect",     "multiselect_op",  "distinct",      "selcollist",  
  "from",          "where_opt",     "groupby_opt",   "having_opt",  
  "orderby_opt",   "limit_opt",     "sclp",          "as",          
  "seltablist",    "stl_prefix",    "joinop",        "on_opt",      
  "using_opt",     "seltablist_paren",  "joinop2",       "inscollist",  
  "sortlist",      "sortitem",      "collate",       "exprlist",    
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "likeop",        "escape",        "between_op",    "in_op",       
  "case_operand",  "case_exprlist",  "case_else",     "expritem",    
  "uniqueflag",    "idxitem",       "plus_opt",      "number",      
  "trigger_decl",  "trigger_cmd_list",  "trigger_time",  "trigger_event",
  "foreach_clause",  "when_clause",   "trigger_cmd",   "database_kw_opt",
  "key_opt",       "add_column_fullname",  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "carg ::= DEFAULT term",
 /*  51 */ "carg ::= DEFAULT LP expr RP",
 /*  52 */ "carg ::= DEFAULT PLUS term",
 /*  53 */ "carg ::= DEFAULT MINUS term",
 /*  54 */ "carg ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 144 */ "sortlist ::= sortitem collate sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "collate ::=",
 /* 150 */ "collate ::= COLLATE id",
 /* 151 */ "groupby_opt ::=",
 /* 152 */ "groupby_opt ::= GROUP BY exprlist",
 /* 153 */ "having_opt ::=",
 /* 154 */ "having_opt ::= HAVING expr",
 /* 155 */ "limit_opt ::=",
 /* 156 */ "limit_opt ::= LIMIT expr",
 /* 157 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 158 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 159 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 160 */ "where_opt ::=",
 /* 161 */ "where_opt ::= WHERE expr",
 /* 162 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 163 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 164 */ "setlist ::= nm EQ expr",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 167 */ "insert_cmd ::= INSERT orconf",
 /* 168 */ "insert_cmd ::= REPLACE",
 /* 169 */ "itemlist ::= itemlist COMMA expr",
 /* 170 */ "itemlist ::= expr",
 /* 171 */ "inscollist_opt ::=",
 /* 172 */ "inscollist_opt ::= LP inscollist RP",
 /* 173 */ "inscollist ::= inscollist COMMA nm",
 /* 174 */ "inscollist ::= nm",
 /* 175 */ "expr ::= term",
 /* 176 */ "expr ::= LP expr RP",
 /* 177 */ "term ::= NULL",
 /* 178 */ "expr ::= ID",
 /* 179 */ "expr ::= JOIN_KW",
 /* 180 */ "expr ::= nm DOT nm",
 /* 181 */ "expr ::= nm DOT nm DOT nm",
 /* 182 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 183 */ "term ::= STRING",
 /* 184 */ "expr ::= REGISTER",
 /* 185 */ "expr ::= VARIABLE",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "escape ::= ESCAPE expr",
 /* 201 */ "escape ::=",
 /* 202 */ "expr ::= expr likeop expr escape",
 /* 203 */ "expr ::= expr ISNULL|NOTNULL",
 /* 204 */ "expr ::= expr IS NULL",
 /* 205 */ "expr ::= expr NOT NULL",
 /* 206 */ "expr ::= expr IS NOT NULL",
 /* 207 */ "expr ::= NOT|BITNOT expr",
 /* 208 */ "expr ::= MINUS expr",
 /* 209 */ "expr ::= PLUS expr",
 /* 210 */ "between_op ::= BETWEEN",
 /* 211 */ "between_op ::= NOT BETWEEN",
 /* 212 */ "expr ::= expr between_op expr AND expr",
 /* 213 */ "in_op ::= IN",
 /* 214 */ "in_op ::= NOT IN",
 /* 215 */ "expr ::= expr in_op LP exprlist RP",
 /* 216 */ "expr ::= LP select RP",
 /* 217 */ "expr ::= expr in_op LP select RP",
 /* 218 */ "expr ::= expr in_op nm dbnm",
 /* 219 */ "expr ::= EXISTS LP select RP",
 /* 220 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 221 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 222 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 223 */ "case_else ::= ELSE expr",
 /* 224 */ "case_else ::=",
 /* 225 */ "case_operand ::= expr",
 /* 226 */ "case_operand ::=",
 /* 227 */ "exprlist ::= exprlist COMMA expritem",
 /* 228 */ "exprlist ::= expritem",
 /* 229 */ "expritem ::= expr",
 /* 230 */ "expritem ::=",
 /* 231 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 232 */ "uniqueflag ::= UNIQUE",
 /* 233 */ "uniqueflag ::=",
 /* 234 */ "idxlist_opt ::=",
 /* 235 */ "idxlist_opt ::= LP idxlist RP",
 /* 236 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 237 */ "idxlist ::= idxitem collate sortorder",
 /* 238 */ "idxitem ::= nm",
 /* 239 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 240 */ "cmd ::= VACUUM",
 /* 241 */ "cmd ::= VACUUM nm",
 /* 242 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 243 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 244 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 246 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 247 */ "cmd ::= PRAGMA nm dbnm",
 /* 248 */ "plus_num ::= plus_opt number",
 /* 249 */ "minus_num ::= MINUS number",
 /* 250 */ "number ::= INTEGER|FLOAT",
 /* 251 */ "plus_opt ::= PLUS",
 /* 252 */ "plus_opt ::=",
 /* 253 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 254 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 255 */ "trigger_time ::= BEFORE",
 /* 256 */ "trigger_time ::= AFTER",
 /* 257 */ "trigger_time ::= INSTEAD OF",
 /* 258 */ "trigger_time ::=",
 /* 259 */ "trigger_event ::= DELETE|INSERT",
 /* 260 */ "trigger_event ::= UPDATE",
 /* 261 */ "trigger_event ::= UPDATE OF inscollist",
 /* 262 */ "foreach_clause ::=",
 /* 263 */ "foreach_clause ::= FOR EACH ROW",
 /* 264 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 265 */ "when_clause ::=",
 /* 266 */ "when_clause ::= WHEN expr",
 /* 267 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 268 */ "trigger_cmd_list ::=",
 /* 269 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 270 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 271 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 272 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 273 */ "trigger_cmd ::= select",
 /* 274 */ "expr ::= RAISE LP IGNORE RP",
 /* 275 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 276 */ "raisetype ::= ROLLBACK",
 /* 277 */ "raisetype ::= ABORT",
 /* 278 */ "raisetype ::= FAIL",
 /* 279 */ "cmd ::= DROP TRIGGER fullname",
 /* 280 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 281 */ "key_opt ::=",
 /* 282 */ "key_opt ::= KEY expr",
 /* 283 */ "database_kw_opt ::= DATABASE",
 /* 284 */ "database_kw_opt ::=",
 /* 285 */ "cmd ::= DETACH database_kw_opt expr",
 /* 286 */ "cmd ::= REINDEX",
 /* 287 */ "cmd ::= REINDEX nm dbnm",
 /* 288 */ "cmd ::= ANALYZE",
 /* 289 */ "cmd ::= ANALYZE nm dbnm",
 /* 290 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 291 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 292 */ "add_column_fullname ::= fullname",
 /* 293 */ "kwcolumn_opt ::=",
 /* 294 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 154:
    case 188:
    case 205:
#line 373 "parse.y"
{sqlite3SelectDelete((yypminor->yy239));}
#line 1215 "parse.c"
      break;
    case 168:
    case 169:
    case 193:
    case 195:
    case 203:
    case 209:
    case 217:
    case 220:
    case 222:
    case 223:
    case 233:
#line 630 "parse.y"
{sqlite3ExprDelete((yypminor->yy178));}
#line 1230 "parse.c"
      break;
    case 173:
    case 181:
    case 191:
    case 194:
    case 196:
    case 198:
    case 208:
    case 211:
    case 212:
    case 215:
    case 221:
#line 861 "parse.y"
{sqlite3ExprListDelete((yypminor->yy462));}
#line 1245 "parse.c"
      break;
    case 187:
    case 192:
    case 200:
    case 201:
#line 501 "parse.y"
{sqlite3SrcListDelete((yypminor->yy285));}
#line 1253 "parse.c"
      break;
    case 197:
#line 562 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy270).pLimit);
  sqlite3ExprDelete((yypminor->yy270).pOffset);
}
#line 1261 "parse.c"
      break;
    case 204:
    case 207:
    case 214:
#line 518 "parse.y"
{sqlite3IdListDelete((yypminor->yy160));}
#line 1268 "parse.c"
      break;
    case 229:
    case 234:
#line 955 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy247));}
#line 1274 "parse.c"
      break;
    case 231:
#line 939 "parse.y"
{sqlite3IdListDelete((yypminor->yy132).b);}
#line 1279 "parse.c"
      break;
    case 236:
#line 1023 "parse.y"
{sqlite3ExprDelete((yypminor->yy292));}
#line 1284 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1437 "parse.c"
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 138, 1 },
  { 139, 2 },
  { 139, 1 },
  { 141, 1 },
  { 140, 1 },
  { 140, 3 },
  { 143, 0 },
  { 143, 1 },
  { 143, 3 },
  { 142, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 2 },
  { 144, 0 },
  { 144, 1 },
  { 144, 1 },
  { 144, 1 },
  { 142, 2 },
  { 142, 2 },
  { 142, 2 },
  { 142, 2 },
  { 147, 6 },
  { 150, 0 },
  { 150, 3 },
  { 149, 1 },
  { 149, 0 },
  { 148, 4 },
  { 148, 2 },
  { 152, 3 },
  { 152, 1 },
  { 155, 3 },
  { 156, 1 },
  { 159, 1 },
  { 160, 1 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 157, 0 },
  { 157, 1 },
  { 161, 1 },
  { 161, 4 },
  { 161, 6 },
  { 162, 1 },
  { 162, 2 },
  { 163, 1 },
  { 163, 1 },
  { 158, 2 },
  { 158, 0 },
  { 166, 3 },
  { 166, 1 },
  { 166, 2 },
  { 166, 4 },
  { 166, 3 },
  { 166, 3 },
  { 166, 2 },
  { 167, 2 },
  { 167, 3 },
  { 167, 5 },
  { 167, 2 },
  { 167, 4 },
  { 167, 4 },
  { 167, 1 },
  { 167, 2 },
  { 172, 0 },
  { 172, 1 },
  { 174, 0 },
  { 174, 2 },
  { 176, 2 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 177, 2 },
  { 177, 2 },
  { 177, 1 },
  { 177, 1 },
  { 175, 3 },
  { 175, 2 },
  { 178, 0 },
  { 178, 2 },
  { 178, 2 },
  { 153, 0 },
  { 153, 2 },
  { 179, 3 },
  { 179, 2 },
  { 179, 1 },
  { 180, 2 },
  { 180, 7 },
  { 180, 5 },
  { 180, 5 },
  { 180, 10 },
  { 182, 0 },
  { 182, 1 },
  { 170, 0 },
  { 170, 3 },
  { 183, 0 },
  { 183, 2 },
  { 184, 1 },
  { 184, 1 },
  { 184, 1 },
  { 142, 4 },
  { 186, 2 },
  { 186, 0 },
  { 142, 7 },
  { 142, 4 },
  { 142, 1 },
  { 154, 1 },
  { 154, 3 },
  { 189, 1 },
  { 189, 2 },
  { 189, 1 },
  { 188, 9 },
  { 190, 1 },
  { 190, 1 },
  { 190, 0 },
  { 198, 2 },
  { 198, 0 },
  { 191, 3 },
  { 191, 2 },
  { 191, 4 },
  { 199, 2 },
  { 199, 1 },
  { 199, 0 },
  { 192, 0 },
  { 192, 2 },
  { 201, 2 },
  { 201, 0 },
  { 200, 6 },
  { 200, 7 },
  { 205, 1 },
  { 205, 1 },
  { 151, 0 },
  { 151, 2 },
  { 187, 2 },
  { 202, 1 },
  { 202, 2 },
  { 202, 3 },
  { 202, 4 },
  { 203, 2 },
  { 203, 0 },
  { 204, 4 },
  { 204, 0 },
  { 196, 0 },
  { 196, 3 },
  { 208, 5 },
  { 208, 3 },
  { 209, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 0 },
  { 210, 0 },
  { 210, 2 },
  { 194, 0 },
  { 194, 3 },
  { 195, 0 },
  { 195, 2 },
  { 197, 0 },
  { 197, 2 },
  { 197, 4 },
  { 197, 4 },
  { 142, 4 },
  { 193, 0 },
  { 193, 2 },
  { 142, 6 },
  { 212, 5 },
  { 212, 3 },
  { 142, 8 },
  { 142, 5 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 207, 3 },
  { 207, 1 },
  { 169, 1 },
  { 169, 3 },
  { 168, 1 },
  { 169, 1 },
  { 169, 1 },
  { 169, 3 },
  { 169, 5 },
  { 168, 1 },
  { 168, 1 },
  { 169, 1 },
  { 169, 1 },
  { 169, 6 },
  { 169, 5 },
  { 169, 4 },
  { 168, 1 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 216, 1 },
  { 216, 2 },
  { 217, 2 },
  { 217, 0 },
  { 169, 4 },
  { 169, 2 },
  { 169, 3 },
  { 169, 3 },
  { 169, 4 },
  { 169, 2 },
  { 169, 2 },
  { 169, 2 },
  { 218, 1 },
  { 218, 2 },
  { 169, 5 },
  { 219, 1 },
  { 219, 2 },
  { 169, 5 },
  { 169, 3 },
  { 169, 5 },
  { 169, 4 },
  { 169, 4 },
  { 169, 5 },
  { 221, 5 },
  { 221, 4 },
  { 222, 2 },
  { 222, 0 },
  { 220, 1 },
  { 220, 0 },
  { 211, 3 },
  { 211, 1 },
  { 223, 1 },
  { 223, 0 },
  { 142, 11 },
  { 224, 1 },
  { 224, 0 },
  { 173, 0 },
  { 173, 3 },
  { 181, 5 },
  { 181, 3 },
  { 225, 1 },
  { 142, 4 },
  { 142, 1 },
  { 142, 2 },
  { 142, 5 },
  { 142, 5 },
  { 142, 5 },
  { 142, 5 },
  { 142, 6 },
  { 142, 3 },
  { 164, 2 },
  { 165, 2 },
  { 227, 1 },
  { 226, 1 },
  { 226, 0 },
  { 142, 5 },
  { 228, 10 },
  { 230, 1 },
  { 230, 1 },
  { 230, 2 },
  { 230, 0 },
  { 231, 1 },
  { 231, 1 },
  { 231, 3 },
  { 232, 0 },
  { 232, 3 },
  { 232, 3 },
  { 233, 0 },
  { 233, 2 },
  { 229, 3 },
  { 229, 0 },
  { 234, 6 },
  { 234, 8 },
  { 234, 5 },
  { 234, 4 },
  { 234, 1 },
  { 169, 4 },
  { 169, 6 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 142, 3 },
  { 142, 6 },
  { 236, 0 },
  { 236, 2 },
  { 235, 1 },
  { 235, 0 },
  { 142, 3 },
  { 142, 1 },
  { 142, 3 },
  { 142, 1 },
  { 142, 3 },
  { 142, 6 },
  { 142, 6 },
  { 237, 1 },
  { 238, 0 },
  { 238, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1810 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1815 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1820 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1825 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy230);}
#line 1830 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy230 = TK_DEFERRED;}
#line 1835 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy230 = yymsp[0].major;}
#line 1844 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1850 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1855 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384,yymsp[-4].minor.yy230,0,yymsp[-2].minor.yy230);
}
#line 1862 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 210:
      case 213:
#line 132 "parse.y"
{yygotominor.yy230 = 0;}
#line 1877 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 211:
      case 214:
#line 133 "parse.y"
{yygotominor.yy230 = 1;}
#line 1889 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy0,0);
}
#line 1896 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy239);
  sqlite3SelectDelete(yymsp[0].minor.yy239);
}
#line 1904 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy384.z = yymsp[-2].minor.yy384.z;
  yygotominor.yy384.n = (pParse->sLastToken.z-yymsp[-2].minor.yy384.z) + pParse->sLastToken.n;
}
#line 1912 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy384);
  yygotominor.yy384 = yymsp[0].minor.yy384;
}
#line 1920 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 250:
#line 168 "parse.y"
{yygotominor.yy384 = yymsp[0].minor.yy0;}
#line 1930 "parse.c"
        break;
      case 38:
#line 227 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy384);}
#line 1935 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 150:
      case 238:
      case 248:
      case 249:
#line 228 "parse.y"
{yygotominor.yy384 = yymsp[0].minor.yy384;}
#line 1948 "parse.c"
        break;
      case 40:
#line 229 "parse.y"
{
  yygotominor.yy384.z = yymsp[-3].minor.yy384.z;
  yygotominor.yy384.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy384.z;
}
#line 1956 "parse.c"
        break;
      case 41:
#line 233 "parse.y"
{
  yygotominor.yy384.z = yymsp[-5].minor.yy384.z;
  yygotominor.yy384.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy384.z;
}
#line 1964 "parse.c"
        break;
      case 43:
#line 239 "parse.y"
{yygotominor.yy384.z=yymsp[-1].minor.yy384.z; yygotominor.yy384.n=yymsp[0].minor.yy384.n+(yymsp[0].minor.yy384.z-yymsp[-1].minor.yy384.z);}
#line 1969 "parse.c"
        break;
      case 44:
#line 241 "parse.y"
{ yygotominor.yy230 = atoi((char*)yymsp[0].minor.yy384.z); }
#line 1974 "parse.c"
        break;
      case 45:
#line 242 "parse.y"
{ yygotominor.yy230 = -atoi((char*)yymsp[0].minor.yy384.z); }
#line 1979 "parse.c"
        break;
      case 50:
      case 52:
#line 251 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy178);}
#line 1985 "parse.c"
        break;
      case 51:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy178);}
#line 1990 "parse.c"
        break;
      case 53:
#line 254 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy178, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 1998 "parse.c"
        break;
      case 54:
#line 258 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy384);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2006 "parse.c"
        break;
      case 56:
#line 267 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy230);}
#line 2011 "parse.c"
        break;
      case 57:
#line 269 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy230,yymsp[0].minor.yy230,yymsp[-2].minor.yy230);}
#line 2016 "parse.c"
        break;
      case 58:
#line 270 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy230,0,0,0,0);}
#line 2021 "parse.c"
        break;
      case 59:
#line 271 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy178);}
#line 2026 "parse.c"
        break;
      case 60:
#line 273 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy384,yymsp[-1].minor.yy462,yymsp[0].minor.yy230);}
#line 2031 "parse.c"
        break;
      case 61:
#line 274 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy230);}
#line 2036 "parse.c"
        break;
      case 62:
#line 275 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy384.z, yymsp[0].minor.yy384.n);}
#line 2041 "parse.c"
        break;
      case 65:
#line 288 "parse.y"
{ yygotominor.yy230 = OE_Restrict * 0x010101; }
#line 2046 "parse.c"
        break;
      case 66:
#line 289 "parse.y"
{ yygotominor.yy230 = (yymsp[-1].minor.yy230 & yymsp[0].minor.yy13.mask) | yymsp[0].minor.yy13.value; }
#line 2051 "parse.c"
        break;
      case 67:
#line 291 "parse.y"
{ yygotominor.yy13.value = 0;     yygotominor.yy13.mask = 0x000000; }
#line 2056 "parse.c"
        break;
      case 68:
#line 292 "parse.y"
{ yygotominor.yy13.value = yymsp[0].minor.yy230;     yygotominor.yy13.mask = 0x0000ff; }
#line 2061 "parse.c"
        break;
      case 69:
#line 293 "parse.y"
{ yygotominor.yy13.value = yymsp[0].minor.yy230<<8;  yygotominor.yy13.mask = 0x00ff00; }
#line 2066 "parse.c"
        break;
      case 70:
#line 294 "parse.y"
{ yygotominor.yy13.value = yymsp[0].minor.yy230<<16; yygotominor.yy13.mask = 0xff0000; }
#line 2071 "parse.c"
        break;
      case 71:
#line 296 "parse.y"
{ yygotominor.yy230 = OE_SetNull; }
#line 2076 "parse.c"
        break;
      case 72:
#line 297 "parse.y"
{ yygotominor.yy230 = OE_SetDflt; }
#line 2081 "parse.c"
        break;
      case 73:
#line 298 "parse.y"
{ yygotominor.yy230 = OE_Cascade; }
#line 2086 "parse.c"
        break;
      case 74:
#line 299 "parse.y"
{ yygotominor.yy230 = OE_Restrict; }
#line 2091 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 167:
#line 301 "parse.y"
{yygotominor.yy230 = yymsp[0].minor.yy230;}
#line 2102 "parse.c"
        break;
      case 80:
#line 311 "parse.y"
{yygotominor.yy384.n = 0; yygotominor.yy384.z = 0;}
#line 2107 "parse.c"
        break;
      case 81:
#line 312 "parse.y"
{yygotominor.yy384 = yymsp[-1].minor.yy0;}
#line 2112 "parse.c"
        break;
      case 86:
#line 318 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy462,yymsp[0].minor.yy230,yymsp[-2].minor.yy230,0);}
#line 2117 "parse.c"
        break;
      case 87:
#line 320 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy462,yymsp[0].minor.yy230,0,0,0,0);}
#line 2122 "parse.c"
        break;
      case 88:
#line 321 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy178);}
#line 2127 "parse.c"
        break;
      case 89:
#line 323 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy462, &yymsp[-3].minor.yy384, yymsp[-2].minor.yy462, yymsp[-1].minor.yy230);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy230);
}
#line 2135 "parse.c"
        break;
      case 92:
      case 94:
#line 337 "parse.y"
{yygotominor.yy230 = OE_Default;}
#line 2141 "parse.c"
        break;
      case 97:
#line 342 "parse.y"
{yygotominor.yy230 = OE_Ignore;}
#line 2146 "parse.c"
        break;
      case 98:
      case 168:
#line 343 "parse.y"
{yygotominor.yy230 = OE_Replace;}
#line 2152 "parse.c"
        break;
      case 99:
#line 347 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy285, 0, yymsp[-1].minor.yy230);
}
#line 2159 "parse.c"
        break;
      case 102:
#line 357 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy384, &yymsp[-2].minor.yy384, yymsp[0].minor.yy239, yymsp[-5].minor.yy230);
}
#line 2166 "parse.c"
        break;
      case 103:
#line 360 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy285, 1, yymsp[-1].minor.yy230);
}
#line 2173 "parse.c"
        break;
      case 104:
#line 367 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy239, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy239);
}
#line 2181 "parse.c"
        break;
      case 105:
      case 128:
#line 377 "parse.y"
{yygotominor.yy239 = yymsp[0].minor.yy239;}
#line 2187 "parse.c"
        break;
      case 106:
#line 379 "parse.y"
{
  if( yymsp[0].minor.yy239 ){
    yymsp[0].minor.yy239->op = yymsp[-1].minor.yy230;
    yymsp[0].minor.yy239->pPrior = yymsp[-2].minor.yy239;
  }
  yygotominor.yy239 = yymsp[0].minor.yy239;
}
#line 2198 "parse.c"
        break;
      case 108:
#line 388 "parse.y"
{yygotominor.yy230 = TK_ALL;}
#line 2203 "parse.c"
        break;
      case 110:
#line 392 "parse.y"
{
  yygotominor.yy239 = sqlite3SelectNew(yymsp[-6].minor.yy462,yymsp[-5].minor.yy285,yymsp[-4].minor.yy178,yymsp[-3].minor.yy462,yymsp[-2].minor.yy178,yymsp[-1].minor.yy462,yymsp[-7].minor.yy230,yymsp[0].minor.yy270.pLimit,yymsp[0].minor.yy270.pOffset);
}
#line 2210 "parse.c"
        break;
      case 114:
      case 235:
#line 413 "parse.y"
{yygotominor.yy462 = yymsp[-1].minor.yy462;}
#line 2216 "parse.c"
        break;
      case 115:
      case 141:
      case 151:
      case 234:
#line 414 "parse.y"
{yygotominor.yy462 = 0;}
#line 2224 "parse.c"
        break;
      case 116:
#line 415 "parse.y"
{
   yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-2].minor.yy462,yymsp[-1].minor.yy178,yymsp[0].minor.yy384.n?&yymsp[0].minor.yy384:0);
}
#line 2231 "parse.c"
        break;
      case 117:
#line 418 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-1].minor.yy462, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2238 "parse.c"
        break;
      case 118:
#line 421 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy384);
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-3].minor.yy462, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2247 "parse.c"
        break;
      case 121:
#line 433 "parse.y"
{yygotominor.yy384.n = 0;}
#line 2252 "parse.c"
        break;
      case 122:
#line 445 "parse.y"
{yygotominor.yy285 = sqliteMalloc(sizeof(*yygotominor.yy285));}
#line 2257 "parse.c"
        break;
      case 123:
#line 446 "parse.y"
{yygotominor.yy285 = yymsp[0].minor.yy285;}
#line 2262 "parse.c"
        break;
      case 124:
#line 451 "parse.y"
{
   yygotominor.yy285 = yymsp[-1].minor.yy285;
   if( yygotominor.yy285 && yygotominor.yy285->nSrc>0 ) yygotominor.yy285->a[yygotominor.yy285->nSrc-1].jointype = yymsp[0].minor.yy230;
}
#line 2270 "parse.c"
        break;
      case 125:
#line 455 "parse.y"
{yygotominor.yy285 = 0;}
#line 2275 "parse.c"
        break;
      case 126:
#line 456 "parse.y"
{
  yygotominor.yy285 = sqlite3SrcListAppend(yymsp[-5].minor.yy285,&yymsp[-4].minor.yy384,&yymsp[-3].minor.yy384);
  if( yymsp[-2].minor.yy384.n ) sqlite3SrcListAddAlias(yygotominor.yy285,&yymsp[-2].minor.yy384);
  if( yymsp[-1].minor.yy178 ){
    if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pOn = yymsp[-1].minor.yy178; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy178); }
  }
  if( yymsp[0].minor.yy160 ){
    if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pUsing = yymsp[0].minor.yy160; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy160); }
  }
}
#line 2291 "parse.c"
        break;
      case 127:
#line 470 "parse.y"
{
    yygotominor.yy285 = sqlite3SrcListAppend(yymsp[-6].minor.yy285,0,0);
    yygotominor.yy285->a[yygotominor.yy285->nSrc-1].pSelect = yymsp[-4].minor.yy239;
    if( yymsp[-2].minor.yy384.n ) sqlite3SrcListAddAlias(yygotominor.yy285,&yymsp[-2].minor.yy384);
    if( yymsp[-1].minor.yy178 ){
      if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pOn = yymsp[-1].minor.yy178; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy178); }
    }
    if( yymsp[0].minor.yy160 ){
      if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pUsing = yymsp[0].minor.yy160; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy160); }
    }
  }
#line 2308 "parse.c"
        break;
      case 129:
#line 491 "parse.y"
{
     yygotominor.yy239 = sqlite3SelectNew(0,yymsp[0].minor.yy285,0,0,0,0,0,0,0);
  }
#line 2315 "parse.c"
        break;
      case 130:
#line 497 "parse.y"
{yygotominor.yy384.z=0; yygotominor.yy384.n=0;}
#line 2320 "parse.c"
        break;
      case 132:
#line 502 "parse.y"
{yygotominor.yy285 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384);}
#line 2325 "parse.c"
        break;
      case 133:
#line 506 "parse.y"
{ yygotominor.yy230 = JT_INNER; }
#line 2330 "parse.c"
        break;
      case 134:
#line 507 "parse.y"
{ yygotominor.yy230 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2335 "parse.c"
        break;
      case 135:
#line 508 "parse.y"
{ yygotominor.yy230 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy384,0); }
#line 2340 "parse.c"
        break;
      case 136:
#line 510 "parse.y"
{ yygotominor.yy230 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy384,&yymsp[-1].minor.yy384); }
#line 2345 "parse.c"
        break;
      case 137:
      case 145:
      case 154:
      case 161:
      case 175:
      case 200:
      case 223:
      case 225:
      case 229:
#line 514 "parse.y"
{yygotominor.yy178 = yymsp[0].minor.yy178;}
#line 2358 "parse.c"
        break;
      case 138:
      case 153:
      case 160:
      case 201:
      case 224:
      case 226:
      case 230:
#line 515 "parse.y"
{yygotominor.yy178 = 0;}
#line 2369 "parse.c"
        break;
      case 139:
      case 172:
#line 519 "parse.y"
{yygotominor.yy160 = yymsp[-1].minor.yy160;}
#line 2375 "parse.c"
        break;
      case 140:
      case 171:
#line 520 "parse.y"
{yygotominor.yy160 = 0;}
#line 2381 "parse.c"
        break;
      case 142:
      case 152:
#line 531 "parse.y"
{yygotominor.yy462 = yymsp[0].minor.yy462;}
#line 2387 "parse.c"
        break;
      case 143:
#line 532 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462,yymsp[-2].minor.yy178,yymsp[-1].minor.yy384.n>0?&yymsp[-1].minor.yy384:0);
  if( yygotominor.yy462 ) yygotominor.yy462->a[yygotominor.yy462->nExpr-1].sortOrder = yymsp[0].minor.yy230;
}
#line 2395 "parse.c"
        break;
      case 144:
#line 536 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy178,yymsp[-1].minor.yy384.n>0?&yymsp[-1].minor.yy384:0);
  if( yygotominor.yy462 && yygotominor.yy462->a ) yygotominor.yy462->a[0].sortOrder = yymsp[0].minor.yy230;
}
#line 2403 "parse.c"
        break;
      case 146:
      case 148:
#line 545 "parse.y"
{yygotominor.yy230 = SQLITE_SO_ASC;}
#line 2409 "parse.c"
        break;
      case 147:
#line 546 "parse.y"
{yygotominor.yy230 = SQLITE_SO_DESC;}
#line 2414 "parse.c"
        break;
      case 149:
#line 548 "parse.y"
{yygotominor.yy384.z = 0; yygotominor.yy384.n = 0;}
#line 2419 "parse.c"
        break;
      case 155:
#line 566 "parse.y"
{yygotominor.yy270.pLimit = 0; yygotominor.yy270.pOffset = 0;}
#line 2424 "parse.c"
        break;
      case 156:
#line 567 "parse.y"
{yygotominor.yy270.pLimit = yymsp[0].minor.yy178; yygotominor.yy270.pOffset = 0;}
#line 2429 "parse.c"
        break;
      case 157:
#line 569 "parse.y"
{yygotominor.yy270.pLimit = yymsp[-2].minor.yy178; yygotominor.yy270.pOffset = yymsp[0].minor.yy178;}
#line 2434 "parse.c"
        break;
      case 158:
#line 571 "parse.y"
{yygotominor.yy270.pOffset = yymsp[-2].minor.yy178; yygotominor.yy270.pLimit = yymsp[0].minor.yy178;}
#line 2439 "parse.c"
        break;
      case 159:
#line 575 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy285,yymsp[0].minor.yy178);}
#line 2444 "parse.c"
        break;
      case 162:
#line 586 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy285,yymsp[-1].minor.yy462,yymsp[0].minor.yy178,yymsp[-4].minor.yy230);}
#line 2449 "parse.c"
        break;
      case 163:
#line 592 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462,yymsp[0].minor.yy178,&yymsp[-2].minor.yy384);}
#line 2454 "parse.c"
        break;
      case 164:
#line 593 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(0,yymsp[0].minor.yy178,&yymsp[-2].minor.yy384);}
#line 2459 "parse.c"
        break;
      case 165:
#line 599 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy285, yymsp[-1].minor.yy462, 0, yymsp[-4].minor.yy160, yymsp[-7].minor.yy230);}
#line 2464 "parse.c"
        break;
      case 166:
#line 601 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy285, 0, yymsp[0].minor.yy239, yymsp[-1].minor.yy160, yymsp[-4].minor.yy230);}
#line 2469 "parse.c"
        break;
      case 169:
      case 227:
#line 611 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-2].minor.yy462,yymsp[0].minor.yy178,0);}
#line 2475 "parse.c"
        break;
      case 170:
      case 228:
#line 612 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(0,yymsp[0].minor.yy178,0);}
#line 2481 "parse.c"
        break;
      case 173:
#line 621 "parse.y"
{yygotominor.yy160 = sqlite3IdListAppend(yymsp[-2].minor.yy160,&yymsp[0].minor.yy384);}
#line 2486 "parse.c"
        break;
      case 174:
#line 622 "parse.y"
{yygotominor.yy160 = sqlite3IdListAppend(0,&yymsp[0].minor.yy384);}
#line 2491 "parse.c"
        break;
      case 176:
#line 633 "parse.y"
{yygotominor.yy178 = yymsp[-1].minor.yy178; sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2496 "parse.c"
        break;
      case 177:
      case 182:
      case 183:
#line 634 "parse.y"
{yygotominor.yy178 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2503 "parse.c"
        break;
      case 178:
      case 179:
#line 635 "parse.y"
{yygotominor.yy178 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2509 "parse.c"
        break;
      case 180:
#line 637 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy384);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy384);
  yygotominor.yy178 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2518 "parse.c"
        break;
      case 181:
#line 642 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy384);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy384);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy384);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy178 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2529 "parse.c"
        break;
      case 184:
#line 651 "parse.y"
{yygotominor.yy178 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2534 "parse.c"
        break;
      case 185:
#line 652 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy178 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2543 "parse.c"
        break;
      case 186:
#line 658 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy178, 0, &yymsp[-1].minor.yy384);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2551 "parse.c"
        break;
      case 187:
#line 663 "parse.y"
{
  yygotominor.yy178 = sqlite3ExprFunction(yymsp[-1].minor.yy462, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy230 && yygotominor.yy178 ){
    yygotominor.yy178->flags |= EP_Distinct;
  }
}
#line 2562 "parse.c"
        break;
      case 188:
#line 670 "parse.y"
{
  yygotominor.yy178 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2570 "parse.c"
        break;
      case 189:
#line 674 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy178 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy178 ) yygotominor.yy178->op = TK_CONST_FUNC;  
}
#line 2580 "parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 680 "parse.y"
{yygotominor.yy178 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy178, yymsp[0].minor.yy178, 0);}
#line 2592 "parse.c"
        break;
      case 198:
#line 690 "parse.y"
{yygotominor.yy440.eOperator = yymsp[0].minor.yy0; yygotominor.yy440.not = 0;}
#line 2597 "parse.c"
        break;
      case 199:
#line 691 "parse.y"
{yygotominor.yy440.eOperator = yymsp[0].minor.yy0; yygotominor.yy440.not = 1;}
#line 2602 "parse.c"
        break;
      case 202:
#line 696 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy178, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy178, 0);
  if( yymsp[0].minor.yy178 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy178, 0);
  }
  yygotominor.yy178 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy440.eOperator);
  if( yymsp[-2].minor.yy440.not ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178, &yymsp[-3].minor.yy178->span, &yymsp[-1].minor.yy178->span);
}
#line 2617 "parse.c"
        break;
      case 203:
#line 708 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2625 "parse.c"
        break;
      case 204:
#line 712 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2633 "parse.c"
        break;
      case 205:
#line 716 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2641 "parse.c"
        break;
      case 206:
#line 720 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-3].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2649 "parse.c"
        break;
      case 207:
#line 724 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy178->span);
}
#line 2657 "parse.c"
        break;
      case 208:
#line 728 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy178->span);
}
#line 2665 "parse.c"
        break;
      case 209:
#line 732 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy178->span);
}
#line 2673 "parse.c"
        break;
      case 212:
#line 739 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy178, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy178, 0);
  yygotominor.yy178 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy178, 0, 0);
  if( yygotominor.yy178 ){
    yygotominor.yy178->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy178->span,&yymsp[0].minor.yy178->span);
}
#line 2689 "parse.c"
        break;
      case 215:
#line 755 "parse.y"
{
    yygotominor.yy178 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy178, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pList = yymsp[-1].minor.yy462;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy462);
    }
    if( yymsp[-3].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy178->span,&yymsp[0].minor.yy0);
  }
#line 2703 "parse.c"
        break;
      case 216:
#line 765 "parse.y"
{
    yygotominor.yy178 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pSelect = yymsp[-1].minor.yy239;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy239);
    }
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2716 "parse.c"
        break;
      case 217:
#line 774 "parse.y"
{
    yygotominor.yy178 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy178, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pSelect = yymsp[-1].minor.yy239;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy239);
    }
    if( yymsp[-3].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy178->span,&yymsp[0].minor.yy0);
  }
#line 2730 "parse.c"
        break;
      case 218:
#line 784 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384);
    yygotominor.yy178 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy178, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-3].minor.yy178->span,yymsp[0].minor.yy384.z?&yymsp[0].minor.yy384:&yymsp[-1].minor.yy384);
  }
#line 2745 "parse.c"
        break;
      case 219:
#line 795 "parse.y"
{
    Expr *p = yygotominor.yy178 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy239;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy239);
    }
  }
#line 2758 "parse.c"
        break;
      case 220:
#line 807 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy178, yymsp[-1].minor.yy178, 0);
  if( yygotominor.yy178 ){
    yygotominor.yy178->pList = yymsp[-2].minor.yy462;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy462);
  }
  sqlite3ExprSpan(yygotominor.yy178, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2771 "parse.c"
        break;
      case 221:
#line 818 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462, yymsp[-2].minor.yy178, 0);
  yygotominor.yy462 = sqlite3ExprListAppend(yygotominor.yy462, yymsp[0].minor.yy178, 0);
}
#line 2779 "parse.c"
        break;
      case 222:
#line 822 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy178, 0);
  yygotominor.yy462 = sqlite3ExprListAppend(yygotominor.yy462, yymsp[0].minor.yy178, 0);
}
#line 2787 "parse.c"
        break;
      case 231:
#line 849 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy384, &yymsp[-5].minor.yy384, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy384,0), yymsp[-1].minor.yy462, yymsp[-9].minor.yy230,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy230);
}
#line 2795 "parse.c"
        break;
      case 232:
      case 277:
#line 855 "parse.y"
{yygotominor.yy230 = OE_Abort;}
#line 2801 "parse.c"
        break;
      case 233:
#line 856 "parse.y"
{yygotominor.yy230 = OE_None;}
#line 2806 "parse.c"
        break;
      case 236:
#line 866 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy384.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy384.z, yymsp[-1].minor.yy384.n);
  }
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462, p, &yymsp[-2].minor.yy384);
  if( yygotominor.yy462 ) yygotominor.yy462->a[yygotominor.yy462->nExpr-1].sortOrder = yymsp[0].minor.yy230;
}
#line 2819 "parse.c"
        break;
      case 237:
#line 875 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy384.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy384.z, yymsp[-1].minor.yy384.n);
  }
  yygotominor.yy462 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy384);
  if( yygotominor.yy462 ) yygotominor.yy462->a[yygotominor.yy462->nExpr-1].sortOrder = yymsp[0].minor.yy230;
}
#line 2832 "parse.c"
        break;
      case 239:
#line 889 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy285, yymsp[-1].minor.yy230);}
#line 2837 "parse.c"
        break;
      case 240:
      case 241:
#line 893 "parse.y"
{sqlite3Vacuum(pParse);}
#line 2843 "parse.c"
        break;
      case 242:
      case 244:
#line 899 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy384,&yymsp[-2].minor.yy384,&yymsp[0].minor.yy384,0);}
#line 2849 "parse.c"
        break;
      case 243:
#line 900 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy384,&yymsp[-2].minor.yy384,&yymsp[0].minor.yy0,0);}
#line 2854 "parse.c"
        break;
      case 245:
#line 902 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy384,&yymsp[-2].minor.yy384,&yymsp[0].minor.yy384,1);
}
#line 2861 "parse.c"
        break;
      case 246:
#line 905 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy384,&yymsp[-3].minor.yy384,&yymsp[-1].minor.yy384,0);}
#line 2866 "parse.c"
        break;
      case 247:
#line 906 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384,0,0);}
#line 2871 "parse.c"
        break;
      case 253:
#line 918 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy384.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy384.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy247, &all);
}
#line 2881 "parse.c"
        break;
      case 254:
#line 927 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy384, &yymsp[-6].minor.yy384, yymsp[-5].minor.yy230, yymsp[-4].minor.yy132.a, yymsp[-4].minor.yy132.b, yymsp[-2].minor.yy285, yymsp[-1].minor.yy230, yymsp[0].minor.yy178, yymsp[-9].minor.yy230);
  yygotominor.yy384 = (yymsp[-6].minor.yy384.n==0?yymsp[-7].minor.yy384:yymsp[-6].minor.yy384);
}
#line 2889 "parse.c"
        break;
      case 255:
      case 258:
#line 933 "parse.y"
{ yygotominor.yy230 = TK_BEFORE; }
#line 2895 "parse.c"
        break;
      case 256:
#line 934 "parse.y"
{ yygotominor.yy230 = TK_AFTER;  }
#line 2900 "parse.c"
        break;
      case 257:
#line 935 "parse.y"
{ yygotominor.yy230 = TK_INSTEAD;}
#line 2905 "parse.c"
        break;
      case 259:
      case 260:
#line 940 "parse.y"
{yygotominor.yy132.a = yymsp[0].major; yygotominor.yy132.b = 0;}
#line 2911 "parse.c"
        break;
      case 261:
#line 942 "parse.y"
{yygotominor.yy132.a = TK_UPDATE; yygotominor.yy132.b = yymsp[0].minor.yy160;}
#line 2916 "parse.c"
        break;
      case 262:
      case 263:
#line 945 "parse.y"
{ yygotominor.yy230 = TK_ROW; }
#line 2922 "parse.c"
        break;
      case 264:
#line 947 "parse.y"
{ yygotominor.yy230 = TK_STATEMENT; }
#line 2927 "parse.c"
        break;
      case 265:
#line 951 "parse.y"
{ yygotominor.yy178 = 0; }
#line 2932 "parse.c"
        break;
      case 266:
#line 952 "parse.y"
{ yygotominor.yy178 = yymsp[0].minor.yy178; }
#line 2937 "parse.c"
        break;
      case 267:
#line 956 "parse.y"
{
  if( yymsp[-2].minor.yy247 ){
    yymsp[-2].minor.yy247->pLast->pNext = yymsp[-1].minor.yy247;
  }else{
    yymsp[-2].minor.yy247 = yymsp[-1].minor.yy247;
  }
  yymsp[-2].minor.yy247->pLast = yymsp[-1].minor.yy247;
  yygotominor.yy247 = yymsp[-2].minor.yy247;
}
#line 2950 "parse.c"
        break;
      case 268:
#line 965 "parse.y"
{ yygotominor.yy247 = 0; }
#line 2955 "parse.c"
        break;
      case 269:
#line 971 "parse.y"
{ yygotominor.yy247 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy384, yymsp[-1].minor.yy462, yymsp[0].minor.yy178, yymsp[-4].minor.yy230); }
#line 2960 "parse.c"
        break;
      case 270:
#line 976 "parse.y"
{yygotominor.yy247 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy384, yymsp[-4].minor.yy160, yymsp[-1].minor.yy462, 0, yymsp[-7].minor.yy230);}
#line 2965 "parse.c"
        break;
      case 271:
#line 979 "parse.y"
{yygotominor.yy247 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy384, yymsp[-1].minor.yy160, 0, yymsp[0].minor.yy239, yymsp[-4].minor.yy230);}
#line 2970 "parse.c"
        break;
      case 272:
#line 983 "parse.y"
{yygotominor.yy247 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy384, yymsp[0].minor.yy178);}
#line 2975 "parse.c"
        break;
      case 273:
#line 986 "parse.y"
{yygotominor.yy247 = sqlite3TriggerSelectStep(yymsp[0].minor.yy239); }
#line 2980 "parse.c"
        break;
      case 274:
#line 989 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy178 ){
    yygotominor.yy178->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy178, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 2991 "parse.c"
        break;
      case 275:
#line 996 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy384); 
  if( yygotominor.yy178 ) {
    yygotominor.yy178->iColumn = yymsp[-3].minor.yy230;
    sqlite3ExprSpan(yygotominor.yy178, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3002 "parse.c"
        break;
      case 276:
#line 1006 "parse.y"
{yygotominor.yy230 = OE_Rollback;}
#line 3007 "parse.c"
        break;
      case 278:
#line 1008 "parse.y"
{yygotominor.yy230 = OE_Fail;}
#line 3012 "parse.c"
        break;
      case 279:
#line 1013 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy285);
}
#line 3019 "parse.c"
        break;
      case 280:
#line 1019 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy178, yymsp[-1].minor.yy178, yymsp[0].minor.yy292);
}
#line 3026 "parse.c"
        break;
      case 281:
#line 1024 "parse.y"
{ yygotominor.yy292 = 0; }
#line 3031 "parse.c"
        break;
      case 282:
#line 1025 "parse.y"
{ yygotominor.yy292 = yymsp[0].minor.yy178; }
#line 3036 "parse.c"
        break;
      case 285:
#line 1031 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy178);
}
#line 3043 "parse.c"
        break;
      case 286:
#line 1037 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3048 "parse.c"
        break;
      case 287:
#line 1038 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy384, &yymsp[0].minor.yy384);}
#line 3053 "parse.c"
        break;
      case 288:
#line 1043 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3058 "parse.c"
        break;
      case 289:
#line 1044 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy384, &yymsp[0].minor.yy384);}
#line 3063 "parse.c"
        break;
      case 290:
#line 1049 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy285,&yymsp[0].minor.yy384);
}
#line 3070 "parse.c"
        break;
      case 291:
#line 1052 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy384);
}
#line 3077 "parse.c"
        break;
      case 292:
#line 1055 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy285);
}
#line 3084 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3152 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
