# -*- encoding: UTF-8 -*-

kern=u"""
 
if (frsp)
french_punct { kern.x = 87m };
p("colon") { kern.x = 0m } / _ p("colon");
p("colon") { kern.x = 0m } / p("colon") _;
french_punct { kern.x = 0m } / leftpunct _;
french_punct { kern.x = 0m } / quots _ quots;
french_punct { kern.x = 0m } / p("bracketleft") _;
french_punct { kern.x = 0m } / U+00BB _ U+00AB;

// guillemets

letters { kern.x = 100m } / U+00AB _;
U+00BB { kern.x = 125m } / letters _;
quots { kern.x = 100m } / U+00AB _;
U+00BB { kern.x = 125m } / quots _;
U+00BB { kern.x = 125m } / french_punct _;

endif;

if (algn)
ANY { kern.x = 2000m - @2.advancewidth } / ZWSP _;
ANY { kern.x = 2000m - @2.advancewidth - @3.advancewidth } / ZWSP _ ANY;
ANY { kern.x = 2000m - @2.advancewidth - @3.advancewidth - @4.advancewidth } / ZWSP _ ANY ANY;

//ANY { kern.x = 2000m - @2.advancewidth } / ZWSP _ { user1 == true };
//ANY { kern.x = 2000m - @2.advancewidth - @3.advancewidth } / ZWSP _ {user1 == true}  ANY;
//ANY { kern.x = 2000m - @2.advancewidth - @3.advancewidth - @4.advancewidth } / ZWSP _ {user1 == true}  ANY ANY;
endif;
"""

kern_linlib = u"""
// put asterisk above the subscript
U+002A { kern.x = (@1.pos.x - @2.pos.x) ; adv.x = -(@2.pos.x - @1.pos.x) + @1.bb.width + 50m } / cidx3 _ { @2.bb.width <= @1.bb.width };
U+002A { kern.x = (@1.pos.x - @2.pos.x) } / cidx3 _;

// subscript letter
cidx2 { kern.x = (@1.pos.x - @2.pos.x) ; adv.x = -(@2.pos.x - @1.pos.x) + @1.bb.width + 50m } / cidx3 _ { @2.bb.width <= @1.bb.width };
cidx2 { kern.x = (@1.pos.x - @2.pos.x) } / cidx3 _;

cidx3 { kern.x =  @1.pos.x + @1.bb.width - @3.pos.x } / cidx3 cidx2 _;
cidx2 { kern.x =  @2.bb.width - @3.bb.width } / cidx3 cidx2 cidx3 _;
cidx3 { kern.x =  @1.bb.width - @2.bb.width + @3.bb.width - @4.bb.width } / cidx3 cidx2 cidx3 cidx2 _;
cidx2 { kern.x = -@1.bb.width + @2.bb.width - @3.bb.width + @4.bb.width - @5.bb.width } / cidx3 cidx2 cidx3 cidx2 cidx3 _;

// nut fraction
if (frac==2)
cnumsup { kern.x = (@2.advancewidth - @1.advancewidth)/2 } / _ {user1==true} dashes;
cnumsup { kern.x = (@3.advancewidth - @1.advancewidth - @2.advancewidth)/2 } / _ {user1==true} cnumsup dashes;
cnumsup { kern.x = (@4.advancewidth - @1.advancewidth - @2.advancewidth - @3.advancewidth)/2 } / _ {user1==true} cnumsup cnumsup dashes;

dashes { kern.x = -@2.advancewidth + (@2.advancewidth - @1.advancewidth)/2; kern.y = 0 } / cnumsup {user1==true} _ cnumsub;
dashes { kern.x = -@3.advancewidth + (@3.advancewidth - @1.advancewidth - @2.advancewidth)/2; kern.y = 0 } / cnumsup {user1==true} cnumsup _ cnumsub;
dashes { kern.x = -@4.advancewidth + (@4.advancewidth - @1.advancewidth - @2.advancewidth - @3.advancewidth)/2; kern.y = 0 } / cnumsup {user1==true} cnumsup cnumsup _ cnumsub;

cnumsub { kern.x = -@2.advancewidth - (@1.advancewidth - @2.advancewidth)/2; kern.y = -100;  } / dashes _ {user1==true};
cnumsub { kern.x = -@2.advancewidth - @3.advancewidth - (@1.advancewidth - @2.advancewidth - @3.advancewidth)/2; kern.y = -100;  } / dashes _ cnumsub {user1==true};
cnumsub { kern.x = -@2.advancewidth - @3.advancewidth - @4.advancewidth - (@1.advancewidth - @2.advancewidth - @3.advancewidth -@4.advancewidth)/2; kern.y = -100;  } / dashes _ cnumsub cnumsub {user1==true};

ANY { kern.x = (@1.advancewidth - @2.advancewidth)/2; kern.y = 100 } / dashes cnumsub {user1==true} _;
ANY { kern.x = (@1.advancewidth - @2.advancewidth - @3.advancewidth)/2; kern.y = 100 } / dashes cnumsub cnumsub {user1==true} _;
ANY { kern.x = (@1.advancewidth - @2.advancewidth - @3.advancewidth - @4.advancewidth)/2; kern.y = 100 } / dashes cnumsub cnumsub cnumsub {user1==true} _;
endif;

// kerning fix for fractions with old figures
slashold { kern.x = -175 } / p("slash") _;
slashold2 { kern.x = -115 } / p("slash") _;

"""

feat_linlibBI = u"""
smcp {id = "smcp"; name.LG_USENG="'smcp' Small capitals";}
"""

feat=u"""
algn { id = "algn"; name.LG_USENG="'algn' Right aligned numbers or footnote numbering signs"; }
arti { id = "arti"; default = 0; 
// name.LG_HU = string("'arti' Számok elé névelő");
name.LG_USENG = string ("'arti' Definitive article before numbers"); }

circ { id = "circ"; name.LG_USENG="'circ' Enclosed alphanumerics"; settings { 
	none { value = 0; name.LG_USENG = "None"; }
	circled { value = 1; name.LG_USENG = "Circled numbers and letters"; } 
	parenthesized { value = 2; name.LG_USENG = "Parenthesized numbers and letters"; } 
	negative { value = 3; name.LG_USENG = "White on black circled numbers"; } 
	double { value = 4; name.LG_USENG = "Double circled numbers"; } 
}}
dash { id="dash"; name.LG_USENG="'dash' N-dash correction"; }
foot { id = "foot"; name.LG_USENG="'foot' Footnote numbering signs"; settings {
	none { value = 0; name.LG_USENG = "None"; }
	basic { value = 1; name.LG_USENG = "Asterisk, dagger, ..."; }
	double { value = 2; name.LG_USENG = "Asterisk, double asterisk, ..."; }
}}
frsp {id = "frsp"; name.LG_USENG = "'frsp' 1/8 em space before !, ?, : and ;"}
grkn { id = "grkn"; name.LG_USENG="'grkn' Numbers to Greek small letters"; }

lng { id = "lng"; default = 0;
name.LG_USENG = string ("'lng' Language");
 settings { 
	none {value = 0; name.LG_USENG="None" }
	AFK { value = 27; name.LG_USENG="AFK" }
	AZE { value = 202; name.LG_USENG="AZE" }
	CAT { value = 37; name.LG_USENG="CAT"}
	CSY { value = 42; name.LG_USENG="CSY"}
	CRT { value = 203; name.LG_USENG="CRT"}
	DAN { value = 45; name.LG_USENG="DAN"}
	DEU { value = 49; name.LG_USENG="DEU"}
	ENG { value = 1; name.LG_USENG="ENG"}
	ELL { value = 30; name.LG_USENG="ELL"}
	EO { value = 200; name.LG_USENG="EO"}
	ESP { value = 34; name.LG_USENG="ESP"}
	FIN { value = 35; name.LG_USENG="FIN"}
	FRA { value = 33; name.LG_USENG="FRA"}
	HUN { value = 36; name.LG_USENG="HUN"}
	ITA { value = 39; name.LG_USENG="ITA"}
	LTZ { value = 201; name.LG_USENG="LTZ"}
	MOL { value = 230; name.LG_USENG="MOL"}
	NLD { value = 31; name.LG_USENG="NLD"}
	PLK { value = 48; name.LG_USENG="PLK"}
	PTG { value = 3; name.LG_USENG="PTG"}
	ROM { value = 40; name.LG_USENG="ROM"}
	RUS { value = 7; name.LG_USENG="RUS"}
	SRPL { value = 52; name.LG_USENG="SRPL"}
	SLV { value = 50; name.LG_USENG="SLV"}
	SRP { value = 51; name.LG_USENG="SRP"}
	SVE { value = 46; name.LG_USENG="SVE"}
	TRK { value = 90; name.LG_USENG="TRK"}
}}

minu {
	id = "minu";
	default = 1;
	name.LG_USENG = string ("'minu' Minus sign");
//	name.LG_HU = string ("'minu' Mínuszjel");
}
numt { id = "name"; default = 0;
//	name.LG_HU = string ("'name' Számokból számnevek");
	name.LG_USENG = string ("'name' Number names from numbers");
	settings {
		none {value = 0; name.LG_USENG = "None"}
		cardinal { value = 1; name.LG_USENG = "Cardinal number name"}
		ordinal { value = 2; name.LG_USENG = "Ordinal number name"}
		ordabbr { value = 3; name.LG_USENG = "Ordinal abbreviation"}
	}
}

quot { id="quot"; name.LG_USENG="'quot' Quoation mark correction"; }
texm { id = "texm"; 
//name.LG_HU = "'texm' TeX-mód";
name.LG_USENG = string ("'texm' TeX-mode"); }
thou {
	id = "thou";
	name.LG_USENG = string ("'thou' Thousand separation");
//	name.LG_HU = string ("'thou' Ezrestagolás");
	default = normal;
	settings {
		none { value = 0; name.LG_HU = string("Nincs"); name.LG_USENG = string("None"); }
		normal { value = 1; name.LG_HU = string("10000-től"); name.LG_USENG = string("From 10000"); }
		tab { value = 2; name.LG_HU = string("1000-től"); name.LG_USENG = string("From 1000"); }
	}
}

vari { id = "vari"; 
//name.LG_HU = "'vari' nyelvi variáns";
name.LG_USENG = string ("'vari' language variant"); }

"""

glyph=u"""

// French spacing before !, ?, : and ;
french_punct = p("exclam", "question", "colon", "semicolon");
punct = (french_punct, p("comma", "period", "ellipsis", "parenright", "parenleft"));
punctsp = (punct, U+0020);
leftpunct = p("parenleft", "braceleft", "bracketleft", "space");
quots = p("quotedbl", "quotedblbase", "quotedblleft", "quotedblright");

//thinspace = U+202F
//thinspacelen = thinspace

// zero width space
ZWSP = U+200B;
SEPARATOR = U+005C;
// digit variants
d0 = U+0030;
d1 = U+0031;
d2 = U+0032;
d3 = U+0033;
d4 = U+0034;
d5 = U+0035;
d6 = U+0036;
d7 = U+0037;
d8 = U+0038;
d9 = U+0039;

dx = (U+0031..U+0039);
dd = (U+0030..U+0039);
// space, (, [, { and U+200B
cmin = (U+0020, U+0028, U+005B, U+007B, U+200B);
cdecsep = (U+002C, U+002E); // . and ,

slashold = p("four.oldstyle");
slashold2 = p("zero.oldstyle", "two.oldstyle", "three.oldstyle", "five.oldstyle", "seven.oldstyle", "nine.oldstyle");

"""

sub_linlibBI=u"""
if (smcp)
	csc1 > csc2;
endif;
"""

sub=u"""

// fix hard dotted line (used by OpenOffice.org TOC)
//p("period") p("period") p("period") p("period") > @1 @2 @3 @4;
//p("period") p("period") p("period") > @1 @2 @3;
//p("period") p("period") p("period") > _ _ p("ellipsis") / ANY _ _ _ #;
p("period") p("period") p("period") > _ _ p("ellipsis") / letters _ _ _;
p("ellipsis") p("period") > p("period") p("period") p("period") p("period"); 

if (minu)
	U+002D > U+2212 / cmin _ dd; // after space or parenthesis
	U+002D > @2 / ANY _ dd; // don't modify
	U+002D > U+2212 / _ dd; // at the beginning of the line
endif;

if (circ > 0)
if (circ == 1)
	dd > (U+24EA, U+2460..U+2468); // CHECK
	d1 dd > _ (U+2469..U+2472); // CHECK
	d2 d0 > _ U+2473; // CHECK
	U+0041..U+005A > (U+24B6..U+24CF); // CHECK
	U+0061..U+007A > (U+24D0..U+24E9); // CHECK
endif;
if (circ == 2)
	dx > (U+2474..U+247C); // CHECK
	d1 dd > _ (U+247D..U+2487); // CHECK
endif;
if (circ == 3)
	dd > (U+24FF, U+2776..U+277E); // CHECK
	d1 dd > _ (U+277F, U+24EB..U+24F3); // CHECK
	d2 d0 > _ U+24F4; // CHECK
endif;
if (circ == 4)
	dx > (U+24F5..U+24FD); // CHECK
	d1 d0 > _ U+24FE; // CHECK
endif;
endif;

if (grkn)
dx > (U+03B1..U+03B9); // CHECK
d1 dd > _ (U+03BA..U+03C3); // CHECK
d2 (U+0030..U+0035) > _ (U+03C4..U+03C9); // CHECK
endif;

if (texm)
// superiors (^n) and inferiors (_n)

// U+005E cidx1 > _ cidx2;
// U+005F cidx1 > _ cidx3;

// black-board letters

U+005C p("m") p("a") p("t") p("h") p("b") p("b") U+007B p("C") U+007D > _ _ _ _ _ _ _ _ U+2102 _;
U+005C p("m") p("a") p("t") p("h") p("b") p("b") U+007B p("H") U+007D > _ _ _ _ _ _ _ _ U+210D _;
U+005C p("m") p("a") p("t") p("h") p("b") p("b") U+007B p("N") U+007D > _ _ _ _ _ _ _ _ U+2115 _;
U+005C p("m") p("a") p("t") p("h") p("b") p("b") U+007B p("P") U+007D > _ _ _ _ _ _ _ _ U+2119 _;
U+005C p("m") p("a") p("t") p("h") p("b") p("b") U+007B p("Q") U+007D > _ _ _ _ _ _ _ _ U+211A _;
U+005C p("m") p("a") p("t") p("h") p("b") p("b") U+007B p("R") U+007D > _ _ _ _ _ _ _ _ U+211D _;
U+005C p("m") p("a") p("t") p("h") p("b") p("b") U+007B p("Z") U+007D > _ _ _ _ _ _ _ _ U+2124 _;

// Greek letters

U+005C p("a") p("l") p("p") p("h") p("a") > _ _ _ _ _ U+03B1;
U+005C p("b") p("e") p("t") p("a") 	> _ _ _ _ U+03B2;
U+005C p("g") p("a") p("m") p("m") p("a") 	> _ _ _ _ _ U+03B3;
U+005C p("d") p("e") p("l") p("t") p("a") 	> _ _ _ _ _ U+03B4;
U+005C p("e") p("p") p("s") p("i") p("l") p("o") p("n") 	> _ _ _ _ _ _ _ _ U+03F5;
U+005C p("v") p("a") p("r") p("e") p("p") p("s") p("i") p("l") p("o") p("n") 	> _ _ _ _ _ _ _ _ _ _ _ U+03B5;
U+005C p("z") p("e") p("t") p("a") 	> _ _ _ _ U+03B6;
U+005C p("e") p("t") p("a") 	> _ _ _ U+03B7;
U+005C p("t") p("h") p("e") p("t") p("a") 	> _ _ _ _ _ U+03B8;
U+005C p("v") p("a") p("r") p("t") p("h") p("e") p("t") p("a") 	> _ _ _ _ _ _ _ _ U+03D1;
U+005C p("i") p("o") p("t") p("a") 	> _ _ _ _ U+03B9;
U+005C p("k") p("a") p("p") p("p") p("a") 	> _ _ _ _ _ U+03BA;
U+005C p("l") p("a") p("m") p("d") p("a") 	> _ _ _ _ _ U+03BB;
U+005C p("m") p("u") 	> _ _ U+03BC;
U+005C p("n") p("u") 	> _ _ U+03BD;
U+005C p("x") p("i") 	> _ _ U+03BE;
U+005C p("p") p("i") 	> _ _ U+03C0;
U+005C p("v") p("a") p("r") p("p") p("i") 	> _ _ _ _ _ U+03D6;
U+005C p("r") p("h") p("o") 	> _ _ _ U+03C1;
U+005C p("v") p("a") p("r") p("r") p("h") p("o") 	> _ _ _ _ _ _ U+03F1;
U+005C p("v") p("a") p("r") p("s") p("i") p("g") p("m") p("a") 	> _ _ _ _ _ _ _ _ U+03C2;
U+005C p("s") p("i") p("g") p("m") p("a") 	> _ _ _ _ _ U+03C3;
U+005C p("t") p("a") p("u") 	> _ _ _ _ U+03C4;
U+005C p("u") p("p") p("s") p("i") p("l") p("o") p("n") 	> _ _ _ _ _ _ _ U+03C5;
U+005C p("p") p("h") p("i") 	> _ _ _ U+03D5;
U+005C p("v") p("a") p("r") p("p") p("h") p("i") 	> _ _ _ _ _ _ U+03C6;
U+005C p("c") p("h") p("i") 	> _ _ _ U+03C7;
U+005C p("p") p("s") p("i") 	> _ _ _ U+03C8;
U+005C p("o") p("m") p("e") p("g") p("a") 	> _ _ _ _ _ _ U+03C9;

U+005C p("G") p("a") p("m") p("m") p("a") 	> _ _ _ _ _ U+0393;
U+005C p("D") p("e") p("l") p("t") p("a") 	> _ _ _ _ _ U+0394;
U+005C p("T") p("h") p("e") p("t") p("a") 	> _ _ _ _ _ U+0398;
U+005C p("L") p("a") p("m") p("d") p("a") 	> _ _ _ _ _ U+039B;
U+005C p("X") p("i") 	> _ _ U+039E;
U+005C p("P") p("i") 	> _ _ U+03A0;
U+005C p("S") p("i") p("g") p("m") p("a") 	> _ _ _ _ _ U+03A3;
U+005C p("U") p("p") p("s") p("i") p("l") p("o") p("n") 	> _ _ _ _ _ _ _ U+03A5;
U+005C p("P") p("h") p("i") 	> _ _ _ U+03A6;
U+005C p("P") p("s") p("i") 	> _ _ _ U+03A8;
U+005C p("O") p("m") p("e") p("g") p("a") 	> _ _ _ _ _ U+03A9;

// other symbols

U+005C p("p") p("m") > _ _ U+00B1;
U+005C p("m") p("p") > _ _ U+2213;
U+005C p("t") p("i") p("m") p("e") p("s") > _ _ _ _ _ U+00D7;
U+005C p("s") p("e") p("t") p("m") p("i") p("n") p("u") p("s") > _ _ _ _ _ _ _ _ U+2216;
U+005C p("c") p("a") p("p") > _ _ _ U+2229;
U+005C p("c") p("u") p("p") > _ _ _ U+222A;
U+005C p("w") p("e") p("d") p("g") p("e") > _ _ _ _ _ U+2227;
U+005C p("v") p("e") p("e") > _ _ _ U+2228;
U+005C p("l") p("e") p("q") > _ _ _ U+2264;
U+005C p("g") p("e") p("q") > _ _ _ U+2265;
U+005C p("l") p("e") > _ _ U+2264;
U+005C p("g") p("e") > _ _ U+2265;
U+005C p("n") p("o") p("t") U+005C p("l") p("e") > _ _ _ _ _ _ U+2270;
U+005C p("n") p("o") p("t") U+005C p("g") p("e") > _ _ _ _ _ _ U+2271;
U+005C p("l") p("l") > _ _ U+226A;
U+005C p("g") p("g") > _ _ U+226B;
U+005C p("n") p("e") p("q") > _ _ _ U+2260;
U+005C p("i") p("n") > _ _ U+2208;
U+005C p("n") p("o") p("t") U+005C p("i") p("n") > _ _ _ _ _ _ U+2209;
U+005C p("n") p("i") > _ _ U+220B;
U+005C p("n") p("o") p("t") U+005C p("n") p("i") > _ _ _ _ _ _ U+220C;
U+005C p("s") p("u") p("b") p("s") p("e") p("t") > _ _ _ _ _ _ U+2282;
U+005C p("s") p("u") p("p") p("s") p("e") p("t") > _ _ _ _ _ _ U+2283;
U+005C p("n") p("o") p("t") U+005C p("s") p("u") p("b") p("s") p("e") p("t") > _ _ _ _ _ _ _ _ _ _ U+2284;
U+005C p("n") p("o") p("t") U+005C p("s") p("u") p("p") p("s") p("e") p("t") > _ _ _ _ _ _ _ _ _ _ U+2285;
U+005C p("s") p("i") p("m") > _ _ _ U+223C;
U+005C p("n") p("s") p("i") p("m") > _ _ _ _ U+2241;
U+005C p("a") p("p") p("p") p("r") p("o") p("x") > _ _ _ _ _ _ U+2248;
U+005C p("m") p("i") p("d") > _ _ _ U+2223;
U+005C p("n") p("m") p("i") p("d") > _ _ _ _ U+2224;
U+005C U+007C > _ U+2225;
U+005C p("n") p("o") p("t") U+003C > _ _ _ _ U+226E;
U+005C p("n") p("o") p("t") U+003E > _ _ _ _ U+226F;
U+005C p("p") p("a") p("r") p("a") p("l") p("l") p("e") p("l") > _ _ _ _ _ _ _ _ U+2225;
U+005C p("n") p("o") p("t") U+005C U+007C > _ _ _ _ _ U+2226;
U+005C p("n") p("p") p("a") p("r") p("a") p("l") p("l") p("e") p("l") > _ _ _ _ _ _ _ _ _ U+2226;

U+005C p("g") p("e") p("t") p("s") > _ _ _ _ U+2190;
U+005C p("l") p("e") p("f") p("t") p("a") p("r") p("r") p("o") p("w") > _ _ _ _ _ _ _ _ _ U+2190;
U+005C p("u") p("p") p("a") p("r") p("r") p("o") p("w") > _ _ _ _ _ _ _ U+2191;
U+005C p("r") p("i") p("g") p("h") p("t") p("a") p("r") p("r") p("o") p("w") > _ _ _ _ _ _ _ _ _ _ U+2192;
U+005C p("t") p("o") > _ _ U+2192;
U+005C p("d") p("o") p("w") p("n") p("a") p("r") p("r") p("o") p("w") > _ _ _ _ _ _ _ _ _ U+2193;
U+005C p("l") p("e") p("f") p("t") p("r") p("i") p("g") p("h") p("t") p("a") p("r") p("r") p("o") p("w") > _ _ _ _ _ _ _ _ _ _ _ _ _ _ U+2194;

U+005C p("L") p("e") p("f") p("t") p("a") p("r") p("r") p("o") p("w") > _ _ _ _ _ _ _ _ _ U+21D0;
U+005C p("U") p("p") p("a") p("r") p("r") p("o") p("w") > _ _ _ _ _ _ _ U+21D1;
U+005C p("R") p("i") p("g") p("h") p("t") p("a") p("r") p("r") p("o") p("w") > _ _ _ _ _ _ _ _ _ _ U+21D2;
U+005C p("D") p("o") p("w") p("n") p("a") p("r") p("r") p("o") p("w") > _ _ _ _ _ _ _ _ _ U+21D3;
U+005C p("L") p("e") p("f") p("t") p("r") p("i") p("g") p("h") p("t") p("a") p("r") p("r") p("o") p("w") > _ _ _ _ _ _ _ _ _ _ _ _ _ _ U+21D4;

U+005C p("h") p("b") p("a") p("r") > _ _ _ _ U+210F;
U+005C p("R") p("e") > _ _ U+211C;
U+005C p("I") p("m") > _ _ U+2111;
U+005C p("e") p("l") p("l") > _ _ _ U+2113;
U+005C p("a") p("l") p("e") p("p") p("h") > _ _ _ _ _ U+2135;
U+005C p("t") p("r") p("i") p("a") p("n") p("g") p("l") p("e") > _ _ _ _ _ _ _ _ U+2206;
U+005C p("i") p("n") p("f") p("t") p("y") > _ _ _ _ _ U+221E;
U+005C p("p") p("a") p("r") p("t") p("i") p("a") p("l") > _ _ _ _ _ _ _ U+2202;


U+005C p("s") p("u") p("r") p("d") > _ _ _ _ U+221A;
U+005C p("s") p("u") p("m") > _ _ _ U+2211;
U+005C p("i") p("n") p("t") > _ _ _ U+222B;

U+005C p("p") p("r") p("o") p("d") > _ _ _ _ U+220F;
U+005C p("p") p("r") p("i") p("m") p("e") > _ _ _ _ _ U+2032;

U+005C p("a") p("n") p("g") p("l") p("e") > _ _ _ _ _ U+2220;
U+005C p("p") p("e") p("r") p("p") > _ _ _ _ U+27C2;
U+005C p("i") p("i") p("n") p("t") > _ _ _ _ U+222C;
U+005C p("i") p("i") p("i") p("n") p("t") > _ _ _ _ _ U+222D;
U+005C p("o") p("i") p("n") p("t") > _ _ _ _ U+222E;


U+005C p("e") p("m") p("p") p("t") p("y") p("s") p("e") p("t") > _ _ _ _ _ _ _ _ U+2205;
U+005C p("f") p("o") p("r") p("a") p("l") p("l") > _ _ _ _ _ _ U+2200;
U+005C p("e") p("x") p("i") p("s") p("t") p("s") > _ _ _ _ _ _ U+2203;
endif;

if (numt == 1 || numt == 2)

	SEPARATOR > _;

// removing left zeros

	csc123ligdash U+200B d0 U+200B > @1 / ^_ _ _ _;
	csc123ligdash U+200B d0 d0 U+200B > @1 U+200B / ^_ _ _ _ _;
	csc123ligdash U+200B d0 dd U+200B > @1 U+200B @4 U+200B / ^_ _ _ _ _;
	csc123ligdash U+200B d0 dd dd U+200B > @1 U+200B @4 @5 U+200B / ^_ _ _ _ _ _;
	csc123ligdash U+200B d0 dd dd dd U+200B > @1 U+200B @4 @5 @6 U+200B / ^_ _ _ _ _ _ _;
	csc123ligdash U+200B d0 dd dd dd dd U+200B > @1 U+200B @4 @5 @6 @7 U+200B / ^_ _ _ _ _ _ _ _;
	csc123ligdash U+200B d0 dd dd dd dd dd U+200B > @1 U+200B @4 @5 @6 @7 @8 U+200B / ^_ _ _ _ _ _ _ _ _;
	csc123ligdash U+200B d0 dd dd dd dd dd dd U+200B > @1 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_ _ _ _ _ _ _ _ _ _;
	csc123ligdash U+200B d0 dd dd dd dd dd dd dd U+200B > @1 U+200B @4 @5 @6 @7 @8 @9 @10 U+200B / ^_ _ _ _ _ _ _ _ _ _ _;
	csc123ligdash U+200B d0 dd dd dd dd dd dd dd dd U+200B > @1 U+200B @4 @5 @6 @7 @8 @9 @10 @11 U+200B / ^_ _ _ _ _ _ _ _ _ _ _ _;

	U+200B d0 U+200B > _ / ^_ _ _ ;
	U+200B d0 d0 U+200B > U+200B / ^_ _ _ _;
	U+200B d0 dd U+200B > U+200B @3 U+200B / ^_ _ _ _;
	U+200B d0 dd dd U+200B > U+200B @3 @4 U+200B / ^_ _ _ _ _;
	U+200B d0 dd dd dd U+200B > U+200B @3 @4 @5 U+200B / ^_ _ _ _ _ _;
	U+200B d0 dd dd dd dd U+200B > U+200B @3 @4 @5 @6 U+200B / ^_ _ _ _ _ _ _;
	U+200B d0 dd dd dd dd dd U+200B > U+200B @3 @4 @5 @6 @7 U+200B / ^_ _ _ _ _ _ _ _;
	U+200B d0 dd dd dd dd dd dd U+200B > U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_ _ _ _ _ _ _ _ _;
	U+200B d0 dd dd dd dd dd dd dd U+200B > U+200B @3 @4 @5 @6 @7 @8 @9 U+200B / ^_ _ _ _ _ _ _ _ _ _;
	U+200B d0 dd dd dd dd dd dd dd dd U+200B > U+200B @3 @4 @5 @6 @7 @8 @9 @10 U+200B / ^_ _ _ _ _ _ _ _ _ _ _;

	// optional space
	U+003A U+003A d0 U+200B > U+200B / ^_ _ _ _;
	U+003A U+003A dd U+200B > U+0020 U+200B / ^_ _ _ _;
	U+003A U+003A d0 d0 U+200B > U+200B / ^_ _ _ _ _;
	U+003A U+003A dd dd U+200B > U+0020 U+200B / ^_ _ _ _ _;
	U+003A U+003A d0 d0 d0 U+200B > U+200B / ^_ _ _ _ _ _;
	U+003A U+003A dd dd dd U+200B > U+0020 U+200B / ^_ _ _ _ _ _;
	U+003A U+003A d0 d0 d0 d0 d0 d0 U+200B > U+200B / ^_ _ _ _ _ _ _ _ _;
	U+003A U+003A dd dd dd dd dd dd U+200B > U+0020 U+200B / ^_ _ _ _ _ _ _ _ _;

// Hungarian numerals
if (numt > 0 && lng == HUN)

	if (arti)
	U+200B U+200B (d1, d5) U+200B > p("a") p("z") U+0020 U+200B @3 U+200B / ^_ _ _ _;
	U+200B U+200B dd U+200B > p("a") U+0020 U+200B @3 U+200B / ^_ _ _ _;
	U+200B U+200B d5 dd U+200B > p("a") p("z") U+0020 U+200B @3 @4 U+200B / ^_ _ _ _ _;
	U+200B U+200B dd dd U+200B > p("a") U+0020 U+200B @3 @4 U+200B / ^_ _ _ _ _;
	U+200B U+200B d5 dd dd U+200B > p("a") p("z") U+0020 U+200B @3 @4 @5 U+200B / ^_ _ _ _ _ _;
	U+200B U+200B dd dd dd U+200B > p("a") U+0020 U+200B @3 @4 @5 U+200B / ^_ _ _ _ _ _;
	U+200B U+200B (d1, d5) dd dd dd U+200B > p("a") p("z") U+0020 U+200B @3 @4 @5 @6 U+200B / ^_ _ _ _ _ _ _;
	U+200B U+200B dd dd dd dd U+200B > p("a") U+0020 U+200B @3 @4 @5 @6 U+200B / ^_ _ _ _ _ _ _;
	U+200B U+200B d5 dd dd dd dd U+200B > p("a") p("z") U+0020 U+200B @3 @4 @5 @6 @7 U+200B / ^_ _ _ _ _ _ _ _;
	U+200B U+200B dd dd dd dd dd U+200B > p("a") U+0020 U+200B @3 @4 @5 @6 @7 U+200B / ^_ _ _ _ _ _ _ _;
	U+200B U+200B d5 dd dd dd dd dd U+200B > p("a") p("z") U+0020 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_ _ _ _ _ _ _ _ _;
	U+200B U+200B dd dd dd dd dd dd U+200B > p("a") U+0020 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_ _ _ _ _ _ _ _ _;
	U+200B U+200B (d1, d5) dd dd dd dd dd dd U+200B > p("a") p("z") U+0020 U+200B @3 @4 @5 @6 @7 @8 @9 U+200B / ^_ _ _ _ _ _ _ _ _ _;
	U+200B U+200B dd dd dd dd dd dd dd U+200B > p("a") U+0020 U+200B @3 @4 @5 @6 @7 @8 @9 U+200B / ^_ _ _ _ _ _ _ _ _ _;
	U+200B U+200B d5 dd dd dd dd dd dd dd U+200B > p("a") p("z") U+0020 U+200B @3 @4 @5 @6 @7 @8 @9 @10 U+200B / ^_ _ _ _ _ _ _ _ _ _ _;
	U+200B U+200B dd dd dd dd dd dd dd dd U+200B > p("a") U+0020 U+200B @3 @4 @5 @6 @7 @8 @9 @10 U+200B / ^_ _ _ _ _ _ _ _ _ _ _;
	U+200B U+200B d5 dd dd dd dd dd dd dd dd U+200B > p("a") p("z") U+0020 U+200B @3 @4 @5 @6 @7 @8 @9 @10 @11 U+200B / ^_ _ _ _ _ _ _ _ _ _ _ _;
	U+200B U+200B dd dd dd dd dd dd dd dd dd U+200B > p("a") U+0020 U+200B @3 @4 @5 @6 @7 @8 @9 @10 @11 U+200B / ^_ _ _ _ _ _ _ _ _ _ _ _;
	endif;

if (numt == 2 && lng == HUN)
	U+200B d0 U+200B U+200B > p("n") p("u") p("l") p("l") p("a") p("d") p("i") p("k") / ^_ _ _ _;
	csc123ligdash U+200B d1 U+200B U+200B > @1 p("e") p("g") p("y") p("e") p("d") p("i") p("k") / ^_ _ _ _ _;
	U+200B d1 U+200B U+200B > p("e") p("l") p("s") U+0151 / ^_ _ _ _;
	U+200B d2 U+200B U+200B > p("m") U+00E1 p("s") p("o") p("d") p("i") p("k") / ^_ _ _ _;
	csc123ligdash U+200B d2 U+200B U+200B > @1 p("k") p("e") p("t") p("t") p("e") p("d") p("i") p("k")  / ^_ _ _ _ _;
	U+200B d3 U+200B U+200B > p("h") p("a") p("r") p("m") p("a") p("d") p("i") p("k") / ^_ _ _ _;
	U+200B d4 U+200B U+200B > p("n") p("e") p("g") p("y") p("e") p("d") p("i") p("k") / ^_ _ _ _;
	U+200B d5 U+200B U+200B > U+00F6 p("t") U+00F6 p("d") p("i") p("k") / ^_ _ _ _;
	U+200B d6 U+200B U+200B > p("h") p("a") p("t") p("o") p("d") p("i") p("k") / ^_ _ _ _;
	U+200B d7 U+200B U+200B > p("h") p("e") p("t") p("e") p("d") p("i") p("k") / ^_ _ _ _;
	U+200B d8 U+200B U+200B > p("n") p("y") p("o") p("l") p("c") p("a") p("d") p("i") p("k") / ^_ _ _ _;
	U+200B d9 U+200B U+200B > p("k") p("i") p("l") p("e") p("n") p("c") p("e") p("d") p("i") p("k") / ^_ _ _ _;
	U+200B d1 d0 U+200B U+200B > p("t") p("i") p("z") p("e") p("d") p("i") p("k") / ^_ _ _ _ _;
	U+200B d2 d0 U+200B U+200B > p("h") p("u") p("s") p("z") p("a") p("d") p("i") p("k") / ^_ _ _ _ _;
	U+200B (d3, d6, d8) d0 U+200B U+200B > U+200B @2 @3 U+200B p("a") p("d") p("i") p("k") / ^_ _ _ _ _;
	U+200B dx d0 U+200B U+200B > U+200B @2 @3 U+200B p("e") p("d") p("i") p("k") / ^_ _ _ _ _;
	U+200B dx d0 d0 U+200B U+200B > U+200B @2 @3 @4 U+200B p("a") p("d") p("i") p("k") / ^_ _ _ _ _ _;
	U+200B d1 d0 d0 d0 U+200B U+200B > p("e") p("z") p("r") p("e") p("d") p("i") p("k") / ^_ _ _ _ _ _ _;
	U+200B dx d0 d0 d0 U+200B U+200B > U+200B @2 U+200B p("e") p("z") p("r") p("e") p("d") p("i") p("k") / ^_ _ _ _ _ _ _;
	U+200B dx dd d0 d0 d0 U+200B U+200B > U+200B @2 @3 U+200B p("e") p("z") p("r") p("e") p("d") p("i") p("k") / ^_ _ _ _ _ _ _ _;
	U+200B dx dd dd d0 d0 d0 U+200B U+200B > U+200B @2 @3 @4 U+200B p("e") p("z") p("r") p("e") p("d") p("i") p("k") / ^_ _ _ _ _ _ _ _ _;
endif;

	U+200B d0 U+200B U+200B > p("n") p("u") p("l") p("l") p("a") / ^_ _ _ _;
	U+200B d1 U+200B > p("e") p("g") p("y") / ^_ _ _;
	U+200B d2 U+200B U+200B > p("k") p("e") p("t") p("t") U+0151 / ^_ _ _ _;
	U+200B d2 U+200B > p("k") U+00E9 p("t") / ^_ _ _;
	U+200B d3 U+200B > p("h") U+00E1 p("r") p("o") p("m") / ^_ _ _;
	U+200B d4 U+200B > p("n") U+00E9 p("g") p("y") / ^_ _ _;
	U+200B d5 U+200B > U+00F6 p("t") / ^_ _ _;
	U+200B d6 U+200B > p("h") p("a") p("t") / ^_ _ _;
	U+200B d7 U+200B > p("h") U+00E9 p("t") / ^_ _ _;
	U+200B d8 U+200B > p("n") p("y") p("o") p("l") p("c") / ^_ _ _;
	U+200B d9 U+200B > p("k") p("i") p("l") p("e") p("n") p("c") / ^_ _ _;

	U+200B d1 d0 U+200B > p("t") U+00ED p("z") / ^_ _ _ _;
	U+200B d1 dx U+200B > p("t") p("i") p("z") p("e") p("n") U+200B @3 U+200B / ^_ _ _ _;
	U+200B d2 d0 U+200B > p("h") U+00FA p("s") p("z") / ^_ _ _ _;
	U+200B d2 dx U+200B > p("h") p("u") p("s") p("z") p("o") p("n") U+200B @3 U+200B / ^_ _ _ _;
	U+200B d3 d0 U+200B > p("h") p("a") p("r") p("m") p("i") p("n") p("c") U+200B / ^_ _ _ _;
	U+200B d4 d0 U+200B > p("n") p("e") p("g") p("y") p("v") p("e") p("n") U+200B / ^_ _ _ _;
	U+200B (d5, d9) d0 U+200B > U+200B @2 U+200B p("v") p("e") p("n") U+200B / ^_ _ _ _;
	U+200B (d6, d8) d0 U+200B > U+200B @2 U+200B p("v") p("a") p("n") U+200B / ^_ _ _ _;
	U+200B d7 d0 U+200B > p("h") p("e") p("t") p("v") p("e") p("n") U+200B / ^_ _;
	U+200B dx dx U+200B > U+200B @2 d0 U+200B @3 U+200B / ^_;

	// separator
	U+003A d0 d0 d0 U+200B > _ _ _ _ U+200B;
	U+003A dd dd dd U+200B > _ _ _ _ U+002D U+200B;
	U+003A d0 d0 d0 d0 d0 d0 U+200B > _ _ _ _ _ _ _ U+200B;
	U+003A dd dd dd dd dd dd U+200B > _ _ _ _ _ _ U+002D U+200B;
	U+003A d0 d0 d0 d0 d0 d0 d0 d0 d0 U+200B > _ _ _ _ _ _ _ _ _ _ U+200B;
	U+003A dd dd dd dd dd dd dd dd dd U+200B > _ _ _ _ _ _ _ _ _ U+002D U+200B;

	U+200B d1 dd dd U+200B > p("s") p("z") U+00E1 p("z") U+200B @3 @4 U+200B / ^_ _ _ _ _;
	U+200B dx dd dd U+200B > U+200B @2 U+200B p("s") p("z") U+00E1 p("z") U+200B @3 @4 U+200B / ^_ _ _ _ _;
	U+200B d1 dd dd dd U+200B > p("e") p("z") p("e") p("r") U+200B @3 @4 @5 U+200B / ^_ _ _ _ _ _;
	U+200B dx d0 d0 d0 U+200B > U+200B @2 U+200B p("e") p("z") p("e") p("r") / ^_ _ _ _ _ _;
	U+200B dx dd dd dd U+200B > U+200B @2 U+200B p("e") p("z") p("e") p("r") U+002D U+200B @3 @4 @5 U+200B / ^_ _ _ _ _ _;
	U+200B dx dd d0 d0 d0 U+200B > U+200B @2 @3 U+200B p("e") p("z") p("e") p("r") / ^_ _ _ _ _ _ _;
	U+200B dx dd dd dd dd U+200B > U+200B @2 @3 U+200B p("e") p("z") p("e") p("r") U+002D U+200B @4 @5 @6 U+200B / ^_ _ _ _ _ _ _;
	U+200B dx dd dd d0 d0 d0 U+200B > U+200B @2 @3 @4 U+200B p("e") p("z") p("e") p("r") / ^_ _ _ _ _ _ _ _;
	U+200B dx dd dd dd dd dd U+200B > U+200B @2 @3 @4 U+200B p("e") p("z") p("e") p("r") U+002D U+200B @5 @6 @7 U+200B / ^_ _ _ _ _ _ _ _;
	U+200B dx d0 d0 d0 d0 d0 d0 U+200B > U+200B @2 U+200B p("m") p("i") p("l") p("l") p("i") U+00F3 / ^_ _ _ _ _ _ _ _ _;
	U+200B dx dd dd dd dd dd dd U+200B > U+200B @2 U+200B p("m") p("i") p("l") p("l") p("i") U+00F3 U+002D U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_ _ _ _ _ _ _ _ _;
	U+200B dx dd d0 d0 d0 d0 d0 d0 U+200B > U+200B @2 @3 U+200B p("m") p("i") p("l") p("l") p("i") U+00F3 / ^_ _ _ _ _ _ _ _ _ _;
	U+200B dx dd dd dd dd dd dd dd U+200B > U+200B @2 @3 U+200B p("m") p("i") p("l") p("l") p("i") U+00F3 U+002D U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_ _ _ _ _ _ _ _ _ _;
//	U+200B dx dd dd d0 d0 d0 d0 d0 d0 U+200B > U+200B @2 @3 @4 U+200B p("m") p("i") p("l") p("l") p("i") U+00F3 / ^_ _ _ _ _ _ _ _ _ _;
	U+200B dx dd dd dd dd dd dd dd dd U+200B > U+200B @2 @3 @4 U+200B p("m") p("i") p("l") p("l") p("i") U+00F3 U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_ _ _ _ _ _ _ _ _ _;
	U+200B dx dd dd dd dd dd dd dd dd dd U+200B > U+200B @2 U+200B p("m") p("i") p("l") p("l") p("i") U+00E1 p("r") p("d") U+003A @3 @4 @5 @6 @7 @8 @9 @10 @11 U+200B @3 @4 @5 @6 @7 @8 @9 @10 @11 U+200B / ^_ _ _ _ _ _ _ _ _ _;
	U+200B dx dd dd dd dd dd dd dd dd dd dd U+200B > U+200B @2 @3 U+200B p("m") p("i") p("l") p("l") p("i") U+00E1 p("r") p("d") U+003A @4 @5 @6 @7 @8 @9 @10 @11 @12 U+200B @4 @5 @6 @7 @8 @9 @10 @11 @12 U+200B / ^_ _ _ _ _ _ _ _ _ _ _;
	U+200B dx dd dd dd dd dd dd dd dd dd dd dd U+200B > U+200B @2 @3 @4 U+200B p("m") p("i") p("l") p("l") p("i") U+00E1 p("r") p("d") U+003A @4 @5 @6 @7 @8 @9 @10 @11 @12 U+200B @4 @5 @6 @7 @8 @9 @10 @11 @12 U+200B / ^_ _ _ _ _ _ _ _ _ _ _ _;

endif;
// English numerals
if (numt > 0 && lng == ENG)

if (numt == 2)
	U+200B d0 U+200B U+200B > p("z") p("e") p("r") p("o") p("t") p("h") / ^_ _ _;
	U+200B d1 U+200B U+200B > p("f") p("i") p("r") p("s") p("t") / ^_ _ _;
	U+200B d2 U+200B U+200B > p("s") p("e") p("c") p("o") p("n") p("d") / ^_ _ _ _;
	U+200B d3 U+200B U+200B > p("t") p("h") p("i") p("r") p("d") / ^_ _ _ _;
	U+200B d5 U+200B U+200B > p("f") p("i") p("f") p("t") p("h") / ^_ _ _ _;
	U+200B d8 U+200B U+200B > U+200B d8 U+200B p("h") / ^_ _ _ _;
	U+200B d9 U+200B U+200B > p("n") p("i") p("n") p("t") p("h") / ^_ _ _ _;
	U+200B dd U+200B U+200B > U+200B @2 U+200B p("t") p("h") / ^_ _ _ _;
	U+200B d1 d2 U+200B U+200B > p("t") p("w") p("e") p("l") p("f") p("t") p("h") / ^_ _ _ _ _;
	U+200B dx d0 d0 U+200B U+200B > U+200B @2 @3 @4 U+200B p("t") p("h") / ^_ _ _ _ _;
	d0 d0 d0 U+200B U+200B > @1 @2 @3 U+200B p("t") p("h") / ^_ _ _ _ _;
	U+200B d1 dd U+200B U+200B > U+200B @2 @3 U+200B p("t") p("h") / ^_ _ _ _ _;
	p("y") U+200B U+200B > p("i") p("e") p("t") p("h") / ^_ _ _;
endif;

	U+200B d0 U+200B U+200B > p("z") p("e") p("r") p("o") / ^_ _ _;
	U+200B d1 U+200B > p("o") p("n") p("e") / ^_ _ _;
	U+200B d2 U+200B > p("t") p("w") p("o") / ^_ _ _;
	U+200B d3 U+200B > p("t") p("h") p("r") p("e") p("e") / ^_ _ _;
	U+200B d4 U+200B > p("f") p("o") p("u") p("r") / ^_ _ _;
	U+200B d5 U+200B > p("f") p("i") p("v") p("e") / ^_ _ _;
	U+200B d6 U+200B > p("s") p("i") p("x") / ^_ _ _;
	U+200B d7 U+200B > p("s") p("e") p("v") p("e") p("n") / ^_ _ _;
	U+200B d8 U+200B > p("e") p("i") p("g") p("h") p("t") / ^_ _ _;
	U+200B d9 U+200B > p("n") p("i") p("n") p("e") / ^_ _ _;
	U+200B d1 d0 U+200B > p("t") p("e") p("n") / ^_ _ _ _;
	U+200B d1 d1 U+200B > p("e") p("l") p("e") p("v") p("e") p("n") / ^_ _ _ _;
	U+200B d1 d2 U+200B > p("t") p("w") p("e") p("l") p("v") p("e") / ^_ _ _ _;
	U+200B d1 d3 U+200B > p("t") p("h") p("i") p("r") p("t") p("e") p("e") p("n") / ^_ _ _ _;
	U+200B d1 d5 U+200B > p("f") p("i") p("f") p("t") p("e") p("e") p("n") / ^_ _ _ _;
	U+200B d1 d8 U+200B > U+200B @3 U+200B p("e") p("e") p("n") / ^_ _ _ _;
	U+200B d1 dx U+200B > U+200B @3 U+200B p("t") p("e") p("e") p("n") / ^_ _ _ _;
	U+200B d2 d0 U+200B > p("t") p("w") p("e") p("n") p("t") p("y") U+200B / ^_ _ _ _;
	U+200B d3 d0 U+200B > p("t") p("h") p("i") p("r") p("t") p("y") U+200B / ^_ _ _ _;
	U+200B d4 d0 U+200B > p("f") p("o") p("r") p("t") p("y") U+200B / ^_ _ _ _;
	U+200B d5 d0 U+200B > p("f") p("i") p("f") p("t") p("y") U+200B / ^_ _ _ _;
	U+200B d8 d0 U+200B > U+200B d8 U+200B p("y") U+200B / ^_ _ _ _;
	U+200B dx d0 U+200B > U+200B @2 U+200B p("t") p("y") U+200B / ^_ _ _ _;
	U+200B dx dx U+200B > U+200B @2 d0 U+200B U+002D U+200B @3 U+200B / ^_ _ _ _;

	// separator
	U+003A d0 d0 U+200B > _ _ _ U+200B; // one million
	if (vari == 0) 
	U+003A dd dd U+200B > U+0020 p("a") p("n") p("d") U+0020 U+200B / ^_ _ _ _; // one million and one
	U+003A d0 d0 d0 U+200B > _ _ _ _ U+200B; // one million
	U+003A d0 dd dd U+200B > U+0020 p("a") p("n") p("d") U+0020 U+200B / ^_ _ _ _ _; // one million and ten
	U+003A dd dd dd U+200B > _ _ U+002C U+0020 U+200B; // one million, one thousand
	else
	U+003A dd dd U+200B > _ _ U+0020 U+200B;
	U+003A dd dd dd U+200B > _ _ _ U+0020 U+200B; // Two Thousand Ten
	endif;

	U+200B dx dd dd U+200B > U+200B @2 U+200B U+0020 p("h") p("u") p("n") p("d") p("r") p("e") p("d") U+003A @3 @4 U+200B @3 @4 U+200B / ^_ _ _ _ _;
	U+200B dx dx dd dd U+200B > U+200B @2 U+200B U+0020 p("t") p("h") p("o") p("u") p("s") p("a") p("n") p("d") U+0020 U+200B @3 @4 @5 U+200B / ^_ _ _ _ _ _;
	U+200B dx dd dd dd U+200B > U+200B @2 U+200B U+0020 p("t") p("h") p("o") p("u") p("s") p("a") p("n") p("d") U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_ _ _ _ _ _;
	U+200B dx dd dx dd dd U+200B > U+200B @2 @3 U+200B U+0020 p("t") p("h") p("o") p("u") p("s") p("a") p("n") p("d") U+0020 U+200B @4 @5 @6 U+200B / ^_ _ _ _ _ _ _;
	U+200B dx dd dd dd dd U+200B > U+200B @2 @3 U+200B U+0020 p("t") p("h") p("o") p("u") p("s") p("a") p("n") p("d") U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_ _ _ _ _ _ _;
	U+200B dx dd dd dd dd dd U+200B > U+200B @2 @3 @4 U+200B U+0020 p("t") p("h") p("o") p("u") p("s") p("a") p("n") p("d") U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_ _ _ _ _ _ _;

	U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("l") p("i") p("o") p("n") U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
	U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l") p("l") p("i") p("o") p("n")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
	U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l") p("l") p("i") p("o") p("n")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;

endif;
// German numerals
if (numt > 0 && lng == DEU)

	U+200B d1 U+200B > p("e") p("i") p("n") / ^_ _ _ csc123ligdash;

if (numt == 2)
	U+200B d0 U+200B U+200B > p("n") p("u") p("l") p("l") p("t") p("e") / ^_ _ _ _;
	U+200B d1 U+200B U+200B > p("e") p("r") p("s") p("t") p("e") / ^_ _ _ _;
	U+200B d3 U+200B U+200B > p("d") p("r") p("i") p("t") p("t") p("e") / ^_ _ _ _;
	U+200B d7 U+200B U+200B > p("s") p("i") p("e") p("b") p("t") p("e") / ^_ _ _ _;
	U+200B d8 U+200B U+200B > p("a") p("c") p("h") p("t") p("e") / ^_ _ _ _;
	U+200B dx U+200B U+200B > U+200B @2 U+200B p("t") p("e") / ^_ _ _ _;

	U+200B d1 dd U+200B U+200B > U+200B @2 @3 U+200B p("t") p("e") / ^_ _ _ _ _;
	U+200B dx dd U+200B U+200B > U+200B @2 @3 U+200B p("s") p("t") p("e") / ^_ _ _ _ _;
	U+200B dx d0 d0 U+200B U+200B > U+200B @2 @3 @4 U+200B p("t") p("e") / ^_ _ _ _ _ _;
	U+200B dx d0 d0 d0 U+200B U+200B > U+200B @2 @3 @4 @5 U+200B p("t") p("e") / ^_ _ _ _ _ _ _;
	U+200B dd dd d0 d0 d0 U+200B U+200B > U+200B @2 @3 @4 @5 @6 U+200B p("t") p("e") / ^_ _ _ _ _ _ _ _;
	U+200B dd dd dd d0 d0 d0 U+200B U+200B > U+200B @2 @3 @4 @5 @6 @7 U+200B p("t") p("e") / ^_ _ _ _ _ _ _ _ _;
endif;

	U+200B d0 U+200B U+200B > p("n") p("u") p("l") p("l") / ^_ _ _ _;

	U+200B d1 U+200B > p("e") p("i") p("n") p("s") / ^_ _ _;

	U+200B d2 U+200B > p("z") p("w") p("e") p("i") / ^_ _ _;
	U+200B d3 U+200B > p("d") p("r") p("e") p("i") / ^_ _ _;
	U+200B d4 U+200B > p("v") p("i") p("e") p("r") / ^_ _ _;
	U+200B d5 U+200B > p("f") U+00FC p("n") p("f") / ^_ _ _;
	U+200B d6 U+200B > p("s") p("e") p("c") p("h") p("s") / ^_ _ _;
	U+200B d7 U+200B > p("s") p("i") p("e") p("b") p("e") p("n") / ^_ _ _;
	U+200B d8 U+200B > p("a") p("c") p("h") p("t") / ^_ _ _;
	U+200B d9 U+200B > p("n") p("e") p("u") p("n") / ^_ _ _;

	U+200B d1 d0 U+200B > p("z") p("e") p("h") p("n") / ^_ _ _ _;
	U+200B d1 d1 U+200B > p("e") p("l") p("f") / ^_ _ _ _;
	U+200B d1 d2 U+200B > p("z") p("w") U+00f6 p("l") p("f") / ^_ _ _ _;
	U+200B d1 d6 U+200B > p("s") p("e") p("c") p("h") p("z") p("e") p("h") p("n") / ^_ _ _ _;
	U+200B d1 d7 U+200B > p("s") p("i") p("e") p("b") p("z") p("e") p("h") p("n") / ^_ _ _ _;
	U+200B d1 dd U+200B > U+200B @3 U+200B p("z") p("e") p("h") p("n") / ^_ _ _ _;

	U+200B d2 d0 U+200B > p("z") p("w") p("a") p("n") p("z") p("i") p("g") / ^_ _ _ _;
	U+200B d3 d0 U+200B > p("d") p("r") p("e") p("i") U+00DF p("i") p("g") / ^_ _ _ _;
	U+200B d6 d0 U+200B > p("s") p("e") p("c") p("h") p("z") p("i") p("g") / ^_ _ _ _;
	U+200B d7 d0 U+200B > p("s") p("i") p("e") p("b") p("z") p("i") p("g") / ^_ _ _ _;
	U+200B dx d0 U+200B > U+200B @2 U+200B p("z") p("i") p("g") / ^_ _ _ _;

	U+200B dd dd U+200B > U+200B @3 U+200B p("u") p("n") p("d") U+200B @2 d0 U+200B / ^_ _ _ _;

	U+200B dx dd dd U+200B > U+200B @2 U+200B p("h") p("u") p("n") p("d") p("e") p("r") p("t") U+200B @3 @4 U+200B / ^_ _ _ _ _;
	U+200B dd dd dd dd U+200B > U+200B @2 U+200B p("t") p("a") p("u") p("s") p("e") p("n") p("d") U+200B @3 @4 @5 U+200B / ^_ _ _ _ _;
	U+200B dd dd dd dd dd U+200B > U+200B @2 @3 U+200B p("t") p("a") p("u") p("s") p("e") p("n") p("d") U+200B @4 @5 @6 U+200B / ^_ _ _ _ _ _;
	U+200B dd dd dd dd dd dd U+200B > U+200B @2 @3 @4 U+200B p("t") p("a") p("u") p("s") p("e") p("n") p("d") U+200B @5 @6 @7 U+200B / ^_ _ _ _ _ _;

	U+200B d1 dd dd dd dd dd dd U+200B > p("e") p("i") p("n") p("e")  U+0020 p("M") p("i") p("l") p("l") p("i") p("o") p("n")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
	U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("M") p("i") p("l") p("l") p("i") p("o") p("n") p("e") p("n")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
	U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("M") p("i") p("l") p("l") p("i") p("o") p("n") p("e") p("n")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
	U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("M") p("i") p("l") p("l") p("i") p("o") p("n") p("e") p("n")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;

endif;

	// boundary signs (first step to number handling)
	dd > U+200B U+200B @1 U+200B U+200B / ^_;
	dd dd  > U+200B U+200B @1 @2 U+200B U+200B / ^_ _;
	dd dd dd  > U+200B U+200B @1 @2 @3 U+200B U+200B / ^_ _ _;
	dd dd dd dd  > U+200B U+200B @1 @2 @3 @4 U+200B U+200B / ^_ _ _ _;
	dd dd dd dd dd  > U+200B U+200B @1 @2 @3 @4 @5 U+200B U+200B / ^_ _ _ _ _;
	dd dd dd dd dd dd  > U+200B U+200B @1 @2 @3 @4 @5 @6 U+200B U+200B / ^_ _ _ _ _ _;
	dd dd dd dd dd dd dd  > U+200B U+200B @1 @2 @3 @4 @5 @6 @7 U+200B U+200B / ^_ _ _ _ _ _ _;
	dd dd dd dd dd dd dd dd  > U+200B U+200B @1 @2 @3 @4 @5 @6 @7 @8 U+200B U+200B / ^_ _ _ _ _ _ _ _;
	dd dd dd dd dd dd dd dd dd  > U+200B U+200B @1 @2 @3 @4 @5 @6 @7 @8 @9 U+200B U+200B / ^_ _ _ _ _ _ _ _ _;
	dd dd dd dd dd dd dd dd dd dd > U+200B U+200B @1 @2 @3 @4 @5 @6 @7 @8 @9 @10 U+200B U+200B / ^_ _ _ _ _ _ _ _ _ _;
	dd dd dd dd dd dd dd dd dd dd dd > U+200B U+200B @1 @2 @3 @4 @5 @6 @7 @8 @9 @10 @11 U+200B U+200B / ^_ _ _ _ _ _ _ _ _ _ _;
	dd dd dd dd dd dd dd dd dd dd dd dd > U+200B U+200B @1 @2 @3 @4 @5 @6 @7 @8 @9 @10 @11 @12 U+200B U+200B / ^_ _ _ _ _ _ _ _ _ _ _ _;
endif;
	

if (numt == 1 && lng == AFK)

U+200B U+200B d0 U+200B U+200B > p("n") p("u") p("l") / ^_  _  _  _  _  ;
U+200B d1  U+200B > p("e") p("e") p("n") / ^_  _   _  ;
U+200B d2  U+200B > p("t") p("w") p("e") p("e") / ^_  _   _  ;
U+200B d3  U+200B > p("d") p("r") p("i") p("e") / ^_  _   _  ;
U+200B d4  U+200B > p("v") p("i") p("e") p("r") / ^_  _   _  ;
U+200B d5  U+200B > p("v") p("y") p("f") / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("e") p("s") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("e") p("w") p("e") / ^_  _   _  ;
U+200B d8  U+200B > p("a") p("g") p("t") / ^_  _   _  ;
U+200B d9  U+200B > p("n") p("e") p("g") p("e") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("t") p("i") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("e") p("l") p("f") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("t") p("w") p("a") p("a") p("l") p("f") / ^_  _  _   _  ;
U+200B d1 d3  U+200B > p("d") p("e") p("r") p("t") p("i") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("v") p("e") p("e") p("r") p("t") p("i") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d7  U+200B > p("s") p("e") p("w") p("e") p("n") p("t") p("i") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d9  U+200B > p("n") p("e") p("g") p("e") p("n") p("t") p("i") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+200B @3 U+200B   U+200B p("t") p("i") p("e") p("n") / ^_  _  _   _  ;
U+200B d2 d0  U+200B > p("t") p("w") p("i") p("n") p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B d3 d0  U+200B > p("d") p("e") p("r") p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B d4 d0  U+200B > p("v") p("e") p("e") p("r") p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B d7 d0  U+200B > p("s") p("e") p("w") p("e") p("n") p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B d8 d0  U+200B > p("t") p("a") p("g") p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B d9 d0  U+200B > p("n") p("e") p("g") p("e") p("n") p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B dx d0  U+200B >  U+200B @2 U+200B  p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @3 U+200B   U+002D p("e") p("n")  U+002D U+200B  @2  d0 U+200B / ^_  _  _   _  ;
endif;
if (numt == 1 && lng == CAT)

U+200B U+200B d0  U+200B > p("z") p("e") p("r") p("o") / ^_  _  _   _  ;
U+200B d1 U+200B U+200B > p("u") / ^_  _  _  _  ;
U+200B d1  U+200B > p("u") p("n") / ^_  _   _  ;
U+200B d2  U+200B > p("d") p("o") p("s") / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r") p("e") p("s") / ^_  _   _  ;
U+200B d4  U+200B > p("q") p("u") p("a") p("t") p("r") p("e") / ^_  _   _  ;
U+200B d5  U+200B > p("c") p("i") p("n") p("c") / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("i") p("s") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("e") p("t") / ^_  _   _  ;
U+200B d8  U+200B > p("v") p("u") p("i") p("t") / ^_  _   _  ;
U+200B d9  U+200B > p("n") p("o") p("u") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("d") p("e") p("u") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("o") p("n") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("d") p("o") p("t") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d3  U+200B > p("t") p("r") p("e") p("t") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("c") p("a") p("t") p("o") p("r") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d5  U+200B > p("q") p("u") p("i") p("n") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d6  U+200B > p("s") p("e") p("t") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d7  U+200B > p("d") p("i") p("s") p("s") p("e") p("t") / ^_  _  _   _  ;
U+200B d1 dd  U+200B > p("d") p("i")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d2 d0  U+200B > p("v") p("i") p("n") p("t") / ^_  _  _   _  ;
U+200B d2 dd  U+200B > p("v") p("i") p("n") p("t")  U+002D p("i")  U+002D  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d3 d0  U+200B > p("t") p("r") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d4 d0  U+200B > p("q") p("u") p("a") p("r") p("a") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d5 d0  U+200B > p("c") p("i") p("n") p("q") p("u") p("a") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d6 d0  U+200B > p("s") p("e") p("i") p("x") p("a") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d7 d0  U+200B > p("s") p("e") p("t") p("a") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d8 d0  U+200B > p("v") p("u") p("i") p("t") p("a") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d9 d0  U+200B > p("n") p("o") p("r") p("a") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B dx dd  U+200B > U+200B  @2  d0 U+200B  U+002D  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("c") p("e") p("n") p("t")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B   U+002D p("c") p("e") p("n") p("t") p("s")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B > p("m") p("i") p("l")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B d1 dd dd dd dd dd dd U+200B > p("u") p("n")  U+0020 p("m") p("i") p("l") p("i")  U+00F3  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("s")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("s")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("s")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == CSY)

U+200B U+200B d0  U+200B > p("n") p("u") p("l") p("a") / ^_  _  _   _  ;
U+200B U+200B d1 U+200B U+200B > p("j") p("e") p("d") p("n") p("o") / ^_  _  _  _  _  ;
U+200B d1  U+200B > p("j") p("e") p("d") p("e") p("n") / ^_  _   _  ;
U+200B U+200B d2 U+200B U+200B > p("d") p("v")  U+011B / ^_  _  _  _  _  ;
U+200B d2  U+200B > p("d") p("v") p("a") / ^_  _   _  ;
U+200B d3  U+200B > p("t")  U+0159 p("i") / ^_  _   _  ;
U+200B d4  U+200B >  U+010D p("t") p("y")  U+0159 p("i") / ^_  _   _  ;
U+200B d5  U+200B > p("p")  U+011B p("t") / ^_  _   _  ;
U+200B d6  U+200B >  U+0161 p("e") p("s") p("t") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("e") p("d") p("m") / ^_  _   _  ;
U+200B d8  U+200B > p("o") p("s") p("m") / ^_  _   _  ;
U+200B d9  U+200B > p("d") p("e") p("v")  U+011B p("t") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("d") p("e") p("s") p("e") p("t") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("j") p("e") p("d") p("e") p("n")  U+00E1 p("c") p("t") / ^_  _  _   _  ;
U+200B d1 d4  U+200B >  U+010D p("t") p("r") p("n")  U+00E1 p("c") p("t") / ^_  _  _   _  ;
U+200B d1 d5  U+200B > p("p") p("a") p("t") p("n")  U+00E1 p("c") p("t") / ^_  _  _   _  ;
U+200B d1 d9  U+200B > p("d") p("e") p("v") p("a") p("t") p("e") p("n")  U+00E1 p("c") p("t") / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+200B @3 U+200B  p("n")  U+00E1 p("c") p("t") / ^_  _  _   _  ;
U+200B (d2,d3,d4) dd  U+200B >  U+200B @2 U+200B  p("c") p("e") p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d5 dd  U+200B > p("p") p("a") p("d") p("e") p("s")  U+00E1 p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d6 dd  U+200B >  U+0161 p("e") p("d") p("e") p("s")  U+00E1 p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d9 dd  U+200B > p("d") p("e") p("v") p("a") p("d") p("e") p("s")  U+00E1 p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @2 U+200B  p("d") p("e") p("s")  U+00E1 p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("s") p("t") p("o")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d2 dd  dd  U+200B > p("d") p("v")  U+011B  U+0020 p("s") p("t")  U+011B  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B (d3,d4) dd  dd  U+200B >  U+200B @2 U+200B   U+0020 p("s") p("t") p("a")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B   U+0020 p("s") p("e") p("t")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd  dd  dd  U+200B > p("t") p("i") p("s")  U+00ED p("c")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
U+200B (d2,d3,d4) dd  dd  dd  U+200B >  U+200B @2 U+200B   U+0020 p("t") p("i") p("s")  U+00ED p("c") p("e")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
U+200B dx dd  dd  dd  U+200B >  U+200B @2 U+200B   U+0020 p("t") p("i") p("s")  U+00ED p("c") p("e")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
U+200B dx dd dd  dd  dd  U+200B >  U+200B @2 @3 U+200B   U+0020 p("t") p("i") p("s")  U+00ED p("c") p("e")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _   _   _   _  ;
U+200B dx dd dd dd  dd  dd  U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("t") p("i") p("s")  U+00ED p("c") p("e")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _   _   _   _  ;
U+200B d1 dd dd dd dd dd dd U+200B > p("m") p("i") p("l") p("i") p("o") p("n")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B (d2,d3,d4) dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("y")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n")  U+016F  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n")  U+016F  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n")  U+016F  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == DAN)

U+200B U+200B d0  U+200B > p("n") p("u") p("l") / ^_  _  _   _  ;
U+200B d1 U+200B U+200B > p("e") p("n") / ^_  _  _  _  ;
U+200B d1  U+200B > p("e") p("t") / ^_  _   _  ;
U+200B d2  U+200B > p("t") p("o") / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r") p("e") / ^_  _   _  ;
U+200B d4  U+200B > p("f") p("i") p("r") p("e") / ^_  _   _  ;
U+200B d5  U+200B > p("f") p("e") p("m") / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("e") p("k") p("s") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("y") p("v") / ^_  _   _  ;
U+200B d8  U+200B > p("o") p("t") p("t") p("e") / ^_  _   _  ;
U+200B d9  U+200B > p("n") p("i") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("t") p("i") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("e") p("l") p("l") p("e") p("v") p("e") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("t") p("o") p("l") p("v") / ^_  _  _   _  ;
U+200B d1 d3  U+200B > p("t") p("r") p("e") p("t") p("t") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("f") p("j") p("o") p("r") p("t") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d5  U+200B > p("f") p("e") p("m") p("t") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d6  U+200B > p("s") p("e") p("k") p("s") p("t") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d7  U+200B > p("s") p("y") p("t") p("t") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d8  U+200B > p("a") p("t") p("t") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d9  U+200B > p("n") p("i") p("t") p("t") p("e") p("n")  U+0020 / ^_  _  _   _  ;
U+200B d2 d0  U+200B > p("t") p("y") p("v") p("e") / ^_  _  _   _  ;
U+200B d3 d0  U+200B > p("t") p("r") p("e") p("d") p("i") p("v") p("e") / ^_  _  _   _  ;
U+200B d4 d0  U+200B > p("f") p("y") p("r") p("r") p("e") / ^_  _  _   _  ;
U+200B d5 d0  U+200B > p("h") p("a") p("l") p("v") p("t") p("r") p("e") p("d") p("s") / ^_  _  _   _  ;
U+200B d6 d0  U+200B > p("t") p("r") p("e") p("s") / ^_  _  _   _  ;
U+200B d7 d0  U+200B > p("h") p("a") p("l") p("v") p("f") p("j") p("e") p("r") p("d") p("s") / ^_  _  _   _  ;
U+200B d8 d0  U+200B > p("f") p("i") p("r") p("s") / ^_  _  _   _  ;
U+200B d9 d0  U+200B > p("h") p("a") p("l") p("v") p("f") p("e") p("m") p("s") / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @3 U+200B   U+200B p("o") p("g") U+200B  @2  d0 U+200B / ^_  _  _   _  ;
endif;
if (numt == 1 && lng == ELL)

U+200B U+200B d0  U+200B >  U+03BC  U+03B7  U+03B4  U+03AD  U+03BD / ^_  _  _   _  ;
U+200B d1  U+200B >  U+03AD  U+03BD  U+03B1 / ^_  _   _  ;
U+200B d2  U+200B >  U+03B4  U+03CD  U+03BF / ^_  _   _  ;
U+200B d3 U+200B U+200B >  U+03C4  U+03C1  U+03AF  U+03B1 / ^_  _  _  _  ;
U+200B d3  U+200B >  U+03C4  U+03C1  U+03B5  U+03B9  U+03C2 / ^_  _   _  ;
U+200B d4 U+200B U+200B >  U+03C4  U+03AD  U+03C3  U+03C3  U+03B5  U+03C1  U+03B1 / ^_  _  _  _  ;
U+200B d4  U+200B >  U+03C4  U+03AD  U+03C3  U+03C3  U+03B5  U+03C1  U+03B9  U+03C2 / ^_  _   _  ;
U+200B d5  U+200B >  U+03C0  U+03AD  U+03BD  U+03C4  U+03B5 / ^_  _   _  ;
U+200B d6  U+200B >  U+03AD  U+03BE  U+03B9 / ^_  _   _  ;
U+200B d7  U+200B >  U+03B5  U+03C0  U+03C4  U+03AC / ^_  _   _  ;
U+200B d8  U+200B >  U+03BF  U+03BA  U+03C4  U+03CE / ^_  _   _  ;
U+200B d9  U+200B >  U+03B5  U+03BD  U+03BD  U+03AD  U+03B1 / ^_  _   _  ;
U+200B d1 d0  U+200B >  U+03B4  U+03AD  U+03BA  U+03B1 / ^_  _  _   _  ;
U+200B d1 d1  U+200B >  U+03AD  U+03BD  U+03C4  U+03B5  U+03BA  U+03B1 / ^_  _  _   _  ;
U+200B d1 d2  U+200B >  U+03B4  U+03CE  U+03B4  U+03B5  U+03BA  U+03B1 / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+03B4  U+03B5  U+03BA  U+03B1  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d2 dd  U+200B >  U+03B5  U+03AF  U+03BA  U+03BF  U+03C3  U+03B9  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d3 dd  U+200B >  U+03C4  U+03C1  U+03B9  U+03AC  U+03BD  U+03C4  U+03B1  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d4 dd  U+200B >  U+03C3  U+03B1  U+03C1  U+03AC  U+03BD  U+03C4  U+03B1  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d5 dd  U+200B >  U+03C0  U+03B5  U+03BD  U+03AE  U+03BD  U+03C4  U+03B1  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d6 dd  U+200B >  U+03B5  U+03BE  U+03AE  U+03BD  U+03C4  U+03B1  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d7 dd  U+200B >  U+03B5  U+03B2  U+03B4  U+03BF  U+03BC  U+03AE  U+03BD  U+03C4  U+03B1  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d8 dd  U+200B >  U+03BF  U+03B3  U+03B4  U+03CC  U+03BD  U+03C4  U+03B1  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d9 dd  U+200B >  U+03B5  U+03BD  U+03B5  U+03BD  U+03AE  U+03BD  U+03C4  U+03B1  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 d0 d0  U+200B >  U+03B5  U+03BA  U+03B1  U+03C4  U+03CC / ^_  _  _  _   _  ;
U+200B d1 dd  dd  U+200B >  U+03B5  U+03BA  U+03B1  U+03C4  U+03CC  U+03BD  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d2 dd  dd U+200B U+200B >  U+03B4  U+03B9  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B1  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _  _  _  ;
U+200B d2 dd  dd  U+200B >  U+03B4  U+03B9  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B5  U+03C2  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d3 dd  dd U+200B U+200B >  U+03C4  U+03C1  U+03B9  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B1  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _  _  _  ;
U+200B d3 dd  dd  U+200B >  U+03C4  U+03C1  U+03B9  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B5  U+03C2  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d4 dd  dd U+200B U+200B >  U+03C4  U+03B5  U+03C4  U+03C1  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B1  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _  _  _  ;
U+200B d4 dd  dd  U+200B >  U+03C4  U+03B5  U+03C4  U+03C1  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B5  U+03C2  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d5 dd  dd U+200B U+200B >  U+03C0  U+03B5  U+03BD  U+03C4  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B1  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _  _  _  ;
U+200B d5 dd  dd  U+200B >  U+03C0  U+03B5  U+03BD  U+03C4  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B5  U+03C2  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d6 dd  dd U+200B U+200B >  U+03B5  U+03BE  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B1  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _  _  _  ;
U+200B d6 dd  dd  U+200B >  U+03B5  U+03BE  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B5  U+03C2  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d7 dd  dd U+200B U+200B >  U+03B5  U+03C0  U+03C4  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B1  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _  _  _  ;
U+200B d7 dd  dd  U+200B >  U+03B5  U+03C0  U+03C4  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B5  U+03C2  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d8 dd  dd U+200B U+200B >  U+03BF  U+03BA  U+03C4  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B1  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _  _  _  ;
U+200B d8 dd  dd  U+200B >  U+03BF  U+03BA  U+03C4  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B5  U+03C2  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d9 dd  dd U+200B U+200B >  U+03B5  U+03BD  U+03BD  U+03B9  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B1  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _  _  _  ;
U+200B d9 dd  dd  U+200B >  U+03B5  U+03BD  U+03BD  U+03B9  U+03B1  U+03BA  U+03CC  U+03C3  U+03B9  U+03B5  U+03C2  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B >  U+03C7  U+03AF  U+03BB  U+03B9  U+03B1  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B   U+0020  U+03C7  U+03B9  U+03BB  U+03B9  U+03AC  U+03B4  U+03B5  U+03C2  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020  U+03C7  U+03B9  U+03BB  U+03B9  U+03AC  U+03B4  U+03B5  U+03C2  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020  U+03C7  U+03B9  U+03BB  U+03B9  U+03AC  U+03B4  U+03B5  U+03C2  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B d1 dd dd dd dd dd dd U+200B >  U+03AD  U+03BD  U+03B1  U+0020  U+03B5  U+03BA  U+03B1  U+03C4  U+03BF  U+03BC  U+03BC  U+03CD  U+03C1  U+03B9  U+03BF  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+200B  U+0020  U+03B5  U+03BA  U+03B1  U+03C4  U+03BF  U+03BC  U+03BC  U+03CD  U+03C1  U+03B9  U+03B1  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+200B  U+0020  U+03B5  U+03BA  U+03B1  U+03C4  U+03BF  U+03BC  U+03BC  U+03CD  U+03C1  U+03B9  U+03B1  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+200B  U+0020  U+03B5  U+03BA  U+03B1  U+03C4  U+03BF  U+03BC  U+03BC  U+03CD  U+03C1  U+03B9  U+03B1  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == EO)

U+200B U+200B d0  U+200B > p("n") p("u") p("l") p("o") / ^_  _  _   _  ;
U+200B d1  U+200B > p("u") p("n") p("u") / ^_  _   _  ;
U+200B d2  U+200B > p("d") p("u") / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r") p("i") / ^_  _   _  ;
U+200B d4  U+200B > p("k") p("v") p("a") p("r") / ^_  _   _  ;
U+200B d5  U+200B > p("k") p("v") p("i") p("n") / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("e") p("s") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("e") p("p") / ^_  _   _  ;
U+200B d8  U+200B > p("o") p("k") / ^_  _   _  ;
U+200B d9  U+200B > p("n") p("a")  U+016D / ^_  _   _  ;
U+200B d1 dd  U+200B > p("d") p("e") p("k")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @2 U+200B  p("d") p("e") p("k")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("c") p("e") p("n") p("t")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B  p("c") p("e") p("n") p("t")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B > p("m") p("i") p("l")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B d1 dd dd dd dd dd dd U+200B > p("u") p("n") p("u")  U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("o")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("o") p("j")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("o") p("j")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("o") p("j")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == ESP)

U+200B U+200B d0  U+200B > p("c") p("e") p("r") p("o") / ^_  _  _   _  ;
U+200B d1 U+200B U+200B > p("u") p("n") p("o") / ^_  _  _  _  ;
U+200B d1  U+200B > p("u") p("n") / ^_  _   _  ;
U+200B d2  U+200B > p("d") p("o") p("s") / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r") p("e") p("s") / ^_  _   _  ;
U+200B d4  U+200B > p("c") p("u") p("a") p("t") p("r") p("o") / ^_  _   _  ;
U+200B d5  U+200B > p("c") p("i") p("n") p("c") p("o") / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("e") p("i") p("s") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("i") p("e") p("t") p("e") / ^_  _   _  ;
U+200B d8  U+200B > p("o") p("c") p("h") p("o") / ^_  _   _  ;
U+200B d9  U+200B > p("n") p("u") p("e") p("v") p("e") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("d") p("i") p("e") p("z") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("o") p("n") p("c") p("e") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("d") p("o") p("c") p("e") / ^_  _  _   _  ;
U+200B d1 d3  U+200B > p("t") p("r") p("e") p("c") p("e") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("c") p("a") p("t") p("o") p("r") p("c") p("e") / ^_  _  _   _  ;
U+200B d1 d5  U+200B > p("q") p("u") p("i") p("n") p("c") p("e") / ^_  _  _   _  ;
U+200B d1 d6  U+200B > p("d") p("i") p("e") p("c") p("i") p("s")  U+00E9 p("i") p("s") / ^_  _  _   _  ;
U+200B d1 dd  U+200B > p("d") p("i") p("e") p("c") p("i")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d2 d0  U+200B > p("v") p("e") p("i") p("n") p("t") p("e") / ^_  _  _   _  ;
U+200B d2 d2  U+200B > p("v") p("e") p("i") p("n") p("t") p("i") p("d")  U+00F3 p("s") / ^_  _  _   _  ;
U+200B d2 d3  U+200B > p("v") p("e") p("i") p("n") p("t") p("i") p("t") p("r")  U+00E9 p("s") / ^_  _  _   _  ;
U+200B d2 d6  U+200B > p("v") p("e") p("i") p("n") p("t") p("i") p("s")  U+00E9 p("i") p("s") / ^_  _  _   _  ;
U+200B d2 dd  U+200B > p("v") p("e") p("i") p("n") p("t") p("i")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d3 d0  U+200B > p("t") p("r") p("e") p("i") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d4 d0  U+200B > p("c") p("u") p("a") p("r") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d5 d0  U+200B > p("c") p("i") p("n") p("c") p("u") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d6 d0  U+200B > p("s") p("e") p("s") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d7 d0  U+200B > p("s") p("e") p("t") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d8 d0  U+200B > p("o") p("c") p("h") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d9 d0  U+200B > p("n") p("o") p("v") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B dx dd  U+200B > U+200B  @2  d0 U+200B  U+0020 p("y")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 d0 d0  U+200B > p("c") p("i") p("e") p("n") / ^_  _  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("c") p("i") p("e") p("n") p("t") p("o")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d5 dd  dd  U+200B > p("q") p("u") p("i") p("n") p("i") p("e") p("n") p("t") p("o") p("s")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d7 dd  dd  U+200B > p("s") p("e") p("t") p("e") p("c") p("i") p("e") p("n") p("t") p("o") p("s")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d9 dd  dd  U+200B > p("n") p("o") p("v") p("e") p("c") p("i") p("e") p("n") p("t") p("o") p("s")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B  p("c") p("i") p("e") p("n") p("t") p("o") p("s")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B > p("m") p("i") p("l")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B d1 dd dd dd dd dd dd U+200B > p("u") p("n")  U+0020 p("m") p("i") p("l") p("l")  U+00F3 p("n")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("l") p("o") p("n") p("e") p("s")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l") p("l") p("o") p("n") p("e") p("s")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l") p("l") p("o") p("n") p("e") p("s")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == FIN)

U+200B U+200B d0  U+200B > p("n") p("o") p("l") p("l") p("a") / ^_  _  _   _  ;
U+200B d1  U+200B > p("y") p("k") p("s") p("i") / ^_  _   _  ;
U+200B d2  U+200B > p("k") p("a") p("k") p("s") p("i") / ^_  _   _  ;
U+200B d3  U+200B > p("k") p("o") p("l") p("m") p("e") / ^_  _   _  ;
U+200B d4  U+200B > p("n") p("e") p("l") p("j")  U+00E4 / ^_  _   _  ;
U+200B d5  U+200B > p("v") p("i") p("i") p("s") p("i") / ^_  _   _  ;
U+200B d6  U+200B > p("k") p("u") p("u") p("s") p("i") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("e") p("i") p("t") p("s") p("e") p("m")  U+00E4 p("n") / ^_  _   _  ;
U+200B d8  U+200B > p("k") p("a") p("h") p("d") p("e") p("k") p("s") p("a") p("n") / ^_  _   _  ;
U+200B d9  U+200B > p("y") p("h") p("d") p("e") p("k") p("s")  U+00E4 p("n") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("k") p("y") p("m") p("m") p("e") p("n") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+200B @3 U+200B  p("t") p("o") p("i") p("s") p("t") p("a") / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @2 U+200B  p("k") p("y") p("m") p("m") p("e") p("n") p("t")  U+00E4  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("s") p("a") p("t") p("a")  U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B  p("s") p("a") p("t") p("a") p("a")  U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B > p("t") p("u") p("h") p("a") p("t")  U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B  p("t") p("u") p("h") p("a") p("t") p("t") p("a")  U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B  p("t") p("u") p("h") p("a") p("t") p("t") p("a")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B  p("t") p("u") p("h") p("a") p("t") p("t") p("a")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B d1 dd dd dd dd dd dd U+200B > p("m") p("i") p("l") p("j") p("o") p("o") p("n") p("a")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("j") p("o") p("o") p("n") p("a") p("a")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l") p("j") p("o") p("o") p("n") p("a") p("a")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l") p("j") p("o") p("o") p("n") p("a") p("a")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == FRA)

U+200B U+200B d0  U+200B > p("z")  U+00E9 p("r") p("o") / ^_  _  _   _  ;
U+200B d1  U+200B > p("u") p("n") / ^_  _   _  ;
U+200B d2  U+200B > p("d") p("e") p("u") p("x") / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r") p("o") p("i") p("s") / ^_  _   _  ;
U+200B d4  U+200B > p("q") p("u") p("a") p("t") p("r") p("e") / ^_  _   _  ;
U+200B d5  U+200B > p("c") p("i") p("n") p("q") / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("i") p("x") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("e") p("p") p("t") / ^_  _   _  ;
U+200B d8  U+200B > p("h") p("u") p("i") p("t") / ^_  _   _  ;
U+200B d9  U+200B > p("n") p("e") p("u") p("f") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("d") p("i") p("x") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("o") p("n") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("d") p("o") p("u") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d3  U+200B > p("t") p("r") p("e") p("i") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("q") p("u") p("a") p("t") p("o") p("r") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d5  U+200B > p("q") p("u") p("i") p("n") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d6  U+200B > p("s") p("e") p("i") p("z") p("e") / ^_  _  _   _  ;
U+200B d2 d0  U+200B > p("v") p("i") p("n") p("g") p("t") / ^_  _  _   _  ;
U+200B d3 d0  U+200B > p("t") p("r") p("e") p("n") p("t") p("e") / ^_  _  _   _  ;
U+200B d4 d0  U+200B > p("q") p("u") p("a") p("r") p("a") p("n") p("t") p("e") / ^_  _  _   _  ;
U+200B d5 d0  U+200B > p("c") p("i") p("n") p("q") p("u") p("a") p("n") p("t") p("e") / ^_  _  _   _  ;
U+200B d6 d0  U+200B > p("s") p("o") p("i") p("x") p("a") p("n") p("t") p("e") / ^_  _  _   _  ;
U+200B d7 d1  U+200B > p("s") p("o") p("i") p("x") p("a") p("n") p("t") p("e")  U+0020 p("e") p("t")  U+0020 p("o") p("n") p("z") p("e") / ^_  _  _   _  ;
U+200B d7 dd  U+200B > p("s") p("o") p("i") p("x") p("a") p("n") p("t") p("e")  U+002D U+200B d1  @3  U+200B / ^_  _  _   _  ;
U+200B d8 d0 U+200B U+200B > p("q") p("u") p("a") p("t") p("r") p("e")  U+002D p("v") p("i") p("n") p("g") p("t") p("s") / ^_  _  _  _  _  ;
U+200B d8 d0  U+200B > p("q") p("u") p("a") p("t") p("r") p("e")  U+002D p("v") p("i") p("n") p("g") p("t") / ^_  _  _   _  ;
U+200B d8 d1  U+200B > p("q") p("u") p("a") p("t") p("r") p("e")  U+002D p("v") p("i") p("n") p("g") p("t")  U+002D p("u") p("n") / ^_  _  _   _  ;
U+200B d9 dd  U+200B > p("q") p("u") p("a") p("t") p("r") p("e")  U+002D p("v") p("i") p("n") p("g") p("t")  U+002D U+200B d1  @3  U+200B / ^_  _  _   _  ;
U+200B dx d1  U+200B > U+200B  @2  d0 U+200B  U+0020 p("e") p("t")  U+0020 p("u") p("n") / ^_  _  _   _  ;
U+200B dx dd  U+200B > U+200B  @2  d0 U+200B  U+002D  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("c") p("e") p("n") p("t")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B (d2,d3,d4,d5,d6,d7,d8,d9) d0 d0 U+200B U+200B >  U+200B @2 U+200B   U+0020 p("c") p("e") p("n") p("t") p("s") / ^_  _  _  _  _  _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B   U+0020 p("c") p("e") p("n") p("t")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 d1 d0 d0  U+200B > p("o") p("n") p("z") p("e")  U+0020 p("c") p("e") p("n") p("t") p("s") / ^_  _  _  _  _   _  ;
U+200B d1 d1 dd  dd  U+200B > p("o") p("n") p("z") p("e")  U+0020 p("c") p("e") p("n") p("t")  U+003A U+003A @4 @5 U+200B @4 @5 U+200B / ^_  _  _  _   _   _  ;
U+200B d1 dd dd dd U+200B > p("m") p("i") p("l") p("l") p("e")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("l") p("e")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l") p("l") p("e")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l") p("l") p("e")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B d1 dd dd dd dd dd dd U+200B > p("u") p("n")  U+0020 p("m") p("i") p("l") p("l") p("i") p("o") p("n")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+200B  U+0020 p("m") p("i") p("l") p("l") p("i") p("o") p("n") p("s")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+200B  U+0020 p("m") p("i") p("l") p("l") p("i") p("o") p("n") p("s")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+200B  U+0020 p("m") p("i") p("l") p("l") p("i") p("o") p("n") p("s")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == ITA)

U+200B U+200B d0  U+200B > p("z") p("e") p("r") p("o") / ^_  _  _   _  ;
U+200B d1  U+200B > p("u") p("n") p("o") / ^_  _   _  ;
U+200B d2  U+200B > p("d") p("u") p("e") / ^_  _   _  ;
U+200B U+200B d3 U+200B U+200B > p("t") p("r") p("e") / ^_  _  _  _  _  ;
U+200B d3 U+200B U+200B > p("t") p("r")  U+00E9 / ^_  _  _  _  ;
U+200B d3  U+200B > p("t") p("r") p("e") / ^_  _   _  ;
U+200B d4  U+200B > p("q") p("u") p("a") p("t") p("t") p("r") p("o") / ^_  _   _  ;
U+200B d5  U+200B > p("c") p("i") p("n") p("q") p("u") p("e") / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("e") p("i") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("e") p("t") p("t") p("e") / ^_  _   _  ;
U+200B d8  U+200B > p("o") p("t") p("t") p("o") / ^_  _   _  ;
U+200B d9  U+200B > p("n") p("o") p("v") p("e") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("d") p("i") p("e") p("c") p("i") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("u") p("n") p("d") p("i") p("c") p("i") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("d") p("o") p("d") p("i") p("c") p("i") / ^_  _  _   _  ;
U+200B d1 d3  U+200B > p("t") p("r") p("e") p("d") p("i") p("c") p("i") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("q") p("u") p("a") p("t") p("t") p("o") p("r") p("d") p("i") p("c") p("i") / ^_  _  _   _  ;
U+200B d1 d5  U+200B > p("q") p("u") p("i") p("n") p("d") p("i") p("c") p("i") / ^_  _  _   _  ;
U+200B d1 d6  U+200B > p("s") p("e") p("d") p("i") p("c") p("i") / ^_  _  _   _  ;
U+200B d1 d7  U+200B > p("d") p("i") p("c") p("i") p("a") p("s") p("s") p("e") p("t") p("t") p("e") / ^_  _  _   _  ;
U+200B d1 d8  U+200B > p("d") p("i") p("c") p("i") p("o") p("t") p("t") p("o") / ^_  _  _   _  ;
U+200B d1 d9  U+200B > p("d") p("i") p("c") p("i") p("a") p("n") p("n") p("o") p("v") p("e") / ^_  _  _   _  ;
U+200B d2 (d1,d8) U+200B > p("v") p("e") p("n") p("t")  U+200B @3 U+200B / ^_  _  _  _  ;
U+200B d2 dd  U+200B > p("v") p("e") p("n") p("t") p("i")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d3 (d1,d8) U+200B > p("t") p("r") p("e") p("n") p("t")  U+200B @3 U+200B / ^_  _  _  _  ;
U+200B d3 dd  U+200B > p("t") p("r") p("e") p("n") p("t") p("a")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d4 (d1,d8) U+200B > p("q") p("u") p("a") p("r") p("a") p("n") p("t")  U+200B @3 U+200B / ^_  _  _  _  ;
U+200B d4 dd  U+200B > p("q") p("u") p("a") p("r") p("a") p("n") p("t") p("a")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d5 (d1,d8) U+200B > p("c") p("i") p("n") p("q") p("u") p("a") p("n") p("t")  U+200B @3 U+200B / ^_  _  _  _  ;
U+200B d5 dd  U+200B > p("c") p("i") p("n") p("q") p("u") p("a") p("n") p("t") p("a")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d6 (d1,d8) U+200B > p("s") p("e") p("s") p("s") p("a") p("n") p("t")  U+200B @3 U+200B / ^_  _  _  _  ;
U+200B d6 dd  U+200B > p("s") p("e") p("s") p("s") p("a") p("n") p("t") p("a")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d7 (d1,d8) U+200B > p("s") p("e") p("t") p("t") p("a") p("n") p("t")  U+200B @3 U+200B / ^_  _  _  _  ;
U+200B d7 dd  U+200B > p("s") p("e") p("t") p("t") p("a") p("n") p("t") p("a")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d8 (d1,d8) U+200B > p("o") p("t") p("t") p("a") p("n") p("t")  U+200B @3 U+200B / ^_  _  _  _  ;
U+200B d8 dd  U+200B > p("o") p("t") p("t") p("a") p("n") p("t") p("a")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d9 (d1,d8) U+200B > p("n") p("o") p("v") p("a") p("n") p("t")  U+200B @3 U+200B / ^_  _  _  _  ;
U+200B d9 dd  U+200B > p("n") p("o") p("v") p("a") p("n") p("t") p("a")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("c") p("e") p("n") p("t") p("o")  U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B  p("c") p("e") p("n") p("t") p("o")  U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B > p("m") p("i") p("l") p("l") p("e")  U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B  p("m") p("i") p("l") p("a")  U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B  p("m") p("i") p("l") p("a")  U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B  p("m") p("i") p("l") p("a")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B d1 dd dd dd dd dd dd U+200B > p("u") p("n")  U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("e")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("i")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("i")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l") p("i") p("o") p("n") p("i")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == LTZ)

U+200B U+200B d0  U+200B > p("n") p("u") p("l") p("l") / ^_  _  _   _  ;
U+200B d1 U+200B U+200B > p("e") p("e") p("n") p("t") / ^_  _  _  _  ;
U+200B d1  U+200B > p("e") p("e") p("n") / ^_  _   _  ;
U+200B d2  U+200B > p("z") p("w") p("e") p("e") / ^_  _   _  ;
U+200B d3  U+200B > p("d") p("r")  U+00E4 p("i") / ^_  _   _  ;
U+200B d4  U+200B > p("v")  U+00E9 p("i") p("e") p("r") / ^_  _   _  ;
U+200B d5  U+200B > p("f")  U+00EB p("n") p("n") p("e") p("f") / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("e") p("c") p("h") p("s") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("i") p("w") p("e") p("n") / ^_  _   _  ;
U+200B d8  U+200B > p("a") p("a") p("c") p("h") p("t") / ^_  _   _  ;
U+200B d9  U+200B > p("n")  U+00E9 p("n") p("g") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("z")  U+00E9 p("n") p("g") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("e") p("e") p("l") p("e") p("f") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("z") p("w") p("i") p("e") p("l") p("e") p("f") / ^_  _  _   _  ;
U+200B d1 d5  U+200B > p("f") p("o") p("f") p("z")  U+00E9 p("n") p("g") / ^_  _  _   _  ;
U+200B d1 d6  U+200B > p("s") p("i") p("e") p("c") p("h") p("z")  U+00E9 p("n") p("g") / ^_  _  _   _  ;
U+200B d1 d7  U+200B > p("s") p("i") p("w") p("w") p("e") p("n") p("z")  U+00E9 p("n") p("g") / ^_  _  _   _  ;
U+200B d1 d8  U+200B > p("u") p("e") p("c") p("h") p("z")  U+00E9 p("n") p("g") / ^_  _  _   _  ;
U+200B d1 d9  U+200B > p("n") p("o") p("n") p("z")  U+00E9 p("n") p("g") / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+200B @3 U+200B  p("z")  U+00E9 p("n") p("g") / ^_  _  _   _  ;
U+200B d2 d0  U+200B > p("z") p("w") p("a") p("n") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d2 dd  U+200B >  U+200B @3 U+200B  p("a") p("n") p("z") p("w") p("a") p("n") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d3 d0  U+200B > p("d") p("r")  U+00EB p("s") p("s") p("e") p("g") / ^_  _  _   _  ;
U+200B d3 dd  U+200B >  U+200B @3 U+200B  p("a") p("n") p("d") p("r")  U+00EB p("s") p("s") p("e") p("g") / ^_  _  _   _  ;
U+200B d4 dd  U+200B >  U+200B @3 U+200B  p("a") p("v")  U+00E9 p("i") p("e") p("r") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d5 d0  U+200B > p("f") p("o") p("f") p("f") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d5 dd  U+200B >  U+200B @3 U+200B  p("a") p("f") p("o") p("f") p("f") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d6 d0  U+200B > p("s") p("i") p("e") p("c") p("h") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d6 dd  U+200B >  U+200B @3 U+200B  p("a") p("s") p("i") p("e") p("c") p("h") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d7 d0  U+200B > p("s") p("i") p("w") p("w") p("e") p("n") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d7 dd  U+200B >  U+200B @3 U+200B  p("a") p("s") p("i") p("w") p("w") p("e") p("n") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d8 d0  U+200B > p("a") p("c") p("h") p("t") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d8 dd  U+200B >  U+200B @3 U+200B  p("a") p("n") p("a") p("c") p("h") p("t") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d9 d0  U+200B > p("n") p("o") p("n") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d9 dd  U+200B >  U+200B @3 U+200B  p("a") p("n") p("n") p("o") p("n") p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B dx d0  U+200B >  U+200B @2 U+200B  p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @3 U+200B  p("a") p("n")  U+200B @2 U+200B  p("z") p("e") p("g") / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("h") p("o") p("n") p("n") p("e") p("r") p("t")  U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B  p("h") p("o") p("n") p("n") p("e") p("r") p("t")  U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B > p("d") p("a") p("u") p("s") p("e") p("n") p("d")  U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B  p("d") p("a") p("u") p("s") p("e") p("n") p("d")  U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B  p("d") p("a") p("u") p("s") p("e") p("n") p("d")  U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B  p("d") p("a") p("u") p("s") p("e") p("n") p("d")  U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B d1 dd dd dd dd dd dd U+200B > p("e") p("n") p("g")  U+0020 p("M") p("i") p("l") p("l") p("i") p("o") p("u") p("n")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("M") p("i") p("l") p("l") p("i") p("o") p("u") p("n") p("e") p("n")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("M") p("i") p("l") p("l") p("i") p("o") p("u") p("n") p("e") p("n")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("M") p("i") p("l") p("l") p("i") p("o") p("u") p("n") p("e") p("n")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == NLD)

U+200B U+200B d0 U+200B U+200B > p("n") p("u") p("l") / ^_  _  _  _  _  ;
U+200B d1 U+200B U+200B > p("e") p("e") p("n") / ^_  _  _  _  ;
U+200B d1  U+200B > p("e") p("e") p("n") p("e") p("n") / ^_  _   _  ;
U+200B d2 U+200B U+200B > p("t") p("w") p("e") p("e") / ^_  _  _  _  ;
U+200B d2  U+200B > p("t") p("w") p("e") p("e")  U+00EB p("n") / ^_  _   _  ;
U+200B d3 U+200B U+200B > p("d") p("r") p("i") p("e") / ^_  _  _  _  ;
U+200B d3  U+200B > p("d") p("r") p("i") p("e")  U+00EB p("n") / ^_  _   _  ;
U+200B d4 U+200B U+200B > p("v") p("i") p("e") p("r") / ^_  _  _  _  ;
U+200B d4  U+200B > p("v") p("i") p("e") p("r") p("e") p("n") / ^_  _   _  ;
U+200B d5 U+200B U+200B > p("v") p("i") p("j") p("f") / ^_  _  _  _  ;
U+200B d5  U+200B > p("v") p("i") p("j") p("f") p("e") p("n") / ^_  _   _  ;
U+200B d6 U+200B U+200B > p("z") p("e") p("s") / ^_  _  _  _  ;
U+200B d6  U+200B > p("z") p("e") p("s") p("e") p("n") / ^_  _   _  ;
U+200B d7 U+200B U+200B > p("z") p("e") p("v") p("e") p("n") / ^_  _  _  _  ;
U+200B d7  U+200B > p("z") p("e") p("v") p("e") p("n") p("e") p("n") / ^_  _   _  ;
U+200B d8 U+200B U+200B > p("a") p("c") p("h") p("t") / ^_  _  _  _  ;
U+200B d8  U+200B > p("a") p("c") p("h") p("t") p("e") p("n") / ^_  _   _  ;
U+200B d9 U+200B U+200B > p("n") p("e") p("g") p("e") p("n") / ^_  _  _  _  ;
U+200B d9  U+200B > p("n") p("e") p("g") p("e") p("n") p("e") p("n") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("t") p("i") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("e") p("l") p("f") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("t") p("w") p("a") p("a") p("l") p("f") / ^_  _  _   _  ;
U+200B d1 d3  U+200B > p("d") p("e") p("r") p("t") p("i") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("v") p("e") p("e") p("r") p("t") p("i") p("e") p("n") / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+200B @3 U+200B   U+200B p("t") p("i") p("e") p("n") / ^_  _  _   _  ;
U+200B d2 dd  U+200B >  U+200B @3 U+200B  p("t") p("w") p("i") p("n") p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B d3 dd  U+200B >  U+200B @3 U+200B  p("d") p("e") p("r") p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B d4 dd  U+200B >  U+200B @3 U+200B  p("v") p("e") p("e") p("r") p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B d8 dd  U+200B >  U+200B @3 U+200B  p("t") p("a") p("c") p("h") p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @3 U+200B   SEPARATOR  U+200B @2 U+200B   U+200B p("t") p("i") p("g") / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("h") p("o") p("n") p("d") p("e") p("r") p("d")  U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B   U+200B p("h") p("o") p("n") p("d") p("e") p("r") p("d")  U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 d0 dd dd U+200B > p("d") p("u") p("i") p("z") p("e") p("n") p("d")  U+003A U+003A @4 @5 U+200B @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx d0 dd dd U+200B >  U+200B @2 U+200B   U+200B p("d") p("u") p("i") p("z") p("e") p("n") p("d")  U+003A U+003A @4 @5 U+200B @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B d1  dd dd dd U+200B >  U+200B @2 @3 U+200B   U+200B p("h") p("o") p("n") p("d") p("e") p("r") p("d")  U+200B @4 @5 U+200B / ^_  _   _  _  _  _  ;
U+200B dx  dd dd dd U+200B >  U+200B @2 @3 U+200B   U+200B p("h") p("o") p("n") p("d") p("e") p("r") p("d")  U+200B @4 @5 U+200B / ^_  _   _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+200B p("d") p("u") p("i") p("z") p("e") p("n") p("d")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+200B p("d") p("u") p("i") p("z") p("e") p("n") p("d")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+200B  U+0020 p("m") p("i") p("l") p("j") p("o") p("e") p("n")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+200B  U+0020 p("m") p("i") p("l") p("j") p("o") p("e") p("n")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+200B  U+0020 p("m") p("i") p("l") p("j") p("o") p("e") p("n")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == PLK)

U+200B U+200B d0  U+200B > p("z") p("e") p("r") p("o") / ^_  _  _   _  ;
U+200B d1  U+200B > p("j") p("e") p("d") p("e") p("n") / ^_  _   _  ;
U+200B d2  U+200B > p("d") p("w") p("a") / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r") p("z") p("y") / ^_  _   _  ;
U+200B d4  U+200B > p("c") p("z") p("t") p("e") p("r") p("y") / ^_  _   _  ;
U+200B d5  U+200B > p("p") p("i")  U+0119  U+0107 / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("z") p("e")  U+015B  U+0107 / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("i") p("e") p("d") p("e") p("m") / ^_  _   _  ;
U+200B d8  U+200B > p("o") p("s") p("i") p("e") p("m") / ^_  _   _  ;
U+200B d9  U+200B > p("d") p("z") p("i") p("e") p("w") p("i")  U+0119  U+0107 / ^_  _   _  ;
U+200B d1 d0  U+200B > p("d") p("z") p("i") p("e") p("s") p("i")  U+0119  U+0107 / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("j") p("e") p("d") p("e") p("n") p("a")  U+015B p("c") p("i") p("e") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("c") p("z") p("t") p("e") p("r") p("n") p("a")  U+015B p("c") p("i") p("e") / ^_  _  _   _  ;
U+200B d1 d5  U+200B > p("p") p("i")  U+0119 p("t") p("n") p("a")  U+015B p("c") p("i") p("e") / ^_  _  _   _  ;
U+200B d1 d6  U+200B > p("s") p("z") p("e") p("s") p("n") p("a")  U+015B p("c") p("i") p("e") / ^_  _  _   _  ;
U+200B d1 d9  U+200B > p("d") p("z") p("i") p("e") p("w") p("i")  U+0119 p("t") p("n") p("a")  U+015B p("c") p("i") p("e") / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+200B @3 U+200B  p("n") p("a")  U+015B p("c") p("i") p("e") / ^_  _  _   _  ;
U+200B d2 dd  U+200B > p("d") p("w") p("a") p("d") p("z") p("i") p("e")  U+015B p("c") p("i") p("a")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d3 dd  U+200B > p("t") p("r") p("z") p("y") p("d") p("z") p("i") p("e")  U+015B p("c") p("i")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d4 dd  U+200B > p("c") p("z") p("t") p("e") p("r") p("d") p("z") p("i") p("e")  U+015B p("c") p("i")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @2 U+200B  p("d") p("z") p("i") p("e") p("s") p("i")  U+0105 p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("s") p("t") p("o")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d2 dd  dd  U+200B > p("d") p("w") p("i") p("e")  U+015B p("c") p("i") p("e")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B (d3,d4) dd  dd  U+200B >  U+200B @2 U+200B  p("s") p("t") p("a")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B  p("s") p("e") p("t")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B > p("t") p("y") p("s") p("i")  U+0105 p("c")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B (d2,d3,d4) dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("t") p("y") p("s") p("i")  U+0105 p("c") p("e")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B (d2,d3,d4,d5,d6,d7,d8,d9) (d2,d3,d4) dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("t") p("y") p("s") p("i")  U+0105 p("c") p("e")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dd (d0,d2,d3,d4,d5,d6,d7,d8,d9) (d2,d3,d4) dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("t") p("y") p("s") p("i")  U+0105 p("c") p("e")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("t") p("y") p("s") p("i")  U+0119 p("c") p("y")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("t") p("y") p("s") p("i")  U+0119 p("c") p("y")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("t") p("y") p("s") p("i")  U+0119 p("c") p("y")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == PTG)

U+200B U+200B d0  U+200B > p("z") p("e") p("r") p("o") / ^_  _  _   _  ;
U+200B d1  U+200B > p("u") p("m") / ^_  _   _  ;
U+200B d2  U+200B > p("d") p("o") p("i") p("s") / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r")  U+00EA p("s") / ^_  _   _  ;
U+200B d4  U+200B > p("q") p("u") p("a") p("t") p("r") p("o") / ^_  _   _  ;
U+200B d5  U+200B > p("c") p("i") p("n") p("c") p("o") / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("e") p("i") p("s") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("e") p("t") p("e") / ^_  _   _  ;
U+200B d8  U+200B > p("o") p("i") p("t") p("o") / ^_  _   _  ;
U+200B d9  U+200B > p("n") p("o") p("v") p("e") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("d") p("e") p("z") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("o") p("n") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("d") p("o") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d3  U+200B > p("t") p("r") p("e") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("q") p("u") p("a") p("t") p("o") p("r") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d5  U+200B > p("q") p("u") p("i") p("n") p("z") p("e") / ^_  _  _   _  ;
U+200B d1 d6  U+200B > p("d") p("e") p("z") p("a") p("s") p("s") p("e") p("i") p("s") / ^_  _  _   _  ;
U+200B d1 d7  U+200B > p("d") p("e") p("z") p("a") p("s") p("s") p("e") p("t") p("e") / ^_  _  _   _  ;
U+200B d1 d8  U+200B > p("d") p("e") p("z") p("o") p("i") p("t") p("o") / ^_  _  _   _  ;
U+200B d1 d9  U+200B > p("d") p("e") p("z") p("a") p("n") p("o") p("v") p("e") / ^_  _  _   _  ;
U+200B d2 d0  U+200B > p("v") p("i") p("n") p("t") p("e") / ^_  _  _   _  ;
U+200B d3 d0  U+200B > p("t") p("r") p("i") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d4 d0  U+200B > p("q") p("u") p("a") p("r") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d5 d0  U+200B > p("c") p("i") p("n") p("q") p("u") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d6 d0  U+200B > p("s") p("e") p("s") p("s") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d7 d0  U+200B > p("s") p("e") p("t") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d8 d0  U+200B > p("o") p("i") p("t") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B d9 d0  U+200B > p("n") p("o") p("v") p("e") p("n") p("t") p("a") / ^_  _  _   _  ;
U+200B dx dd  U+200B > U+200B  @2  d0 U+200B  U+0020 p("e")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 d0 d0  U+200B > p("c") p("e") p("m") / ^_  _  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("c") p("i") p("e") p("n") p("t") p("o")  U+0020 p("e")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d2 d0 d0  U+200B > p("d") p("u") p("z") p("e") p("n") p("t") p("o") p("s") / ^_  _  _  _   _  ;
U+200B d3 d0 d0  U+200B > p("t") p("r") p("e") p("z") p("e") p("n") p("t") p("o") p("s") / ^_  _  _  _   _  ;
U+200B d5 d0 d0  U+200B > p("q") p("u") p("i") p("n") p("h") p("e") p("n") p("t") p("o") p("s") / ^_  _  _  _   _  ;
U+200B dx d0 d0  U+200B >  U+200B @2 U+200B  p("c") p("i") p("e") p("n") p("t") p("o") p("s") / ^_  _  _  _   _  ;
U+200B dx dd  dd  U+200B > U+200B  @2  d0 d0 U+200B  U+0020 p("e")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
endif;
if (numt == 1 && lng == ROM)

U+200B U+200B d0  U+200B > p("z") p("e") p("r") p("o") / ^_  _  _   _  ;
U+200B d1  U+200B > p("u") p("n") p("u") / ^_  _   _  ;
U+200B d2 U+200B U+200B > p("d") p("o") p("i") / ^_  _  _  _  ;
U+200B d2  U+200B > p("d") p("o") p("u")  U+0103 / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r") p("e") p("i") / ^_  _   _  ;
U+200B d4  U+200B > p("p") p("a") p("t") p("r") p("u") / ^_  _   _  ;
U+200B d5  U+200B > p("c") p("i") p("n") p("c") p("i") / ^_  _   _  ;
U+200B d6 U+200B U+200B >  U+0219 p("a") p("s") p("e") / ^_  _  _  _  ;
U+200B d6  U+200B >  U+0219 p("a") p("i") / ^_  _   _  ;
U+200B d7  U+200B >  U+0219 p("a") p("p") p("t") p("e") / ^_  _   _  ;
U+200B d8  U+200B > p("o") p("p") p("t") / ^_  _   _  ;
U+200B d9  U+200B > p("n") p("o") p("u")  U+0103 / ^_  _   _  ;
U+200B d1 d0  U+200B > p("z") p("e") p("c") p("e") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("u") p("n") p("s") p("p") p("r") p("e") p("z") p("e") p("c") p("e") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("d") p("o") p("i") p("s") p("p") p("r") p("e") p("z") p("e") p("c") p("e") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("p") p("a") p("i") p("s") p("p") p("r") p("e") p("z") p("e") p("c") p("e") / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+200B @3 U+200B  p("s") p("p") p("r") p("e") p("z") p("e") p("c") p("e") / ^_  _  _   _  ;
U+200B dx d0  U+200B >  U+200B @2 U+200B  p("z") p("e") p("c") p("i") / ^_  _  _   _  ;
U+200B dx dd  U+200B > U+200B  @2  d0 U+200B  U+0020  U+0219 p("i")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("o")  U+0020 p("s") p("u") p("t")  U+0103  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B   U+0020 p("s") p("u") p("t") p("e")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B > p("o")  U+0020 p("m") p("i") p("e")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == RUS)

U+200B U+200B d0  U+200B >  U+043D  U+043E  U+043B  U+044C / ^_  _  _   _  ;
U+200B d1  U+200B >  U+043E  U+0434  U+0438  U+043D / ^_  _   _  ;
U+200B d2 U+200B U+200B >  U+0434  U+0432  U+0430 / ^_  _  _  _  ;
U+200B d2  U+200B >  U+0434  U+0432  U+0435 / ^_  _   _  ;
U+200B d3  U+200B >  U+0442  U+0440  U+0438 / ^_  _   _  ;
U+200B d4  U+200B >  U+0447  U+0435  U+0442  U+044B  U+0440  U+0435 / ^_  _   _  ;
U+200B d5  U+200B >  U+043F  U+044F  U+0442  U+044C / ^_  _   _  ;
U+200B d6  U+200B >  U+0448  U+0435  U+0441  U+0442  U+044C / ^_  _   _  ;
U+200B d7  U+200B >  U+0441  U+0435  U+043C  U+044C / ^_  _   _  ;
U+200B d8  U+200B >  U+0432  U+043E  U+0441  U+0435  U+043C  U+044C / ^_  _   _  ;
U+200B d9  U+200B >  U+0434  U+0435  U+0432  U+044F  U+0442  U+044C / ^_  _   _  ;
U+200B d1 d0  U+200B >  U+0434  U+0435  U+0441  U+044F  U+0442  U+044C / ^_  _  _   _  ;
U+200B d1 d1  U+200B >  U+043E  U+0434  U+0438  U+043D  U+043D  U+0430  U+0434  U+0446  U+0430  U+0442  U+044C / ^_  _  _   _  ;
U+200B d1 d2  U+200B >  U+0434  U+0432  U+0435  U+043D  U+0430  U+0434  U+0446  U+0430  U+0442  U+044C / ^_  _  _   _  ;
U+200B d1 d3  U+200B >  U+0442  U+0440  U+0438  U+043D  U+0430  U+0434  U+0446  U+0430  U+0442  U+044C / ^_  _  _   _  ;
U+200B d1 d4  U+200B >  U+0447  U+0435  U+0442  U+044B  U+0440  U+043D  U+0430  U+0434  U+0446  U+0430  U+0442  U+044C / ^_  _  _   _  ;
U+200B d1 d5  U+200B >  U+043F  U+044F  U+0442  U+043D  U+0430  U+0434  U+0446  U+0430  U+0442  U+044C / ^_  _  _   _  ;
U+200B d1 d6  U+200B >  U+0448  U+0435  U+0441  U+0442  U+043D  U+0430  U+0434  U+0446  U+0430  U+0442  U+044C / ^_  _  _   _  ;
U+200B d1 d7  U+200B >  U+0441  U+0435  U+043C  U+043D  U+0430  U+0434  U+0446  U+0430  U+0442  U+044C / ^_  _  _   _  ;
U+200B d1 d8  U+200B >  U+0432  U+043E  U+0441  U+0435  U+043C  U+043D  U+0430  U+0434  U+0446  U+0430  U+0442  U+044C / ^_  _  _   _  ;
U+200B d1 d9  U+200B >  U+0434  U+0435  U+0432  U+044F  U+0442  U+043D  U+0430  U+0434  U+0446  U+0430  U+0442  U+044C / ^_  _  _   _  ;
U+200B (d2,d3) dd  U+200B >  U+200B @2 U+200B   U+200B  U+0434  U+0446  U+0430  U+0442  U+044C  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d4 dd  U+200B >  U+0441  U+043E  U+0440  U+043E  U+043A  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d9 dd  U+200B >  U+0434  U+0435  U+0432  U+044F  U+043D  U+043E  U+0441  U+0442  U+043E  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @2 U+200B   U+0434  U+0435  U+0441  U+044F  U+0442  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B >  U+0441  U+0442  U+043E  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d2 dd  dd  U+200B >  U+0434  U+0432  U+0435  U+0441  U+0442  U+0438  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B (d3,d4) dd  dd  U+200B >  U+200B @2 U+200B   U+0441  U+0442  U+0430  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B   U+0441  U+043E  U+0442  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B >  U+043E  U+0434  U+043D  U+0430  U+0020  U+0442  U+044B  U+0441  U+044F  U+0447  U+0430  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B (d2,d3,d4) dd dd dd U+200B >  U+200B @2 U+200B   U+0020  U+0442  U+044B  U+0441  U+044F  U+0447  U+0438  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B (d0,d2,d3,d4,d5,d6,d7,d8,d9) (d2,d3,d4) dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020  U+0442  U+044B  U+0441  U+044F  U+0447  U+0438  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B (d2,d3,d4) dd dd dd U+200B >  U+200B @2 U+200B   U+0020  U+0442  U+044B  U+0441  U+044F  U+0447  U+0438  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx (d0,d2,d3,d4,d5,d6,d7,d8,d9) (d2,d3,d4) dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020  U+0442  U+044B  U+0441  U+044F  U+0447  U+0438  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B   U+0020  U+0442  U+044B  U+0441  U+044F  U+0447  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020  U+0442  U+044B  U+0441  U+044F  U+0447  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020  U+0442  U+044B  U+0441  U+044F  U+0447  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B d1 dd dd dd dd dd dd U+200B >  U+043E  U+0434  U+0438  U+043D  U+0020  U+043C  U+0438  U+043B  U+043B  U+0438  U+043E  U+043D  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020  U+043C  U+0438  U+043B  U+043B  U+0438  U+043E  U+043D  U+043E  U+0432  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020  U+043C  U+0438  U+043B  U+043B  U+0438  U+043E  U+043D  U+043E  U+0432  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020  U+043C  U+0438  U+043B  U+043B  U+0438  U+043E  U+043D  U+043E  U+0432  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == SRPL)
U+200B U+200B d0  U+200B > p("n") p("u") p("l") p("a") / ^_  _  _   _  ;
U+200B d1  U+200B > p("j") p("e") p("d") p("a") p("n") / ^_  _   _  ;
U+200B d2  U+200B > p("d") p("v") p("a") / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r") p("i") / ^_  _   _  ;
U+200B d4  U+200B >  U+010D p("e") p("t") p("i") p("r") p("i") / ^_  _   _  ;
U+200B d5  U+200B > p("p") p("e") p("t") / ^_  _   _  ;
U+200B d6  U+200B >  U+0161 p("e") p("s") p("t") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("e") p("d") p("a") p("m") / ^_  _   _  ;
U+200B d8  U+200B > p("o") p("s") p("a") p("m") / ^_  _   _  ;
U+200B d9  U+200B > p("d") p("e") p("v") p("e") p("t") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("d") p("e") p("s") p("e") p("t") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("j") p("e") p("d") p("a") p("n") p("a") p("e") p("s") p("t") / ^_  _  _   _  ;
U+200B d1 d4  U+200B >  U+010D p("e") p("t") p("r") p("n") p("a") p("e") p("s") p("t") / ^_  _  _   _  ;
U+200B d1 d6  U+200B >  U+0161 p("e") p("s") p("n") p("a") p("e") p("s") p("t") / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+200B @3 U+200B  p("n") p("a") p("e") p("s") p("t") / ^_  _  _   _  ;
U+200B d4 dd  U+200B >  U+010D p("e") p("t") p("r") p("d") p("e") p("s") p("e") p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d5 dd  U+200B > p("p") p("e") p("d") p("e") p("s") p("e") p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d6 dd  U+200B >  U+0161 p("e") p("z") p("d") p("e") p("s") p("e") p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d9 dd  U+200B > p("d") p("e") p("v") p("e") p("d") p("e") p("s") p("e") p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B dx d0  U+200B >  U+200B @2 U+200B  p("d") p("e") p("s") p("e") p("t") / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @2 U+200B  p("d") p("e") p("s") p("e") p("t")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("s") p("t") p("o")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d2 dd  dd  U+200B > p("d") p("v") p("e") p("s") p("t") p("a")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d3 dd  dd  U+200B > p("t") p("r") p("i") p("s") p("t") p("a")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B  p("s") p("t") p("o")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd  dd  dd  U+200B > p("h") p("i") p("l") p("j") p("a") p("d") p("u")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
U+200B d2 dd  dd  dd  U+200B > p("d") p("v") p("e")  U+0020 p("h") p("i") p("l") p("j") p("a") p("d") p("e")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
U+200B (d3,d4) dd  dd  dd  U+200B >  U+200B @2 U+200B   U+0020 p("h") p("i") p("l") p("j") p("a") p("d") p("e")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
endif;
if (numt == 1 && lng == SLV)

U+200B U+200B d0  U+200B > p("n") p("i")  U+010D / ^_  _  _   _  ;
U+200B d1  U+200B > p("e") p("n") p("a") / ^_  _   _  ;
U+200B d2 U+200B U+200B > p("d") p("v") p("e") / ^_  _  _  _  ;
U+200B d2  U+200B > p("d") p("v") p("a") / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r") p("i") / ^_  _   _  ;
U+200B d4  U+200B >  U+0161 p("t") p("i") p("r") p("i") / ^_  _   _  ;
U+200B d5  U+200B > p("p") p("e") p("t") / ^_  _   _  ;
U+200B d6  U+200B >  U+0161 p("e") p("s") p("t") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("e") p("d") p("e") p("m") / ^_  _   _  ;
U+200B d8  U+200B > p("o") p("s") p("e") p("m") / ^_  _   _  ;
U+200B d9  U+200B > p("d") p("e") p("v") p("e") p("t") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("d") p("e") p("s") p("e") p("t") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("e") p("n") p("a") p("j") p("s") p("t") / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+200B @3 U+200B  p("n") p("a") p("j") p("s") p("t") / ^_  _  _   _  ;
U+200B d2 d0  U+200B > p("d") p("v") p("a") p("j") p("s") p("e") p("t") / ^_  _  _   _  ;
U+200B d2 dd  U+200B >  U+200B @3 U+200B  p("i") p("n") p("d") p("v") p("a") p("j") p("s") p("e") p("t") / ^_  _  _   _  ;
U+200B dx d0  U+200B >  U+200B @2 U+200B  p("d") p("e") p("s") p("e") p("t") / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @3 U+200B  p("i") p("n")  U+200B @2 U+200B  p("d") p("e") p("s") p("e") p("t") / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("s") p("t") p("o")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d2 dd  dd  U+200B > p("d") p("v") p("e") p("s") p("t") p("o")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B  p("s") p("t") p("o")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd  dd  dd  U+200B > p("t") p("i") p("s") p("o")  U+010D  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
U+200B dx dd  dd  dd  U+200B >  U+200B @2 U+200B   U+0020 p("t") p("i") p("s") p("o")  U+010D  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
U+200B dx dd dd  dd  dd  U+200B >  U+200B @2 @3 U+200B   U+0020 p("t") p("i") p("s") p("o")  U+010D  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _   _   _   _  ;
U+200B dx dd dd dd  dd  dd  U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("t") p("i") p("s") p("o")  U+010D  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _   _   _   _  ;
U+200B d1 dd dd dd dd dd dd U+200B > p("m") p("i") p("l") p("i") p("j") p("o") p("n")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B (d2,d3,d4) dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("i") p("j") p("o") p("n") p("a")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("i") p("j") p("o") p("n") p("o") p("v")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l") p("i") p("j") p("o") p("n") p("o") p("v")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l") p("i") p("j") p("o") p("n") p("o") p("v")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == SRP)
U+200B U+200B d0  U+200B >  U+043D  U+0443  U+043B  U+0430 / ^_  _  _   _  ;
U+200B d1  U+200B >  U+0458  U+0435  U+0434  U+0430  U+043D / ^_  _   _  ;
U+200B d2  U+200B >  U+0434  U+0432  U+0430 / ^_  _   _  ;
U+200B d3  U+200B >  U+0442  U+0440  U+0438 / ^_  _   _  ;
U+200B d4  U+200B >  U+0447  U+0435  U+0442  U+0438  U+0440  U+0438 / ^_  _   _  ;
U+200B d5  U+200B >  U+043F  U+0435  U+0442 / ^_  _   _  ;
U+200B d6  U+200B >  U+0448  U+0435  U+0441  U+0442 / ^_  _   _  ;
U+200B d7  U+200B >  U+0441  U+0435  U+0434  U+0430  U+043C / ^_  _   _  ;
U+200B d8  U+200B >  U+043E  U+0441  U+0430  U+043C / ^_  _   _  ;
U+200B d9  U+200B >  U+0434  U+0435  U+0432  U+0435  U+0442 / ^_  _   _  ;
U+200B d1 d0  U+200B >  U+0434  U+0435  U+0441  U+0435  U+0442 / ^_  _  _   _  ;
U+200B d1 d1  U+200B >  U+0458  U+0435  U+0434  U+0430  U+043D  U+0430  U+0435  U+0441  U+0442 / ^_  _  _   _  ;
U+200B d1 d4  U+200B >  U+0447  U+0435  U+0442  U+0440  U+043D  U+0430  U+0435  U+0441  U+0442 / ^_  _  _   _  ;
U+200B d1 d6  U+200B >  U+0448  U+0435  U+0441  U+043D  U+0430  U+0435  U+0441  U+0442 / ^_  _  _   _  ;
U+200B d1 dd  U+200B >  U+200B @3 U+200B   U+043D  U+0430  U+0435  U+0441  U+0442 / ^_  _  _   _  ;
U+200B d4 dd  U+200B >  U+0447  U+0435  U+0442  U+0440  U+0434  U+0435  U+0441  U+0435  U+0442  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d5 dd  U+200B >  U+043F  U+0435  U+0434  U+0435  U+0441  U+0435  U+0442  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d6 dd  U+200B >  U+0448  U+0435  U+0437  U+0434  U+0435  U+0441  U+0435  U+0442  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d9 dd  U+200B >  U+0434  U+0435  U+0432  U+0435  U+0434  U+0435  U+0441  U+0435  U+0442  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B dx d0  U+200B >  U+200B @2 U+200B   U+0434  U+0435  U+0441  U+0435  U+0442 / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @2 U+200B   U+0434  U+0435  U+0441  U+0435  U+0442  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B >  U+0441  U+0442  U+043E  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d2 dd  dd  U+200B >  U+0434  U+0432  U+0435  U+0441  U+0442  U+0430  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d3 dd  dd  U+200B >  U+0442  U+0440  U+0438  U+0441  U+0442  U+0430  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B   U+0441  U+0442  U+043E  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd  dd  dd  U+200B >  U+0445  U+0438  U+0459  U+0430  U+0434  U+0443  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
U+200B d2 dd  dd  dd  U+200B >  U+0434  U+0432  U+0435  U+0020  U+0445  U+0438  U+0459  U+0430  U+0434  U+0435  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
U+200B (d3,d4) dd  dd  dd  U+200B >  U+200B @2 U+200B   U+0020  U+0445  U+0438  U+0459  U+0430  U+0434  U+0435  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
endif;
if (numt == 1 && lng == SVE)

U+200B U+200B d0  U+200B > p("n") p("o") p("l") p("l") / ^_  _  _   _  ;
U+200B U+200B d1 U+200B U+200B > p("e") p("t") p("t") / ^_  _  _  _  _  ;
U+200B U+200B d1  U+200B > p("e") p("n") / ^_  _  _   _  ;
U+200B d1  U+200B > p("e") p("t") p("t") / ^_  _   _  ;
U+200B d2  U+200B > p("t") p("v")  U+00E5 / ^_  _   _  ;
U+200B d3  U+200B > p("t") p("r") p("e") / ^_  _   _  ;
U+200B d4  U+200B > p("f") p("y") p("r") p("a") / ^_  _   _  ;
U+200B d5  U+200B > p("f") p("e") p("m") / ^_  _   _  ;
U+200B d6  U+200B > p("s") p("e") p("x") / ^_  _   _  ;
U+200B d7  U+200B > p("s") p("j") p("u") / ^_  _   _  ;
U+200B d8  U+200B >  U+00E5 p("t") p("t") p("a") / ^_  _   _  ;
U+200B d9  U+200B > p("n") p("i") p("o") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("t") p("i") p("o") / ^_  _  _   _  ;
U+200B d1 d1  U+200B > p("e") p("l") p("v") p("a") / ^_  _  _   _  ;
U+200B d1 d2  U+200B > p("t") p("o") p("l") p("v") / ^_  _  _   _  ;
U+200B d1 d3  U+200B > p("t") p("r") p("e") p("t") p("t") p("o") p("n") / ^_  _  _   _  ;
U+200B d1 d4  U+200B > p("f") p("j") p("o") p("r") p("t") p("o") p("n") / ^_  _  _   _  ;
U+200B d1 d5  U+200B > p("f") p("e") p("m") p("t") p("o") p("n") / ^_  _  _   _  ;
U+200B d1 d6  U+200B > p("s") p("e") p("x") p("t") p("o") p("n") / ^_  _  _   _  ;
U+200B d1 d7  U+200B > p("s") p("j") p("u") p("t") p("t") p("o") p("n") / ^_  _  _   _  ;
U+200B d1 d8  U+200B > p("a") p("r") p("t") p("o") p("n") / ^_  _  _   _  ;
U+200B d1 d9  U+200B > p("n") p("i") p("t") p("t") p("o") p("n") / ^_  _  _   _  ;
U+200B d2 dd  U+200B > p("t") p("j") p("u") p("g") p("o")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d3 dd  U+200B > p("t") p("r") p("e") p("t") p("t") p("i") p("o")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d4 dd  U+200B > p("f") p("y") p("r") p("t") p("i") p("o")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d7 dd  U+200B > p("s") p("j") p("u") p("t") p("t") p("i") p("o")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d8 dd  U+200B >  U+00E5 p("t") p("t") p("i") p("o")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d9 dd  U+200B > p("n") p("i") p("t") p("t") p("i") p("o")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B dx dd  U+200B >  U+200B @2 U+200B  p("t") p("i") p("o")  U+200B @3 U+200B / ^_  _  _   _  ;
U+200B dx dd  dd  U+200B >  U+200B @2 U+200B   U+200B p("h") p("u") p("n") p("d") p("r") p("a")  U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd dd dd U+200B >  U+200B @2 U+200B   U+200B p("u") p("s") p("e") p("n")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B (d0,d2,d3,d4,d5,d6,d7,d8,d9) d1 dd dd dd U+200B >  U+200B @2 @3 U+200B   U+200B p("u") p("s") p("e") p("n")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B d1 dd dd dd U+200B >  U+200B @2 U+200B   U+200B p("u") p("s") p("e") p("n")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx (d0,d2,d3,d4,d5,d6,d7,d8,d9) d1 dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+200B p("u") p("s") p("e") p("n")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B  p("t") p("u") p("s") p("e") p("n")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B  p("t") p("u") p("s") p("e") p("n")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B  p("t") p("u") p("s") p("e") p("n")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
endif;
if (numt == 1 && lng == TRK)

U+200B U+200B d0  U+200B > p("s")  U+0131 p("f")  U+0131 p("r") / ^_  _  _   _  ;
U+200B d1  U+200B > p("b") p("i") p("r") / ^_  _   _  ;
U+200B d2  U+200B > p("i") p("k") p("i") / ^_  _   _  ;
U+200B d3  U+200B >  U+00FC  U+00E7 / ^_  _   _  ;
U+200B d4  U+200B > p("d")  U+00F6 p("r") p("t") / ^_  _   _  ;
U+200B d5  U+200B > p("b") p("e")  U+015F / ^_  _   _  ;
U+200B d6  U+200B > p("a") p("l") p("t")  U+0131 / ^_  _   _  ;
U+200B d7  U+200B > p("y") p("e") p("d") p("i") / ^_  _   _  ;
U+200B d8  U+200B > p("s") p("e") p("k") p("i") p("z") / ^_  _   _  ;
U+200B d9  U+200B > p("d") p("o") p("k") p("u") p("z") / ^_  _   _  ;
U+200B d1 d0  U+200B > p("o") p("n") / ^_  _  _   _  ;
U+200B d1 dd  U+200B > p("o") p("n")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d2 d0  U+200B > p("y") p("i") p("r") p("m") p("i") / ^_  _  _   _  ;
U+200B d2 dd  U+200B > p("y") p("i") p("r") p("m") p("i")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d3 d0  U+200B > p("o") p("t") p("u") p("z") / ^_  _  _   _  ;
U+200B d3 dd  U+200B > p("o") p("t") p("u") p("z")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d4 d0  U+200B > p("k")  U+0131 p("r") p("k") / ^_  _  _   _  ;
U+200B d4 dd  U+200B > p("k")  U+0131 p("r") p("k")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d5 d0  U+200B > p("e") p("l") p("l") p("i") / ^_  _  _   _  ;
U+200B d5 dd  U+200B > p("e") p("l") p("l") p("i")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d6 d0  U+200B > p("a") p("l") p("t") p("m")  U+0131  U+015F / ^_  _  _   _  ;
U+200B d6 dd  U+200B > p("a") p("l") p("t") p("m")  U+0131  U+015F  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d7 d0  U+200B > p("y") p("e") p("t") p("m") p("i")  U+015F / ^_  _  _   _  ;
U+200B d7 dd  U+200B > p("y") p("e") p("t") p("m") p("i")  U+015F  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d8 d0  U+200B > p("s") p("e") p("k") p("s") p("e") p("n") / ^_  _  _   _  ;
U+200B d8 dd  U+200B > p("s") p("e") p("k") p("s") p("e") p("n")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d9 d0  U+200B > p("d") p("o") p("k") p("s") p("a") p("n") / ^_  _  _   _  ;
U+200B d9 dd  U+200B > p("d") p("o") p("k") p("s") p("a") p("n")  U+003A U+003A @3 U+200B @3 U+200B / ^_  _  _   _  ;
U+200B d1 dd  dd  U+200B > p("y")  U+00FC p("z")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B (d2,d3,d4,d5,d6,d7,d8,d9) dd  dd  U+200B >  U+200B @2 U+200B   U+0020 p("y")  U+00FC p("z")  U+003A U+003A @3 @4 U+200B @3 @4 U+200B / ^_  _  _   _   _  ;
U+200B d1 dd  dd  dd  U+200B > p("b") p("i") p("n")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _   _   _   _  ;
U+200B dx (d1,d2,d3,d4,d5,d6,d7,d8,d9) dd  dd  U+200B >  U+200B @2 U+200B   U+0020 p("b") p("i") p("n")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _   _   _  ;
U+200B dx dd (d1,d2,d3,d4,d5,d6,d7,d8,d9) dd  dd  U+200B >  U+200B @2 @3 U+200B   U+0020 p("b") p("i") p("n")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _   _   _  ;
U+200B dx dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("b") p("i") p("n")  U+003A U+003A @3 @4 @5 U+200B @3 @4 @5 U+200B / ^_  _  _  _  _  _  ;
U+200B dx dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("b") p("i") p("n")  U+003A U+003A @4 @5 @6 U+200B @4 @5 @6 U+200B / ^_  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("b") p("i") p("n")  U+003A U+003A @5 @6 @7 U+200B @5 @6 @7 U+200B / ^_  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd U+200B >  U+200B @2 U+200B   U+0020 p("m") p("i") p("l") p("y") p("o") p("n")  U+003A U+003A @3 @4 @5 @6 @7 @8 U+200B @3 @4 @5 @6 @7 @8 U+200B / ^_  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 U+200B   U+0020 p("m") p("i") p("l") p("y") p("o") p("n")  U+003A U+003A @4 @5 @6 @7 @8 @9 U+200B @4 @5 @6 @7 @8 @9 U+200B / ^_  _  _  _  _  _  _  _  _  _  ;
U+200B dx dd dd dd dd dd dd dd dd U+200B >  U+200B @2 @3 @4 U+200B   U+0020 p("m") p("i") p("l") p("y") p("o") p("n")  U+003A U+003A @5 @6 @7 @8 @9 @10 U+200B @5 @6 @7 @8 @9 @10 U+200B / ^_  _  _  _  _  _  _  _  _  _  _  ;
endif;


if (thou > 0 && !numt)

cdecsep dd dd dd dd > @1 @2 @3 @4 U+200B @5 / _ ^_ _ _ _;

dd dd dd dd dd dd dd dd dd dd dd dd dd > @1 U+202F @2 @3 @4 U+202F @5 @6 @7 U+202F @8 @9 @10 U+202F @11 @12 @13 / ^_ _ _ _ _ _ _ _ _ _ _ _ _ ;
dd dd dd dd dd dd dd dd dd dd dd dd > @1 @2 @3 U+202F @4 @5 @6 U+202F @7 @8 @9 U+202F @10 @11 @12 / ^_ _ _ _ _ _ _ _ _ _ _ _;
dd dd dd dd dd dd dd dd dd dd dd > @1 @2 U+202F @3 @4 @5 U+202F @6 @7 @8 U+202f @9 @10 @11 / ^_ _ _ _ _ _ _ _ _ _ _;
dd dd dd dd dd dd dd dd dd dd > @1 U+202F @2 @3 @4 U+202F @5 @6 @7 U+202F @8 @9 @10 / ^ _ _ _ _ _ _ _ _ _ _;
dd dd dd dd dd dd dd dd dd > @1 @2 @3 U+202F @4 @5 @6 U+202F @7 @8 @9 / ^_ _ _ _ _ _ _ _ _; 
dd dd dd dd dd dd dd dd > @1 @2 U+202F @3 @4 @5 U+202F @6 @7 @8 / ^_ _ _ _ _ _ _ _; 
dd dd dd dd dd dd dd > @1 U+202F @2 @3 @4 U+202F @5 @6 @7 / ^_ _ _ _ _ _ _; 
dd dd dd dd dd dd > @1 @2 @3 U+202F @4 @5 @6 / ^_ _ _ _ _ _; 
dd dd dd dd dd > @1 @2 U+202F @3 @4 @5 / ^_ _ _ _ _; 

  if (thou == 2)
	dd dd dd dd > @1 U+202F @2 @3 @4 / ^_ _ _ _; 
  endif;

endif;

if (arti==1 && numt == 0 && lng == HUN)

U+200B ad1 _ > p("z") U+0020 @2 / ^ _ _ _;
U+200B ad5 _ > p("z") U+0020 @2 / ^ _ _ _;
U+200B add > U+0020 @2 / _ ^_;
U+200B ad5 add _ > p("z") U+0020 @2 @3 / ^ _ _ _ _;
U+200B add add > U+0020 @2 @3 / _ _ ^_;
U+200B ad5 add add > p("z") U+0020 @2 @3 @4 / ^ _ _ _ _ ;
U+200B add add add > U+0020 @2 @3 @4 / _ _ ^_ _;
U+200B ad1 add add add > p("z") U+0020 @2 @3 @4 @5 / _ _ ^_ _ _;
U+200B ad5 add add add > p("z") U+0020 @2 @3 @4 @5 / _ _ ^ _ _ _;
U+200B add add add add > U+0020 @2 @3 @4 @5 / _ _ ^_ _ _;
U+200B ad5 add add add add _ > p("z") U+0020 @2 @3 @4 @5 @6 / ^ _ _ _ _ _ _ _;
U+200B add add add add add > U+0020 @2 @3 @4 @5 @6;
U+200B ad5 add add add add add _ > p("z") U+0020 @2 @3 @4 @5 @6 @7 / ^ _ _ _ _ _ _ _ _ ;
U+200B add add add add add add > U+0020 @2 @3 @4 @5 @6 @7;
U+200B ad1 add add add add add add _ > p("z") U+0020 @2 @3 @4 @5 @6 @7 @8 / ^ _ _ _ _ _ _ _ _ _ ;
U+200B ad5 add add add add add add _ > p("z") U+0020 @2 @3 @4 @5 @6 @7 @8 / ^ _ _ _ _ _ _ _ _ _ ;
U+200B add add add add add add add > U+0020 @2 @3 @4 @5 @6 @7 @8;

add > @2 / ANY _;
add > p("a") U+200B @1 / ^_;

endif;

if (numt == 3)
  if (vari == 0)
	d1 dd > @1 @2 / _ _ dd;
	d1 dd > @1 @2 p("t") p("h");
	dd > @1 / _ dd;
	d1 > @1 p("s") p("t");
	d2 > @1 p("n") p("d");
	d3 > @1 p("r") p("d");
	dd > @1 p("t") p("h");
  else
	d1 dd > @1 @2 / _ _ dd;
	d1 dd > @1 @2 p("t.superior") p("h.superior");
	dd > @1 / _ dd;
	d1 > @1 p("s.superior") p("t.superior");
	d2 > @1 p("n.superior") p("d.superior");
	d3 > @1 p("r.superior") p("d.superior");
	dd > @1 p("t.superior") p("h.superior");
 endif;

endif;

if (foot > 0)
  if (foot == 2 || lng == HUN)
    if (!algn)
	d1 > asterisk;
	d2 > asterisk asterisk;
	d3 > asterisk asterisk asterisk;
	d4 > dagger;
	d5 > dagger dagger;
	d6 > dagger dagger dagger;
	d7 > daggerdbl;
	d8 > daggerdbl daggerdbl;
	d9 > daggerdbl daggerdbl daggerdbl;
    else
	d1 _ > ZWSP asterisk {user1 = true} / ^ _ _;
	d2 _ _ > ZWSP asterisk {user1 = true} asterisk / ^ _ _ _;
	d3 _ _ _ > ZWSP asterisk {user1 = true} asterisk asterisk;
	d4 _ > ZWSP dagger {user1 = true} / ^ _ _;
	d5 _ _ > ZWSP dagger {user1 = true} dagger / ^ _ _ _;
	d6 _ _ _ > ZWSP dagger {user1 = true} dagger dagger;
	d7 _ > ZWSP daggerdbl {user1 = true} / ^ _ _;
	d8 _ _ > ZWSP daggerdbl {user1 = true} daggerdbl / ^ _ _ _;
	d9 _ _ _ > ZWSP daggerdbl {user1 = true} daggerdbl daggerdbl;
    endif;
  else
    if (!algn)
	d1 > asterisk;
	d2 > dagger;
	d3 > daggerdbl;
	d4 > U+00A7;
	d5 > asterisk asterisk;
	d6 > dagger dagger;
	d7 > daggerdbl daggerdbl;
	d8 > U+00A7 U+00A7;
	d9 > asterisk asterisk asterisk;
	d1 d0 > dagger dagger dagger;
	d1 d1 > daggerdbl daggerdbl daggerdbl;
	d1 d2 > U+00A7 U+00A7 U+00A7;
    else
	d1 _ > ZWSP asterisk {user1 = true} / ^ _ _;
	d2 _ > ZWSP dagger {user1 = true} / ^ _ _;
	d3 _ > ZWSP daggerdbl {user1 = true} / ^ _ _;
	d4 _ > ZWSP U+00A7 {user1 = true} / ^ _ _;
	d5 _ _ > ZWSP asterisk {user1 = true} asterisk / ^ _ _ _;
	d6 _ _ > ZWSP dagger {user1 = true} dagger / ^ _ _ _;
	d7 _ _ > ZWSP daggerdbl {user1 = true} daggerdbl / ^ _ _ _;
	d8 _ _ > ZWSP U+00A7 {user1 = true} U+00A7 / ^ _ _ _;
	d9 _ _ _ > ZWSP asterisk {user1 = true} asterisk asterisk / ^ _ _ _ _;
	d1 d0 _ _ > ZWSP dagger {user1 = true} dagger dagger / ^ _ _ _ _;
	d1 d1 _ _ > ZWSP daggerdbl {user1 = true} daggerdbl daggerdbl / ^ _ _ _ _;
	d1 d2 _ _ > ZWSP U+00A7 {user1 = true} U+00A7 U+00A7 / ^ _ _ _ _;
    endif;
  endif;
endif;

if (algn && !foot)	
	numbers numbers numbers _ > ZWSP @1 { user1 = true } @2 { user1 = true } @3 { user1 = true } / ^_ { user1 == false } _ _ _;
	numbers numbers _ > ZWSP @1 { user1 = true } @2 { user1 = true} / ^_ { user1 == false } _ _;
	numbers _ > ZWSP @1 { user1 = true } / ^ _ { user1 == false } _;
endif;

"""

feat_linlib = """
caps { id = "caps"; name.LG_USENG = string ("'caps' Capitalization"); 
	settings {
		none {value = 0; name.LG_USENG = string("None"); }
		first { value = 1; name.LG_USENG = string("Capitalized"); }
		all { value = 2; name.LG_USENG = string("Uppercase"); }
		wordparts { value = 3; name.LG_USENG = string("Capitalized words and word parts"); }
		title { value = 4; name.LG_USENG = string("Capitalized words"); }
	}
}

"""

glyph_linlib = """
csc1 = ( U+E02D, U+0061..U+007A, U+00E0..U+00F6, U+0153, U+00F8..U+00FF, U+0133, U+00DF, U+0111, U+0103, U+0105, U+0107, U+010D, U+010F, U+0119, U+011B, U+011F, U+013A, U+0142, U+0144, U+0148, U+014B, U+0151, U+0155, U+0159, U+015B, U+015F, U+0161, U+0163, U+0167, U+016F, U+0171, U+017A, U+017C, U+017E, U+013E, U+0165, U+021B, U+0219 ); 
csc2 = ( U+E06D, U+E051..U+E06A, U+E070..U+E091, U+E097..U+E0B5 );

csc3 = ( U+E02D, U+0041..U+005A, U+00C0..U+00D6, U+0152, U+00D8, U+00D9, U+00DA, U+00DB, U+00DC, U+00DD, U+00DE, U+0178, U+0132, U+0053, U+0110, U+0102, U+0104, U+0106, U+010C, U+010E, U+0118, U+011A, U+011E, U+0139, U+0141, U+0143, U+0147, U+014A, U+0150, U+0154, U+0158, U+015A, U+015E, U+0160, U+0162, U+0166, U+016E, U+0170, U+0179, U+017B, U+017D, U+013D, U+0164, U+021A, U+0218);

//csc123 = (csc1, csc2, csc3);
//csc123lig = (csc123, letters);
//csc123ligd = (csc123lig, U+002D)
//csc123liga = (csc123ligd, U+0020)

cnumsup = (U+2070, U+00B9, U+00B2, U+00B3, U+2074..U+2079);
cnumsub = (U+2080..U+2089);

dashes = (U+2012..U+2015);
slashes = p("slash", "fraction");
"""

sub_linlib = """

// fi correction with short f

if (!liga)
	p("f") p("i") _ > f_corr ZWSP @2 / ^ _ _ _;
	p("f") p("f") p("i") _ > f_corr f_corr ZWSP @3 / ^ _ _ _ _; 	
endif;

// Dutch letter IJ

if (lng == NLD && caps != 2)
	p("I") p("J") > U+132 _;

	if (liga)
		p("f") _ > f_corr ZWSP / _ _ p("i") p("j");
		p("f") p("f")  > ff_corr ZWSP / _ _ p("i") p("j");
	endif;
endif;

if (caps == title) // eg. Twenty-one
	if (smcp) 
		csc2 > csc2 / csc123ligd _;
	else
		csc1 > @ / csc123ligd _;
	endif;
	if (lng == NLD)
		p("i") p("j") > _ U+0132 / ^ _;
	endif;
	csc1 > csc3 {user3 = true} / ^_;
	csc2 > csc3 / ^_;
else if (caps == 2)	// eg. TWENTY-ONE
	csc1 > csc3 / ^_;
	csc2 > csc3 / ^_;
else if (caps == 3)	// eg. Twenty-One
	if (smcp) 
		csc1 > csc2 / csc123lig _;
	else
		csc1 > @ / csc123lig _;
	endif;
	if (lng == NLD)
		p("i") p("j") > _ U+0132 / ^ _;
	endif;
	csc1 > csc3 { user3 = true } / ^_ ;
	csc2 > csc3 / ^_;
else if (caps == first)	// eg. Hundred twenty-one
	if (smcp) 
		csc1 > csc2 / csc123liga _;
	else
		csc1 > @ / csc123liga _;
	endif;
	if (lng == NLD)
		p("i") p("j") > _ U+0132 / ^ _;
	endif;
	csc1 > csc3 { user3 = true } / ^_;
	csc2 > csc3 / ^_;
endif;

if (frac==1)

p("one") slashes p("four") > p("onequarter") / ^_ _ _ ;
p("one") slashes p("two") > p("onehalf") / ^_ _ _ ;
p("three") slashes p("four") > p("threequarters") / ^_ _ _ ;
p("one") slashes p("three") > p("onethird") / ^_ _ _ ;
p("two") slashes p("three") > p("twothirds") / ^_ _ _ ;

dd dd dd dd U+002F dd > cnumsup cnumsup cnumsup cnumsup U+2044 cnumsub / ^_ _ _ _ _ _;
dd dd dd U+002F dd > cnumsup cnumsup cnumsup U+2044 cnumsub / ^_ _ _ _ _;
dd dd U+002F dd > cnumsup cnumsup U+2044 cnumsub / ^_ _ _ _;
dd U+002F dd dd > cnumsup U+2044 cnumsub @4 / ^_ _ _;
dd U+002F dd > cnumsup U+2044 cnumsub / ^_ _ _;

U+2044 cnumsub dd dd dd > U+2044 @2 cnumsub cnumsub cnumsub / ^_ _ _ _ _;
U+2044 cnumsub dd dd > U+2044 @2 cnumsub cnumsub / ^_ _ _ _;
U+2044 cnumsub dd > U+2044 @2 cnumsub / ^_ _ _;
endif;

if (frac==2)
dd dd dd U+002F > cnumsup {user1=true} cnumsup cnumsup U+2015 / ^_ _ _ _ dd;
dd dd U+002F > cnumsup {user1=true} cnumsup U+2014 / ^_ _ _ dd;
dd U+002F > cnumsup {user1=true} U+2013 / ^_ _ dd;
dashes dd dd dd > U+2015 cnumsub cnumsub cnumsub {user1=true} / _ _ _ _;
U+2013 dd dd > U+2014 cnumsub cnumsub {user1=true} / ^_ _ _;
dashes dd dd > @1 cnumsub cnumsub {user1=true} / ^_ _ _;
dashes dd > @1 cnumsub {user1=true} / ^_ _;
endif;

if (dash)
	p("hyphen") > p("endash") / U+0020 _ U+0020;
	p("hyphen") > p("endash") / U+0020 _ p("comma");
	p("hyphen") > p("hyphen") / ANY _ U+0020;
	p("hyphen") > p("endash") / _ U+0020;
endif;

if (quot)

	if (lng==CSY || lng==HUN || lng==ROM)
		p("quotedbl") > p("quotedblbase") / U+0020 _ ANY;
		p("quotedbl") > p("quotedblbase") / p("parenleft") _ ANY;
	endif;

	if (lng==CSY || lng==DEU || lng==HUN || lng==PLK || lng==ROM || lng==SRP || lng==SRPL)
		p("quotedbl") > p("quotedblbase") / U+0020 _ ANY;
		p("quotedbl") > p("quotedblbase") / p("parenleft") _ ANY;
	else if (lng == AFK || lng == CAT || lng == ENG || lng==ESP || lng==NLD || lng==PTG || lng==TRK) 
		p("quotedbl") > p("quotedblleft") / U+0020 _ ANY;
		p("quotedbl") > p("quotedblleft") / p("parenleft") _ ANY;
	else if (lng == FIN || lng == SVE)
		p("quotedbl") > p("quotedblright") / U+0020 _ ANY;
		p("quotedbl") > p("quotedblright") / p("parenleft") _ ANY;
	endif;

	if (lng == AFK || lng == CAT || lng == ENG || lng == ESP || lng==HUN || lng == FIN || lng==NLD || lng == PLK || lng == PTG || lng==ROM || lng == SVE || lng == TRK)
		p("quotedbl") > p("quotedblright") / ANY _ punctsp;
	else if (lng == CSY || lng == DEU || lng == SRP || lng == SRPL)
		p("quotedbl") > p("quotedblleft") / ANY _ punctsp;
	endif;

	p("quotedbl") > p("quotedbl") / ANY _ ANY;

	if (lng==CSY || lng==DEU || lng==HUN || lng==PLK || lng==ROM || lng==SRP || lng==SRPL)
		p("quotedbl") > p("quotedblbase") / _ ANY;
	else if (lng == AFK || lng == CAT || lng == ENG || lng==ESP || lng==NLD || lng==PTG || lng==TRK) 
		p("quotedbl") > p("quotedblleft") / _ ANY;
	else if (lng == FIN || lng == SVE)
		p("quotedbl") > p("quotedblright") / _ ANY;
	endif;

	if (lng == AFK || lng == CAT || lng == ENG || lng == ESP || lng==HUN || lng == FIN || lng==NLD || lng == PLK || lng == PTG || lng==ROM || lng == SVE || lng == TRK)
		p("quotedbl") > p("quotedblright") / ANY _;
	else if (lng == CSY || lng == DEU || lng == SRP || lng == SRPL)
		p("quotedbl") > p("quotedblleft") / ANY _;
	endif;
endif;
"""


