/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * BaselineInfo.java
 * ------------
 */
package org.pentaho.reporting.libraries.fonts.registry;

/**
 * Creation-Date: 24.07.2006, 18:36:21
 *
 * @author Thomas Morgner
 */
public final class BaselineInfo
{
  public static final int HANGING = 0;
  public static final int MATHEMATICAL = 1;
  public static final int CENTRAL = 2;
  public static final int MIDDLE = 3;
  public static final int ALPHABETIC = 4;
  public static final int IDEOGRAPHIC = 5;

  private long[] baselines;
  private int dominantBaseline;

  public BaselineInfo()
  {
    this.baselines = new long[6];
  }

  public long[] getBaselines()
  {
    return (long[]) baselines.clone();
  }

  public void update(final BaselineInfo parent)
  {
    System.arraycopy(parent.baselines, 0, this.baselines, 0, 6);
    dominantBaseline = parent.dominantBaseline;
  }

  public void setBaselines(final long[] baselines)
  {
    if (baselines.length != 6)
    {
      throw new IllegalArgumentException();
    }
    System.arraycopy(baselines, 0, this.baselines, 0, 6);
  }

  public long getBaseline (final int indx)
  {
    return baselines[indx];
  }

  public void setBaseline (final int idx, final long baseline)
  {
    baselines[idx] = baseline;
  }

  public int getDominantBaseline()
  {
    return dominantBaseline;
  }

  public void setDominantBaseline(final int dominantBaseline)
  {
    this.dominantBaseline = dominantBaseline;
  }
}
