/**
 * ================================================
 * LibLoader : a free Java resource loading library
 * ================================================
 *
 * Project Info:  http://reporting.pentaho.org/libloader/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * LibLoaderInfo.java
 * ------------
 */

package org.pentaho.reporting.libraries.resourceloader;

import org.pentaho.reporting.libraries.base.LibBaseInfo;
import org.pentaho.reporting.libraries.base.versioning.DependencyInformation;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

public class LibLoaderInfo extends ProjectInformation
{
  private static LibLoaderInfo instance;

  public static LibLoaderInfo getInstance()
  {
    if (instance == null)
    {
      instance = new LibLoaderInfo();
      instance.initialize();
    }
    return instance;
  }

  /**
   * Constructs an empty project info object.
   */
  public LibLoaderInfo()
  {
    super("libloader", "LibLoader");
  }

  private void initialize()
  {
    setLicenseName("LGPL");

    setInfo("http://reporting.pentaho.org/libloader/");
    setCopyright("(C)opyright 2006,2007, by Pentaho Corporation and Contributors");

    setBootClass(LibLoaderBoot.class.getName());

    addLibrary(LibBaseInfo.getInstance());
    addOptionalLibrary("org.pentaho.reporting.libraries.pixie.PixieInfo");
    addOptionalLibrary(new DependencyInformation("OSCache", "2.3", "The OpenSymphony Software License",
        "http://www.opensymphony.com/oscache/license.action"));
    addOptionalLibrary(new DependencyInformation("EHCache", "1.2rc1", "Apache Licence 2.0",
        "http://ehcache.sourceforge.net/"));
    addOptionalLibrary(new DependencyInformation("Batik", "1.6", "Apache Software License",
        "http://xml.apache.org/batik"));
  }
}
