/* gsd-swap-operation.c generated by valac 0.12.0, the Vala compiler
 * generated from gsd-swap-operation.vala, do not modify */

/* 
 * 
 * Copyright (C) 2009-2011 Colomban Wendling <ban@herbesfolles.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <config.h>


#define GSD_TYPE_ASYNC_OPERATION (gsd_async_operation_get_type ())
#define GSD_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperation))
#define GSD_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))
#define GSD_IS_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_ASYNC_OPERATION))
#define GSD_IS_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_ASYNC_OPERATION))
#define GSD_ASYNC_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))

typedef struct _GsdAsyncOperation GsdAsyncOperation;
typedef struct _GsdAsyncOperationClass GsdAsyncOperationClass;
typedef struct _GsdAsyncOperationPrivate GsdAsyncOperationPrivate;

#define GSD_TYPE_SECURE_DELETE_OPERATION (gsd_secure_delete_operation_get_type ())
#define GSD_SECURE_DELETE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperation))
#define GSD_SECURE_DELETE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperationClass))
#define GSD_IS_SECURE_DELETE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_SECURE_DELETE_OPERATION))
#define GSD_IS_SECURE_DELETE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_SECURE_DELETE_OPERATION))
#define GSD_SECURE_DELETE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperationClass))

typedef struct _GsdSecureDeleteOperation GsdSecureDeleteOperation;
typedef struct _GsdSecureDeleteOperationClass GsdSecureDeleteOperationClass;
typedef struct _GsdSecureDeleteOperationPrivate GsdSecureDeleteOperationPrivate;

#define GSD_TYPE_ZEROABLE_OPERATION (gsd_zeroable_operation_get_type ())
#define GSD_ZEROABLE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperation))
#define GSD_ZEROABLE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperationClass))
#define GSD_IS_ZEROABLE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_ZEROABLE_OPERATION))
#define GSD_IS_ZEROABLE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_ZEROABLE_OPERATION))
#define GSD_ZEROABLE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperationClass))

typedef struct _GsdZeroableOperation GsdZeroableOperation;
typedef struct _GsdZeroableOperationClass GsdZeroableOperationClass;
typedef struct _GsdZeroableOperationPrivate GsdZeroableOperationPrivate;

#define GSD_TYPE_SWAP_OPERATION (gsd_swap_operation_get_type ())
#define GSD_SWAP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_SWAP_OPERATION, GsdSwapOperation))
#define GSD_SWAP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_SWAP_OPERATION, GsdSwapOperationClass))
#define GSD_IS_SWAP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_SWAP_OPERATION))
#define GSD_IS_SWAP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_SWAP_OPERATION))
#define GSD_SWAP_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_SWAP_OPERATION, GsdSwapOperationClass))

typedef struct _GsdSwapOperation GsdSwapOperation;
typedef struct _GsdSwapOperationClass GsdSwapOperationClass;
typedef struct _GsdSwapOperationPrivate GsdSwapOperationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

typedef enum  {
	GSD_ASYNC_OPERATION_ERROR_CHILD_FAILED,
	GSD_ASYNC_OPERATION_ERROR_SUBCLASS_ERROR
} GsdAsyncOperationError;
#define GSD_ASYNC_OPERATION_ERROR gsd_async_operation_error_quark ()
struct _GsdAsyncOperation {
	GObject parent_instance;
	GsdAsyncOperationPrivate * priv;
	guint n_passes;
	guint passes;
	GPid pid;
	gint fd_in;
	gint fd_out;
	gint fd_err;
};

struct _GsdAsyncOperationClass {
	GObjectClass parent_class;
	GList* (*build_args) (GsdAsyncOperation* self, GError** error);
	gchar** (*build_env) (GsdAsyncOperation* self, int* result_length1);
	void (*cleanup) (GsdAsyncOperation* self);
	guint (*get_max_progress) (GsdAsyncOperation* self);
	guint (*get_progress) (GsdAsyncOperation* self);
	gchar* (*get_subprocess_error_msg) (GsdAsyncOperation* self);
};

struct _GsdSecureDeleteOperation {
	GsdAsyncOperation parent_instance;
	GsdSecureDeleteOperationPrivate * priv;
};

struct _GsdSecureDeleteOperationClass {
	GsdAsyncOperationClass parent_class;
};

struct _GsdZeroableOperation {
	GsdSecureDeleteOperation parent_instance;
	GsdZeroableOperationPrivate * priv;
};

struct _GsdZeroableOperationClass {
	GsdSecureDeleteOperationClass parent_class;
};

struct _GsdSwapOperation {
	GsdZeroableOperation parent_instance;
	GsdSwapOperationPrivate * priv;
};

struct _GsdSwapOperationClass {
	GsdZeroableOperationClass parent_class;
};

struct _GsdSwapOperationPrivate {
	gchar* _device;
	gboolean _check_device;
};


static gpointer gsd_swap_operation_parent_class = NULL;

GType gsd_async_operation_get_type (void) G_GNUC_CONST;
GQuark gsd_async_operation_error_quark (void);
GType gsd_secure_delete_operation_get_type (void) G_GNUC_CONST;
GType gsd_zeroable_operation_get_type (void) G_GNUC_CONST;
GType gsd_swap_operation_get_type (void) G_GNUC_CONST;
#define GSD_SWAP_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GSD_TYPE_SWAP_OPERATION, GsdSwapOperationPrivate))
enum  {
	GSD_SWAP_OPERATION_DUMMY_PROPERTY,
	GSD_SWAP_OPERATION_DEVICE,
	GSD_SWAP_OPERATION_CHECK_DEVICE
};
static gboolean gsd_swap_operation_swap_is_in_use (GsdSwapOperation* self, const gchar* swapdev);
static GList* gsd_swap_operation_real_build_args (GsdAsyncOperation* base, GError** error);
const gchar* gsd_swap_operation_get_device (GsdSwapOperation* self);
gboolean gsd_swap_operation_get_check_device (GsdSwapOperation* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GList* gsd_async_operation_build_args (GsdAsyncOperation* self, GError** error);
static void gsd_swap_operation_real_cleanup (GsdAsyncOperation* base);
void gsd_swap_operation_set_device (GsdSwapOperation* self, const gchar* value);
gboolean gsd_swap_operation_run (GsdSwapOperation* self, const gchar* device, GError** error);
gboolean gsd_secure_delete_operation_run (GsdSecureDeleteOperation* self, GError** error);
gboolean gsd_swap_operation_run_sync (GsdSwapOperation* self, const gchar* device, GError** error);
gboolean gsd_secure_delete_operation_run_sync (GsdSecureDeleteOperation* self, GError** error);
GsdSwapOperation* gsd_swap_operation_new (void);
GsdSwapOperation* gsd_swap_operation_construct (GType object_type);
GsdZeroableOperation* gsd_zeroable_operation_construct (GType object_type);
void gsd_swap_operation_set_check_device (GsdSwapOperation* self, gboolean value);
static GObject * gsd_swap_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void gsd_async_operation_set_path (GsdAsyncOperation* self, const gchar* value);
static void gsd_swap_operation_finalize (GObject* obj);
static void _vala_gsd_swap_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gsd_swap_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		if (!(c != EOF)) {
			break;
		}
		if (ret == NULL) {
			GString* _tmp1_ = NULL;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == '\n') {
			break;
		}
		g_string_append_c (ret, (gchar) c);
	}
	if (ret == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (ret->str);
		result = _tmp2_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static gboolean gsd_swap_operation_swap_is_in_use (GsdSwapOperation* self, const gchar* swapdev) {
	gboolean result = FALSE;
	gboolean in_use;
	gsize _tmp0_;
	gsize swapdev_len;
	FILE* _tmp1_ = NULL;
	FILE* file;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (swapdev != NULL, FALSE);
	in_use = FALSE;
	_tmp0_ = strlen (swapdev);
	swapdev_len = _tmp0_;
	_tmp1_ = fopen ("/proc/swaps", "r");
	file = _tmp1_;
	if (file != NULL) {
		gchar* line;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		line = NULL;
		_tmp2_ = g_file_stream_read_line (file);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp3_);
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar* _tmp6_ = NULL;
				if (!_tmp4_) {
					gboolean _tmp5_ = FALSE;
					if (line != NULL) {
						_tmp5_ = !in_use;
					} else {
						_tmp5_ = FALSE;
					}
					if (!_tmp5_) {
						break;
					}
				}
				_tmp4_ = FALSE;
				_tmp6_ = g_file_stream_read_line (file);
				_g_free0 (line);
				line = _tmp6_;
				if (line != NULL) {
					gboolean _tmp7_ = FALSE;
					gboolean _tmp8_;
					_tmp8_ = g_str_has_prefix (line, swapdev);
					if (_tmp8_) {
						const gchar* _tmp9_ = NULL;
						_tmp9_ = g_utf8_strchr (" \t", (gssize) (-1), (gunichar) ((gchar*) line)[swapdev_len]);
						_tmp7_ = _tmp9_ != NULL;
					} else {
						_tmp7_ = FALSE;
					}
					in_use = _tmp7_;
				}
			}
		}
		_g_free0 (line);
	}
	result = in_use;
	_fclose0 (file);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static GList* gsd_swap_operation_real_build_args (GsdAsyncOperation* base, GError** error) {
	GsdSwapOperation * self;
	GList* result = NULL;
	GList* args;
	gboolean _tmp0_ = FALSE;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (GsdSwapOperation*) base;
	g_return_val_if_fail (self->priv->_device != NULL, NULL);
	args = NULL;
	if (self->priv->_check_device) {
		gboolean _tmp1_;
		_tmp1_ = gsd_swap_operation_swap_is_in_use (self, self->priv->_device);
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new (GSD_ASYNC_OPERATION_ERROR, GSD_ASYNC_OPERATION_ERROR_SUBCLASS_ERROR, "The swap device \"%s\" is in use", self->priv->_device);
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_free0_0 (args);
			return NULL;
		} else {
			__g_list_free__g_free0_0 (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = GSD_ASYNC_OPERATION_CLASS (gsd_swap_operation_parent_class)->build_args ((GsdAsyncOperation*) GSD_ZEROABLE_OPERATION (self), &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_free0_0 (args);
			return NULL;
		} else {
			__g_list_free__g_free0_0 (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	__g_list_free__g_free0_0 (args);
	args = _tmp4_;
	_tmp5_ = g_strdup (self->priv->_device);
	args = g_list_append (args, _tmp5_);
	result = args;
	return result;
}


static void gsd_swap_operation_real_cleanup (GsdAsyncOperation* base) {
	GsdSwapOperation * self;
	self = (GsdSwapOperation*) base;
	gsd_swap_operation_set_device (self, NULL);
}


/**
     * Launches a secure wiping of a swap device asynchronously.
     * 
     * @param device the swap device to wipe. It is exactly the same as setting
     *    the SwapOperation:device property, just a convenience shortcut.
     * 
     * @return whether subprocess started successfully.
     */
gboolean gsd_swap_operation_run (GsdSwapOperation* self, const gchar* device, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (device != NULL) {
		gsd_swap_operation_set_device (self, device);
	}
	_tmp0_ = gsd_secure_delete_operation_run ((GsdSecureDeleteOperation*) GSD_ZEROABLE_OPERATION (self), &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


/**
     * Launches a secure wiping of a swap device synchronously.
     * 
     * @param device the swap device to wipe. It is exactly the same as setting
     *    the SwapOperation:device property, just a convenience shortcut.
     * 
     * @return whether wiping of the swap device succeed.
     */
gboolean gsd_swap_operation_run_sync (GsdSwapOperation* self, const gchar* device, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (device != NULL) {
		gsd_swap_operation_set_device (self, device);
	}
	_tmp0_ = gsd_secure_delete_operation_run_sync ((GsdSecureDeleteOperation*) GSD_ZEROABLE_OPERATION (self), &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


GsdSwapOperation* gsd_swap_operation_construct (GType object_type) {
	GsdSwapOperation * self = NULL;
	self = (GsdSwapOperation*) gsd_zeroable_operation_construct (object_type);
	return self;
}


GsdSwapOperation* gsd_swap_operation_new (void) {
	return gsd_swap_operation_construct (GSD_TYPE_SWAP_OPERATION);
}


const gchar* gsd_swap_operation_get_device (GsdSwapOperation* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_device;
	return result;
}


void gsd_swap_operation_set_device (GsdSwapOperation* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_device);
	self->priv->_device = _tmp0_;
	g_object_notify ((GObject *) self, "device");
}


gboolean gsd_swap_operation_get_check_device (GsdSwapOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_check_device;
	return result;
}


void gsd_swap_operation_set_check_device (GsdSwapOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_check_device = value;
	g_object_notify ((GObject *) self, "check-device");
}


static GObject * gsd_swap_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GsdSwapOperation * self;
	parent_class = G_OBJECT_CLASS (gsd_swap_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GSD_SWAP_OPERATION (obj);
	gsd_async_operation_set_path ((GsdAsyncOperation*) self, SSWAP_PATH);
	return obj;
}


static void gsd_swap_operation_class_init (GsdSwapOperationClass * klass) {
	gsd_swap_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GsdSwapOperationPrivate));
	GSD_ASYNC_OPERATION_CLASS (klass)->build_args = gsd_swap_operation_real_build_args;
	GSD_ASYNC_OPERATION_CLASS (klass)->cleanup = gsd_swap_operation_real_cleanup;
	G_OBJECT_CLASS (klass)->get_property = _vala_gsd_swap_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gsd_swap_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = gsd_swap_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = gsd_swap_operation_finalize;
	/**
	     * The swap device to wipe.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_SWAP_OPERATION_DEVICE, g_param_spec_string ("device", "device", "device", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether to throw an error if the swap is detected as being currently
	     * used.
	     * 
	     * This may be useful because doing the operation on an in-use swap device
	     * may crash the system.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_SWAP_OPERATION_CHECK_DEVICE, g_param_spec_boolean ("check-device", "check-device", "check-device", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gsd_swap_operation_instance_init (GsdSwapOperation * self) {
	self->priv = GSD_SWAP_OPERATION_GET_PRIVATE (self);
	self->priv->_device = NULL;
	self->priv->_check_device = TRUE;
}


static void gsd_swap_operation_finalize (GObject* obj) {
	GsdSwapOperation * self;
	self = GSD_SWAP_OPERATION (obj);
	_g_free0 (self->priv->_device);
	G_OBJECT_CLASS (gsd_swap_operation_parent_class)->finalize (obj);
}


/**
   * Wrapper for //sswap//.
   */
GType gsd_swap_operation_get_type (void) {
	static volatile gsize gsd_swap_operation_type_id__volatile = 0;
	if (g_once_init_enter (&gsd_swap_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GsdSwapOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gsd_swap_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GsdSwapOperation), 0, (GInstanceInitFunc) gsd_swap_operation_instance_init, NULL };
		GType gsd_swap_operation_type_id;
		gsd_swap_operation_type_id = g_type_register_static (GSD_TYPE_ZEROABLE_OPERATION, "GsdSwapOperation", &g_define_type_info, 0);
		g_once_init_leave (&gsd_swap_operation_type_id__volatile, gsd_swap_operation_type_id);
	}
	return gsd_swap_operation_type_id__volatile;
}


static void _vala_gsd_swap_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GsdSwapOperation * self;
	self = GSD_SWAP_OPERATION (object);
	switch (property_id) {
		case GSD_SWAP_OPERATION_DEVICE:
		g_value_set_string (value, gsd_swap_operation_get_device (self));
		break;
		case GSD_SWAP_OPERATION_CHECK_DEVICE:
		g_value_set_boolean (value, gsd_swap_operation_get_check_device (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gsd_swap_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GsdSwapOperation * self;
	self = GSD_SWAP_OPERATION (object);
	switch (property_id) {
		case GSD_SWAP_OPERATION_DEVICE:
		gsd_swap_operation_set_device (self, g_value_get_string (value));
		break;
		case GSD_SWAP_OPERATION_CHECK_DEVICE:
		gsd_swap_operation_set_check_device (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



