/*
	     Format Manager Window Creation, Management, and Deletion
 */

#ifndef FORMATMANAGER_H
#define FORMATMANAGER_H

#include <stdio.h>
#include <gtk/gtk.h>

#include "../pulist.h"
#include "../lib/endeavour2.h"


/*
 *	Format Stages:
 */
typedef enum {
	FORMAT_STAGE_FORMAT,
	FORMAT_STAGE_MKFS
} fm_format_stage;
#define FORMAT_STAGE_HIGHEST		FORMAT_STAGE_MKFS


/*
 *	Format Manager Window:
 */
typedef struct {

	GtkWidget	*toplevel;
	gboolean	map_state;
	gint		busy_count,
			freeze_count;
	GtkAccelGroup	*accelgrp;
	GdkColormap	*colormap;
	GdkGC		*gc;
	edv_context_struct *ctx;

	GdkCursor	*busy_cur,
			*text_cur;

	GdkColor	error_color;
	GdkFont		*text_font;

	GtkWidget	*main_vbox,
			*devices_clist,
			*quick_format_check,
			*volume_label_entry,
			*verbose_check,
			*output_text,
			*progress_bar;

	pulistbox_struct	*capacity_pulistbox,
				*filesystem_type_pulistbox;

	GtkWidget	*devices_menu,
			*devices_start_mi,
			*devices_stop_mi;

	GtkWidget	*disk_anim_da;
	GdkPixmap	*disk_anim_pm;

	GdkPixmap	**disk_icon_pixmap;
	GdkBitmap	**disk_icon_mask;
	gint		last_disk_icon_num, total_disk_icons;

	GtkWidget	*start_btn,
			*stop_btn,
			*clear_btn,
			*close_btn;

	/* Queued this of rows in the devices_clist that we need
	 * to check.
	 */
	GList		*queued_device_to_format;

	fm_format_stage	format_stage;
	guint		format_toid;
	pid_t		format_pid;
	FILE		*stdout_fp, *stderr_fp;
	gchar		*stdout_path, *stderr_path;

	gint		stop_count;
	gfloat		progress_pos_last;

	/* List of devices. */
	edv_device_struct	**device;
	gint			total_devices;

} format_manager_struct;
#define FORMAT_MANAGER(p)	((format_manager_struct *)(p))


extern void FormatManagerSetDevices(
	format_manager_struct *fm,
	edv_device_struct **device, gint total_devices
);
extern void FormatManagerAppendMessage(
	format_manager_struct *fm,
	GdkFont *font, GdkColor *color_fg, GdkColor *color_bg,
	const gchar *text,
	gboolean allow_auto_scroll
);

extern format_manager_struct *FormatManagerNew(edv_context_struct *ctx);
extern void FormatManagerUpdateMenus(format_manager_struct *fm);
extern void FormatManagerSetBusy(format_manager_struct *fm, gboolean is_busy);
extern void FormatManagerSetProgress(
	format_manager_struct *fm, gfloat value,
	gboolean allow_gtk_iteration
);
extern void FormatManagerMap(format_manager_struct *fm);
extern void FormatManagerUnmap(format_manager_struct *fm);
extern void FormatManagerDelete(format_manager_struct *fm);


#endif	/* FORMATMANAGER_H */
