/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.parser.Ajax;
import org.emboss.jemboss.programs.RunEmbossApplication2;
import org.emboss.jemboss.server.AppendToLogFileThread;

public class JembossAuthServer {
    final JembossParams jp = new JembossParams();
    private String tmproot = this.jp.getResultsHome();
    private final String logFile = new String(this.tmproot + "/jemboss.log");
    private final String errorLog = new String(this.tmproot + "/jemboss_error.log");
    private final String fs = File.separator;
    private final String ps = File.pathSeparator;
    private final String ls = System.getProperty("line.separator");
    final String plplot = this.jp.getPlplot();
    final String embossData = this.jp.getEmbossData();
    final String embossBin = this.jp.getEmbossBin();
    final String embossPath = this.embossBin + this.ps + this.jp.getEmbossPath();
    private final String[] env = new String[]{"PATH=" + this.embossPath, "PLPLOT_LIB=" + this.plplot, "EMBOSS_DATA=" + this.embossData};
    private final String environ = "PATH=" + this.embossPath + " " + "PLPLOT_LIB=" + this.plplot + " " + "EMBOSS_DATA=" + this.embossData + " " + this.jp.getEmbossEnvironment();

    public JembossAuthServer() {
        File logDir = new File(this.tmproot);
        if (!this.tmproot.endsWith(this.fs)) {
            this.tmproot = this.tmproot + this.fs;
        }
        if (!logDir.exists()) {
            logDir.mkdirs();
            try {
                Runtime.getRuntime().exec("chmod 1777 " + this.tmproot);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Vector show_acd(String appName) {
        Vector<String> acd = new Vector<String>(4);
        StringBuffer acdText = new StringBuffer();
        String acdToParse = new String(this.jp.getAcdDirToParse() + appName + ".acd");
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(acdToParse));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#") || line.equals("")) continue;
                line = line.trim();
                line = line.replace('}', ')');
                acdText.append(line + "\n");
            }
        }
        catch (IOException e) {
            this.appendToLogFile("Cannot open EMBOSS acd file " + acdToParse, this.errorLog);
        }
        acd.add("status");
        acd.add("0");
        acd.add("acd");
        acd.add(acdText.toString());
        return acd;
    }

    public Vector getWossname() {
        String[] envp = this.jp.getEmbossEnvironmentArray(this.env);
        Vector<String> wossOut = new Vector<String>(4);
        String embossCommand = new String(this.embossBin + "wossname -colon -gui -auto");
        RunEmbossApplication2 rea = new RunEmbossApplication2(embossCommand, envp, null);
        rea.waitFor();
        wossOut.add("status");
        wossOut.add(rea.getStatus());
        wossOut.add("wossname");
        wossOut.add(rea.getProcessStdout());
        return wossOut;
    }

    public Vector show_help(String applName) {
        String[] envp = this.jp.getEmbossEnvironmentArray(this.env);
        String command = this.embossBin.concat("tfm " + applName + " -html -nomore");
        RunEmbossApplication2 rea = new RunEmbossApplication2(command, envp, null);
        rea.waitFor();
        String helptext = rea.getProcessStdout();
        if (helptext.equals("")) {
            helptext = "No help available for this application.";
        }
        Vector<String> vans = new Vector<String>(2);
        vans.add("helptext");
        vans.add(helptext);
        return vans;
    }

    public Vector call_ajax(String fileContent, String seqtype, String userName, byte[] passwd) {
        Ajax aj = new Ajax();
        Vector<Object> vans = new Vector<Object>(8);
        if (!this.verifyUser(aj, userName, passwd, vans)) {
            vans.trimToSize();
            return vans;
        }
        boolean afile = false;
        boolean fexists = false;
        if (fileContent.startsWith(this.fs)) {
            int ind = fileContent.lastIndexOf(this.fs);
            String fdir = fileContent.substring(0, ind);
            String ffile = fileContent.substring(ind + 1).trim();
            boolean ok = aj.listFiles(userName, passwd, this.environ, fdir);
            if (!ok) {
                return this.returnError(aj, "listFiles error in call_ajax", userName);
            }
            if (aj.getOutStd().indexOf(this.fs + ffile + "\n") > -1) {
                fexists = true;
            } else {
                return this.returnError(aj, "listFiles error in call_ajax", userName);
            }
        }
        String fn = null;
        if (!(fileContent.indexOf(":") >= 0 && fileContent.indexOf("\n") <= 0 || fexists)) {
            try {
                fn = this.tmproot + this.fs + userName + this.fs + ".jembosstmp";
                boolean ok = aj.putFile(userName, passwd, this.environ, fn, fileContent.getBytes());
                if (!ok) {
                    return this.returnError(aj, "putFile error in call_ajax", userName);
                }
                afile = true;
            }
            catch (Exception ioe) {
                String dat = new Date().toString();
                dat = dat.replace(':', '_');
                this.appendToLogFile(userName + ":: " + dat + " Exception: call_ajax creating " + fn, this.errorLog);
                vans.add("status");
                vans.add("1");
                vans.trimToSize();
                return vans;
            }
        } else {
            fn = fileContent;
        }
        if (fexists || afile || fn.indexOf(":") > 0) {
            boolean ok = false;
            try {
                ok = seqtype.startsWith("seqset") ? aj.seqsetAttrib(userName, passwd, this.environ, fn) : aj.seqAttrib(userName, passwd, this.environ, fn);
                if (!ok) {
                    return this.returnError(aj, "seqAttrib or seqsetAttrib error", userName);
                }
            }
            catch (Exception e) {
                String dat = new Date().toString();
                dat = dat.replace(':', '_');
                this.appendToLogFile(userName + ":: " + dat + " Exception: call_ajax status not ok", this.errorLog);
                vans.add("status");
                vans.add("1");
                vans.trimToSize();
                return vans;
            }
        }
        if (afile) {
            aj.delFile(userName, passwd, this.environ, fn);
        }
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        vans.add("length");
        vans.add(new Integer(aj.length_soap));
        vans.add("protein");
        vans.add(new Boolean(aj.protein_soap));
        vans.add("weight");
        vans.add(new Float(aj.weight_soap));
        vans.add("status");
        vans.add("0");
        return vans;
    }

    public Vector call_ajax(String fileContent, String seqtype) {
        boolean afile = false;
        String fn = null;
        File tf = null;
        Vector<Object> vans = new Vector<Object>(8);
        if (!(fileContent.indexOf(":") >= 0 && fileContent.indexOf("\n") <= 0 || new File(fileContent).exists())) {
            afile = true;
            try {
                File tmprootDir = new File(this.tmproot);
                tf = File.createTempFile("tmp", ".jembosstmp", tmprootDir);
                PrintWriter out = new PrintWriter(new FileWriter(tf));
                out.println(fileContent);
                out.close();
                fn = new String(tf.getCanonicalPath());
            }
            catch (IOException ioe) {
                this.appendToLogFile("IOException: call_ajax creating tmp.jembosstmp", this.errorLog);
                vans.add("status");
                vans.add("1");
                vans.trimToSize();
                return vans;
            }
        } else {
            fn = fileContent;
        }
        boolean ok = false;
        Ajax aj = null;
        if (new File(fn).exists() || fn.indexOf(":") > 0) {
            try {
                aj = new Ajax();
                ok = seqtype.startsWith("seqset") ? aj.seqsetType(fn) : aj.seqType(fn);
            }
            catch (Exception e) {
                this.appendToLogFile("Exception: call_ajax status not ok", this.errorLog);
                vans.add("status");
                vans.add("1");
                vans.trimToSize();
                return vans;
            }
        }
        if (ok) {
            vans.add("length");
            vans.add(new Integer(Ajax.length));
            vans.add("protein");
            vans.add(new Boolean(Ajax.protein));
            vans.add("weight");
            vans.add(new Float(Ajax.weight));
            vans.add("status");
            vans.add("0");
        } else {
            this.appendToLogFile("Error: call_ajax status not ok", this.errorLog);
            vans.add("status");
            vans.add("1");
            vans.trimToSize();
        }
        if (afile) {
            tf.delete();
        }
        return vans;
    }

    public Vector show_db() {
        int i;
        String[] envp = this.jp.getEmbossEnvironmentArray(this.env);
        Vector<String> showdbOut = new Vector<String>(8);
        String embossCommand = new String(this.embossBin + "showdb -auto");
        RunEmbossApplication2 rea = new RunEmbossApplication2(embossCommand, envp, null);
        rea.waitFor();
        showdbOut.add("status");
        showdbOut.add(rea.getStatus());
        if (!rea.getStatus().equals("0")) {
            showdbOut.trimToSize();
            return showdbOut;
        }
        showdbOut.add("showdb");
        showdbOut.add(rea.getProcessStdout());
        String[] dataFile = new File(this.embossData).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("EPAM") || name.startsWith("EBLOSUM") || name.startsWith("EDNA");
            }
        });
        StringBuffer matrices = new StringBuffer();
        for (i = 0; i < dataFile.length; ++i) {
            matrices.append(dataFile[i] + "\n");
        }
        showdbOut.add("matrices");
        showdbOut.add(matrices.toString());
        dataFile = new File(this.embossData + this.fs + "CODONS").list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File fileName = new File(dir, name);
                return !fileName.isDirectory();
            }
        });
        matrices = new StringBuffer();
        for (i = 0; i < dataFile.length; ++i) {
            matrices.append(dataFile[i] + "\n");
        }
        showdbOut.add("codons");
        showdbOut.add(matrices.toString());
        showdbOut.add("doesJembossServerSupportPDFoutput");
        showdbOut.add(Boolean.toString(this.jp.getEmbossHavePDF()));
        return showdbOut;
    }

    public synchronized Vector run_prog(String embossCommand, String options, Vector inFiles, String userName, byte[] passwd) {
        this.tmproot = this.tmproot.concat(userName + this.fs);
        Ajax aj = new Ajax();
        Vector result = new Vector(6, 1);
        if (!this.verifyUser(aj, userName, passwd, result)) {
            return result;
        }
        String dat = new Date().toString();
        dat = dat.replace(':', '_');
        if (embossCommand.indexOf(";") > -1) {
            String warn = new String(userName + ":: " + dat + " ERROR: Disallowed command syntax " + embossCommand);
            this.appendToLogFile(warn, this.errorLog);
            result.add("msg");
            result.add(warn);
            result.add("status");
            result.add("1");
            result.trimToSize();
            return result;
        }
        int stdIndex = embossCommand.indexOf(" stdout ");
        if (stdIndex > -1) {
            String startCmd = embossCommand.substring(0, stdIndex + 7);
            String endCmd = embossCommand.substring(stdIndex + 8);
            embossCommand = startCmd.concat("file ");
            embossCommand = embossCommand.concat(endCmd);
        }
        boolean ok = false;
        try {
            aj.setErrStd();
            ok = aj.listDirs(userName, passwd, this.environ, this.tmproot);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (!ok) {
            try {
                aj.setErrStd();
                ok = aj.makeDir(userName, passwd, this.environ, this.tmproot);
            }
            catch (Exception exp) {
                // empty catch block
            }
            if (ok) {
                this.appendToLogFile(userName + ":: " + dat + " Created directory " + this.tmproot, this.errorLog);
            } else {
                String warnmsg = new String(userName + ":: " + dat + " Failed to create dir " + this.tmproot + "\nSTDERR :" + aj.getErrStd());
                this.appendToLogFile(warnmsg, this.errorLog);
                result.add("msg");
                result.add(warnmsg);
                result.add("status");
                result.add("1");
                result.trimToSize();
                return result;
            }
        }
        String appl = embossCommand.substring(0, embossCommand.indexOf(" "));
        Random rnd = new Random();
        String project = new String(this.tmproot + appl + "_" + dat.replace(' ', '_') + "_" + rnd.nextInt(99999));
        try {
            aj.setErrStd();
            ok = aj.makeDir(userName, passwd, this.environ, project);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (!ok) {
            return this.returnError(aj, "run_prog failed to create dir " + project, userName);
        }
        StringBuffer descript = new StringBuffer();
        descript.append("EMBOSS run details for ");
        descript.append(appl);
        descript.append(this.ls);
        descript.append(this.ls);
        descript.append("Parameters Used: ");
        descript.append(embossCommand);
        descript.append(this.ls);
        descript.append("Started: ");
        descript.append(dat);
        descript.append(this.ls);
        descript.append(this.ls);
        descript.append("Input files:");
        descript.append(this.ls);
        Vector<String> inFileNames = new Vector<String>();
        Enumeration e = inFiles.elements();
        while (e.hasMoreElements()) {
            String thiskey = (String)e.nextElement();
            inFileNames.add(thiskey);
            descript.append(project);
            descript.append(this.fs);
            descript.append(thiskey);
            descript.append(this.ls);
            ok = false;
            try {
                aj.setErrStd();
                ok = aj.putFile(userName, passwd, this.environ, new String(project + this.fs + thiskey), (byte[])e.nextElement());
            }
            catch (Exception exp) {
                // empty catch block
            }
            if (ok) continue;
            return this.returnError(aj, "Failed to make file " + project + this.fs + thiskey, userName);
        }
        ok = false;
        try {
            aj.setErrStd();
            ok = aj.putFile(userName, passwd, this.environ, new String(project + this.fs + ".desc"), descript.toString().getBytes());
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (!ok) {
            return this.returnError(aj, "Failed to make file " + project + this.fs + ".desc", userName);
        }
        new AppendToLogFileThread(userName + ":: " + dat + " " + options + " " + embossCommand, this.logFile, true).start();
        result.add("cmd");
        result.add(embossCommand);
        result.add("status");
        result.add("0");
        File projectDir = new File(project);
        if (options.toLowerCase().indexOf("interactive") > -1) {
            ok = true;
            try {
                aj.setErrStd();
                ok = aj.forkEmboss(userName, passwd, this.environ, embossCommand, project);
            }
            catch (Exception exp) {
                // empty catch block
            }
            String stderr = aj.getErrStd();
            result.add("msg");
            result.add(stderr);
            if (stderr.length() > 0) {
                this.createStderrFile(project, stderr);
            }
            try {
                aj.setErrStd();
                ok = aj.putFile(userName, passwd, this.environ, new String(project + this.fs + ".finished"), new Date().toString().getBytes());
            }
            catch (Exception exp) {
                // empty catch block
            }
            if (!ok) {
                return this.returnError(aj, "putFile error in run_prog", userName);
            }
            result = this.loadFilesContent(aj, userName, passwd, projectDir, project, result, inFileNames);
            for (int i = 0; i < passwd.length; ++i) {
                passwd[i] = 0;
            }
        } else {
            aj.forkBatch(userName, passwd, this.environ, embossCommand, project);
            result.add("msg");
            result.add("");
            result.add("job_submitted");
            result.add("Job " + projectDir.getName() + "submitted.");
            result.add("jobid");
            result.add(projectDir.getName());
            result.add("description");
            result.add(descript + this.ls + "Application pending" + this.ls);
        }
        return result;
    }

    private void createStderrFile(String project, String stderr) {
        File finished = new File(project + this.fs + "stderrfile");
        try {
            PrintWriter fout = new PrintWriter(new FileWriter(finished));
            fout.println(stderr);
            fout.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private String quoteMe(String s) {
        StringBuffer qs = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s.trim(), " ");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken().trim();
            if (tok.equals(" ")) continue;
            qs.append("\"");
            qs.append(tok);
            qs.append("\" ");
        }
        return qs.toString();
    }

    private void runAsPBSBatch(Ajax aj, String userName, byte[] passwd, String project, String embossCommand) {
        StringBuffer scriptIt = new StringBuffer();
        scriptIt.append("#PBS -j oe\n");
        scriptIt.append("#PBS -S /bin/sh\n");
        scriptIt.append(this.environ.replace(' ', '\n'));
        scriptIt.append("\nexport PATH\n");
        scriptIt.append("export PLPLOT_LIB\n");
        scriptIt.append("export EMBOSS_DATA\n");
        scriptIt.append("cd " + project + "\n" + embossCommand + "\n");
        scriptIt.append("date > " + project + "/.finished\n");
        String scriptFile = new String(project + this.fs + ".scriptfile");
        boolean ok = false;
        try {
            ok = aj.putFile(userName, passwd, this.environ, scriptFile, scriptIt.toString().getBytes());
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (!ok) {
            String dat = new Date().toString();
            dat = dat.replace(':', '_');
            this.appendToLogFile(userName + ":: " + dat + " Failed to make file " + project + this.fs + ".scriptfile\n" + "STDERR " + aj.getErrStd() + "\n" + "STDOUT " + aj.getOutStd(), this.errorLog);
        }
        boolean lfork = true;
        try {
            String batchCommand = "/hgmp/local/openpbs/bin/qsub " + scriptFile;
            lfork = aj.forkEmboss(userName, passwd, this.environ, batchCommand, project);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (!lfork || !aj.getErrStd().equals("")) {
            String dat = new Date().toString();
            dat = dat.replace(':', '_');
            this.appendToLogFile(userName + ":: " + dat + " Fork batch process failed " + embossCommand, this.errorLog);
        }
    }

    private void runAsGNQSBatch(Ajax aj, String userName, byte[] passwd, String project, String embossCommand) {
        String scriptIt = "#QSUB -q jemboss-queue\n";
        scriptIt = scriptIt.concat("#QSUB -s /bin/sh\n");
        scriptIt = scriptIt.concat("#QSUB -eo -o report.nqs\n");
        scriptIt = scriptIt.concat(this.environ.replace(' ', '\n'));
        scriptIt = scriptIt.concat("\nexport PATH\n");
        scriptIt = scriptIt.concat("export PLPLOT_LIB\n");
        scriptIt = scriptIt.concat("export EMBOSS_DATA\n");
        scriptIt = scriptIt.concat("cd " + project + "\n" + embossCommand + "\n");
        scriptIt = scriptIt.concat("date > " + project + "/.finished\n");
        String scriptFile = new String(project + this.fs + ".scriptfile");
        boolean ok = false;
        try {
            ok = aj.putFile(userName, passwd, this.environ, scriptFile, scriptIt.getBytes());
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (!ok) {
            String dat = new Date().toString();
            dat = dat.replace(':', '_');
            this.appendToLogFile(userName + ":: " + dat + " Failed to make file " + project + this.fs + ".scriptfile", this.errorLog);
            this.appendToLogFile(userName + ":: " + dat + " STDERR " + aj.getErrStd(), this.errorLog);
            this.appendToLogFile(userName + ":: " + dat + " STDOUT " + aj.getOutStd(), this.errorLog);
        }
        boolean lfork = true;
        try {
            String batchCommand = "/hgmp/local/nqs/bin/qsub " + scriptFile;
            lfork = aj.forkEmboss(userName, passwd, this.environ, batchCommand, project);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (!lfork || !aj.getErrStd().equals("")) {
            String dat = new Date().toString();
            dat = dat.replace(':', '_');
            this.appendToLogFile(userName + ":: " + dat + " Fork batch process failed " + embossCommand, this.errorLog);
        }
    }

    private void runAsBatch(Ajax aj, String userName, byte[] passwd, String project, String embossCommand) {
        String scriptIt = "#!/bin/sh\n";
        scriptIt = scriptIt.concat(this.environ.replace(' ', '\n'));
        scriptIt = scriptIt.concat("\nexport PATH\n");
        scriptIt = scriptIt.concat("export PLPLOT_LIB\n");
        scriptIt = scriptIt.concat("export EMBOSS_DATA\n");
        scriptIt = scriptIt.concat("cd " + project + "\n" + embossCommand + "\n");
        scriptIt = scriptIt.concat("date > " + project + "/.finished\n");
        boolean ok = false;
        try {
            ok = aj.putFile(userName, passwd, this.environ, new String(project + this.fs + ".scriptfile"), scriptIt.getBytes());
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (!ok) {
            String dat = new Date().toString();
            dat = dat.replace(':', '_');
            this.appendToLogFile(userName + ":: " + dat + " Failed to make file " + project + this.fs + ".scriptfile", this.errorLog);
            this.appendToLogFile(userName + ":: " + dat + " STDERR " + aj.getErrStd(), this.errorLog);
            this.appendToLogFile(userName + ":: " + dat + " STDOUT " + aj.getOutStd(), this.errorLog);
        }
        boolean lfork = true;
        try {
            String batchCommand = "/bin/batchQueue.sh " + project + "/.scriptfile ";
            lfork = aj.forkEmboss(userName, passwd, this.environ, batchCommand, project);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (!lfork || !aj.getErrStd().equals("")) {
            String dat = new Date().toString();
            dat = dat.replace(':', '_');
            this.appendToLogFile(userName + ":: " + dat + " Fork batch process failed " + embossCommand, this.errorLog);
        }
    }

    public Vector show_saved_results(String project, String cl, String userName, byte[] passwd) {
        Ajax aj = new Ajax();
        Vector ssr = new Vector();
        if (!this.verifyUser(aj, userName, passwd, ssr)) {
            return ssr;
        }
        project = this.tmproot.concat(userName + this.fs + project);
        if (cl.equals("")) {
            File projectDir = new File(project);
            ssr = this.loadFilesContent(aj, userName, passwd, projectDir, project, ssr, null);
        } else {
            byte[] fbuf = null;
            try {
                fbuf = aj.getFile(userName, passwd, this.environ, project + this.fs + cl);
                ssr.add(cl);
                ssr.add(new String(fbuf));
            }
            catch (Exception exp) {
                // empty catch block
            }
        }
        ssr.add("status");
        ssr.add("0");
        ssr.add("msg");
        ssr.add("OK");
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return ssr;
    }

    public Vector save_project_file(String project, String filename, String notes, String userName, byte[] passwd) {
        Ajax aj = new Ajax();
        Vector<String> v = new Vector<String>(4);
        if (!this.verifyUser(aj, userName, passwd, v)) {
            v.trimToSize();
            return v;
        }
        String fn = this.tmproot + this.fs + userName + this.fs + project + this.fs + filename;
        boolean ok = aj.putFile(userName, passwd, this.environ, fn, notes.getBytes());
        v.add("status");
        v.add("0");
        v.add("msg");
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        if (!ok) {
            return this.returnError(aj, "Failed to save file " + fn, userName);
        }
        v.add("OK");
        return v;
    }

    public Vector delete_saved_results(String project, String cl, String userName, byte[] passwd) {
        Ajax aj = new Ajax();
        Vector<String> dsr = new Vector<String>(4);
        if (!this.verifyUser(aj, userName, passwd, dsr)) {
            dsr.trimToSize();
            return dsr;
        }
        this.tmproot = this.tmproot.concat(userName + this.fs);
        StringTokenizer st = new StringTokenizer(project, "\n");
        while (st.hasMoreTokens()) {
            String proj = this.tmproot.concat(st.nextToken());
            boolean ok = aj.delDir(userName, passwd, this.environ, proj);
            if (ok && aj.getErrStd().equals("")) continue;
            return this.returnError(aj, "Failed deletion of directory " + proj, userName);
        }
        dsr.add("status");
        dsr.add("0");
        dsr.add("msg");
        dsr.add("Results deleted successfully.");
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return dsr;
    }

    public Vector list_saved_results(String userName, byte[] passwd) {
        Ajax aj = new Ajax();
        Vector<String> lsr = new Vector<String>();
        if (!this.verifyUser(aj, userName, passwd, lsr)) {
            return lsr;
        }
        this.tmproot = this.tmproot.concat(userName + this.fs);
        lsr.add("status");
        lsr.add("0");
        lsr.add("msg");
        lsr.add("OK");
        aj.setErrStd();
        aj.listDirs(userName, passwd, this.environ, this.tmproot);
        String outStd = aj.getOutStd();
        int indStart = 0;
        int indEnd = 0;
        while ((indEnd = outStd.indexOf("\n", indStart)) > -1) {
            String dirname = outStd.substring(indStart, indEnd);
            indStart = indEnd + 1;
            lsr.add(dirname);
            byte[] fbuf = aj.getFile(userName, passwd, this.environ, this.tmproot + dirname + this.fs + ".desc");
            lsr.add(new String(fbuf));
            if (aj.getFileok() == 1) continue;
            String dat = new Date().toString();
            dat = dat.replace(':', '_');
            this.appendToLogFile(userName + ":: " + dat + " Calling getFile : " + this.tmproot + dirname + this.fs + ".desc\n" + "STDERR " + aj.getErrStd() + "\n" + "STDOUT " + aj.getOutStd(), this.errorLog);
        }
        lsr.add("list");
        lsr.add(outStd);
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return lsr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToLogFile(String logEntry, String logFileName) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(logFileName, true));
            bw.write(logEntry);
            bw.newLine();
            bw.flush();
        }
        catch (Exception ioe) {
            System.out.println("Error writing to log file " + logFileName);
            ioe.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ioe2) {}
            }
        }
    }

    private Vector loadFilesContent(Ajax aj, String userName, byte[] passwd, File projectDir, String project, Vector result, Vector inFiles) {
        boolean ls = false;
        try {
            ls = aj.listFiles(userName, passwd, this.environ, project);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (!ls) {
            String dat = new Date().toString();
            dat = dat.replace(':', '_');
            this.appendToLogFile(userName + ":: " + dat + " Failed loadFilesContent\n" + "STDERR " + aj.getErrStd() + "\n" + "STDOUT " + aj.getOutStd(), this.errorLog);
        }
        StringTokenizer stok = new StringTokenizer(aj.getOutStd(), "\n");
        String fn = null;
        while (stok.hasMoreTokens()) {
            fn = stok.nextToken();
            if (inFiles != null && inFiles.contains(fn)) continue;
            byte[] fbuf = null;
            try {
                fbuf = aj.getFile(userName, passwd, this.environ, project + this.fs + fn);
            }
            catch (Exception exp) {
                // empty catch block
            }
            if (aj.getFileok() == 1) {
                result.add(fn);
                result.add(fbuf);
                continue;
            }
            String dat = new Date().toString();
            dat = dat.replace(':', '_');
            this.appendToLogFile(userName + ":: " + dat + " Cannot getFile " + project + this.fs + fn, this.errorLog);
        }
        return result;
    }

    public Vector update_result_status(String prog, String opt, Vector resToQuery, String userName, byte[] passwd) {
        Ajax aj = new Ajax();
        Vector<String> vans = new Vector<String>();
        if (!this.verifyUser(aj, userName, passwd, vans)) {
            return vans;
        }
        this.tmproot = this.tmproot.concat(userName + this.fs);
        Enumeration e = resToQuery.elements();
        while (e.hasMoreElements()) {
            String thiskey = (String)e.nextElement();
            e.nextElement();
            try {
                aj.getFile(userName, passwd, this.environ, this.tmproot + thiskey + this.fs + ".finished");
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (aj.getErrStd().indexOf("stat error") == -1 && aj.getFileok() == 1) {
                vans.add(thiskey);
                vans.add("complete");
                byte[] fbuf = aj.getFile(userName, passwd, this.environ, this.tmproot + this.fs + thiskey + this.fs + ".desc");
                if (aj.getFileok() != 1) continue;
                vans.add(thiskey + "-description");
                vans.add(new String(fbuf));
                continue;
            }
            vans.add(thiskey);
            vans.add("pending");
        }
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 0;
        }
        return vans;
    }

    private boolean verifyUser(Ajax aj, String userName, byte[] passwd, Vector res) {
        if (userName == null || passwd == null) {
            res.add("msg");
            res.add("Failed Authorisation ");
            res.add("status");
            res.add("1");
            return false;
        }
        boolean ok = false;
        try {
            ok = aj.userAuth(userName, passwd, this.environ);
        }
        catch (Exception exp) {
            this.appendToLogFile(userName + ":: " + new Date().toString().replace(':', '_') + " Failed Authorisation call " + userName + "\n" + "Error message: " + exp.getMessage(), this.errorLog);
            ok = false;
        }
        if (!ok) {
            String dat = new Date().toString();
            dat = dat.replace(':', '_');
            this.appendToLogFile(userName + ":: " + dat + " Failed Authorisation " + userName + "\n" + "STDERR " + aj.getErrStd(), this.errorLog);
            res.add("msg");
            res.add("Failed Authorisation " + userName);
            res.add("status");
            res.add("1");
            return false;
        }
        return true;
    }

    private Vector returnError(Ajax aj, String msg, String userName) {
        String dat = new Date().toString();
        dat = dat.replace(':', '_');
        this.appendToLogFile(userName + ":: " + dat + " STDERR " + aj.getErrStd() + "\n" + "STDOUT " + aj.getOutStd() + "\n" + "MSG    " + msg, this.errorLog);
        Vector<String> vans = new Vector<String>(4);
        vans.add("msg");
        vans.add(aj.getErrStd());
        vans.add("status");
        vans.add("1");
        return vans;
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public String version() {
        String[] envp = this.jp.getEmbossEnvironmentArray(this.env);
        String embossCommand = new String(this.embossBin + "embossversion");
        RunEmbossApplication2 rea = new RunEmbossApplication2(embossCommand, envp, null);
        try {
            Process p = rea.getProcess();
            p.waitFor();
        }
        catch (InterruptedException iexp) {
            // empty catch block
        }
        return rea.getProcessStdout();
    }
}

