/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.sort;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.TableFormat;
import java.util.Comparator;

public class TableColumnComparator
implements Comparator {
    private TableFormat tableFormat;
    private int column;
    private Comparator comparator = null;

    public TableColumnComparator(TableFormat tableFormat, int column) {
        this(tableFormat, column, GlazedLists.comparableComparator());
    }

    public TableColumnComparator(TableFormat tableFormat, int column, Comparator comparator) {
        this.column = column;
        this.tableFormat = tableFormat;
        this.comparator = comparator;
    }

    public int compare(Object alpha, Object beta) {
        Object alphaField = this.tableFormat.getColumnValue(alpha, this.column);
        Object betaField = this.tableFormat.getColumnValue(beta, this.column);
        try {
            return this.comparator.compare(alphaField, betaField);
        }
        catch (ClassCastException e) {
            IllegalStateException illegalStateException = null;
            illegalStateException = this.comparator == GlazedLists.comparableComparator() ? new IllegalStateException("TableComparatorChooser can not sort objects \"" + alphaField + "\", \"" + betaField + "\" that do not implement Comparable.") : new IllegalStateException("TableComparatorChooser can not sort objects \"" + alphaField + "\", \"" + betaField + "\" using the provided Comparator.");
            illegalStateException.initCause(e);
            throw illegalStateException;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableColumnComparator that = (TableColumnComparator)o;
        if (this.column != that.column) {
            return false;
        }
        if (!((Object)this.comparator).equals(that.comparator)) {
            return false;
        }
        return this.tableFormat.equals(that.tableFormat);
    }

    public int hashCode() {
        int result = this.tableFormat.hashCode();
        result = 29 * result + this.column;
        result = 29 * result + this.comparator.hashCode();
        return result;
    }
}

