/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.rbp;

import ca.odell.glazedlists.impl.ctp.CTPConnection;
import ca.odell.glazedlists.impl.ctp.CTPHandler;
import ca.odell.glazedlists.impl.io.Bufferlo;
import ca.odell.glazedlists.impl.rbp.Peer;
import ca.odell.glazedlists.impl.rbp.PeerBlock;
import ca.odell.glazedlists.impl.rbp.PeerResource;
import ca.odell.glazedlists.impl.rbp.ResourceConnection;
import ca.odell.glazedlists.impl.rbp.ResourceUri;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class PeerConnection
implements CTPHandler {
    private static Logger logger = Logger.getLogger(PeerConnection.class.toString());
    private Peer peer;
    private CTPConnection connection = null;
    private static final int AWAITING_CONNECT = 0;
    private static final int READY = 1;
    private static final int AWAITING_CLOSE = 2;
    private static final int CLOSED = 3;
    private int state = 0;
    private Bufferlo currentBlock = new Bufferlo();
    private Bufferlo pendingConnect = new Bufferlo();
    Map incomingSubscriptions = new TreeMap();
    Map outgoingPublications = new TreeMap();

    public PeerConnection(Peer peer) {
        this.peer = peer;
    }

    public void connectionReady(CTPConnection connection) {
        int priorState = this.state;
        this.connection = connection;
        this.state = 1;
        if (this.pendingConnect.length() > 0) {
            connection.sendChunk(this.pendingConnect);
        }
        if (priorState == 2) {
            this.close();
        }
    }

    public void connectionClosed(CTPConnection source, Exception reason) {
        this.connection = null;
        this.state = 3;
        this.peer.connections.remove(this);
        ArrayList resourcesToNotify = new ArrayList();
        resourcesToNotify.addAll(this.incomingSubscriptions.values());
        resourcesToNotify.addAll(this.outgoingPublications.values());
        Iterator r = resourcesToNotify.iterator();
        while (r.hasNext()) {
            ResourceConnection resource = (ResourceConnection)r.next();
            resource.getResource().connectionClosed(resource, reason);
        }
    }

    public void receiveChunk(CTPConnection source, Bufferlo data) {
        this.currentBlock.append(data);
        try {
            PeerBlock block = null;
            while ((block = PeerBlock.fromBytes(this.currentBlock, source.getLocalHost(), source.getLocalPort())) != null) {
                ResourceUri resourceUri = block.getResourceUri();
                ResourceConnection resource = null;
                if (block.isSubscribe()) {
                    resource = new ResourceConnection(this, this.peer.getPublishedResource(resourceUri));
                } else if (block.isUnsubscribe()) {
                    resource = (ResourceConnection)this.outgoingPublications.get(resourceUri);
                } else if (block.isSubscribeConfirm() || block.isUpdate() || block.isUnpublish()) {
                    resource = (ResourceConnection)this.incomingSubscriptions.get(resourceUri);
                } else {
                    throw new UnsupportedOperationException();
                }
                if (resource == null) {
                    logger.warning("Unknown resource: \"" + resourceUri + "\"");
                    this.close();
                    return;
                }
                resource.getResource().incomingBlock(resource, block);
            }
        }
        catch (ParseException e) {
            source.close(e);
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Unexpected error handling block", e.getMessage());
            source.close(e);
        }
    }

    boolean isIdle() {
        return this.incomingSubscriptions.isEmpty() && this.outgoingPublications.isEmpty();
    }

    public void close() {
        if (this.state == 3) {
            logger.warning("Closing a closed connection");
            return;
        }
        this.state = 2;
        if (this.connection != null) {
            this.connection.close();
            this.peer.connections.remove(this);
        }
    }

    public void writeBlock(PeerResource resource, PeerBlock block) {
        if (this.state == 0) {
            this.pendingConnect.append(block.toBytes(null, -1));
        } else if (this.state == 1) {
            this.connection.sendChunk(block.toBytes(this.connection.getLocalHost(), this.connection.getLocalPort()));
        } else if (this.state == 3 || this.state == 2) {
            logger.warning("Write block to closed connection: " + this);
        } else {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        if (this.state == 0) {
            return "pending";
        }
        if (this.state == 1) {
            return this.connection.toString();
        }
        if (this.state == 3) {
            return "closed";
        }
        if (this.state == 2) {
            return "closing";
        }
        throw new IllegalStateException();
    }

    void print() {
        ResourceUri resourceUri;
        System.out.print(this);
        System.out.print(": ");
        System.out.print("Incoming {");
        Iterator s = this.incomingSubscriptions.keySet().iterator();
        while (s.hasNext()) {
            resourceUri = (ResourceUri)s.next();
            System.out.print(resourceUri);
            if (!s.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.print("}, ");
        System.out.print("Outgoing {");
        s = this.outgoingPublications.keySet().iterator();
        while (s.hasNext()) {
            resourceUri = (ResourceUri)s.next();
            System.out.print(resourceUri);
            if (!s.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.println("}");
    }
}

