/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace.graph;

import org.openjdk.jmc.flightrecorder.stacktrace.graph.Node;

public final class Edge {
    private final Node from;
    private final Node to;
    int count;
    double value;

    public Edge(Node from, Node to, double value) {
        if (from == null || to == null) {
            throw new NullPointerException("Nodes must not be null");
        }
        this.from = from;
        this.to = to;
        this.value = value;
    }

    public Node getFrom() {
        return this.from;
    }

    public Node getTo() {
        return this.to;
    }

    public int getCount() {
        return this.count;
    }

    public double getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.from.hashCode();
        result = 31 * result + this.to.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (!this.from.equals(other.from)) {
            return false;
        }
        return this.to.equals(other.to);
    }

    public String toString() {
        return this.getFrom().toString() + " -> " + this.getTo().toString() + ", count = " + this.count;
    }
}

