\name{FFTNormalizedCorrelationImageFilter}
\alias{FFTNormalizedCorrelationImageFilter}
\title{FFTNormalizedCorrelationImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Calculate normalized cross correlation using FFTs.
FFTNormalizedCorrelationImageFilter}
\details{
This filter calculates the normalized cross correlation (NCC) of two
images using FFTs instead of spatial correlation. It is much faster
than spatial correlation for reasonably large structuring elements.
This filter is a subclass of the more general MaskedFFTNormalizedCorrelationImageFilter and operates by essentially setting the masks in that algorithm to
images of ones. As described in detail in the references below, there
is no computational overhead to utilizing the more general masked
algorithm because the FFTs of the images of ones are still necessary
for the computations.
Inputs: Two images are required as inputs, fixedImage and movingImage.
In the context of correlation, inputs are often defined as: "image"
and "template". In this filter, the fixedImage plays the role of the
image, and the movingImage plays the role of the template. However,
this filter is capable of correlating any two images and is not
restricted to small movingImages (templates).
Optional parameters: The RequiredNumberOfOverlappingPixels enables the
user to specify how many voxels of the two images must overlap; any
location in the correlation map that results from fewer than this
number of voxels will be set to zero. Larger values zero-out pixels on
a larger border around the correlation image. Thus, larger values
remove less stable computations but also limit the capture range. If
RequiredNumberOfOverlappingPixels is set to 0, the default, no zeroing
will take place.
Image size: fixedImage and movingImage need not be the same size.
Furthermore, whereas some algorithms require that the "template" be
smaller than the "image" because of errors in the regions where the
two are not fully overlapping, this filter has no such restriction.
Image spacing: Since the computations are done in the pixel domain, all
input images must have the same spacing.
Outputs; The output is an image of RealPixelType that is the NCC of
the two images and its values range from -1.0 to 1.0. The size of this
NCC image is, by definition, size(fixedImage) + size(movingImage) - 1.
Example filter usage:
WARNING:
The pixel type of the output image must be of real type (float or
double). ConceptChecking is used to enforce the output pixel type. You
will get a compilation error if the pixel type of the output image is
not float or double.
 References: 1) D. Padfield. "Masked object registration in the
Fourier domain." Transactions on Image Processing. 2) D. Padfield. "Masked FFT registration". In Proc.
Computer Vision and Pattern Recognition, 2010.
: Dirk Padfield, GE Global Research, padfield@research.ge.com
See:
FFTNormalizedCorrelation for the procedural interface
itk::FFTNormalizedCorrelationImageFilter for the Doxygen on the original ITK class.
FFTNormalizedCorrelationImageFilter}
%C++ includes: sitkFFTNormalizedCorrelationImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &fixedImage, const Image &movingImage):}{
Execute the filter on the input image
}
\item{ FFTNormalizedCorrelationImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetRequiredFractionOfOverlappingPixels() const:}{
Set and get the required fraction of overlapping pixels
}
\item{uint64_t GetRequiredNumberOfOverlappingPixels() const:}{
Set and get the required number of overlapping pixels
}
\item{Self SetRequiredFractionOfOverlappingPixels(double RequiredFractionOfOverlappingPixels):}{
Set and get the required fraction of overlapping pixels
}
\item{Self SetRequiredNumberOfOverlappingPixels(uint64_t RequiredNumberOfOverlappingPixels):}{
Set and get the required number of overlapping pixels
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~FFTNormalizedCorrelationImageFilter():}{
Destructor
}
}
}
