from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

VIETNAMESE_LANG_MODEL = {
    46: {  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.LIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.LIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.LIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.LIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.LIKELY,  # 'c'
        32: SequenceLikelihood.LIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.NEGATIVE,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.LIKELY,  # '̣'
    },
    39: {  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.LIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.LIKELY,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.LIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.LIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.LIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.UNLIKELY,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    35: {  # 'C'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.LIKELY,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.POSITIVE,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.LIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        40: SequenceLikelihood.POSITIVE,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.LIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.LIKELY,  # 'ă'
        42: SequenceLikelihood.LIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.LIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    47: {  # 'D'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    55: {  # 'E'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.LIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.LIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.LIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.LIKELY,  # 'v'
        36: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.NEGATIVE,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.NEGATIVE,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.NEGATIVE,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.UNLIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
    48: {  # 'G'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.LIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.LIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.LIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.LIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.LIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
    38: {  # 'H'
        46: SequenceLikelihood.POSITIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.POSITIVE,  # 'C'
        47: SequenceLikelihood.LIKELY,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.LIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.LIKELY,  # 'Â'
        60: SequenceLikelihood.LIKELY,  # 'Ê'
        58: SequenceLikelihood.LIKELY,  # 'Ô'
        19: SequenceLikelihood.LIKELY,  # 'â'
        13: SequenceLikelihood.LIKELY,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.LIKELY,  # 'ă'
        42: SequenceLikelihood.LIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.LIKELY,  # 'ơ'
        61: SequenceLikelihood.LIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    50: {  # 'I'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.LIKELY,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.POSITIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.LIKELY,  # '̀'
        5: SequenceLikelihood.LIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.LIKELY,  # '̣'
    },
    49: {  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.LIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.LIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    45: {  # 'L'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.LIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.LIKELY,  # 'ă'
        42: SequenceLikelihood.LIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.LIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    40: {  # 'M'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.LIKELY,  # 'â'
        13: SequenceLikelihood.LIKELY,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.LIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.LIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.LIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    34: {  # 'N'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.POSITIVE,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.POSITIVE,  # 'G'
        38: SequenceLikelihood.POSITIVE,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.LIKELY,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.LIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.LIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.LIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    54: {  # 'O'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.LIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.NEGATIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.LIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.LIKELY,  # '̣'
    },
    44: {  # 'P'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.LIKELY,  # 'G'
        38: SequenceLikelihood.LIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    51: {  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    52: {  # 'R'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.LIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.LIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.LIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.LIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    43: {  # 'S'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.LIKELY,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.LIKELY,  # 'G'
        38: SequenceLikelihood.LIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.LIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.LIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.LIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.LIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.LIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    33: {  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.LIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.POSITIVE,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.POSITIVE,  # 'P'
        51: SequenceLikelihood.LIKELY,  # 'Q'
        52: SequenceLikelihood.LIKELY,  # 'R'
        43: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        56: SequenceLikelihood.LIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.POSITIVE,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.LIKELY,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.LIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.LIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    53: {  # 'U'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.POSITIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.LIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.LIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.LIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.LIKELY,  # '̉'
        10: SequenceLikelihood.LIKELY,  # '̣'
    },
    41: {  # 'V'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.LIKELY,  # 'ê'
        16: SequenceLikelihood.LIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.LIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    56: {  # 'X'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.LIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.LIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.LIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.LIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.LIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    57: {  # 'Y'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.LIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.LIKELY,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.LIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.LIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
    3: {  # 'a'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.LIKELY,  # 'a'
        29: SequenceLikelihood.POSITIVE,  # 'b'
        7: SequenceLikelihood.POSITIVE,  # 'c'
        32: SequenceLikelihood.POSITIVE,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.POSITIVE,  # 'k'
        23: SequenceLikelihood.POSITIVE,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.POSITIVE,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.POSITIVE,  # 'r'
        28: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.LIKELY,  # 'v'
        36: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    29: {  # 'b'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.LIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.UNLIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    7: {  # 'c'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.LIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.POSITIVE,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
    32: {  # 'd'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.LIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.LIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.LIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.LIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    26: {  # 'e'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.POSITIVE,  # 'b'
        7: SequenceLikelihood.POSITIVE,  # 'c'
        32: SequenceLikelihood.POSITIVE,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.LIKELY,  # 'k'
        23: SequenceLikelihood.POSITIVE,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.POSITIVE,  # 'r'
        28: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.LIKELY,  # 'v'
        36: SequenceLikelihood.POSITIVE,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    8: {  # 'g'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
    2: {  # 'h'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.LIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.UNLIKELY,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    4: {  # 'i'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.LIKELY,  # 'b'
        7: SequenceLikelihood.POSITIVE,  # 'c'
        32: SequenceLikelihood.POSITIVE,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.POSITIVE,  # 'k'
        23: SequenceLikelihood.POSITIVE,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.POSITIVE,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.POSITIVE,  # 'r'
        28: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.POSITIVE,  # 'v'
        36: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.LIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    30: {  # 'k'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.LIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    23: {  # 'l'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.LIKELY,  # 'b'
        7: SequenceLikelihood.LIKELY,  # 'c'
        32: SequenceLikelihood.POSITIVE,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.LIKELY,  # 'k'
        23: SequenceLikelihood.POSITIVE,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.LIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    17: {  # 'm'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.LIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.POSITIVE,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    1: {  # 'n'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.LIKELY,  # 'b'
        7: SequenceLikelihood.POSITIVE,  # 'c'
        32: SequenceLikelihood.POSITIVE,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.POSITIVE,  # 'k'
        23: SequenceLikelihood.POSITIVE,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.LIKELY,  # 'v'
        36: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    12: {  # 'o'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.POSITIVE,  # 'b'
        7: SequenceLikelihood.POSITIVE,  # 'c'
        32: SequenceLikelihood.POSITIVE,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.POSITIVE,  # 'k'
        23: SequenceLikelihood.POSITIVE,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.POSITIVE,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.POSITIVE,  # 'r'
        28: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.POSITIVE,  # 'v'
        36: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    25: {  # 'p'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.LIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.POSITIVE,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.POSITIVE,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
    37: {  # 'q'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.NEGATIVE,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.NEGATIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    21: {  # 'r'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.LIKELY,  # 'b'
        7: SequenceLikelihood.LIKELY,  # 'c'
        32: SequenceLikelihood.POSITIVE,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.POSITIVE,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.LIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    28: {  # 's'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.LIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.LIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    6: {  # 't'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.LIKELY,  # 'c'
        32: SequenceLikelihood.LIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.POSITIVE,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.POSITIVE,  # 'r'
        28: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.LIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.UNLIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    11: {  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.POSITIVE,  # 'b'
        7: SequenceLikelihood.POSITIVE,  # 'c'
        32: SequenceLikelihood.LIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.LIKELY,  # 'k'
        23: SequenceLikelihood.POSITIVE,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.POSITIVE,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.POSITIVE,  # 'r'
        28: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        24: SequenceLikelihood.LIKELY,  # 'v'
        36: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.LIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    24: {  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    36: {  # 'x'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.LIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.LIKELY,  # 'ê'
        16: SequenceLikelihood.LIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.LIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.LIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
    22: {  # 'y'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.LIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.LIKELY,  # 'c'
        32: SequenceLikelihood.LIKELY,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.LIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        25: SequenceLikelihood.LIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.LIKELY,  # 'r'
        28: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.LIKELY,  # '̣'
    },
    59: {  # 'Â'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.NEGATIVE,  # 'D'
        55: SequenceLikelihood.NEGATIVE,  # 'E'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.NEGATIVE,  # 'Q'
        52: SequenceLikelihood.NEGATIVE,  # 'R'
        43: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        29: SequenceLikelihood.NEGATIVE,  # 'b'
        7: SequenceLikelihood.NEGATIVE,  # 'c'
        32: SequenceLikelihood.NEGATIVE,  # 'd'
        26: SequenceLikelihood.NEGATIVE,  # 'e'
        8: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        30: SequenceLikelihood.NEGATIVE,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.LIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.NEGATIVE,  # 'q'
        21: SequenceLikelihood.NEGATIVE,  # 'r'
        28: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.NEGATIVE,  # 'v'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.NEGATIVE,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.NEGATIVE,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.NEGATIVE,  # 'Đ'
        20: SequenceLikelihood.NEGATIVE,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.NEGATIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.NEGATIVE,  # 'ư'
        9: SequenceLikelihood.LIKELY,  # '̀'
        5: SequenceLikelihood.LIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.LIKELY,  # '̉'
        10: SequenceLikelihood.LIKELY,  # '̣'
    },
    60: {  # 'Ê'
        46: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.NEGATIVE,  # 'E'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.NEGATIVE,  # 'I'
        49: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.NEGATIVE,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.NEGATIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.NEGATIVE,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        24: SequenceLikelihood.NEGATIVE,  # 'v'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.NEGATIVE,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.NEGATIVE,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.NEGATIVE,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.NEGATIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.NEGATIVE,  # 'ư'
        9: SequenceLikelihood.LIKELY,  # '̀'
        5: SequenceLikelihood.LIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.LIKELY,  # '̉'
        10: SequenceLikelihood.LIKELY,  # '̣'
    },
    58: {  # 'Ô'
        46: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.NEGATIVE,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.NEGATIVE,  # 'Q'
        52: SequenceLikelihood.NEGATIVE,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.NEGATIVE,  # 'd'
        26: SequenceLikelihood.NEGATIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.NEGATIVE,  # 'q'
        21: SequenceLikelihood.NEGATIVE,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.NEGATIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.NEGATIVE,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.NEGATIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.NEGATIVE,  # 'ư'
        9: SequenceLikelihood.LIKELY,  # '̀'
        5: SequenceLikelihood.LIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.LIKELY,  # '̉'
        10: SequenceLikelihood.LIKELY,  # '̣'
    },
    19: {  # 'â'
        46: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.NEGATIVE,  # 'D'
        55: SequenceLikelihood.NEGATIVE,  # 'E'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        38: SequenceLikelihood.NEGATIVE,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.NEGATIVE,  # 'P'
        51: SequenceLikelihood.NEGATIVE,  # 'Q'
        52: SequenceLikelihood.NEGATIVE,  # 'R'
        43: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.NEGATIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.NEGATIVE,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.NEGATIVE,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.NEGATIVE,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.NEGATIVE,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.NEGATIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    13: {  # 'ê'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.NEGATIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.NEGATIVE,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    16: {  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.NEGATIVE,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    63: {  # 'Ă'
        46: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.NEGATIVE,  # 'E'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.NEGATIVE,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.NEGATIVE,  # 'P'
        51: SequenceLikelihood.NEGATIVE,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        29: SequenceLikelihood.NEGATIVE,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.NEGATIVE,  # 'd'
        26: SequenceLikelihood.NEGATIVE,  # 'e'
        8: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        30: SequenceLikelihood.NEGATIVE,  # 'k'
        23: SequenceLikelihood.NEGATIVE,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.NEGATIVE,  # 'o'
        25: SequenceLikelihood.NEGATIVE,  # 'p'
        37: SequenceLikelihood.NEGATIVE,  # 'q'
        21: SequenceLikelihood.NEGATIVE,  # 'r'
        28: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.NEGATIVE,  # 'u'
        24: SequenceLikelihood.NEGATIVE,  # 'v'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.NEGATIVE,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.NEGATIVE,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.NEGATIVE,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.NEGATIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.NEGATIVE,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.UNLIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
    31: {  # 'ă'
        46: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.NEGATIVE,  # 'D'
        55: SequenceLikelihood.NEGATIVE,  # 'E'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        38: SequenceLikelihood.NEGATIVE,  # 'H'
        50: SequenceLikelihood.NEGATIVE,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.NEGATIVE,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.NEGATIVE,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.NEGATIVE,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.NEGATIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.NEGATIVE,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    42: {  # 'Đ'
        46: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.LIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.NEGATIVE,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.LIKELY,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.LIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
    20: {  # 'đ'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.NEGATIVE,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.NEGATIVE,  # 'P'
        51: SequenceLikelihood.NEGATIVE,  # 'Q'
        52: SequenceLikelihood.NEGATIVE,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.NEGATIVE,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.POSITIVE,  # 'â'
        13: SequenceLikelihood.POSITIVE,  # 'ê'
        16: SequenceLikelihood.POSITIVE,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.POSITIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.POSITIVE,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
    62: {  # 'Ơ'
        46: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.NEGATIVE,  # 'D'
        55: SequenceLikelihood.NEGATIVE,  # 'E'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        38: SequenceLikelihood.NEGATIVE,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.NEGATIVE,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.NEGATIVE,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        29: SequenceLikelihood.NEGATIVE,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.NEGATIVE,  # 'd'
        26: SequenceLikelihood.NEGATIVE,  # 'e'
        8: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.NEGATIVE,  # 'k'
        23: SequenceLikelihood.NEGATIVE,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.NEGATIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.NEGATIVE,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        11: SequenceLikelihood.NEGATIVE,  # 'u'
        24: SequenceLikelihood.NEGATIVE,  # 'v'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.NEGATIVE,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.NEGATIVE,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.NEGATIVE,  # 'Đ'
        20: SequenceLikelihood.NEGATIVE,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.NEGATIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.NEGATIVE,  # 'ư'
        9: SequenceLikelihood.LIKELY,  # '̀'
        5: SequenceLikelihood.LIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.LIKELY,  # '̉'
        10: SequenceLikelihood.LIKELY,  # '̣'
    },
    18: {  # 'ơ'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.NEGATIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.NEGATIVE,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    61: {  # 'Ư'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.NEGATIVE,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.NEGATIVE,  # 'H'
        50: SequenceLikelihood.NEGATIVE,  # 'I'
        49: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.NEGATIVE,  # 'R'
        43: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.NEGATIVE,  # 'd'
        26: SequenceLikelihood.NEGATIVE,  # 'e'
        8: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        30: SequenceLikelihood.NEGATIVE,  # 'k'
        23: SequenceLikelihood.NEGATIVE,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.NEGATIVE,  # 'p'
        37: SequenceLikelihood.NEGATIVE,  # 'q'
        21: SequenceLikelihood.NEGATIVE,  # 'r'
        28: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        24: SequenceLikelihood.NEGATIVE,  # 'v'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.NEGATIVE,  # 'Ô'
        19: SequenceLikelihood.NEGATIVE,  # 'â'
        13: SequenceLikelihood.NEGATIVE,  # 'ê'
        16: SequenceLikelihood.NEGATIVE,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.NEGATIVE,  # 'Đ'
        20: SequenceLikelihood.NEGATIVE,  # 'đ'
        62: SequenceLikelihood.LIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.LIKELY,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.LIKELY,  # '̣'
    },
    15: {  # 'ư'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        54: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.UNLIKELY,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.POSITIVE,  # 'ơ'
        61: SequenceLikelihood.NEGATIVE,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.POSITIVE,  # '̀'
        5: SequenceLikelihood.POSITIVE,  # '́'
        27: SequenceLikelihood.POSITIVE,  # '̃'
        14: SequenceLikelihood.POSITIVE,  # '̉'
        10: SequenceLikelihood.POSITIVE,  # '̣'
    },
    9: {  # '̀'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.NEGATIVE,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.UNLIKELY,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    5: {  # '́'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.POSITIVE,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.LIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.POSITIVE,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.UNLIKELY,  # '̀'
        5: SequenceLikelihood.UNLIKELY,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    27: {  # '̃'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.UNLIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.NEGATIVE,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.UNLIKELY,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    14: {  # '̉'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.UNLIKELY,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.POSITIVE,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.UNLIKELY,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.UNLIKELY,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.NEGATIVE,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.NEGATIVE,  # '̉'
        10: SequenceLikelihood.NEGATIVE,  # '̣'
    },
    10: {  # '̣'
        46: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        47: SequenceLikelihood.UNLIKELY,  # 'D'
        55: SequenceLikelihood.UNLIKELY,  # 'E'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'H'
        50: SequenceLikelihood.LIKELY,  # 'I'
        49: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        54: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        51: SequenceLikelihood.UNLIKELY,  # 'Q'
        52: SequenceLikelihood.UNLIKELY,  # 'R'
        43: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        53: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'b'
        7: SequenceLikelihood.POSITIVE,  # 'c'
        32: SequenceLikelihood.UNLIKELY,  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'e'
        8: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        30: SequenceLikelihood.UNLIKELY,  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'l'
        17: SequenceLikelihood.POSITIVE,  # 'm'
        1: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        25: SequenceLikelihood.POSITIVE,  # 'p'
        37: SequenceLikelihood.UNLIKELY,  # 'q'
        21: SequenceLikelihood.UNLIKELY,  # 'r'
        28: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        24: SequenceLikelihood.UNLIKELY,  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        59: SequenceLikelihood.UNLIKELY,  # 'Â'
        60: SequenceLikelihood.NEGATIVE,  # 'Ê'
        58: SequenceLikelihood.UNLIKELY,  # 'Ô'
        19: SequenceLikelihood.UNLIKELY,  # 'â'
        13: SequenceLikelihood.UNLIKELY,  # 'ê'
        16: SequenceLikelihood.UNLIKELY,  # 'ô'
        63: SequenceLikelihood.NEGATIVE,  # 'Ă'
        31: SequenceLikelihood.UNLIKELY,  # 'ă'
        42: SequenceLikelihood.UNLIKELY,  # 'Đ'
        20: SequenceLikelihood.UNLIKELY,  # 'đ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ơ'
        18: SequenceLikelihood.UNLIKELY,  # 'ơ'
        61: SequenceLikelihood.UNLIKELY,  # 'Ư'
        15: SequenceLikelihood.UNLIKELY,  # 'ư'
        9: SequenceLikelihood.NEGATIVE,  # '̀'
        5: SequenceLikelihood.UNLIKELY,  # '́'
        27: SequenceLikelihood.NEGATIVE,  # '̃'
        14: SequenceLikelihood.UNLIKELY,  # '̉'
        10: SequenceLikelihood.UNLIKELY,  # '̣'
    },
}

# Character Mapping Table(s):
WINDOWS_1258_VIETNAMESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 46,  # 'A'
    66: 39,  # 'B'
    67: 35,  # 'C'
    68: 47,  # 'D'
    69: 55,  # 'E'
    70: 0,  # 'F'
    71: 48,  # 'G'
    72: 38,  # 'H'
    73: 50,  # 'I'
    74: 0,  # 'J'
    75: 49,  # 'K'
    76: 45,  # 'L'
    77: 40,  # 'M'
    78: 34,  # 'N'
    79: 54,  # 'O'
    80: 44,  # 'P'
    81: 51,  # 'Q'
    82: 52,  # 'R'
    83: 43,  # 'S'
    84: 33,  # 'T'
    85: 53,  # 'U'
    86: 41,  # 'V'
    87: 0,  # 'W'
    88: 56,  # 'X'
    89: 57,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 29,  # 'b'
    99: 7,  # 'c'
    100: 32,  # 'd'
    101: 26,  # 'e'
    102: 0,  # 'f'
    103: 8,  # 'g'
    104: 2,  # 'h'
    105: 4,  # 'i'
    106: 0,  # 'j'
    107: 30,  # 'k'
    108: 23,  # 'l'
    109: 17,  # 'm'
    110: 1,  # 'n'
    111: 12,  # 'o'
    112: 25,  # 'p'
    113: 37,  # 'q'
    114: 21,  # 'r'
    115: 28,  # 's'
    116: 6,  # 't'
    117: 11,  # 'u'
    118: 24,  # 'v'
    119: 0,  # 'w'
    120: 36,  # 'x'
    121: 22,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: CharacterCategory.UNDEFINED,  # None
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: CharacterCategory.UNDEFINED,  # None
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: CharacterCategory.UNDEFINED,  # None
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: CharacterCategory.UNDEFINED,  # None
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 59,  # 'Â'
    195: 63,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 60,  # 'Ê'
    203: 0,  # 'Ë'
    204: 9,  # '̀'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 42,  # 'Đ'
    209: 0,  # 'Ñ'
    210: 14,  # '̉'
    211: 0,  # 'Ó'
    212: 58,  # 'Ô'
    213: 62,  # 'Ơ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 61,  # 'Ư'
    222: 27,  # '̃'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 19,  # 'â'
    227: 31,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 13,  # 'ê'
    235: 0,  # 'ë'
    236: 5,  # '́'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 20,  # 'đ'
    241: 0,  # 'ñ'
    242: 10,  # '̣'
    243: 0,  # 'ó'
    244: 16,  # 'ô'
    245: 18,  # 'ơ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 15,  # 'ư'
    254: CharacterCategory.SYMBOL,  # '₫'
    255: 0,  # 'ÿ'
}

WINDOWS_1258_VIETNAMESE_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1258",
    language="Vietnamese",
    char_to_order_map=WINDOWS_1258_VIETNAMESE_CHAR_TO_ORDER,
    language_model=VIETNAMESE_LANG_MODEL,
    typical_positive_ratio=0.9773291999305039,
    keep_ascii_letters=False,
    alphabet="ABCDEGHIKLMNOPQRSTUVXYabcdeghiklmnopqrstuvxyÂÊÔâêôĂăĐđƠơƯự̀́̃̉",
)
