from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

BULGARIAN_LANG_MODEL = {
    34: {  # 'А'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.LIKELY,  # 'Б'
        32: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.LIKELY,  # 'Г'
        39: SequenceLikelihood.LIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.LIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.LIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        46: SequenceLikelihood.LIKELY,  # 'Л'
        40: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.LIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.LIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.LIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        3: SequenceLikelihood.UNLIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    37: {  # 'Б'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.LIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.LIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.LIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.LIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
    },
    32: {  # 'В'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.LIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
    },
    45: {  # 'Г'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    39: {  # 'Д'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.LIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.POSITIVE,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
    },
    43: {  # 'Е'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.LIKELY,  # 'Г'
        39: SequenceLikelihood.LIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.LIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        46: SequenceLikelihood.LIKELY,  # 'Л'
        40: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.POSITIVE,  # 'С'
        33: SequenceLikelihood.LIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.LIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.UNLIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.NEGATIVE,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    56: {  # 'Ж'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.NEGATIVE,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.NEGATIVE,  # 'ж'
        15: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.NEGATIVE,  # 'ф'
        26: SequenceLikelihood.NEGATIVE,  # 'х'
        23: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.NEGATIVE,  # 'я'
    },
    44: {  # 'З'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.LIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.NEGATIVE,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.NEGATIVE,  # 'ф'
        26: SequenceLikelihood.NEGATIVE,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    36: {  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.LIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.LIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        46: SequenceLikelihood.LIKELY,  # 'Л'
        40: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.LIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.LIKELY,  # 'Ц'
        50: SequenceLikelihood.LIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.LIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        3: SequenceLikelihood.UNLIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.NEGATIVE,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    57: {  # 'Й'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.NEGATIVE,  # 'ж'
        15: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.NEGATIVE,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.NEGATIVE,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    35: {  # 'К'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.LIKELY,  # 'Т'
        48: SequenceLikelihood.LIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    46: {  # 'Л'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.LIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.NEGATIVE,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.NEGATIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    40: {  # 'М'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.LIKELY,  # 'Б'
        32: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.NEGATIVE,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    31: {  # 'Н'
        34: SequenceLikelihood.POSITIVE,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.LIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.POSITIVE,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.LIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.NEGATIVE,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.NEGATIVE,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    38: {  # 'О'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.LIKELY,  # 'Б'
        32: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.LIKELY,  # 'Г'
        39: SequenceLikelihood.LIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.LIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        46: SequenceLikelihood.LIKELY,  # 'Л'
        40: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.LIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.UNLIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.LIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.LIKELY,  # 'щ'
        17: SequenceLikelihood.NEGATIVE,  # 'ъ'
        52: SequenceLikelihood.NEGATIVE,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    30: {  # 'П'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        46: SequenceLikelihood.LIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.NEGATIVE,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    41: {  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.LIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.LIKELY,  # 'Т'
        48: SequenceLikelihood.LIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    29: {  # 'С'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.LIKELY,  # 'Б'
        32: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        46: SequenceLikelihood.LIKELY,  # 'Л'
        40: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.LIKELY,  # 'Т'
        48: SequenceLikelihood.LIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.LIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    33: {  # 'Т'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        38: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.LIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.LIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.NEGATIVE,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
    },
    48: {  # 'У'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    49: {  # 'Ф'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.NEGATIVE,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.NEGATIVE,  # 'я'
    },
    47: {  # 'Х'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.NEGATIVE,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    51: {  # 'Ц'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.LIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        18: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.NEGATIVE,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.NEGATIVE,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
    },
    50: {  # 'Ч'
        34: SequenceLikelihood.LIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.LIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        18: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.NEGATIVE,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.NEGATIVE,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    55: {  # 'Ш'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.NEGATIVE,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.NEGATIVE,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    54: {  # 'Щ'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.NEGATIVE,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.NEGATIVE,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.LIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.NEGATIVE,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.NEGATIVE,  # 'К'
        46: SequenceLikelihood.NEGATIVE,  # 'Л'
        40: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        18: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.NEGATIVE,  # 'ж'
        15: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.NEGATIVE,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.NEGATIVE,  # 'ф'
        26: SequenceLikelihood.NEGATIVE,  # 'х'
        23: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    59: {  # 'Ъ'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.LIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.LIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.UNLIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.NEGATIVE,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.NEGATIVE,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.NEGATIVE,  # 'ь'
        42: SequenceLikelihood.NEGATIVE,  # 'ю'
        16: SequenceLikelihood.NEGATIVE,  # 'я'
    },
    60: {  # 'Ь'
        34: SequenceLikelihood.NEGATIVE,  # 'А'
        37: SequenceLikelihood.NEGATIVE,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.NEGATIVE,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        47: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.NEGATIVE,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.NEGATIVE,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        3: SequenceLikelihood.UNLIKELY,  # 'е'
        22: SequenceLikelihood.NEGATIVE,  # 'ж'
        15: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        10: SequenceLikelihood.NEGATIVE,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.NEGATIVE,  # 'п'
        7: SequenceLikelihood.NEGATIVE,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        20: SequenceLikelihood.NEGATIVE,  # 'у'
        28: SequenceLikelihood.NEGATIVE,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.NEGATIVE,  # 'ъ'
        52: SequenceLikelihood.NEGATIVE,  # 'ь'
        42: SequenceLikelihood.NEGATIVE,  # 'ю'
        16: SequenceLikelihood.NEGATIVE,  # 'я'
    },
    58: {  # 'Ю'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.UNLIKELY,  # 'е'
        22: SequenceLikelihood.LIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.NEGATIVE,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    53: {  # 'Я'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.LIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.UNLIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.NEGATIVE,  # 'ь'
        42: SequenceLikelihood.NEGATIVE,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    1: {  # 'а'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.POSITIVE,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.POSITIVE,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        24: SequenceLikelihood.POSITIVE,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    18: {  # 'б'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.NEGATIVE,  # 'Л'
        40: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.POSITIVE,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    9: {  # 'в'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.LIKELY,  # 'х'
        23: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    19: {  # 'г'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.NEGATIVE,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    12: {  # 'д'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.POSITIVE,  # 'ж'
        15: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    3: {  # 'е'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.POSITIVE,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.POSITIVE,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        24: SequenceLikelihood.POSITIVE,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    22: {  # 'ж'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.NEGATIVE,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.NEGATIVE,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    15: {  # 'з'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.NEGATIVE,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.LIKELY,  # 'ж'
        15: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    2: {  # 'и'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.POSITIVE,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.POSITIVE,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        24: SequenceLikelihood.POSITIVE,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    25: {  # 'й'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    11: {  # 'к'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    10: {  # 'л'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.POSITIVE,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.LIKELY,  # 'х'
        23: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.LIKELY,  # 'ь'
        42: SequenceLikelihood.POSITIVE,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    14: {  # 'м'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    6: {  # 'н'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.LIKELY,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.POSITIVE,  # 'ф'
        26: SequenceLikelihood.LIKELY,  # 'х'
        23: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.LIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    4: {  # 'о'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.POSITIVE,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.POSITIVE,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        24: SequenceLikelihood.POSITIVE,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    13: {  # 'п'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    7: {  # 'р'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.POSITIVE,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    8: {  # 'с'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.LIKELY,  # 'х'
        23: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.LIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    5: {  # 'т'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.LIKELY,  # 'х'
        23: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.POSITIVE,  # 'ъ'
        52: SequenceLikelihood.LIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    20: {  # 'у'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.POSITIVE,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        25: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        24: SequenceLikelihood.LIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
    },
    28: {  # 'ф'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.NEGATIVE,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.NEGATIVE,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.LIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
    },
    26: {  # 'х'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    23: {  # 'ц'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.NEGATIVE,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.NEGATIVE,  # 'Т'
        48: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.NEGATIVE,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
    },
    21: {  # 'ч'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.NEGATIVE,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    27: {  # 'ш'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.NEGATIVE,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        47: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.LIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.LIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    24: {  # 'щ'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.NEGATIVE,  # 'Б'
        32: SequenceLikelihood.NEGATIVE,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.NEGATIVE,  # 'Л'
        40: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.POSITIVE,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        20: SequenceLikelihood.POSITIVE,  # 'у'
        28: SequenceLikelihood.NEGATIVE,  # 'ф'
        26: SequenceLikelihood.NEGATIVE,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
    },
    17: {  # 'ъ'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.NEGATIVE,  # 'Д'
        43: SequenceLikelihood.NEGATIVE,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.NEGATIVE,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.NEGATIVE,  # 'Н'
        38: SequenceLikelihood.NEGATIVE,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.POSITIVE,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.LIKELY,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        24: SequenceLikelihood.POSITIVE,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    52: {  # 'ь'
        34: SequenceLikelihood.NEGATIVE,  # 'А'
        37: SequenceLikelihood.NEGATIVE,  # 'Б'
        32: SequenceLikelihood.NEGATIVE,  # 'В'
        45: SequenceLikelihood.NEGATIVE,  # 'Г'
        39: SequenceLikelihood.NEGATIVE,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.NEGATIVE,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.NEGATIVE,  # 'К'
        46: SequenceLikelihood.NEGATIVE,  # 'Л'
        40: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        41: SequenceLikelihood.NEGATIVE,  # 'Р'
        29: SequenceLikelihood.NEGATIVE,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.NEGATIVE,  # 'У'
        49: SequenceLikelihood.NEGATIVE,  # 'Ф'
        47: SequenceLikelihood.NEGATIVE,  # 'Х'
        51: SequenceLikelihood.NEGATIVE,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.NEGATIVE,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.NEGATIVE,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        3: SequenceLikelihood.UNLIKELY,  # 'е'
        22: SequenceLikelihood.UNLIKELY,  # 'ж'
        15: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        4: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    42: {  # 'ю'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.NEGATIVE,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.NEGATIVE,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.NEGATIVE,  # 'И'
        57: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.NEGATIVE,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.NEGATIVE,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.NEGATIVE,  # 'Ч'
        55: SequenceLikelihood.NEGATIVE,  # 'Ш'
        54: SequenceLikelihood.NEGATIVE,  # 'Щ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.UNLIKELY,  # 'е'
        22: SequenceLikelihood.LIKELY,  # 'ж'
        15: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.UNLIKELY,  # 'х'
        23: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        24: SequenceLikelihood.UNLIKELY,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
    16: {  # 'я'
        34: SequenceLikelihood.UNLIKELY,  # 'А'
        37: SequenceLikelihood.UNLIKELY,  # 'Б'
        32: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        39: SequenceLikelihood.UNLIKELY,  # 'Д'
        43: SequenceLikelihood.UNLIKELY,  # 'Е'
        56: SequenceLikelihood.UNLIKELY,  # 'Ж'
        44: SequenceLikelihood.UNLIKELY,  # 'З'
        36: SequenceLikelihood.UNLIKELY,  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        46: SequenceLikelihood.UNLIKELY,  # 'Л'
        40: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        38: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        41: SequenceLikelihood.UNLIKELY,  # 'Р'
        29: SequenceLikelihood.UNLIKELY,  # 'С'
        33: SequenceLikelihood.UNLIKELY,  # 'Т'
        48: SequenceLikelihood.UNLIKELY,  # 'У'
        49: SequenceLikelihood.UNLIKELY,  # 'Ф'
        47: SequenceLikelihood.UNLIKELY,  # 'Х'
        51: SequenceLikelihood.UNLIKELY,  # 'Ц'
        50: SequenceLikelihood.UNLIKELY,  # 'Ч'
        55: SequenceLikelihood.UNLIKELY,  # 'Ш'
        54: SequenceLikelihood.UNLIKELY,  # 'Щ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ь'
        58: SequenceLikelihood.UNLIKELY,  # 'Ю'
        53: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        18: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        3: SequenceLikelihood.LIKELY,  # 'е'
        22: SequenceLikelihood.LIKELY,  # 'ж'
        15: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        25: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        4: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        20: SequenceLikelihood.UNLIKELY,  # 'у'
        28: SequenceLikelihood.UNLIKELY,  # 'ф'
        26: SequenceLikelihood.POSITIVE,  # 'х'
        23: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        24: SequenceLikelihood.POSITIVE,  # 'щ'
        17: SequenceLikelihood.UNLIKELY,  # 'ъ'
        52: SequenceLikelihood.UNLIKELY,  # 'ь'
        42: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
    },
}

# Character Mapping Table(s):
CP855_BULGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'ђ'
    129: 0,  # 'Ђ'
    130: 0,  # 'ѓ'
    131: 0,  # 'Ѓ'
    132: 0,  # 'ё'
    133: 0,  # 'Ё'
    134: 0,  # 'є'
    135: 0,  # 'Є'
    136: 0,  # 'ѕ'
    137: 0,  # 'Ѕ'
    138: 0,  # 'і'
    139: 0,  # 'І'
    140: 0,  # 'ї'
    141: 0,  # 'Ї'
    142: 0,  # 'ј'
    143: 0,  # 'Ј'
    144: 0,  # 'љ'
    145: 0,  # 'Љ'
    146: 0,  # 'њ'
    147: 0,  # 'Њ'
    148: 0,  # 'ћ'
    149: 0,  # 'Ћ'
    150: 0,  # 'ќ'
    151: 0,  # 'Ќ'
    152: 0,  # 'ў'
    153: 0,  # 'Ў'
    154: 0,  # 'џ'
    155: 0,  # 'Џ'
    156: 42,  # 'ю'
    157: 58,  # 'Ю'
    158: 17,  # 'ъ'
    159: 59,  # 'Ъ'
    160: 1,  # 'а'
    161: 34,  # 'А'
    162: 18,  # 'б'
    163: 37,  # 'Б'
    164: 23,  # 'ц'
    165: 51,  # 'Ц'
    166: 12,  # 'д'
    167: 39,  # 'Д'
    168: 3,  # 'е'
    169: 43,  # 'Е'
    170: 28,  # 'ф'
    171: 49,  # 'Ф'
    172: 19,  # 'г'
    173: 45,  # 'Г'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 26,  # 'х'
    182: 47,  # 'Х'
    183: 2,  # 'и'
    184: 36,  # 'И'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 25,  # 'й'
    190: 57,  # 'Й'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 11,  # 'к'
    199: 35,  # 'К'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 10,  # 'л'
    209: 46,  # 'Л'
    210: 14,  # 'м'
    211: 40,  # 'М'
    212: 6,  # 'н'
    213: 31,  # 'Н'
    214: 4,  # 'о'
    215: 38,  # 'О'
    216: 13,  # 'п'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 30,  # 'П'
    222: 16,  # 'я'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 53,  # 'Я'
    225: 7,  # 'р'
    226: 41,  # 'Р'
    227: 8,  # 'с'
    228: 29,  # 'С'
    229: 5,  # 'т'
    230: 33,  # 'Т'
    231: 20,  # 'у'
    232: 48,  # 'У'
    233: 22,  # 'ж'
    234: 56,  # 'Ж'
    235: 9,  # 'в'
    236: 32,  # 'В'
    237: 52,  # 'ь'
    238: 60,  # 'Ь'
    239: CharacterCategory.SYMBOL,  # '№'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: 0,  # 'ы'
    242: 0,  # 'Ы'
    243: 15,  # 'з'
    244: 44,  # 'З'
    245: 27,  # 'ш'
    246: 55,  # 'Ш'
    247: 0,  # 'э'
    248: 0,  # 'Э'
    249: 24,  # 'щ'
    250: 54,  # 'Щ'
    251: 21,  # 'ч'
    252: 50,  # 'Ч'
    253: CharacterCategory.SYMBOL,  # '§'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP855_BULGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP855",
    language="Bulgarian",
    char_to_order_map=CP855_BULGARIAN_CHAR_TO_ORDER,
    language_model=BULGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9784582288406054,
    keep_ascii_letters=False,
    alphabet="АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЬЮЯабвгдежзийклмнопрстуфхцчшщъьюя",
)

CP866_BULGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 34,  # 'А'
    129: 37,  # 'Б'
    130: 32,  # 'В'
    131: 45,  # 'Г'
    132: 39,  # 'Д'
    133: 43,  # 'Е'
    134: 56,  # 'Ж'
    135: 44,  # 'З'
    136: 0,  # 'И'
    137: 57,  # 'Й'
    138: 35,  # 'К'
    139: 46,  # 'Л'
    140: 40,  # 'М'
    141: 31,  # 'Н'
    142: 38,  # 'О'
    143: 30,  # 'П'
    144: 41,  # 'Р'
    145: 29,  # 'С'
    146: 33,  # 'Т'
    147: 48,  # 'У'
    148: 49,  # 'Ф'
    149: 47,  # 'Х'
    150: 51,  # 'Ц'
    151: 50,  # 'Ч'
    152: 55,  # 'Ш'
    153: 54,  # 'Щ'
    154: 59,  # 'Ъ'
    155: 0,  # 'Ы'
    156: 60,  # 'Ь'
    157: 0,  # 'Э'
    158: 58,  # 'Ю'
    159: 53,  # 'Я'
    160: 1,  # 'а'
    161: 18,  # 'б'
    162: 9,  # 'в'
    163: 19,  # 'г'
    164: 12,  # 'д'
    165: 3,  # 'е'
    166: 22,  # 'ж'
    167: 15,  # 'з'
    168: 0,  # 'и'
    169: 25,  # 'й'
    170: 11,  # 'к'
    171: 10,  # 'л'
    172: 14,  # 'м'
    173: 6,  # 'н'
    174: 4,  # 'о'
    175: 13,  # 'п'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 7,  # 'р'
    225: 8,  # 'с'
    226: 5,  # 'т'
    227: 20,  # 'у'
    228: 28,  # 'ф'
    229: 26,  # 'х'
    230: 23,  # 'ц'
    231: 21,  # 'ч'
    232: 27,  # 'ш'
    233: 24,  # 'щ'
    234: 17,  # 'ъ'
    235: 0,  # 'ы'
    236: 52,  # 'ь'
    237: 0,  # 'э'
    238: 42,  # 'ю'
    239: 16,  # 'я'
    240: 0,  # 'Ё'
    241: 0,  # 'ё'
    242: 0,  # 'Є'
    243: 0,  # 'є'
    244: 0,  # 'Ї'
    245: 0,  # 'ї'
    246: 0,  # 'Ў'
    247: 0,  # 'ў'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: CharacterCategory.SYMBOL,  # '№'
    253: CharacterCategory.SYMBOL,  # '¤'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP866_BULGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP866",
    language="Bulgarian",
    char_to_order_map=CP866_BULGARIAN_CHAR_TO_ORDER,
    language_model=BULGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9784582288406054,
    keep_ascii_letters=False,
    alphabet="АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЬЮЯабвгдежзийклмнопрстуфхцчшщъьюя",
)

ISO_8859_5_BULGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ё'
    162: 0,  # 'Ђ'
    163: 0,  # 'Ѓ'
    164: 0,  # 'Є'
    165: 0,  # 'Ѕ'
    166: 0,  # 'І'
    167: 0,  # 'Ї'
    168: 0,  # 'Ј'
    169: 0,  # 'Љ'
    170: 0,  # 'Њ'
    171: 0,  # 'Ћ'
    172: 0,  # 'Ќ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'Ў'
    175: 0,  # 'Џ'
    176: 34,  # 'А'
    177: 37,  # 'Б'
    178: 32,  # 'В'
    179: 45,  # 'Г'
    180: 39,  # 'Д'
    181: 43,  # 'Е'
    182: 56,  # 'Ж'
    183: 44,  # 'З'
    184: 36,  # 'И'
    185: 57,  # 'Й'
    186: 35,  # 'К'
    187: 46,  # 'Л'
    188: 40,  # 'М'
    189: 31,  # 'Н'
    190: 38,  # 'О'
    191: 30,  # 'П'
    192: 41,  # 'Р'
    193: 29,  # 'С'
    194: 33,  # 'Т'
    195: 48,  # 'У'
    196: 49,  # 'Ф'
    197: 47,  # 'Х'
    198: 51,  # 'Ц'
    199: 50,  # 'Ч'
    200: 55,  # 'Ш'
    201: 54,  # 'Щ'
    202: 59,  # 'Ъ'
    203: 0,  # 'Ы'
    204: 60,  # 'Ь'
    205: 0,  # 'Э'
    206: 58,  # 'Ю'
    207: 53,  # 'Я'
    208: 1,  # 'а'
    209: 18,  # 'б'
    210: 9,  # 'в'
    211: 19,  # 'г'
    212: 12,  # 'д'
    213: 3,  # 'е'
    214: 22,  # 'ж'
    215: 15,  # 'з'
    216: 2,  # 'и'
    217: 25,  # 'й'
    218: 11,  # 'к'
    219: 10,  # 'л'
    220: 14,  # 'м'
    221: 6,  # 'н'
    222: 4,  # 'о'
    223: 13,  # 'п'
    224: 7,  # 'р'
    225: 8,  # 'с'
    226: 5,  # 'т'
    227: 20,  # 'у'
    228: 28,  # 'ф'
    229: 26,  # 'х'
    230: 23,  # 'ц'
    231: 21,  # 'ч'
    232: 27,  # 'ш'
    233: 24,  # 'щ'
    234: 17,  # 'ъ'
    235: 0,  # 'ы'
    236: 52,  # 'ь'
    237: 0,  # 'э'
    238: 42,  # 'ю'
    239: 16,  # 'я'
    240: CharacterCategory.SYMBOL,  # '№'
    241: 0,  # 'ё'
    242: 0,  # 'ђ'
    243: 0,  # 'ѓ'
    244: 0,  # 'є'
    245: 0,  # 'ѕ'
    246: 0,  # 'і'
    247: 0,  # 'ї'
    248: 0,  # 'ј'
    249: 0,  # 'љ'
    250: 0,  # 'њ'
    251: 0,  # 'ћ'
    252: 0,  # 'ќ'
    253: CharacterCategory.SYMBOL,  # '§'
    254: 0,  # 'ў'
    255: 0,  # 'џ'
}

ISO_8859_5_BULGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-5",
    language="Bulgarian",
    char_to_order_map=ISO_8859_5_BULGARIAN_CHAR_TO_ORDER,
    language_model=BULGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9784582288406054,
    keep_ascii_letters=False,
    alphabet="АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЬЮЯабвгдежзийклмнопрстуфхцчшщъьюя",
)

KOI8_R_BULGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '─'
    129: CharacterCategory.SYMBOL,  # '│'
    130: CharacterCategory.SYMBOL,  # '┌'
    131: CharacterCategory.SYMBOL,  # '┐'
    132: CharacterCategory.SYMBOL,  # '└'
    133: CharacterCategory.SYMBOL,  # '┘'
    134: CharacterCategory.SYMBOL,  # '├'
    135: CharacterCategory.SYMBOL,  # '┤'
    136: CharacterCategory.SYMBOL,  # '┬'
    137: CharacterCategory.SYMBOL,  # '┴'
    138: CharacterCategory.SYMBOL,  # '┼'
    139: CharacterCategory.SYMBOL,  # '▀'
    140: CharacterCategory.SYMBOL,  # '▄'
    141: CharacterCategory.SYMBOL,  # '█'
    142: CharacterCategory.SYMBOL,  # '▌'
    143: CharacterCategory.SYMBOL,  # '▐'
    144: CharacterCategory.SYMBOL,  # '░'
    145: CharacterCategory.SYMBOL,  # '▒'
    146: CharacterCategory.SYMBOL,  # '▓'
    147: CharacterCategory.SYMBOL,  # '⌠'
    148: CharacterCategory.SYMBOL,  # '■'
    149: CharacterCategory.SYMBOL,  # '∙'
    150: CharacterCategory.SYMBOL,  # '√'
    151: CharacterCategory.SYMBOL,  # '≈'
    152: CharacterCategory.SYMBOL,  # '≤'
    153: CharacterCategory.SYMBOL,  # '≥'
    154: CharacterCategory.CONTROL,  # '\xa0'
    155: CharacterCategory.SYMBOL,  # '⌡'
    156: CharacterCategory.SYMBOL,  # '°'
    157: CharacterCategory.DIGIT,  # '²'
    158: CharacterCategory.SYMBOL,  # '·'
    159: CharacterCategory.SYMBOL,  # '÷'
    160: CharacterCategory.SYMBOL,  # '═'
    161: CharacterCategory.SYMBOL,  # '║'
    162: CharacterCategory.SYMBOL,  # '╒'
    163: 0,  # 'ё'
    164: CharacterCategory.SYMBOL,  # '╓'
    165: CharacterCategory.SYMBOL,  # '╔'
    166: CharacterCategory.SYMBOL,  # '╕'
    167: CharacterCategory.SYMBOL,  # '╖'
    168: CharacterCategory.SYMBOL,  # '╗'
    169: CharacterCategory.SYMBOL,  # '╘'
    170: CharacterCategory.SYMBOL,  # '╙'
    171: CharacterCategory.SYMBOL,  # '╚'
    172: CharacterCategory.SYMBOL,  # '╛'
    173: CharacterCategory.SYMBOL,  # '╜'
    174: CharacterCategory.SYMBOL,  # '╝'
    175: CharacterCategory.SYMBOL,  # '╞'
    176: CharacterCategory.SYMBOL,  # '╟'
    177: CharacterCategory.SYMBOL,  # '╠'
    178: CharacterCategory.SYMBOL,  # '╡'
    179: 0,  # 'Ё'
    180: CharacterCategory.SYMBOL,  # '╢'
    181: CharacterCategory.SYMBOL,  # '╣'
    182: CharacterCategory.SYMBOL,  # '╤'
    183: CharacterCategory.SYMBOL,  # '╥'
    184: CharacterCategory.SYMBOL,  # '╦'
    185: CharacterCategory.SYMBOL,  # '╧'
    186: CharacterCategory.SYMBOL,  # '╨'
    187: CharacterCategory.SYMBOL,  # '╩'
    188: CharacterCategory.SYMBOL,  # '╪'
    189: CharacterCategory.SYMBOL,  # '╫'
    190: CharacterCategory.SYMBOL,  # '╬'
    191: CharacterCategory.SYMBOL,  # '©'
    192: 42,  # 'ю'
    193: 1,  # 'а'
    194: 18,  # 'б'
    195: 23,  # 'ц'
    196: 12,  # 'д'
    197: 3,  # 'е'
    198: 28,  # 'ф'
    199: 19,  # 'г'
    200: 26,  # 'х'
    201: 2,  # 'и'
    202: 25,  # 'й'
    203: 11,  # 'к'
    204: 10,  # 'л'
    205: 14,  # 'м'
    206: 6,  # 'н'
    207: 4,  # 'о'
    208: 13,  # 'п'
    209: 16,  # 'я'
    210: 7,  # 'р'
    211: 8,  # 'с'
    212: 5,  # 'т'
    213: 20,  # 'у'
    214: 22,  # 'ж'
    215: 9,  # 'в'
    216: 52,  # 'ь'
    217: 0,  # 'ы'
    218: 15,  # 'з'
    219: 27,  # 'ш'
    220: 0,  # 'э'
    221: 24,  # 'щ'
    222: 21,  # 'ч'
    223: 17,  # 'ъ'
    224: 58,  # 'Ю'
    225: 34,  # 'А'
    226: 37,  # 'Б'
    227: 51,  # 'Ц'
    228: 39,  # 'Д'
    229: 43,  # 'Е'
    230: 49,  # 'Ф'
    231: 45,  # 'Г'
    232: 47,  # 'Х'
    233: 36,  # 'И'
    234: 57,  # 'Й'
    235: 35,  # 'К'
    236: 46,  # 'Л'
    237: 40,  # 'М'
    238: 31,  # 'Н'
    239: 38,  # 'О'
    240: 30,  # 'П'
    241: 53,  # 'Я'
    242: 41,  # 'Р'
    243: 29,  # 'С'
    244: 33,  # 'Т'
    245: 48,  # 'У'
    246: 56,  # 'Ж'
    247: 32,  # 'В'
    248: 60,  # 'Ь'
    249: 0,  # 'Ы'
    250: 44,  # 'З'
    251: 55,  # 'Ш'
    252: 0,  # 'Э'
    253: 54,  # 'Щ'
    254: 50,  # 'Ч'
    255: 59,  # 'Ъ'
}

KOI8_R_BULGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="KOI8-R",
    language="Bulgarian",
    char_to_order_map=KOI8_R_BULGARIAN_CHAR_TO_ORDER,
    language_model=BULGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9784582288406054,
    keep_ascii_letters=False,
    alphabet="АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЬЮЯабвгдежзийклмнопрстуфхцчшщъьюя",
)

MACCYRILLIC_BULGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 34,  # 'А'
    129: 37,  # 'Б'
    130: 32,  # 'В'
    131: 45,  # 'Г'
    132: 39,  # 'Д'
    133: 43,  # 'Е'
    134: 56,  # 'Ж'
    135: 44,  # 'З'
    136: 36,  # 'И'
    137: 57,  # 'Й'
    138: 35,  # 'К'
    139: 46,  # 'Л'
    140: 40,  # 'М'
    141: 31,  # 'Н'
    142: 38,  # 'О'
    143: 30,  # 'П'
    144: 41,  # 'Р'
    145: 29,  # 'С'
    146: 33,  # 'Т'
    147: 48,  # 'У'
    148: 49,  # 'Ф'
    149: 47,  # 'Х'
    150: 51,  # 'Ц'
    151: 50,  # 'Ч'
    152: 55,  # 'Ш'
    153: 54,  # 'Щ'
    154: 59,  # 'Ъ'
    155: 0,  # 'Ы'
    156: 60,  # 'Ь'
    157: 0,  # 'Э'
    158: 58,  # 'Ю'
    159: 53,  # 'Я'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 0,  # 'Ґ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'І'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 0,  # 'Ђ'
    172: 0,  # 'ђ'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Ѓ'
    175: 0,  # 'ѓ'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 0,  # 'і'
    181: 0,  # 'µ'
    182: 0,  # 'ґ'
    183: 0,  # 'Ј'
    184: 0,  # 'Є'
    185: 0,  # 'є'
    186: 0,  # 'Ї'
    187: 0,  # 'ї'
    188: 0,  # 'Љ'
    189: 0,  # 'љ'
    190: 0,  # 'Њ'
    191: 0,  # 'њ'
    192: 0,  # 'ј'
    193: 0,  # 'Ѕ'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'Ћ'
    204: 0,  # 'ћ'
    205: 0,  # 'Ќ'
    206: 0,  # 'ќ'
    207: 0,  # 'ѕ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '„'
    216: 0,  # 'Ў'
    217: 0,  # 'ў'
    218: 0,  # 'Џ'
    219: 0,  # 'џ'
    220: CharacterCategory.SYMBOL,  # '№'
    221: 0,  # 'Ё'
    222: 0,  # 'ё'
    223: 16,  # 'я'
    224: 1,  # 'а'
    225: 18,  # 'б'
    226: 9,  # 'в'
    227: 19,  # 'г'
    228: 12,  # 'д'
    229: 3,  # 'е'
    230: 22,  # 'ж'
    231: 15,  # 'з'
    232: 2,  # 'и'
    233: 25,  # 'й'
    234: 11,  # 'к'
    235: 10,  # 'л'
    236: 14,  # 'м'
    237: 6,  # 'н'
    238: 4,  # 'о'
    239: 13,  # 'п'
    240: 7,  # 'р'
    241: 8,  # 'с'
    242: 5,  # 'т'
    243: 20,  # 'у'
    244: 28,  # 'ф'
    245: 26,  # 'х'
    246: 23,  # 'ц'
    247: 21,  # 'ч'
    248: 27,  # 'ш'
    249: 24,  # 'щ'
    250: 17,  # 'ъ'
    251: 0,  # 'ы'
    252: 52,  # 'ь'
    253: 0,  # 'э'
    254: 42,  # 'ю'
    255: CharacterCategory.SYMBOL,  # '€'
}

MACCYRILLIC_BULGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacCyrillic",
    language="Bulgarian",
    char_to_order_map=MACCYRILLIC_BULGARIAN_CHAR_TO_ORDER,
    language_model=BULGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9784582288406054,
    keep_ascii_letters=False,
    alphabet="АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЬЮЯабвгдежзийклмнопрстуфхцчшщъьюя",
)

WINDOWS_1251_BULGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ђ'
    129: 0,  # 'Ѓ'
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ѓ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.SYMBOL,  # '€'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Љ'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Њ'
    141: 0,  # 'Ќ'
    142: 0,  # 'Ћ'
    143: 0,  # 'Џ'
    144: 0,  # 'ђ'
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'љ'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'њ'
    157: 0,  # 'ќ'
    158: 0,  # 'ћ'
    159: 0,  # 'џ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ў'
    162: 0,  # 'ў'
    163: 0,  # 'Ј'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ґ'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ё'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Є'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ї'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 0,  # 'І'
    179: 0,  # 'і'
    180: 0,  # 'ґ'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ё'
    185: CharacterCategory.SYMBOL,  # '№'
    186: 0,  # 'є'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'ј'
    189: 0,  # 'Ѕ'
    190: 0,  # 'ѕ'
    191: 0,  # 'ї'
    192: 34,  # 'А'
    193: 37,  # 'Б'
    194: 32,  # 'В'
    195: 45,  # 'Г'
    196: 39,  # 'Д'
    197: 43,  # 'Е'
    198: 56,  # 'Ж'
    199: 44,  # 'З'
    200: 36,  # 'И'
    201: 57,  # 'Й'
    202: 35,  # 'К'
    203: 46,  # 'Л'
    204: 40,  # 'М'
    205: 31,  # 'Н'
    206: 38,  # 'О'
    207: 30,  # 'П'
    208: 41,  # 'Р'
    209: 29,  # 'С'
    210: 33,  # 'Т'
    211: 48,  # 'У'
    212: 49,  # 'Ф'
    213: 47,  # 'Х'
    214: 51,  # 'Ц'
    215: 50,  # 'Ч'
    216: 55,  # 'Ш'
    217: 54,  # 'Щ'
    218: 59,  # 'Ъ'
    219: 0,  # 'Ы'
    220: 60,  # 'Ь'
    221: 0,  # 'Э'
    222: 58,  # 'Ю'
    223: 53,  # 'Я'
    224: 1,  # 'а'
    225: 18,  # 'б'
    226: 9,  # 'в'
    227: 19,  # 'г'
    228: 12,  # 'д'
    229: 3,  # 'е'
    230: 22,  # 'ж'
    231: 15,  # 'з'
    232: 2,  # 'и'
    233: 25,  # 'й'
    234: 11,  # 'к'
    235: 10,  # 'л'
    236: 14,  # 'м'
    237: 6,  # 'н'
    238: 4,  # 'о'
    239: 13,  # 'п'
    240: 7,  # 'р'
    241: 8,  # 'с'
    242: 5,  # 'т'
    243: 20,  # 'у'
    244: 28,  # 'ф'
    245: 26,  # 'х'
    246: 23,  # 'ц'
    247: 21,  # 'ч'
    248: 27,  # 'ш'
    249: 24,  # 'щ'
    250: 17,  # 'ъ'
    251: 0,  # 'ы'
    252: 52,  # 'ь'
    253: 0,  # 'э'
    254: 42,  # 'ю'
    255: 16,  # 'я'
}

WINDOWS_1251_BULGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1251",
    language="Bulgarian",
    char_to_order_map=WINDOWS_1251_BULGARIAN_CHAR_TO_ORDER,
    language_model=BULGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9784582288406054,
    keep_ascii_letters=False,
    alphabet="АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЬЮЯабвгдежзийклмнопрстуфхцчшщъьюя",
)
