/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing;

import java.util.Objects;
import net.sourceforge.plantuml.klimt.CopyForegroundColorToBackgroundColor;
import net.sourceforge.plantuml.klimt.UBackground;
import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.UClip;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.UPattern;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.UHidden;
import net.sourceforge.plantuml.url.Url;

public abstract class AbstractCommonUGraphic
implements UGraphic {
    private UStroke stroke = UStroke.simple();
    private UPattern pattern = UPattern.FULL;
    private boolean hidden = false;
    private HColor backColor = HColors.none();
    private HColor color = HColors.none();
    private boolean enlargeClip = false;
    private final StringBounder stringBounder;
    private UTranslate translate = UTranslate.none();
    private ColorMapper colorMapper;
    private UClip clip;
    private HColor defaultBackground;

    protected AbstractCommonUGraphic(StringBounder stringBounder) {
        this.stringBounder = stringBounder;
    }

    public void basicCopy(HColor defaultBackground, ColorMapper colorMapper) {
        this.colorMapper = colorMapper;
        this.defaultBackground = Objects.requireNonNull(defaultBackground);
    }

    protected void basicCopy(AbstractCommonUGraphic other) {
        this.defaultBackground = Objects.requireNonNull(other.defaultBackground);
        this.enlargeClip = other.enlargeClip;
        this.colorMapper = other.colorMapper;
        this.translate = other.translate;
        this.clip = other.clip;
        this.stroke = other.stroke;
        this.pattern = other.pattern;
        this.hidden = other.hidden;
        this.color = other.color;
        this.backColor = other.backColor;
    }

    protected abstract AbstractCommonUGraphic copyUGraphic();

    @Override
    public HColor getDefaultBackground() {
        return this.defaultBackground;
    }

    public double dpiFactor() {
        return 1.0;
    }

    @Override
    public UGraphic apply(UChange change) {
        Objects.requireNonNull(change);
        AbstractCommonUGraphic copy = this.copyUGraphic();
        if (change instanceof UTranslate) {
            copy.translate = ((UTranslate)change).compose(copy.translate);
        } else if (change instanceof UClip) {
            copy.clip = (UClip)change;
            copy.clip = copy.clip.translate(this.getTranslateX(), this.getTranslateY());
        } else if (change instanceof UStroke) {
            copy.stroke = (UStroke)change;
        } else if (change instanceof UPattern) {
            copy.pattern = (UPattern)change;
        } else if (change instanceof UHidden) {
            copy.hidden = change == UHidden.HIDDEN;
        } else if (change instanceof UBackground) {
            copy.backColor = ((UBackground)change).getBackColor();
        } else if (change instanceof HColor) {
            copy.color = (HColor)change;
        } else if (change instanceof CopyForegroundColorToBackgroundColor) {
            copy.backColor = this.color;
        }
        return copy;
    }

    public final UClip getClip() {
        if (this.enlargeClip && this.clip != null) {
            return this.clip.enlarge(1.0);
        }
        return this.clip;
    }

    public final void enlargeClip() {
        this.enlargeClip = true;
    }

    @Override
    public final UParam getParam() {
        return new UParam(){

            @Override
            public boolean isHidden() {
                return AbstractCommonUGraphic.this.hidden;
            }

            @Override
            public UStroke getStroke() {
                return AbstractCommonUGraphic.this.stroke;
            }

            @Override
            public HColor getColor() {
                return AbstractCommonUGraphic.this.color;
            }

            @Override
            public HColor getBackcolor() {
                return AbstractCommonUGraphic.this.backColor;
            }

            @Override
            public UPattern getPattern() {
                return AbstractCommonUGraphic.this.pattern;
            }
        };
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected final double getTranslateX() {
        return this.translate.getDx();
    }

    protected final double getTranslateY() {
        return this.translate.getDy();
    }

    @Override
    public final ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    @Override
    public final void flushUg() {
    }

    @Override
    public void startUrl(Url url) {
    }

    @Override
    public void closeUrl() {
    }

    @Override
    public void startGroup(UGroup group) {
    }

    @Override
    public void closeGroup() {
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        return false;
    }

    public final UTranslate getTranslate() {
        return this.translate;
    }
}

