/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeProjected;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingFormat;
import net.sourceforge.plantuml.timingdiagram.TimingNote;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.utils.Position;

public abstract class Panels
implements TimeProjected {
    protected static final double MARGIN_Y = 8.0;
    protected static final double MARGIN_X = 12.0;
    protected static final double BOTTOM_MARGIN = 10.0;
    protected static final double LEFT_PANEL_MIN_WIDTH = 5.0;
    protected final ISkinParam skinParam;
    protected final TimingRuler ruler;
    protected final int suggestedHeight;
    protected final Style style;
    private final List<TimeConstraint> constraints;
    private final List<TimingNote> notes;

    public Panels(TimingRuler ruler, ISkinParam skinParam, int suggestedHeight, Style style, List<TimingNote> notes, List<TimeConstraint> constraints) {
        this.ruler = ruler;
        this.skinParam = skinParam;
        this.suggestedHeight = suggestedHeight;
        this.style = style;
        this.notes = notes != null ? notes : new ArrayList();
        this.constraints = constraints != null ? constraints : new ArrayList();
    }

    public abstract void drawLeftPanel(UGraphic var1, double var2);

    public abstract void drawRightPanel(UGraphic var1);

    public abstract double getFullHeight(StringBounder var1);

    public abstract double getLeftPanelWidth(StringBounder var1);

    protected final List<TimeConstraint> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    protected double getConstraintDeltaY(TimeConstraint constraint) {
        return 0.0;
    }

    protected final void drawConstraints(UGraphic ug) {
        for (TimeConstraint constraint : this.getConstraints()) {
            constraint.drawU(ug.apply(UTranslate.dy(this.getConstraintDeltaY(constraint))), this.ruler);
        }
    }

    protected double getHeightForConstraints(StringBounder stringBounder) {
        if (this.constraints.size() == 0) {
            return 0.0;
        }
        double result = 0.0;
        for (TimeConstraint constraint : this.constraints) {
            result = Math.max(result, constraint.getConstraintHeight(stringBounder) - this.getConstraintDeltaY(constraint));
        }
        return result;
    }

    protected final List<TimingNote> getNotes() {
        return Collections.unmodifiableList(this.notes);
    }

    protected final void drawNotes(UGraphic ug, Position position) {
        for (TimingNote note : this.notes) {
            if (note.getPosition() != position) continue;
            TimeTick when = note.getWhen();
            double x = when == null ? 0.0 : this.ruler.getPosInPixel(when);
            note.drawU(ug.apply(UTranslate.dx(x)));
        }
    }

    protected final double getHeightForNotes(StringBounder stringBounder, Position position) {
        double height = 0.0;
        for (TimingNote note : this.notes) {
            if (note.getPosition() != position) continue;
            height = Math.max(height, note.getHeight(stringBounder));
        }
        return height;
    }

    protected final Fashion getContext() {
        HColor lineColor = this.style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        HColor backgroundColor = this.style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        return new Fashion(backgroundColor, lineColor).withStroke(this.getStroke());
    }

    protected final UStroke getStroke() {
        return this.style.getStroke();
    }

    protected final FontConfiguration getFontConfiguration() {
        return FontConfiguration.create(this.skinParam, this.style);
    }

    protected final TextBlock createTextBlock(String value) {
        Display display = Display.getWithNewlines(this.skinParam.getPragma(), value);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    protected final TextBlock getTextBlock(String value) {
        return this.createTextBlock(value);
    }

    protected final void drawHLineFromPoint(UGraphic ug, XPoint2D start, double length) {
        ug.apply(UTranslate.point(start)).draw(ULine.hline(length));
    }

    protected final void drawHorizontalBetweenTimes(UGraphic ug, double startTime, double endTime) {
        double x1 = this.xOfTime(startTime);
        double x2 = Math.min(this.ruler.getWidth(), this.xOfTime(endTime));
        ULine hline = ULine.hline(x2 - x1);
        ug.apply(UTranslate.dx(x1)).draw(hline);
    }

    protected final double xOfTime(double time) {
        return this.ruler.getPosInPixel(new TimeTick(new BigDecimal(time), TimingFormat.DECIMAL));
    }

    protected final void drawVline(UGraphic ug, double x, double y, ULine vline) {
        ug.apply(new UTranslate(x, y)).draw(vline);
    }
}

