/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch.core.explain.Explanation;
import org.opensearch.client.opensearch.core.search.InnerHitsResult;
import org.opensearch.client.opensearch.core.search.NestedIdentity;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

public class Hit<TDocument>
implements PlainJsonSerializable,
ToCopyableBuilder<Builder<TDocument>, Hit<TDocument>> {
    @Nullable
    private final Explanation explanation;
    @Nonnull
    private final Map<String, JsonData> fields;
    @Nonnull
    private final Map<String, List<String>> highlight;
    @Nullable
    private final String id;
    @Nonnull
    private final List<String> ignored;
    @Nonnull
    private final Map<String, List<String>> ignoredFieldValues;
    @Nullable
    private final String index;
    @Nonnull
    private final Map<String, InnerHitsResult> innerHits;
    @Nonnull
    private final List<String> matchedQueries;
    @Nullable
    private final NestedIdentity nested;
    @Nullable
    private final String node;
    @Nullable
    private final Long primaryTerm;
    @Nullable
    private final String routing;
    @Nullable
    private final Double score;
    @Nullable
    private final Long seqNo;
    @Nullable
    private final String shard;
    @Nonnull
    private final List<FieldValue> sort;
    @Nullable
    private final TDocument source;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    @Nullable
    private final Long version;

    private Hit(Builder<TDocument> builder) {
        this.explanation = ((Builder)builder).explanation;
        this.fields = ApiTypeHelper.unmodifiable(((Builder)builder).fields);
        this.highlight = ApiTypeHelper.unmodifiable(((Builder)builder).highlight);
        this.id = ((Builder)builder).id;
        this.ignored = ApiTypeHelper.unmodifiable(((Builder)builder).ignored);
        this.ignoredFieldValues = ApiTypeHelper.unmodifiable(((Builder)builder).ignoredFieldValues);
        this.index = ((Builder)builder).index;
        this.innerHits = ApiTypeHelper.unmodifiable(((Builder)builder).innerHits);
        this.matchedQueries = ApiTypeHelper.unmodifiable(((Builder)builder).matchedQueries);
        this.nested = ((Builder)builder).nested;
        this.node = ((Builder)builder).node;
        this.primaryTerm = ((Builder)builder).primaryTerm;
        this.routing = ((Builder)builder).routing;
        this.score = ((Builder)builder).score;
        this.seqNo = ((Builder)builder).seqNo;
        this.shard = ((Builder)builder).shard;
        this.sort = ApiTypeHelper.unmodifiable(((Builder)builder).sort);
        this.source = ((Builder)builder).source;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
        this.version = ((Builder)builder).version;
    }

    public static <TDocument> Hit<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<Hit<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Explanation explanation() {
        return this.explanation;
    }

    @Nonnull
    public final Map<String, JsonData> fields() {
        return this.fields;
    }

    @Nonnull
    public final Map<String, List<String>> highlight() {
        return this.highlight;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final List<String> ignored() {
        return this.ignored;
    }

    @Nonnull
    public final Map<String, List<String>> ignoredFieldValues() {
        return this.ignoredFieldValues;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final Map<String, InnerHitsResult> innerHits() {
        return this.innerHits;
    }

    @Nonnull
    public final List<String> matchedQueries() {
        return this.matchedQueries;
    }

    @Nullable
    public final NestedIdentity nested() {
        return this.nested;
    }

    @Nullable
    public final String node() {
        return this.node;
    }

    @Nullable
    public final Long primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Double score() {
        return this.score;
    }

    @Nullable
    public final Long seqNo() {
        return this.seqNo;
    }

    @Nullable
    public final String shard() {
        return this.shard;
    }

    @Nonnull
    public final List<FieldValue> sort() {
        return this.sort;
    }

    @Nullable
    public final TDocument source() {
        return this.source;
    }

    @Nullable
    public final JsonpSerializer<TDocument> tDocumentSerializer() {
        return this.tDocumentSerializer;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.explanation != null) {
            generator.writeKey("_explanation");
            this.explanation.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.highlight)) {
            generator.writeKey("highlight");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.highlight.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (String item1 : (List)entry.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        if (ApiTypeHelper.isDefined(this.ignored)) {
            generator.writeKey("_ignored");
            generator.writeStartArray();
            for (String string : this.ignored) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.ignoredFieldValues)) {
            generator.writeKey("ignored_field_values");
            generator.writeStartObject();
            for (Map.Entry entry : this.ignoredFieldValues.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (String item1 : (List)entry.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        if (ApiTypeHelper.isDefined(this.innerHits)) {
            generator.writeKey("inner_hits");
            generator.writeStartObject();
            for (Map.Entry entry : this.innerHits.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((InnerHitsResult)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.matchedQueries)) {
            generator.writeKey("matched_queries");
            generator.writeStartArray();
            for (String string : this.matchedQueries) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.nested != null) {
            generator.writeKey("_nested");
            this.nested.serialize(generator, mapper);
        }
        if (this.node != null) {
            generator.writeKey("_node");
            generator.write(this.node);
        }
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.longValue());
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        if (this.score != null) {
            generator.writeKey("_score");
            generator.write(this.score.doubleValue());
        }
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.longValue());
        }
        if (this.shard != null) {
            generator.writeKey("_shard");
            generator.write(this.shard);
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (FieldValue fieldValue : this.sort) {
                fieldValue.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("_source");
            JsonpUtils.serialize(this.source, generator, this.tDocumentSerializer, mapper);
        }
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder<TDocument> toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static <TDocument> Builder builder() {
        return new Builder();
    }

    public static <TDocument> JsonpDeserializer<Hit<TDocument>> createHitDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> Hit.setupHitDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupHitDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::explanation, Explanation._DESERIALIZER, "_explanation");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields");
        op.add(Builder::highlight, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "highlight");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::ignored, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "_ignored");
        op.add(Builder::ignoredFieldValues, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "ignored_field_values");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::innerHits, JsonpDeserializer.stringMapDeserializer(InnerHitsResult._DESERIALIZER), "inner_hits");
        op.add(Builder::matchedQueries, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "matched_queries");
        op.add(Builder::nested, NestedIdentity._DESERIALIZER, "_nested");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "_node");
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "_routing");
        op.add(Builder::score, JsonpDeserializer.doubleDeserializer(), "_score");
        op.add(Builder::seqNo, JsonpDeserializer.longDeserializer(), "_seq_no");
        op.add(Builder::shard, JsonpDeserializer.stringDeserializer(), "_shard");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "sort");
        op.add(Builder::source, tDocumentDeserializer, "_source");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.explanation);
        result = 31 * result + Objects.hashCode(this.fields);
        result = 31 * result + Objects.hashCode(this.highlight);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.ignored);
        result = 31 * result + Objects.hashCode(this.ignoredFieldValues);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.innerHits);
        result = 31 * result + Objects.hashCode(this.matchedQueries);
        result = 31 * result + Objects.hashCode(this.nested);
        result = 31 * result + Objects.hashCode(this.node);
        result = 31 * result + Objects.hashCode(this.primaryTerm);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.score);
        result = 31 * result + Objects.hashCode(this.seqNo);
        result = 31 * result + Objects.hashCode(this.shard);
        result = 31 * result + Objects.hashCode(this.sort);
        result = 31 * result + Objects.hashCode(this.source);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hit other = (Hit)o;
        return Objects.equals(this.explanation, other.explanation) && Objects.equals(this.fields, other.fields) && Objects.equals(this.highlight, other.highlight) && Objects.equals(this.id, other.id) && Objects.equals(this.ignored, other.ignored) && Objects.equals(this.ignoredFieldValues, other.ignoredFieldValues) && Objects.equals(this.index, other.index) && Objects.equals(this.innerHits, other.innerHits) && Objects.equals(this.matchedQueries, other.matchedQueries) && Objects.equals(this.nested, other.nested) && Objects.equals(this.node, other.node) && Objects.equals(this.primaryTerm, other.primaryTerm) && Objects.equals(this.routing, other.routing) && Objects.equals(this.score, other.score) && Objects.equals(this.seqNo, other.seqNo) && Objects.equals(this.shard, other.shard) && Objects.equals(this.sort, other.sort) && Objects.equals(this.source, other.source) && Objects.equals(this.version, other.version);
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder<TDocument>, Hit<TDocument>> {
        @Nullable
        private Explanation explanation;
        @Nullable
        private Map<String, JsonData> fields;
        @Nullable
        private Map<String, List<String>> highlight;
        @Nullable
        private String id;
        @Nullable
        private List<String> ignored;
        @Nullable
        private Map<String, List<String>> ignoredFieldValues;
        @Nullable
        private String index;
        @Nullable
        private Map<String, InnerHitsResult> innerHits;
        @Nullable
        private List<String> matchedQueries;
        @Nullable
        private NestedIdentity nested;
        @Nullable
        private String node;
        @Nullable
        private Long primaryTerm;
        @Nullable
        private String routing;
        @Nullable
        private Double score;
        @Nullable
        private Long seqNo;
        @Nullable
        private String shard;
        @Nullable
        private List<FieldValue> sort;
        @Nullable
        private TDocument source;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;
        @Nullable
        private Long version;

        public Builder() {
        }

        private Builder(Hit<TDocument> o) {
            this.explanation = ((Hit)o).explanation;
            this.fields = Builder._mapCopy(((Hit)o).fields);
            this.highlight = Builder._mapCopy(((Hit)o).highlight);
            this.id = ((Hit)o).id;
            this.ignored = Builder._listCopy(((Hit)o).ignored);
            this.ignoredFieldValues = Builder._mapCopy(((Hit)o).ignoredFieldValues);
            this.index = ((Hit)o).index;
            this.innerHits = Builder._mapCopy(((Hit)o).innerHits);
            this.matchedQueries = Builder._listCopy(((Hit)o).matchedQueries);
            this.nested = ((Hit)o).nested;
            this.node = ((Hit)o).node;
            this.primaryTerm = ((Hit)o).primaryTerm;
            this.routing = ((Hit)o).routing;
            this.score = ((Hit)o).score;
            this.seqNo = ((Hit)o).seqNo;
            this.shard = ((Hit)o).shard;
            this.sort = Builder._listCopy(((Hit)o).sort);
            this.source = ((Hit)o).source;
            this.tDocumentSerializer = ((Hit)o).tDocumentSerializer;
            this.version = ((Hit)o).version;
        }

        private Builder(Builder<TDocument> o) {
            this.explanation = o.explanation;
            this.fields = Builder._mapCopy(o.fields);
            this.highlight = Builder._mapCopy(o.highlight);
            this.id = o.id;
            this.ignored = Builder._listCopy(o.ignored);
            this.ignoredFieldValues = Builder._mapCopy(o.ignoredFieldValues);
            this.index = o.index;
            this.innerHits = Builder._mapCopy(o.innerHits);
            this.matchedQueries = Builder._listCopy(o.matchedQueries);
            this.nested = o.nested;
            this.node = o.node;
            this.primaryTerm = o.primaryTerm;
            this.routing = o.routing;
            this.score = o.score;
            this.seqNo = o.seqNo;
            this.shard = o.shard;
            this.sort = Builder._listCopy(o.sort);
            this.source = o.source;
            this.tDocumentSerializer = o.tDocumentSerializer;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder<TDocument> copy() {
            return new Builder<TDocument>(this);
        }

        @Nonnull
        public final Builder<TDocument> explanation(@Nullable Explanation value) {
            this.explanation = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> explanation(Function<Explanation.Builder, ObjectBuilder<Explanation>> fn) {
            return this.explanation(fn.apply(new Explanation.Builder()).build());
        }

        @Nonnull
        public final Builder<TDocument> fields(Map<String, JsonData> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> fields(String key, JsonData value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> highlight(Map<String, List<String>> map) {
            this.highlight = Builder._mapPutAll(this.highlight, map);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> highlight(String key, List<String> value) {
            this.highlight = Builder._mapPut(this.highlight, key, value);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> ignored(List<String> list) {
            this.ignored = Builder._listAddAll(this.ignored, list);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> ignored(String value, String ... values) {
            this.ignored = Builder._listAdd(this.ignored, value, values);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> ignoredFieldValues(Map<String, List<String>> map) {
            this.ignoredFieldValues = Builder._mapPutAll(this.ignoredFieldValues, map);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> ignoredFieldValues(String key, List<String> value) {
            this.ignoredFieldValues = Builder._mapPut(this.ignoredFieldValues, key, value);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> innerHits(Map<String, InnerHitsResult> map) {
            this.innerHits = Builder._mapPutAll(this.innerHits, map);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> innerHits(String key, InnerHitsResult value) {
            this.innerHits = Builder._mapPut(this.innerHits, key, value);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> innerHits(String key, Function<InnerHitsResult.Builder, ObjectBuilder<InnerHitsResult>> fn) {
            return this.innerHits(key, fn.apply(new InnerHitsResult.Builder()).build());
        }

        @Nonnull
        public final Builder<TDocument> matchedQueries(List<String> list) {
            this.matchedQueries = Builder._listAddAll(this.matchedQueries, list);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> matchedQueries(String value, String ... values) {
            this.matchedQueries = Builder._listAdd(this.matchedQueries, value, values);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> nested(@Nullable NestedIdentity value) {
            this.nested = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> nested(Function<NestedIdentity.Builder, ObjectBuilder<NestedIdentity>> fn) {
            return this.nested(fn.apply(new NestedIdentity.Builder()).build());
        }

        @Nonnull
        public final Builder<TDocument> node(@Nullable String value) {
            this.node = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> primaryTerm(@Nullable Long value) {
            this.primaryTerm = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> score(@Nullable Double value) {
            this.score = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> seqNo(@Nullable Long value) {
            this.seqNo = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> shard(@Nullable String value) {
            this.shard = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> sort(List<FieldValue> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> sort(FieldValue value, FieldValue ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> sort(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.sort(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        @Nonnull
        public final Builder<TDocument> source(@Nullable TDocument value) {
            this.source = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public Hit<TDocument> build() {
            this._checkSingleUse();
            return new Hit(this);
        }
    }
}

