/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.rollup;

import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.indexmanagement.indexstatemanagement.action.RollupAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.rollup.AttemptCreateRollupJobStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupAction;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupRequest;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupResponse;
import org.opensearch.indexmanagement.rollup.action.start.StartRollupAction;
import org.opensearch.indexmanagement.rollup.action.start.StartRollupRequest;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u0001H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\"\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aJ\u001e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollup/AttemptCreateRollupJobStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/RollupAction;", "<init>", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/RollupAction;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "info", "", "", "", "rollupId", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateResolvedIndices", "", "sourceIndex", "targetIndex", "processFailure", "indexName", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "startRollupJob", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "(Ljava/lang/String;Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "", "Companion", "opensearch-index-management"})
public final class AttemptCreateRollupJobStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RollupAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @Nullable
    private String rollupId;
    @NotNull
    public static final String name = "attempt_create_rollup";

    public AttemptCreateRollupJobStep(@NotNull RollupAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false, 2, null);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> $completion) {
        block21: {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var14_2 = $completion;
            if ((var14_2.label & -2147483648) != 0) {
                var14_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    /* synthetic */ Object result;
                    final /* synthetic */ AttemptCreateRollupJobStep this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var15_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.getContext();
                    if (v0 == null) {
                        return this;
                    }
                    context = v0;
                    indexName = context.getMetadata().getIndex();
                    managedIndexMetadata = context.getMetadata();
                    v1 = managedIndexMetadata.getActionMetaData();
                    previousRunRollupId = v1 != null && (v1 = v1.getActionProperties()) != null ? v1.getRollupId() : null;
                    v2 = managedIndexMetadata.getActionMetaData();
                    hasPreviousRollupAttemptFailed = v2 != null && (v2 = v2.getActionProperties()) != null ? v2.getHasRollupFailed() : null;
                    tempRollup = this.action.getIsmRollup().toRollup(indexName, context.getUser());
                    resolvedSourceIndex = this.action.getIsmRollup().getSourceIndex() != null ? RollupFieldValueExpressionResolver.INSTANCE.resolve(tempRollup, this.action.getIsmRollup().getSourceIndex(), indexName) : indexName;
                    resolvedTargetIndex = RollupFieldValueExpressionResolver.INSTANCE.resolve(tempRollup, this.action.getIsmRollup().getTargetIndex(), indexName);
                    this.validateResolvedIndices(resolvedSourceIndex, resolvedTargetIndex);
                    this.logger.info("Executing rollup from source [" + resolvedSourceIndex + "] to target [" + resolvedTargetIndex + "] for managed index [" + indexName + "]");
                    rollup = Rollup.copy$default(this.action.getIsmRollup().toRollup(indexName, context.getUser()), null, 0L, 0L, false, 0L, null, null, null, null, resolvedSourceIndex, resolvedTargetIndex, null, null, null, 0, null, false, null, null, null, 1047039, null);
                    this.rollupId = rollup.getId();
                    this.logger.info("Attempting to create a rollup job " + this.rollupId + " for index " + indexName);
                    indexRollupRequest = new IndexRollupRequest(rollup, WriteRequest.RefreshPolicy.IMMEDIATE);
                    $continuation.L$0 = context;
                    $continuation.L$1 = indexName;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)managedIndexMetadata);
                    $continuation.L$3 = previousRunRollupId;
                    $continuation.L$4 = hasPreviousRollupAttemptFailed;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)tempRollup);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)resolvedSourceIndex);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)resolvedTargetIndex);
                    $continuation.L$8 = rollup;
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)indexRollupRequest);
                    $continuation.label = 1;
                    v3 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, execute$lambda$0(org.opensearch.indexmanagement.rollup.action.index.IndexRollupRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexRollupRequest)indexRollupRequest), $continuation);
                    ** if (v3 != var15_4) goto lbl47
lbl46:
                    // 1 sources

                    return var15_4;
lbl47:
                    // 1 sources

                    ** GOTO lbl63
                }
                case 1: {
                    indexRollupRequest = (IndexRollupRequest)$continuation.L$9;
                    rollup = (Rollup)$continuation.L$8;
                    resolvedTargetIndex = (String)$continuation.L$7;
                    resolvedSourceIndex = (String)$continuation.L$6;
                    tempRollup = (Rollup)$continuation.L$5;
                    hasPreviousRollupAttemptFailed = (Boolean)$continuation.L$4;
                    previousRunRollupId = (String)$continuation.L$3;
                    managedIndexMetadata = (ManagedIndexMetaData)$continuation.L$2;
                    indexName = (String)$continuation.L$1;
                    context = (StepContext)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl63:
                        // 2 sources

                        response = (IndexRollupResponse)v3;
                        this.logger.info("Received status " + response.getStatus().getStatus() + " on trying to create rollup job " + this.rollupId);
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptCreateRollupJobStep.Companion.getSuccessMessage(rollup.getId(), indexName)));
                    }
                    catch (IllegalArgumentException e) {
                        message = "Failed to validate resolved indices for rollup job";
                        this.logger.error(message, (Throwable)e);
                        this.stepStatus = Step.StepStatus.FAILED;
                        var9_27 = new Pair[]{TuplesKt.to((Object)"message", (Object)message), TuplesKt.to((Object)"cause", (Object)String.valueOf(e.getMessage()))};
                        this.info = MapsKt.mapOf((Pair[])var9_27);
                        break block21;
                    }
                    catch (VersionConflictEngineException e) {
                        v4 = this.rollupId;
                        if (v4 == null) {
                            v4 = "unknown";
                        }
                        message = AttemptCreateRollupJobStep.Companion.getFailedJobExistsMessage(v4, indexName);
                        this.logger.info(message);
                        if (!Intrinsics.areEqual((Object)this.rollupId, (Object)previousRunRollupId) || !Intrinsics.areEqual((Object)hasPreviousRollupAttemptFailed, (Object)Boxing.boxBoolean((boolean)true))) break;
                        v5 = this.rollupId;
                        if (v5 == null) {
                            v5 = "unknown";
                        }
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexName);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)managedIndexMetadata);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)previousRunRollupId);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)hasPreviousRollupAttemptFailed);
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)e);
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)message);
                        $continuation.L$7 = null;
                        $continuation.L$8 = null;
                        $continuation.L$9 = null;
                        $continuation.label = 2;
                        v6 = this.startRollupJob(v5, context, (Continuation<? super Unit>)$continuation);
                        if (v6 == var15_4) {
                            return var15_4;
                        }
                        break block21;
                    }
                }
                case 2: {
                    message = (String)$continuation.L$6;
                    e = (VersionConflictEngineException)$continuation.L$5;
                    hasPreviousRollupAttemptFailed = (Boolean)$continuation.L$4;
                    previousRunRollupId = (String)$continuation.L$3;
                    managedIndexMetadata = (ManagedIndexMetaData)$continuation.L$2;
                    indexName = (String)$continuation.L$1;
                    context = (StepContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
                    break block21;
                }
            }
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"info", (Object)message));
            break block21;
            catch (RemoteTransportException e) {
                v7 = this.rollupId;
                if (v7 == null) {
                    v7 = "unknown";
                }
                v8 = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)v8, (String)"null cannot be cast to non-null type java.lang.Exception");
                this.processFailure(v7, indexName, (Exception)v8);
                break block21;
            }
            catch (OpenSearchException e) {
                v9 = this.rollupId;
                if (v9 == null) {
                    v9 = "unknown";
                }
                this.processFailure(v9, indexName, (Exception)e);
                break block21;
            }
            catch (Exception e) {
                message = "Failed to create rollup job";
                this.logger.error(message, (Throwable)e);
                this.stepStatus = Step.StepStatus.FAILED;
                var9_27 = new Pair[]{TuplesKt.to((Object)"message", (Object)message), TuplesKt.to((Object)"cause", (Object)String.valueOf(e.getMessage()))};
                this.info = MapsKt.mapOf((Pair[])var9_27);
            }
        }
        return this;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void validateResolvedIndices(String sourceIndex, String targetIndex) {
        if (!(!StringsKt.isBlank((CharSequence)sourceIndex))) {
            boolean $i$a$-require-AttemptCreateRollupJobStep$validateResolvedIndices$42 = false;
            String $i$a$-require-AttemptCreateRollupJobStep$validateResolvedIndices$42 = "Resolved source_index cannot be empty";
            throw new IllegalArgumentException($i$a$-require-AttemptCreateRollupJobStep$validateResolvedIndices$42.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)targetIndex))) {
            boolean $i$a$-require-AttemptCreateRollupJobStep$validateResolvedIndices$52 = false;
            String $i$a$-require-AttemptCreateRollupJobStep$validateResolvedIndices$52 = "Resolved target_index cannot be empty";
            throw new IllegalArgumentException($i$a$-require-AttemptCreateRollupJobStep$validateResolvedIndices$52.toString());
        }
        if (!(!Intrinsics.areEqual((Object)sourceIndex, (Object)targetIndex))) {
            boolean bl = false;
            String string = "Source and target indices must be different: " + sourceIndex;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void processFailure(@NotNull String rollupId, @NotNull String indexName, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String message = Companion.getFailedMessage(rollupId, indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message), TuplesKt.to((Object)"cause", (Object)String.valueOf(e.getMessage()))};
        this.info = MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * Unable to fully structure code
     */
    private final Object startRollupJob(String rollupId, StepContext context, Continuation<? super Unit> $completion) {
        if (!($completion instanceof startRollupJob.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptCreateRollupJobStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptCreateRollupJobStep.access$startRollupJob(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indexName = context.getMetadata().getIndex();
                client = context.getClient();
                this.logger.info("Attempting to re-start the job " + rollupId);
                startRollupRequest = new StartRollupRequest(rollupId);
                $continuation.L$0 = rollupId;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$2 = indexName;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)startRollupRequest);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, startRollupJob$lambda$4(org.opensearch.indexmanagement.rollup.action.start.StartRollupRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((StartRollupRequest)startRollupRequest), $continuation);
                ** if (v0 != var10_6) goto lbl27
lbl26:
                // 1 sources

                return var10_6;
lbl27:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                startRollupRequest = (StartRollupRequest)$continuation.L$4;
                client = (Client)$continuation.L$3;
                indexName = (String)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                rollupId = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl38:
                    // 2 sources

                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptCreateRollupJobStep.Companion.getSuccessRestartMessage(rollupId, indexName)));
                }
                catch (Exception e) {
                    message = AttemptCreateRollupJobStep.Companion.getFailedToStartMessage(rollupId, indexName);
                    this.logger.error(message, (Throwable)e);
                    this.stepStatus = Step.StepStatus.FAILED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        ActionMetaData currentActionMetaData;
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData actionMetaData = currentActionMetaData = currentMetadata.getActionMetaData();
        ActionMetaData actionMetaData2 = actionMetaData != null ? ActionMetaData.copy$default((ActionMetaData)actionMetaData, null, null, (int)0, (boolean)false, (int)0, null, (ActionProperties)new ActionProperties(null, null, this.rollupId, null, null, null, 59, null), (int)63, null) : null;
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)actionMetaData2, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)250623, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    private static final Unit execute$lambda$0(IndexRollupRequest $indexRollupRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.execute((ActionType)IndexRollupAction.Companion.getINSTANCE(), (ActionRequest)$indexRollupRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit startRollupJob$lambda$4(StartRollupRequest $startRollupRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.execute((ActionType)StartRollupAction.Companion.getINSTANCE(), (ActionRequest)$startRollupRequest, it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$startRollupJob(AttemptCreateRollupJobStep $this, String rollupId, StepContext context, Continuation $completion) {
        return $this.startRollupJob(rollupId, context, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollup/AttemptCreateRollupJobStep$Companion;", "", "<init>", "()V", "name", "", "getFailedMessage", "rollupId", "index", "getFailedJobExistsMessage", "getFailedToStartMessage", "getSuccessMessage", "getSuccessRestartMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String rollupId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to create the rollup job [" + rollupId + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedJobExistsMessage(@NotNull String rollupId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollup job [" + rollupId + "] already exists, skipping creation [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedToStartMessage(@NotNull String rollupId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to start the rollup job [" + rollupId + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String rollupId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully created the rollup job [" + rollupId + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessRestartMessage(@NotNull String rollupId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully restarted the rollup job [" + rollupId + "] [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

